function DPenerimaanBarangAction(name, page, action, column) {
	this.initialize(name, page, action, column);
}
DPenerimaanBarangAction.prototype.constructor = DPenerimaanBarangAction;
DPenerimaanBarangAction.prototype = new TableAction();
DPenerimaanBarangAction.prototype.validate = function() {
	var valid = true;
	var invalid_msg = "";
	var nama_barang = $("#dpenerimaan_barang_name_barang").val();
	var jumlah_tercatat = $("#dpenerimaan_barang_jumlah_tercatat").val();
	var jumlah = $("#dpenerimaan_barang_jumlah").val();
	var konversi = $("#dpenerimaan_barang_konversi").val();
	var hna = $("#dpenerimaan_barang_hna").val().replace(/[^0-9-,]/g, '').replace(",", ".");
	var diskon = $("#dpenerimaan_barang_diskon").val().replace(/[^0-9-,]/g, '').replace(",", ".");
	var sisa_opl_sebelum = $("#dpenerimaan_barang_sisa_opl_sebelum").val();
	var flag = $("#penerimaan_barang_flag").val();
	var inventaris = $("#dpenerimaan_barang_inventaris").val();
	if (nama_barang == "") {
		valid = false;
		invalid_msg += "</br><strong>Nama Barang</strong> tidak boleh kosong";
		$("#dpenerimaan_barang_nama_barang").addClass("error_field");
	}
	if (jumlah_tercatat == "") {
		valid = false;
		invalid_msg += "</br><strong>Jumlah Tercatat</strong> tidak boleh kosong";
		$("#dpenerimaan_barang_jumlah_tercatat").addClass("error_field");
	} else if (inventaris == 1 && !is_numeric(jumlah_tercatat)) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah Tercatat</strong> seharusnya numerik (0-9 / Tidak Diperkenankan Desimal)";
		$("#dpenerimaan_barang_jumlah_tercatat").addClass("error_field");
	} else if (inventaris == 0 && isNaN(jumlah_tercatat)) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah Tercatat</strong> seharusnya numerik (0-9 / Diperkenankan Desimal)";
		$("#dpenerimaan_barang_jumlah_tercatat").addClass("error_field");
	} else if (jumlah_tercatat <= 0) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah Tercatat</strong> seharusnya > 0";
		$("#dpenerimaan_barang_jumlah_tercatat").addClass("error_field");
	}
	if (jumlah == "") {
		valid = false;
		invalid_msg += "</br><strong>Jumlah Diterima</strong> tidak boleh kosong";
		$("#dpenerimaan_barang_jumlah").addClass("error_field");
	} else if (inventaris == 1 && !is_numeric(jumlah)) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah Diterima</strong> seharusnya numerik (0-9 / Tidak Diperkenankan Desimal)";
		$("#dpenerimaan_barang_jumlah").addClass("error_field");
	} else if (inventaris == 0 && isNaN(jumlah)) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah Diterima</strong> seharusnya numerik (0-9 / Diperkenankan Desimal)";
		$("#dpenerimaan_barang_jumlah").addClass("error_field");
	} else if (jumlah <= 0) {
		valid = false;
		invalid_msg += "</br><strong>Jumlah Diterima</strong> seharusnya > 0";
		$("#dpenerimaan_barang_jumlah").addClass("error_field");
	} else if (flag == "bbm_opl") {
		if (parseFloat(jumlah) > parseFloat(sisa_opl_sebelum)) {
			valid = false;
			invalid_msg += "</br><strong>Jumlah Diterima</strong> lebih dari <strong>Sisa</strong>";
			$("#dpenerimaan_barang_jumlah").addClass("error_field");
		}
	}
	if (konversi == "") {
		valid = false;
		invalid_msg += "</br><strong>Konversi</strong> tidak boleh kosong";
		$("#dpenerimaan_barang_konversi").addClass("error_field");
	} else if (!is_numeric(konversi)) {
		valid = false;
		invalid_msg += "</br><strong>Konversi</strong> seharusnya numerik (0-9)";
		$("#dpenerimaan_barang_konversi").addClass("error_field");
	} else if (jumlah <= 0) {
		valid = false;
		invalid_msg += "</br><strong>Konversi</strong> seharusnya > 0";
		$("#dpenerimaan_barang_konversi").addClass("error_field");
	}
	if (hna == "") {
		valid = false;
		invalid_msg += "</br><strong>Harga</strong> tidak boleh kosong";
		$("#dpenerimaan_barang_hna").addClass("error_field");
	} else if (jumlah <= 0) {
		valid = false;
		invalid_msg += "</br><strong>Harga</strong> tidak boleh 0";
		$("#dpenerimaan_barang_hna").addClass("error_field");
	}
	if (diskon == "") {
		valid = false;
		invalid_msg += "</br><strong>Diskon</strong> tidak boleh kosong";
		$("#dpenerimaan_barang_diskon").addClass("error_field");
	}
	if (!valid)
		bootbox.alert(invalid_msg);
	return valid;
};
DPenerimaanBarangAction.prototype.clear = function() {
	$("#dpenerimaan_barang_row_num").val("");
	$("#dpenerimaan_barang_id_barang").val("");
	$("#dpenerimaan_barang_kode_barang").val("");
	$("#dpenerimaan_barang_name_barang").val("");
	$("#dpenerimaan_barang_inventaris").val("");
	$("#dpenerimaan_barang_medis").val("");
	$("#dpenerimaan_barang_nama_barang").val("");
	$("#dpenerimaan_barang_nama_jenis_barang").val("");
	$("#dpenerimaan_barang_jumlah_tercatat").val("");
	$("#dpenerimaan_barang_jumlah").val("");
	$("#dpenerimaan_barang_satuan").val("");
	$("#dpenerimaan_barang_konversi").val("");
	$("#dpenerimaan_barang_satuan_konversi").val("");
	$("#dpenerimaan_barang_hpp").val("Rp. 0,00");
	$("#dpenerimaan_barang_hna").val("Rp. 0,00");
	$("#dpenerimaan_barang_diskon").val("0,00");
	$("#dpenerimaan_barang_t_diskon").val("persen");
	$("#dpenerimaan_barang_produsen").val("");
	$("#dpenerimaan_barang_tanggal_exp").val("");
	$("#dpenerimaan_barang_no_batch").val("");
};
DPenerimaanBarangAction.prototype.save = function() {
	if (!this.validate())
		return;
	var r_num = $("#dpenerimaan_barang_row_num").val();
	var jumlah_tercatat = $("#dpenerimaan_barang_jumlah_tercatat").val();
	var f_jumlah_tercatat = jumlah_tercatat;
	var jumlah = $("#dpenerimaan_barang_jumlah").val();
	var f_jumlah = jumlah;
	var sisa_opl_sebelum = $("#dpenerimaan_barang_sisa_opl_sebelum").val();
	var sisa_opl_sesudah = sisa_opl_sebelum - jumlah;
	var konversi = $("#dpenerimaan_barang_konversi").val();
	var hna = parseFloat($("#dpenerimaan_barang_hna").val().replace(/[^0-9-,]/g, '').replace(",", "."));
	var f_hna = hna.formatMoney("2", ".", ",");
	var hpp = hna / 1.1;
	var use_ppn = $("#penerimaan_barang_use_ppn").val();
	if (use_ppn == 0)
		hpp = hna;
	var diskon = parseFloat($("#dpenerimaan_barang_diskon").val().replace(/[^0-9-,]/g, '').replace(",", "."));
	var t_diskon = $("#dpenerimaan_barang_t_diskon").val();
	var f_diskon = diskon + " %";
	if (t_diskon == "nominal")
		f_diskon = diskon.formatMoney("2", ".", ",");
	var produsen = $("#dpenerimaan_barang_produsen").val();
	var tanggal_exp = $("#dpenerimaan_barang_tanggal_exp").val();
	var no_batch = $("#dpenerimaan_barang_no_batch").val();
	var subtotal = jumlah * hna;
	if (t_diskon == "persen")
		subtotal = subtotal - (diskon * subtotal / 100);
	else
		subtotal = subtotal - diskon;
	subtotal = Math.round(subtotal);
	var f_subtotal = subtotal.formatMoney("2", ".", ",");
	
	$("tr#data_" + r_num + " td#jumlah_tercatat").html(jumlah_tercatat);
	$("tr#data_" + r_num + " td#f_jumlah_tercatat").html("<small><div align='right'>" + f_jumlah_tercatat + "</div></small>");
	$("tr#data_" + r_num + " td#jumlah").html(jumlah);
	$("tr#data_" + r_num + " td#f_jumlah").html("<small><div align='right'>" + f_jumlah + "</div></small>");
	$("tr#data_" + r_num + " td#konversi").html(konversi);
	$("tr#data_" + r_num + " td#hna").html(hna);
	$("tr#data_" + r_num + " td#hpp").html(hpp);
	$("tr#data_" + r_num + " td#f_hna").html("<small><div align='right'>" + f_hna + "</div></small>");
	$("tr#data_" + r_num + " td#diskon").html(diskon);
	$("tr#data_" + r_num + " td#t_diskon").html(t_diskon);
	$("tr#data_" + r_num + " td#f_diskon").html("<small><div align='right'>" + f_diskon + "</div></small>");
	$("tr#data_" + r_num + " td#produsen").html(produsen);
	$("tr#data_" + r_num + " td#tanggal_exp").html(tanggal_exp);
	$("tr#data_" + r_num + " td#no_batch").html(no_batch);
	$("tr#data_" + r_num + " td#sisa_opl_sesudah").html(sisa_opl_sesudah);
	$("tr#data_" + r_num + " td#subtotal").html(subtotal);
	$("tr#data_" + r_num + " td#f_subtotal").html("<small><div align='right'>" + f_subtotal + "</div></small>");
	this.clear();
	penerimaan_barang.update_total();
	this.setEditMode("false");
};
DPenerimaanBarangAction.prototype.setEditMode = function(enable) {
	var limited = $("#penerimaan_barang_limited").val();
	if (enable == "true") {
		if (limited == "false") {
			$("#dpenerimaan_barang_jumlah_tercatat").removeAttr("disabled");
			$("#dpenerimaan_barang_jumlah").removeAttr("disabled");
			$("#dpenerimaan_barang_konversi").removeAttr("disabled");
			$("#dpenerimaan_barang_hpp").removeAttr("disabled");
			$("#dpenerimaan_barang_hna").removeAttr("disabled");
			$("#dpenerimaan_barang_produsen").removeAttr("disabled");
			$("#dpenerimaan_barang_tanggal_exp").removeAttr("disabled");
			$("#dpenerimaan_barang_no_batch").removeAttr("disabled");
		}
		$("#dpenerimaan_barang_diskon").removeAttr("disabled");
		$("#dpenerimaan_barang_t_diskon").removeAttr("disabled");
		$("#penerimaan_barang_form_update").show();
		$("#penerimaan_barang_form_cancel").show();
	} else {
		$("#dpenerimaan_barang_jumlah_tercatat").removeAttr("disabled");
		$("#dpenerimaan_barang_jumlah_tercatat").attr("disabled", "disabled");
		$("#dpenerimaan_barang_jumlah").removeAttr("disabled");
		$("#dpenerimaan_barang_jumlah").attr("disabled", "disabled");
		$("#dpenerimaan_barang_konversi").removeAttr("disabled");
		$("#dpenerimaan_barang_konversi").attr("disabled", "disabled");
		$("#dpenerimaan_barang_hpp").removeAttr("disabled");
		$("#dpenerimaan_barang_hpp").attr("disabled", "disabled");
		$("#dpenerimaan_barang_hna").removeAttr("disabled");
		$("#dpenerimaan_barang_hna").attr("disabled", "disabled");
		$("#dpenerimaan_barang_diskon").removeAttr("disabled");
		$("#dpenerimaan_barang_diskon").attr("disabled", "disabled");
		$("#dpenerimaan_barang_t_diskon").removeAttr("disabled");
		$("#dpenerimaan_barang_t_diskon").attr("disabled", "disabled");
		$("#dpenerimaan_barang_produsen").removeAttr("disabled");
		$("#dpenerimaan_barang_produsen").attr("disabled", "disabled");
		$("#dpenerimaan_barang_tanggal_exp").removeAttr("disabled");
		$("#dpenerimaan_barang_tanggal_exp").attr("disabled", "disabled");
		$("#dpenerimaan_barang_no_batch").removeAttr("disabled");
		$("#dpenerimaan_barang_no_batch").attr("disabled", "disabled");
		$("#penerimaan_barang_form_update").hide();
		$("#penerimaan_barang_form_cancel").hide();
	}
};
DPenerimaanBarangAction.prototype.edit = function(r_num) {
	var kode_barang = $("tr#data_" + r_num + " td#kode_barang").text();
	var nama_barang = $("tr#data_" + r_num + " td#nama_barang").text();
	var nama_jenis_barang = $("tr#data_" + r_num + " td#nama_jenis_barang").text();
	var inventaris = $("tr#data_" + r_num + " td#inventaris").text();
	var medis = $("tr#data_" + r_num + " td#medis").text();
	var jumlah_tercatat = parseFloat($("tr#data_" + r_num + " td#jumlah_tercatat").text());
	var jumlah = parseFloat($("tr#data_" + r_num + " td#jumlah").text());
	var satuan = $("tr#data_" + r_num + " td#satuan").text();
	var konversi = $("tr#data_" + r_num + " td#konversi").text();
	var satuan_konversi = $("tr#data_" + r_num + " td#satuan_konversi").text();
	var hna = "Rp. " + parseFloat($("tr#data_" + r_num + " td#hna").text()).formatMoney("2", ".", ",");
	var hpp = "Rp. " + (parseFloat($("tr#data_" + r_num + " td#hna").text()) * 1.1).formatMoney("2", ".", ",");
	var use_ppn = $("#penerimaan_barang_use_ppn").val();
	if (use_ppn == 0)
		hpp = hna;
	var diskon = $("tr#data_" + r_num + " td#diskon").text();
	var t_diskon = $("tr#data_" + r_num + " td#t_diskon").text();
	var produsen = $("tr#data_" + r_num + " td#produsen").text();
	var tanggal_exp = $("tr#data_" + r_num + " td#tanggal_exp").text();
	var no_batch = $("tr#data_" + r_num + " td#no_batch").text();
	this.setEditMode("true");
	$("#dpenerimaan_barang_row_num").val(r_num);
	$("#dpenerimaan_barang_kode_barang").val(kode_barang);
	$("#dpenerimaan_barang_name_barang").val(nama_barang);
	$("#dpenerimaan_barang_nama_barang").val(nama_barang);
	$("#dpenerimaan_barang_nama_jenis_barang").val(nama_jenis_barang);
	$("#dpenerimaan_barang_inventaris").val(inventaris);
	$("#dpenerimaan_barang_medis").val(medis);
	$("#dpenerimaan_barang_jumlah_tercatat").val(jumlah_tercatat);
	$("#dpenerimaan_barang_jumlah").val(jumlah);
	$("#dpenerimaan_barang_satuan").val(satuan);
	$("#dpenerimaan_barang_konversi").val(konversi);
	$("#dpenerimaan_barang_satuan_konversi").val(satuan_konversi);
	$("#dpenerimaan_barang_hpp").val(hpp);
	$("#dpenerimaan_barang_hna").val(hna);
	$("#dpenerimaan_barang_diskon").val(diskon);
	$("#dpenerimaan_barang_t_diskon").val(t_diskon);
	$("#dpenerimaan_barang_produsen").val(produsen);
	$("#dpenerimaan_barang_tanggal_exp").val(tanggal_exp);
	$("#dpenerimaan_barang_no_batch").val(no_batch);
};
DPenerimaanBarangAction.prototype.empty = function(r_num) {
	$("tr#data_" + r_num + " td#jumlah").html(0);
	$("tr#data_" + r_num + " td#f_jumlah").html("<small><div align='right'>0</div></small>");
	$("tr#data_" + r_num + " td#jumlah_tercatat").html(0);
	$("tr#data_" + r_num + " td#f_jumlah_tercatat").html("<small><div align='right'>0</div></small>");
	$("tr#data_" + r_num + " td#subtotal").html(0);
	$("tr#data_" + r_num + " td#f_subtotal").html("<small><div align='right'>0,00</div></small>");
	penerimaan_barang.update_total();
};
DPenerimaanBarangAction.prototype.del = function(r_num) {
	var id = $("tr#data_" + r_num + " td#id").text();
	if (id.length == 0) {
		$("#data_" + r_num).remove();
	} else {
		$("#data_" + r_num).attr("style", "display: none;");
		$("#data_" + r_num).attr("class", "deleted");
	}
	penerimaan_barang.update_total();
};
DPenerimaanBarangAction.prototype.cancel = function() {
	this.clear();
	this.setEditMode("false");
};