<?php 
	require_once("smis-base/smis-include-service-consumer.php");
	require_once("smis-base/smis-include-duplicate.php");
	require_once("gudang_umum/table/BarangTTable.php");
	global $db;
	
	$barang_table = new BarangTTable(
		array("Nomor", "Kode", "Jenis", "Barang", "No. BBM", "Merk", "Harga", "Tahun Perolehan", "Penyusutan", "Kondisi", "Lokasi"),
		"",
		null,
		true
	);
	$barang_table->setName("inventaris_t");
	$barang_table->setReloadButtonEnable(false);
	$barang_table->setPrintButtonEnable(false);
	$barang_table->setAddButtonEnable(false);
		
	//detail history modal: 
	$history_modal = new Modal("history_add_form", "smis_form_container", "history");
	$history_modal->setTitle("Riwayat Inventaris");
	$history_modal->setClass(Modal::$FULL_MODEL);
	$id_hidden = new Hidden("history_id_inventaris", "history_id_inventaris", "");
	$history_modal->addElement("", $id_hidden);
	$nama_barang_text = new Text("history_nama_barang", "history_nama_barang", "");
	$nama_barang_text->setAtribute("disabled='disabled'");
	$history_modal->addElement("Nama Barang", $nama_barang_text);
	$hna_text = new Text("history_hna", "history_hna", "");
	$hna_text->setAtribute("disabled", "disabled");
	$history_modal->addElement("H. Perolehan", $hna_text);
	$history_button = new Button("", "", "Cetak");
	$history_button->setClass("btn-inverse");
	$history_button->setIsButton(Button::$ICONIC);
	$history_button->setIcon("icon-print icon-white");
	$history_button->setAction("detail_history.print()");
	$history_modal->addElement("", $history_button);
	$detail_history_table = new Table(
		array("No.", "Tanggal", "Merk", "Kode", "Mutasi / Retur", "Unit", "Petugas Entri"),
		"",
		null,
		true
	);
	$detail_history_table->setName("detail_history");
	$detail_history_table->setAction(false);
	$history_modal->addBody("detail_history_table", $detail_history_table);
	$history_button = new Button("", "", "OK");
	$history_button->setAtribute("id='history_ok_btn'");
	$history_button->setClass("btn-success");
	$history_button->setAction("$($(this).data('target')).smodal('hide')");
	$history_modal->addFooter($history_button);
	
	if (isset($_POST['super_command']) && $_POST['super_command'] == "detail_history") {
		if (isset($_POST['command'])) {
			$detail_history_adapter = new SimpleAdapter(true, "No.");
			$detail_history_adapter->add("Tanggal", "tanggal", "date d M Y");
			$detail_history_adapter->add("Kode", "kode");
			$detail_history_adapter->add("Merk", "merk");
			$detail_history_adapter->add("Mutasi / Retur", "status", "unslug");
			$detail_history_adapter->add("Unit", "unit", "unslug");
			$detail_history_adapter->add("Petugas Entri", "nama_user");
			$filter = "";
			if (isset($_POST['kriteria'])) {
				$filter = " AND (a.kode LIKE '%" . $_POST['kriteria'] . "%' OR a.merk LIKE '%" . $_POST['kriteria'] . "%' OR a.nama_user LIKE '%" . $_POST['kriteria'] . "%')";
			}
			$detail_history_dbtable = new DBTable($db, "smis_gd_riwayat_inventaris");
			$query_value = "
				SELECT a.*
				FROM smis_gd_riwayat_inventaris a
				WHERE a.id_inventaris = '" . $_POST['id_inventaris'] . "' AND a.prop NOT LIKE 'del' " . $filter . "
			";
			$query_count = "
				SELECT COUNT(*)
				FROM (" . $query_value . ") v
			";
			$detail_history_dbtable->setPreferredQuery(true, $query_value, $query_count);
			require_once("gudang_umum/responder/DetailHistoryDBResponder.php");
			$detail_history_dbresponder = new DetailHistoryDBResponder(
				$detail_history_dbtable,
				$detail_history_table,
				$detail_history_adapter
			);
			$data = $detail_history_dbresponder->command($_POST['command']);
			echo json_encode($data);
			return;
		}
		return;
	}
	
	if (isset($_POST['command'])) {
		require_once("gudang_umum/adapter/BarangTAdapter.php");
		$barang_adapter = new BarangTAdapter();
		$columns = array("id", "id_dbarang_masuk", "nama_barang", "medis", "hna", "kode", "merk", "tahun_perolehan", "usia_penyusutan", "kondisi_baik", "unit", "tanggal_mutasi", "user_mutasi", "tipe", "status");
		$barang_dbtable = new DBTable(
			$db,
			"smis_gd_inventaris",
			$columns
		);
		$filter = "";
		if (isset($_POST['kriteria'])) {
			$filter = "
				AND (			
					a.kode LIKE '%" . $_POST['kriteria'] . "%' OR
					a.nama_barang LIKE '%" . $_POST['kriteria'] . "%' OR
					c.no_bbm LIKE '%" . $_POST['kriteria'] . "%' OR
					a.merk LIKE '%" . $_POST['kriteria'] . "%'
				)
			";
		}
		$query_value = "
			SELECT
				a.*, c.no_bbm
			FROM
				smis_gd_inventaris a
					INNER JOIN smis_gd_dbarang_masuk b ON a.id_dbarang_masuk = b.id
					INNER JOIN smis_gd_barang_masuk c ON b.id_barang_masuk = c.id
			WHERE
				a.prop LIKE ''
				 	AND a.kondisi_baik = 1
				 	AND a.tipe = ''
					" . $filter . "
		";
		$query_count = "
			SELECT
				COUNT(*)
			FROM
				(" . $query_value . ") v
		";
		$barang_dbtable->setPreferredQuery(true, $query_value, $query_count);
		$barang_dbresponder = new DuplicateResponder(
			$barang_dbtable,
			$barang_table,
			$barang_adapter
		);
		if ($barang_dbresponder->isSave()) {
			if (isset($_POST['tanggal_mutasi'])) {
				$_POST['tanggal_mutasi'] = DateTime::createFromFormat("d-m-Y H:i", $_POST['tanggal_mutasi'])->format("Y-m-d H:i");
			}
			if (isset($_POST['push_command']) && $_POST['push_command'] == "insert") {
				$_POST['tipe'] = "mutasi";
				$_POST['status'] = "belum";
				global $user;
				$_POST['user_mutasi'] = $user->getNameOnly();
			}
		}
		$data = $barang_dbresponder->command($_POST['command']);
		if (isset($_POST['push_command'])) {
			$inventaris_dbtable = new DBTable($db, "smis_gd_inventaris");
			$inventaris_row = $inventaris_dbtable->get_row("
				SELECT smis_gd_inventaris.*
				FROM smis_gd_inventaris
				WHERE smis_gd_inventaris.prop NOT LIKE 'del' AND smis_gd_inventaris.id = '" . $data['content']['id'] . "'
			");
			$command = "push_" . $_POST['push_command'];
			require_once("gudang_umum/service_consumer/PushInventarisServiceConsumer.php");
			$push_inventaris_service_consumer = new PushInventarisServiceConsumer(
				$db, 
				$inventaris_row->id, 
				$inventaris_row->nama_barang, 
				$inventaris_row->medis, 
				$inventaris_row->kode, 
				$inventaris_row->merk, 
				$inventaris_row->hna, 
				$inventaris_row->tahun_perolehan, 
				$inventaris_row->usia_penyusutan, 
				$inventaris_row->kondisi_baik,
				$command, 
				$inventaris_row->unit,
				$inventaris_row->tanggal_mutasi,
				$inventaris_row->user_mutasi
			);
			$result = $push_inventaris_service_consumer->execute();
			if ($result) {
				$riwayat_inventaris_dbtable = new DBTable($db, "smis_gd_riwayat_inventaris");
				$riwayat_inventaris_data = array();
				$riwayat_inventaris_data['id_inventaris'] = $inventaris_row->id;
				$riwayat_inventaris_data['unit'] = $inventaris_row->unit;
				$riwayat_inventaris_data['tanggal'] = date("Y-m-d");
				$riwayat_inventaris_data['kode'] = $inventaris_row->kode;
				$riwayat_inventaris_data['merk'] = $inventaris_row->merk;
				$riwayat_inventaris_data['usia_penyusutan'] = $inventaris_row->usia_penyusutan;
				$riwayat_inventaris_data['kondisi_baik'] = $inventaris_row->kondisi_baik;
				$riwayat_inventaris_data['status'] = "mutasi";
				global $user;
				$riwayat_inventaris_data['nama_user'] = $user->getName();
				$riwayat_inventaris_data['autonomous'] = "[".getSettings($db, "smis_autonomous_id", "")."]";
		        $riwayat_inventaris_data['duplicate'] = 0;
		        $riwayat_inventaris_data['time_updated'] = date("Y-m-d H:i:s");
		        $riwayat_inventaris_data['origin_updated'] = getSettings($db, "smis_autonomous_id", "");
		        $riwayat_inventaris_data['origin'] = getSettings($db, "smis_autonomous_id", "");
				$riwayat_inventaris_dbtable->insert($riwayat_inventaris_data);
			}
		}
		echo json_encode($data);
		return;
	}
	
	$inventaris_modal = new Modal("inventaris_t_add_form", "smis_form_container", "inventaris_t");
	$inventaris_modal->setTitle("Data Barang Inventaris");
	$id_hidden = new Hidden("inventaris_t_id", "inventaris_t_id", "");
	$inventaris_modal->addElement("", $id_hidden);
	$nama_barang_text = new Text("inventaris_t_nama_barang", "inventaris_t_nama_barang", "");
	$nama_barang_text->setAtribute("disabled='disabled'");
	$inventaris_modal->addElement("Nama Barang", $nama_barang_text);
	$kode_text = new Text("inventaris_t_kode", "inventaris_t_kode", "");
	$inventaris_modal->addElement("Kode", $kode_text);
	$merk_text = new Text("inventaris_t_merk", "inventaris_t_merk", "");
	$inventaris_modal->addElement("Merk", $merk_text);
	$harga_perolehan_text = new Text("inventaris_t_harga_perolehan", "inventaris_t_harga_perolehan", "");
	$harga_perolehan_text->setTypical("money");
	$harga_perolehan_text->setAtribute("disabled='disabled' data-thousands=\".\" data-decimal=\",\" data-prefix=\"Rp. \"  data-precision=\"2\"");
	$inventaris_modal->addElement("Harga", $harga_perolehan_text);
	$tahun_perolehan_text = new Text("inventaris_t_tahun_perolehan", "inventaris_t_tahun_perolehan", "");
	$inventaris_modal->addElement("Tahun", $tahun_perolehan_text);
	$usia_penyusutan_text = new Text("inventaris_t_usia_penyusutan", "inventaris_t_usia_penyusutan", "");
	$inventaris_modal->addElement("Usia Susut (th)", $usia_penyusutan_text);
	$kondisi_option = array(
		array(
			'name'	=> "Baik",
			'value'	=> 1
		),
		array(
			'name'	=> "Rusak",
			'value'	=> 0
		)
	);
	$kondisi_select = new Select("inventaris_t_kondisi", "inventaris_t_kondisi", $kondisi_option);
	$inventaris_modal->addElement("Kondisi", $kondisi_select);
	$tanggal_text = new Text("inventaris_t_tanggal_mutasi", "inventaris_t_tanggal_mutasi", date("d-m-Y H:i"));
	$tanggal_text->setClass("mydatetime");
	$tanggal_text->setAtribute("data-date-format='dd-mm-yyyy hh:ii'");
	$inventaris_modal->addElement("Tanggal", $tanggal_text);
	require_once("gudang_umum/service_consumer/UnitInventarisServiceConsumer.php");
	$unit_service_consumer = new UnitInventarisServiceConsumer($db);
	$unit_service_consumer->execute();
	$unit_option = $unit_service_consumer->getContent();
	$unit_select = new Select("inventaris_t_unit", "inventaris_t_unit", $unit_option);
	$inventaris_modal->addElement("Lokasi", $unit_select);
	$barang_button = new Button("", "", "Simpan");
	$barang_button->setAtribute("id='inventaris_t_save_btn'");
	$barang_button->setClass("btn-success");
	$barang_button->setIcon("fa fa-floppy-o");
	$barang_button->setIsButton(Button::$ICONIC);
	$inventaris_modal->addFooter($barang_button);
	$inventaris_modal->addHTML(
	"<div class='alert alert-block alert-inverse'>" .
		 "<h4>Informasi</h4>" .
		 "Berikut ini adalah aturan taksiran umur ekonomis atas perolehan aset untuk pengisian <b>Usia Susut (th)</b>:" .
		 "<ol>
			<li>Gedung Permanen: 20 Tahun</li>
			<li>Peralatan/Mesin dan Peralatan Medis: 5 Tahun</li>
			<li>Komputer dan Alat Elektronik: 2 Tahun</li>
			<li>Kendaraan Bermotor: 5 Tahun</li>
			<li>Peralatan Kantor dan Meubelir: 5 Tahun</li>
		</ol>" .
	 "</div>", "before");
	 
	$print_kode_modal = new Modal("print_kode_add_form", "smis_form_container", "print_kode");
	$print_kode_modal->setTitle("Cetak Kode");
	$kode_hidden = new Hidden("print_kode_kode", "print_kode_kode", "");
	$print_kode_modal->addElement("", $kode_hidden);
	$option = new OptionBuilder();
	$option->add("Kecil", "2");
	$option->add("Sedang", "4", "1");
	$option->add("Besar", "6");
	$option->add("Sangat Besar", "8");
	$ukuran_select = new Select("print_kode_ukuran_setting", "print_kode_ukuran_setting", $option->getContent());
	$print_kode_modal->addElement("Pilihan", $ukuran_select);
	$jumlah_text = new Text("print_kode_jumlah", "print_kode_jumlah", "");
	$print_kode_modal->addElement("Jumlah", $jumlah_text);
	$button = new Button("", "", "Cetak");
	$button->setClass("btn-inverse");
	$button->setIcon("icon-print icon-white");
	$button->setIsButton(Button::$ICONIC);
	$button->setAction("inventaris_t.cetak_kode()");
	$print_kode_modal->addFooter($button);
	$print_kode_modal->addHTML("<center><div id='preview_kode'></div></center>", "before");
	
	echo $history_modal->getHtml();
	echo $print_kode_modal->getHtml();
	echo $inventaris_modal->getHtml();
	echo $barang_table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
	echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");
	echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
?>
<script type="text/javascript">
	function BarangTAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	BarangTAction.prototype.constructor = BarangTAction;
	BarangTAction.prototype = new TableAction();
	BarangTAction.prototype.edit = function(id) {
		var data = this.getRegulerData();
		data['command'] = "edit";
		data['id'] = id;
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#inventaris_t_id").val(json.id);
				$("#inventaris_t_nama_barang").val(json.nama_barang);
				$(".inventaris_t_kode").show();
				$("#inventaris_t_kode").removeAttr("disabled");
				$("#inventaris_t_kode").val(json.kode);
				$(".inventaris_t_merk").show();
				$("#inventaris_t_merk").val(json.merk);
				$(".inventaris_t_harga_perolehan").show();
				$("#inventaris_t_harga_perolehan").maskMoney();				
				$("#inventaris_t_harga_perolehan").maskMoney('mask', Number(json.hna));
				$(".inventaris_t_tahun_perolehan").show();
				$("#inventaris_t_tahun_perolehan").val(json.tahun_perolehan);
				$(".inventaris_t_usia_penyusutan").show();
				$("#inventaris_t_usia_penyusutan").val(json.usia_penyusutan);
				$(".inventaris_t_kondisi").hide();
				$("#inventaris_t_kondisi").val(json.kondisi_baik);
				$(".inventaris_t_unit").hide();
				$("#inventaris_t_unit").val(json.unit);
				$(".inventaris_t_tanggal_mutasi").hide();
				$("#inventaris_t_tanggal_mutasi").val(json.tanggal_mutasi);
				$("#modal_alert_inventaris_t_add_form").html("");
				$(".error_field").removeClass("error_field");
				$("#inventaris_t_save_btn").removeAttr("onclick");
				$("#inventaris_t_save_btn").attr("onclick", "inventaris_t.update()");
				$("#inventaris_t_add_form").smodal("show");
				$(".alert").show();
			}
		);
	};
	BarangTAction.prototype.validate = function(is_include_unit) {
		var valid = true;
		var invalid_msg = "";
		var kode = $("#inventaris_t_kode").val();
		var merk = $("#inventaris_t_merk").val();
		var tahun_perolehan = $("#inventaris_t_tahun_perolehan").val();
		var usia_penyusutan = $("#inventaris_t_usia_penyusutan").val();
		var unit = $("#inventaris_t_unit").val();
		var tanggal_mutasi = $("#inventaris_t_tanggal_mutasi").val();
		$(".error_field").removeClass("error_field");
		if (kode == "") {
			valid = false;
			invalid_msg += "</br><strong>Kode</strong> tidak boleh kosong";
			$("#inventaris_t_kode").addClass("error_field");
		} 
		if (merk == "") {
			valid = false;
			invalid_msg += "</br><strong>Merk</strong> tidak boleh kosong";
			$("#inventaris_t_merk").addClass("error_field");
		} 
		if (tahun_perolehan == "") {
			valid = false;
			invalid_msg += "</br><strong>Tahun</strong> tidak boleh kosong";
			$("#inventaris_t_tahun_perolehan").addClass("error_field");
		}
		if (unit == "" && is_include_unit) {
			valid = false;
			invalid_msg += "</br><strong>Lokasi</strong> tidak boleh kosong";
			$("#inventaris_t_unit").addClass("error_field");
		} else if (unit == null && is_include_unit) {
			valid = false;
			invalid_msg += "</br><strong>Lokasi</strong> tidak boleh kosong";
			$("#inventaris_t_unit").addClass("error_field");
		}
		if (tanggal_mutasi == "" && is_include_unit) {
			valid = false;
			invalid_msg += "</br><strong>Tanggal</strong> tidak boleh kosong";
			$("#inventaris_t_tanggal_mutasi").addClass("error_field");
		}  
		if (!valid) {
			$("#modal_alert_inventaris_t_add_form").html(
				"<div class='alert alert-block alert-danger'>" +
					"<h4>Peringatan</h4>" +
					invalid_msg +
				"</div>"
			);
		}
		return valid;
	};
	BarangTAction.prototype.update = function() {
		if (!this.validate(false)) {
			return;
		}
		$("#inventaris_t_add_form").smodal("hide");
		showLoading();
		var self = this;
		var data = this.getRegulerData();
		data['command'] = "save";
		data['id'] = $("#inventaris_t_id").val();
		data['kode'] = $("#inventaris_t_kode").val();
		data['merk'] = $("#inventaris_t_merk").val();
		data['tahun_perolehan'] = $("#inventaris_t_tahun_perolehan").val();
		data['usia_penyusutan'] = $("#inventaris_t_usia_penyusutan").val();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) {
					$("#inventaris_t_add_form").smodal("show");
				} else {
					self.view();
				}
				dismissLoading();
			}
		);
	};
	BarangTAction.prototype.prepare_send = function(id) {
		var data = this.getRegulerData();
		data['command'] = "edit";
		data['id'] = id;
		$.post(
			"",
			data,
			function(response) {
				var today = new Date();
				var json = getContent(response);
				if (json == null) return;
				$("#inventaris_t_id").val(json.id);
				$("#inventaris_t_nama_barang").val(json.nama_barang);
				$(".inventaris_t_kode").show();
				$("#inventaris_t_kode").val(json.kode);
				$("#inventaris_t_kode").removeAttr("disabled");
				$("#inventaris_t_kode").attr("disabled", "disabled");
				$(".inventaris_t_merk").hide();
				$("#inventaris_t_merk").val(json.merk);
				$(".inventaris_t_harga_perolehan").hide();
				$("#inventaris_t_harga_perolehan").maskMoney();				
				$("#inventaris_t_harga_perolehan").maskMoney('mask', Number(json.hna));
				$(".inventaris_t_tahun_perolehan").hide();
				$("#inventaris_t_tahun_perolehan").val(json.tahun_perolehan);
				$(".inventaris_t_usia_penyusutan").hide();
				$("#inventaris_t_usia_penyusutan").val(json.usia_penyusutan);
				$(".inventaris_t_kondisi").hide();
				$("#inventaris_t_kondisi").val(json.kondisi_baik);
				$(".inventaris_t_unit").show();
				$("#inventaris_t_unit").val(json.unit);
				$(".inventaris_t_tanggal_mutasi").show();
				$("#inventaris_t_tanggal_mutasi").val("");
				$("#inventaris_t_save_btn").removeAttr("onclick");
				$("#inventaris_t_save_btn").attr("onclick", "inventaris_t.send()");
				$("#inventaris_t_add_form").smodal("show");
				$(".alert").hide();
			}
		);
	};
	BarangTAction.prototype.send = function() {
		if (!this.validate(true)) {
			return;
		}
		$("#inventaris_t_add_form").smodal("hide");
		showLoading();
		var self = this;
		var data = this.getRegulerData();
		data['command'] = "save";
		data['push_command'] = "insert";
		data['id'] = $("#inventaris_t_id").val();
		data['unit'] = $("#inventaris_t_unit").val();
		data['tanggal_mutasi'] = $("#inventaris_t_tanggal_mutasi").val();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) {
					$("#inventaris_t_add_form").smodal("show");
				} else {
					self.view();
				}
				dismissLoading();
			}
		);
	};
	BarangTAction.prototype.edit_kondisi = function(id) {
		var data = this.getRegulerData();
		data['command'] = "edit";
		data['id'] = id;
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#inventaris_t_id").val(json.id);
				$("#inventaris_t_nama_barang").val(json.nama_barang);
				$(".inventaris_t_kode").show();				
				$("#inventaris_t_kode").val(json.kode);
				$("#inventaris_t_kode").removeAttr("disabled");
				$("#inventaris_t_kode").attr("disabled", "disabled");
				$(".inventaris_t_merk").hide();
				$("#inventaris_t_merk").val(json.merk);
				$(".inventaris_t_harga_perolehan").hide();
				$("#inventaris_t_harga_perolehan").maskMoney();				
				$("#inventaris_t_harga_perolehan").maskMoney('mask', Number(json.hna));
				$(".inventaris_t_tahun_perolehan").hide();
				$("#inventaris_t_tahun_perolehan").val(json.tahun_perolehan);
				$(".inventaris_t_usia_penyusutan").hide();
				$("#inventaris_t_usia_penyusutan").val(json.usia_penyusutan);
				$(".inventaris_t_kondisi").show();
				$("#inventaris_t_kondisi").val(json.kondisi_baik);
				$(".inventaris_t_unit").hide();
				$("#inventaris_t_unit").val(json.unit);
				$(".inventaris_t_tanggal_mutasi").hide();
				$("#inventaris_t_tanggal_mutasi").val(json.tanggal_mutasi);
				$("#inventaris_t_save_btn").removeAttr("onclick");
				$("#inventaris_t_save_btn").attr("onclick", "inventaris_t.update_kondisi()");
				$("#inventaris_t_add_form").smodal("show");
				$(".alert").hide();
			}
		);
	};
	BarangTAction.prototype.update_kondisi = function() {
		$("#inventaris_t_add_form").smodal("hide");
		showLoading();
		var self = this;
		var data = this.getRegulerData();
		data['command'] = "save";
		data['push_command'] = "update";
		data['id'] = $("#inventaris_t_id").val();
		data['kondisi_baik'] = $("#inventaris_t_kondisi").val();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) {
					$("#inventaris_t_add_form").smodal("show");
				} else {
					self.view();
				}
				dismissLoading();
			}
		);
	};
	BarangTAction.prototype.print_kode = function(kode) {
		$("#modal_alert_print_kode_add_form").html("");
		$(".error_field").removeClass("error_field");
		$("#print_kode_kode").val(kode);
		$("#print_kode_jumlah").val("1");
		var ukuran_font = $("#print_kode_ukuran_setting").val();
		$("#preview_kode").html(
			"<table border='" + (ukuran_font / 2) + "' cellpadding='" + ((ukuran_font / 2) * 3) + "' class='united'>" +
				"<tr>" +
					"<td id='kode_content'><font size='" + ukuran_font + "'><b>" + kode + "</b></td>" +
				"</tr>" +
			"</table>"
		);
		$("#print_kode_add_form").smodal("show");
	};
	BarangTAction.prototype.validate_print_kode = function() {
		var valid = true;
		var invalid_msg = "";
		var jumlah = $("#print_kode_jumlah").val();
		$(".error_field").removeClass("error_field");
		if (jumlah == "") {
			valid = false;
			invalid_msg += "</br><strong>Jumlah</strong> tidak boleh kosong";
			$("#print_kode_jumlah").addClass("error_field");
		} else if (!is_numeric(jumlah)) {
			valid = false;
			invalid_msg += "</br><strong>Jumlah</strong> seharusnya numerik (0-9)";
			$("#print_kode_jumlah").addClass("error_field");
		} else if (jumlah == 0) {
			valid = false;
			invalid_msg += "</br><strong>Jumlah</strong> tidak boleh 0 (nol)";
			$("#print_kode_jumlah").addClass("error_field");
		}
		if (!valid) {
			$("#modal_alert_print_kode_add_form").html(
				"<div class='alert alert-block alert-danger'>" +
					"<h4>Peringatan</h4>" +
					invalid_msg +
				"</div>"
			);
		}
		return valid;
	};
	BarangTAction.prototype.view_history = function(id) {
		var data = this.getRegulerData();
		data['command'] = "edit";
		data['id'] = id;
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#history_id_inventaris").val(id);
				$("#history_nama_barang").val(json.nama_barang);
				$("#history_hna").val("Rp. " + (parseFloat(json.hna)).formatMoney("2", ".", ","));
				detail_history.setSuperCommand("detail_history");
				detail_history.view();
				$("#history_add_form").smodal("show");
			}
		);
	};
	BarangTAction.prototype.cetak_kode = function() {
		if (!this.validate_print_kode())
			return;
		var ukuran = $("#print_kode_ukuran_setting").val();			
		var kode = $("#print_kode_kode").val();
		var jumlah = $("#print_kode_jumlah").val();
		var data_print = "";
		for(var i = 0; i < jumlah; i++) {
			data_print += 	"<table border='" + (ukuran / 2) + "' cellpadding='" + ((ukuran / 2) * 3) + "' class='united'>" +
								"<tr>" +
									"<td id='kode_content'><font size='" + ukuran + "'><b>" + kode + "</b></td>" +
								"</tr>" +
							"</table>";
			if (i + 1 < jumlah)
				data_print += "<br/>";
		}
		smis_print(data_print);
	};
	
	function DetailHistoryAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	DetailHistoryAction.prototype.constructor = DetailHistoryAction;
	DetailHistoryAction.prototype = new TableAction();
	DetailHistoryAction.prototype.getViewData = function() {
		var data = TableAction.prototype.getViewData.call(this);
		data['id_inventaris'] = $("#history_id_inventaris").val();
		console.log(data);
		return data;
	};
	DetailHistoryAction.prototype.print = function() {
		var data = this.getRegulerData();
		data['super_command'] = "detail_history";
		data['command'] = "print_history";
		data['id_inventaris'] = $("#history_id_inventaris").val();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				smis_print(json);
			}
		);
	};

	var inventaris_t;
	var detail_history;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		$(".mydate").datepicker();
		$(".mydatetime").datetimepicker({ minuteStep: 1});
		$("#print_kode_ukuran_setting").on("change", function() {
			var ukuran = $("#print_kode_ukuran_setting").val();			
			var kode = $("#print_kode_kode").val();
			if (kode != "") {
				$("#preview_kode").html(
					"<table border='" + (ukuran / 2) + "' cellpadding='" + ((ukuran / 2) * 3) + "' class='united'>" +
						"<tr>" +
							"<td id='kode_content'><font size='" + ukuran + "'><b>" + kode + "</b></td>" +
						"</tr>" +
					"</table>"
				);
			}
		});
		detail_history = new DetailHistoryAction(
			"detail_history",
			"gudang_umum",
			"daftar_barang_terinventarisasi",
			new Array()
		);
		var inventaris_t_columns = new Array("id", "id_dbarang_masuk", "nama_barang", "medis", "hna", "kode", "merk", "tahun_perolehan", "usia_penyusutan", "kondisi_baik", "unit", "harga_perolehan", "tanggal_mutasi");
		inventaris_t = new BarangTAction(
			"inventaris_t",
			"gudang_umum",
			"daftar_barang_terinventarisasi",
			inventaris_t_columns
		);
	});
</script>
<style type="text/css">
	.united { 
		page-break-inside:avoid !important; 
	}
</style>