<?php
	require_once("smis-base/smis-include-duplicate.php");
	global $db;
	
	$barang_table = new Table(
		array("Nomor", "Kode", "Jenis", "Barang", "No. BBM", "Merk", "Harga", "Tahun Perolehan", "Penyusutan", "Kondisi", "Lokasi", "Status"),
		"",
		null,
		true
	);
	$barang_table->setName("barang_t_unit");
	$barang_table->setReloadButtonEnable(false);
	$barang_table->setAddButtonEnable(false);
	$barang_table->setPrintButtonEnable(false);
	$barang_table->setEditButtonEnable(false);
	$barang_table->setDelButtonEnable(false);
	$btn = new Button("", "", "Riwayat Inventaris");
	$btn->setAtribute("data-content='Lihat Riwayat' data-toggle='popover'");
	$btn->setIcon("fa fa-history");
	$btn->setIsButton(Button::$ICONIC);
	$barang_table->addContentButton("view_history", $btn);
	$btn = new Button("", "", "Cetak Kode");
	$btn->setClass("btn-inverse");
	$btn->setAtribute("data-content='Ubah' data-toggle='popover'");
	$btn->setIcon("icon-print icon-white");
	$btn->setIsButton(Button::$ICONIC);
	$barang_table->addContentButton("print_kode", $btn);

	$history_modal = new Modal("iu_history_add_form", "smis_form_container", "iu_history");
	$history_modal->setTitle("Riwayat Inventaris");
	$history_modal->setClass(Modal::$FULL_MODEL);
	$id_hidden = new Hidden("iu_history_id_inventaris", "iu_history_id_inventaris", "");
	$history_modal->addElement("", $id_hidden);
	$nama_barang_text = new Text("iu_history_nama_barang", "iu_history_nama_barang", "");
	$nama_barang_text->setAtribute("disabled='disabled'");
	$history_modal->addElement("Nama Barang", $nama_barang_text);
	$hna_text = new Text("iu_history_hna", "iu_history_hna", "");
	$hna_text->setAtribute("disabled", "disabled");
	$history_modal->addElement("H. Perolehan", $hna_text);
	$history_button = new Button("", "", "Cetak");
	$history_button->setClass("btn-inverse");
	$history_button->setIsButton(Button::$ICONIC);
	$history_button->setIcon("icon-print icon-white");
	$history_button->setAction("iu_detail_history.print()");
	$history_modal->addElement("", $history_button);
	$detail_history_table = new Table(
		array("No.", "Tanggal", "Merk", "Kode", "Mutasi / Retur", "Unit", "Petugas Entri"),
		"",
		null,
		true
	);
	$detail_history_table->setName("iu_detail_history");
	$detail_history_table->setAction(false);
	$history_modal->addBody("iu_detail_history_table", $detail_history_table);
	$history_button = new Button("", "", "OK");
	$history_button->setAtribute("id='iu_history_ok_btn'");
	$history_button->setClass("btn-success");
	$history_button->setAction("$($(this).data('target')).smodal('hide')");
	$history_modal->addFooter($history_button);

	if (isset($_POST['super_command']) && $_POST['super_command'] == "detail_history") {
		if (isset($_POST['command'])) {
			$detail_history_adapter = new SimpleAdapter(true, "No.");
			$detail_history_adapter->add("Tanggal", "tanggal", "date d M Y");
			$detail_history_adapter->add("Kode", "kode");
			$detail_history_adapter->add("Merk", "merk");
			$detail_history_adapter->add("Mutasi / Retur", "status", "unslug");
			$detail_history_adapter->add("Unit", "unit", "unslug");
			$detail_history_adapter->add("Petugas Entri", "nama_user");
			$filter = "";
			if (isset($_POST['kriteria'])) {
				$filter = " AND (a.kode LIKE '%" . $_POST['kriteria'] . "%' OR a.merk LIKE '%" . $_POST['kriteria'] . "%' OR a.nama_user LIKE '%" . $_POST['kriteria'] . "%')";
			}
			$detail_history_dbtable = new DBTable($db, "smis_gd_riwayat_inventaris");
			$query_value = "
				SELECT a.*
				FROM smis_gd_riwayat_inventaris a
				WHERE a.id_inventaris = '" . $_POST['id_inventaris'] . "' AND a.prop NOT LIKE 'del' " . $filter . "
			";
			$query_count = "
				SELECT COUNT(*)
				FROM (" . $query_value . ") v
			";
			$detail_history_dbtable->setPreferredQuery(true, $query_value, $query_count);
			require_once("gudang_umum/responder/DetailHistoryDBResponder.php");
			$detail_history_dbresponder = new DetailHistoryDBResponder(
				$detail_history_dbtable,
				$detail_history_table,
				$detail_history_adapter
			);
			$data = $detail_history_dbresponder->command($_POST['command']);
			echo json_encode($data);
			return;
		}
		return;
	}

	if (isset($_POST['command'])) {
		require_once("gudang_umum/adapter/BarangTAdapter.php");
		$barang_adapter = new BarangTAdapter();
		$barang_dbtable = new DBTable($db, "smis_gd_inventaris");
		$filter = "";
		if (isset($_POST['kriteria'])) {
			$filter = "
				AND (			
					a.kode LIKE '%" . $_POST['kriteria'] . "%' OR
					a.nama_barang LIKE '%" . $_POST['kriteria'] . "%' OR
					c.no_bbm LIKE '%" . $_POST['kriteria'] . "%' OR
					a.merk LIKE '%" . $_POST['kriteria'] . "%'
				)
			";
		}
		$query_value = "
			SELECT
				a.*, c.no_bbm
			FROM
				smis_gd_inventaris a
					INNER JOIN smis_gd_dbarang_masuk b ON a.id_dbarang_masuk = b.id
					INNER JOIN smis_gd_barang_masuk c ON b.id_barang_masuk = c.id
			WHERE
				a.prop LIKE ''
				 	AND a.tipe = 'mutasi'
					" . $filter . "
		";
		$query_count = "
			SELECT
				COUNT(*)
			FROM
				(" . $query_value . ") v
		";
		$barang_dbtable->setPreferredQuery(true, $query_value, $query_count);
		$barang_dbresponder = new DuplicateResponder(
			$barang_dbtable,
			$barang_table,
			$barang_adapter
		);
		$data = $barang_dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}

	$print_kode_modal = new Modal("iu_print_kode_add_form", "smis_form_container", "iu_print_kode");
	$print_kode_modal->setTitle("Cetak Kode");
	$kode_hidden = new Hidden("iu_print_kode_kode", "iu_print_kode_kode", "");
	$print_kode_modal->addElement("", $kode_hidden);
	$option = new OptionBuilder();
	$option->add("Kecil", "2");
	$option->add("Sedang", "4", "1");
	$option->add("Besar", "6");
	$option->add("Sangat Besar", "8");
	$ukuran_select = new Select("iu_print_kode_ukuran_setting", "iu_print_kode_ukuran_setting", $option->getContent());
	$print_kode_modal->addElement("Pilihan", $ukuran_select);
	$jumlah_text = new Text("iu_print_kode_jumlah", "iu_print_kode_jumlah", "");
	$print_kode_modal->addElement("Jumlah", $jumlah_text);
	$button = new Button("", "", "Cetak");
	$button->setClass("btn-inverse");
	$button->setIcon("icon-print icon-white");
	$button->setIsButton(Button::$ICONIC);
	$button->setAction("barang_t_unit.cetak_kode()");
	$print_kode_modal->addFooter($button);
	$print_kode_modal->addHTML("<center><div id='iu_preview_kode'></div></center>", "before");

	echo $history_modal->getHtml();
	echo $print_kode_modal->getHtml();
	echo $barang_table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	var barang_t_unit;
	var iu_detail_history;
	$(document).ready(function() {
		$("#iu_print_kode_ukuran_setting").on("change", function() {
			var ukuran = $("#iu_print_kode_ukuran_setting").val();			
			var kode = $("#iu_print_kode_kode").val();
			if (kode != "") {
				$("#iu_preview_kode").html(
					"<table border='" + (ukuran / 2) + "' cellpadding='" + ((ukuran / 2) * 3) + "' class='united'>" +
						"<tr>" +
							"<td id='kode_content'><font size='" + ukuran + "'><b>" + kode + "</b></td>" +
						"</tr>" +
					"</table>"
				);
			}
		});
		iu_detail_history = new TableAction(
			"iu_detail_history",
			"gudang_umum",
			"daftar_barang_inventaris_unit",
			new Array()
		);
		iu_detail_history.getViewData = function() {
			var data = TableAction.prototype.getViewData.call(this);
			data['id_inventaris'] = $("#iu_history_id_inventaris").val();
			return data;
		};
		iu_detail_history.print = function() {
			var data = this.getRegulerData();
			data['super_command'] = "detail_history";
			data['command'] = "print_history";
			data['id_inventaris'] = $("#iu_history_id_inventaris").val();
			$.post(
				"",
				data,
				function(response) {
					var json = getContent(response);
					if (json == null) return;
					smis_print(json);
				}
			);
		};
		barang_t_unit = new TableAction(
			"barang_t_unit",
			"gudang_umum",
			"daftar_barang_inventaris_unit",
			new Array()
		);
		barang_t_unit.print_kode = function(kode) {
			$("#modal_alert_iu_print_kode_add_form").html("");
			$(".error_field").removeClass("error_field");
			$("#iu_print_kode_kode").val(kode);
			$("#iu_print_kode_jumlah").val("1");
			var ukuran_font = $("#iu_print_kode_ukuran_setting").val();
			$("#iu_preview_kode").html(
				"<table border='" + (ukuran_font / 2) + "' cellpadding='" + ((ukuran_font / 2) * 3) + "' class='united'>" +
					"<tr>" +
						"<td id='kode_content'><font size='" + ukuran_font + "'><b>" + kode + "</b></td>" +
					"</tr>" +
				"</table>"
			);
			$("#iu_print_kode_add_form").smodal("show");
		};
		barang_t_unit.validate_print_kode = function() {
			var valid = true;
			var invalid_msg = "";
			var jumlah = $("#iu_print_kode_jumlah").val();
			$(".error_field").removeClass("error_field");
			if (jumlah == "") {
				valid = false;
				invalid_msg += "</br><strong>Jumlah</strong> tidak boleh kosong";
				$("#iu_print_kode_jumlah").addClass("error_field");
			} else if (!is_numeric(jumlah)) {
				valid = false;
				invalid_msg += "</br><strong>Jumlah</strong> seharusnya numerik (0-9)";
				$("#iu_print_kode_jumlah").addClass("error_field");
			} else if (jumlah == 0) {
				valid = false;
				invalid_msg += "</br><strong>Jumlah</strong> tidak boleh 0 (nol)";
				$("#iu_print_kode_jumlah").addClass("error_field");
			}
			if (!valid) {
				$("#modal_alert_iu_print_kode_add_form").html(
					"<div class='alert alert-block alert-danger'>" +
						"<h4>Peringatan</h4>" +
						invalid_msg +
					"</div>"
				);
			}
			return valid;
		};
		barang_t_unit.view_history = function(id) {
			var data = this.getRegulerData();
			data['command'] = "edit";
			data['id'] = id;
			$.post(
				"",
				data,
				function(response) {
					var json = getContent(response);
					if (json == null) return;
					$("#iu_history_id_inventaris").val(id);
					$("#iu_history_nama_barang").val(json.nama_barang);
					$("#iu_history_hna").val("Rp. " + (parseFloat(json.hna)).formatMoney("2", ".", ","));
					iu_detail_history.setSuperCommand("detail_history");
					iu_detail_history.view();
					$("#iu_history_add_form").smodal("show");
				}
			);
		};
		barang_t_unit.cetak_kode = function() {
			if (!this.validate_print_kode())
				return;
			var ukuran = $("#iu_print_kode_ukuran_setting").val();			
			var kode = $("#iu_print_kode_kode").val();
			var jumlah = $("#iu_print_kode_jumlah").val();
			var data_print = "";
			for(var i = 0; i < jumlah; i++) {
				data_print += 	"<table border='" + (ukuran / 2) + "' cellpadding='" + ((ukuran / 2) * 3) + "' class='united'>" +
									"<tr>" +
										"<td id='kode_content'><font size='" + ukuran + "'><b>" + kode + "</b></td>" +
									"</tr>" +
								"</table>";
				if (i + 1 < jumlah)
					data_print += "<br/>";
			}
			smis_print(data_print);
		};
		barang_t_unit.view();
	});
</script>