<?php
	global $db;

	$table = new Table(
		array("Nomor", "Kode", "Jenis", "Barang", "No. BBM", "Merk", "Harga", "Tahun Perolehan", "Penyusutan", "Kondisi", "Lokasi"),
		"",
		null,
		true
	);
	$table->setName("barang_inventaris_rusak");
	$table->setAddButtonEnable(false);
	$table->setPrintButtonEnable(false);
	$table->setReloadButtonEnable(false);
	$table->setDelButtonEnable(false);

	if (isset($_POST['command'])) {
		class BarangAdapter extends ArrayAdapter {
			public function adapt($row) {
				$array = array();
				$array['id'] = $row->id;
				$array['unit'] = $row->unit;
				$array['kode'] = $row->kode;
				$array['Nomor'] = self::format("digit8", $row->id);
				$array['Kode'] = $row->kode;
				if ($row->medis)
					$array['Jenis'] = "Medis";
				else
					$array['Jenis'] = "Non-Medis";
				$array['Barang'] = $row->nama_barang;
				$array['No. BBM'] = $row->no_bbm;
				$array['Merk'] = $row->merk;
				$array['Harga'] = self::format("money Rp.", $row->hna);
				$array['Tahun Perolehan'] = $row->tahun_perolehan;
				$array['Penyusutan'] = $row->usia_penyusutan . " tahun";
				if ($row->kondisi_baik)
					$array['Kondisi'] = "Baik";
				else 
					$array['Kondisi'] = "Rusak";
				if ($row->unit == "")
					$array['Lokasi'] = "-";
				else
					$array['Lokasi'] = self::format("unslug", $row->unit);
				return $array;
			}
		}
		$adapter = new BarangAdapter();
		$dbtable = new DBTable($db, "smis_gd_inventaris");
		$dbtable->setCustomKriteria(" kondisi_baik = 0 AND tipe NOT LIKE 'musnah' ");
		$dbresponder = new DBResponder(
			$dbtable,
			$table,
			$adapter
		);
		$data = $dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}

	$table->addModal("id", "hidden", "", "");
	$table->addModal("kode", "text", "Kode", "", "y", null, true);
	$table->addModal("nama_barang", "text", "Barang", "", "y", null, true);
	$medis_option = new OptionBuilder();
	$medis_option->add("", "", "1");
	$medis_option->add("Medis", "1");
	$medis_option->add("Non-Medis", "0");
	$table->addModal("medis", "select", "Jenis", $medis_option->getContent(), "y", null, true);
	$table->addModal("merk", "text", "Merk", "", "y", null, true);
	$kondisi_baik_option = new OptionBuilder();
	$kondisi_baik_option->add("Baik", "1");
	$kondisi_baik_option->add("Rusak", "0");
	$table->addModal("kondisi_baik", "select", "Kondisi", $kondisi_baik_option->getContent());
	$modal = $table->getModal();
	$modal->setTitle("Barang Inventaris Rusak");

	echo $modal->getHtml();
	echo $table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	var barang_inventaris_rusak;
	$(document).ready(function() {
		barang_inventaris_rusak = new TableAction(
			"barang_inventaris_rusak",
			"gudang_umum",
			"daftar_barang_inventaris_rusak",
			new Array("id", "kode", "nama_barang", "medis", "merk", "kondisi_baik")
		);
	});
</script>