<?php
	require_once("smis-base/smis-include-service-consumer.php");
	
	class BarangKeluarTable extends Table {
		public function getBodyContent(){
			$content = "";
			if ($this->content!=NULL) {
				foreach ($this->content as $d) {
					$content .= "<tr>";
					foreach ($this->header as $h) {
						$content .= "<td>" . $d[$h] . "</td>";
					}
					if ($this->is_action) {
						$content .= "<td>" . $this->getFilteredContentButton($d['id'], $d['status'], $d['status_acc'], $d['prop'])->getHtml() . "</td>";
					}
					$content .= "</tr>";
				}
			}
			return $content;
		}
		public function getFilteredContentButton($id, $status, $status_acc, $prop) {
			$btn_group = new ButtonGroup("noprint");
			if ($status == "sudah") {
				$btn = new Button("", "", "Lihat");
				$btn->setAction($this->action . ".detail('" . $id . "')");
				$btn->setClass("btn-success");
				$btn->setAtribute("data-content='Lihat' data-toggle='popover'");
				$btn->setIcon("icon-eye-open icon-white");
				$btn->setIsButton(Button::$ICONIC);
				$btn_group->addElement($btn);
			} else if ($status == "belum" && $status_acc == 0 && $prop == "") {
				$btn = new Button("", "", "Edit");
				$btn->setClass("btn-warning");
				$btn->setAction($this->action . ".edit('" . $id . "')");
				$btn->setAtribute("data-content='Edit' data-toggle='popover'");
				$btn->setIcon("fa fa-pencil");
				$btn->setIsButton(Button::$ICONIC);
				$btn_group->addElement($btn);
			}
			if ($prop == "del") {
				$btn = new Button("", "", "Lihat");
				$btn->setAction($this->action . ".detail('" . $id . "')");
				$btn->setClass("btn-inverse");
				$btn->setAtribute("data-content='Lihat' data-toggle='popover'");
				$btn->setIcon("icon-eye-open icon-white");
				$btn->setIsButton(Button::$ICONIC);
				$btn_group->addElement($btn);
			} else {
				$btn = new Button("", "", "Cetak");
				$btn->setAction($this->action . ".export_pdf('" . $id . "', '" . $status . "')");
				$btn->setClass("btn-inverse");
				$btn->setAtribute("data-content='Cetak' data-toggle='popover'");
				$btn->setIcon("fa fa-print");
				$btn->setIsButton(Button::$ICONIC);
				$btn_group->addElement($btn);
			}
			return $btn_group;
		}
	}
	$barang_keluar_table = new BarangKeluarTable(
		array("Nomor", "Tanggal Keluar", "Unit", "Status"),
		"Gudang Umum : Barang Keluar",
		null,
		true
	);
	$barang_keluar_table->setName("barang_keluar");
	
	if (isset($_POST['super_command']) && $_POST['super_command'] == "barang_keluar") {
		if (isset($_POST['command'])) {
			require_once("gudang_umum/adapter/BarangKeluarAdapter.php");
			$barang_keluar_adapter = new BarangKeluarAdapter();
			$columns = array("id", "tanggal", "unit", "status", "keterangan", "prop");
			$barang_keluar_dbtable = new DBTable(
				$db,
				"smis_gd_barang_keluar",
				$columns
			);
			$barang_keluar_dbtable->setDelete(true);
			$barang_keluar_dbtable->setOrder("id DESC");
			require_once("gudang_umum/responder/BarangKeluarDBResponder.php");
			$barang_keluar_dbresponder = new BarangKeluarDBResponder(
				$barang_keluar_dbtable,
				$barang_keluar_table,
				$barang_keluar_adapter
			);
			$data = $barang_keluar_dbresponder->command($_POST['command']);
			echo json_encode($data);
			return;
		}
		return;
	}

	//get barang chooser:
	$barang_table = new Table(
		array("Barang", "Jenis", "Stok"),
		"",
		null,
		true
	);
	$barang_table->setName("barang");
	$barang_table->setModel(Table::$SELECT);
	$barang_adapter = new SimpleAdapter();
	$barang_adapter->add("Barang", "nama_barang");
	$barang_adapter->add("Jenis", "nama_jenis_barang");
	$barang_adapter->add("Stok", "stok");
	$barang_dbtable = new DBTable($db, "smis_gd_stok_barang");
	$barang_dbtable->setViewForSelect(true);
	$filter = "";
	if (isset($_POST['kriteria'])) {
		$filter = " AND (smis_gd_stok_barang.nama_barang LIKE '%" . $_POST['kriteria'] . "%' OR smis_gd_stok_barang.nama_jenis_barang LIKE '%" . $_POST['kriteria'] . "%')";
	}
	$query_value = "
		SELECT *
		FROM (
			SELECT id_barang AS 'id', nama_barang, nama_jenis_barang, GROUP_CONCAT(CONCAT(sisa, ' ', satuan) ORDER BY satuan, sisa ASC SEPARATOR ', ') AS 'stok'
			FROM (
				SELECT smis_gd_dbarang_masuk.id_barang, smis_gd_stok_barang.nama_barang, smis_gd_stok_barang.nama_jenis_barang, SUM(smis_gd_stok_barang.sisa) AS 'sisa', smis_gd_stok_barang.satuan, smis_gd_stok_barang.konversi, smis_gd_stok_barang.satuan_konversi
				FROM smis_gd_stok_barang LEFT JOIN smis_gd_dbarang_masuk ON smis_gd_stok_barang.id_dbarang_masuk = smis_gd_dbarang_masuk.id
				WHERE smis_gd_stok_barang.prop NOT LIKE 'del' AND smis_gd_stok_barang.konversi = '1' " . $filter . "
				GROUP BY smis_gd_dbarang_masuk.id_barang, smis_gd_stok_barang.satuan, smis_gd_stok_barang.konversi, smis_gd_stok_barang.satuan_konversi
			) v_barang
			GROUP BY id_barang
		) v_stok
	";
	$query_count = "
		SELECT COUNT(*)
		FROM (
			SELECT id_barang AS 'id', nama_barang, nama_jenis_barang, GROUP_CONCAT(CONCAT(sisa, ' ', satuan) ORDER BY satuan, sisa ASC SEPARATOR ', ') AS 'stok'
			FROM (
				SELECT smis_gd_dbarang_masuk.id_barang, smis_gd_stok_barang.nama_barang, smis_gd_stok_barang.nama_jenis_barang, SUM(smis_gd_stok_barang.sisa) AS 'sisa', smis_gd_stok_barang.satuan, smis_gd_stok_barang.konversi, smis_gd_stok_barang.satuan_konversi
				FROM smis_gd_stok_barang LEFT JOIN smis_gd_dbarang_masuk ON smis_gd_stok_barang.id_dbarang_masuk = smis_gd_dbarang_masuk.id
				WHERE smis_gd_stok_barang.prop NOT LIKE 'del' AND smis_gd_stok_barang.konversi = '1' " . $filter . "
				GROUP BY smis_gd_dbarang_masuk.id_barang, smis_gd_stok_barang.satuan, smis_gd_stok_barang.konversi, smis_gd_stok_barang.satuan_konversi
			) v_barang
			GROUP BY id_barang
		) v_stok
	";
	$barang_dbtable->setPreferredQuery(true, $query_value, $query_count);
	class BarangDBResponder extends DBResponder {
		public function edit() {
			$id = $_POST['id'];
			$data['header'] = $this->dbtable->get_row("
				SELECT DISTINCT smis_gd_dbarang_masuk.id_barang, smis_gd_stok_barang.nama_barang, smis_gd_stok_barang.nama_jenis_barang
				FROM smis_gd_stok_barang LEFT JOIN smis_gd_dbarang_masuk ON smis_gd_stok_barang.id_dbarang_masuk = smis_gd_dbarang_masuk.id
				WHERE smis_gd_stok_barang.prop NOT LIKE 'del' AND smis_gd_dbarang_masuk.id_barang = '" . $id . "'
			");
			$satuan_rows = $this->dbtable->get_result("
				SELECT DISTINCT smis_gd_stok_barang.satuan, smis_gd_stok_barang.konversi, smis_gd_stok_barang.satuan_konversi
				FROM smis_gd_stok_barang LEFT JOIN smis_gd_dbarang_masuk ON smis_gd_stok_barang.id_dbarang_masuk = smis_gd_dbarang_masuk.id
				WHERE smis_gd_dbarang_masuk.id_barang = '" . $id . "' AND smis_gd_stok_barang.prop NOT LIKE 'del'
			");
			$satuan_option = "";
			foreach($satuan_rows as $sr) {
				if ($sr->konversi == 1) {
					$satuan_option .= "
						<option value='" . $sr->konversi . "_" . $sr->satuan_konversi . "'>" . $sr->satuan . "</option>
					";
				}
			}
			$data['satuan_option'] = $satuan_option;
			return $data;
		}
	}
	$barang_dbresponder = new BarangDBResponder(
		$barang_dbtable,
		$barang_table,
		$barang_adapter
	);
	
	//get sisa by id_barang, satuan, konversi, dan satuan_konversi:
	$sisa_table = new Table(
		array("id_barang", "sisa", "satuan", "konversi", "satuan_konversi"),
		"",
		null,
		true
	);
	$sisa_table->setName("sisa");
	$sisa_adapter = new SimpleAdapter();
	$sisa_adapter->add("id_barang", "id_barang");
	$sisa_adapter->add("sisa", "sisa");
	$sisa_adapter->add("satuan", "satuan");
	$sisa_adapter->add("konversi", "konversi");
	$sisa_adapter->add("satuan_konversi", "satuan_konversi");
	$columns = array("id_barang", "sisa", "satuan", "konversi", "satuan_konversi");
	$sisa_dbtable = new DBTable(
		$db,
		"smis_gd_stok_barang",
		$columns
	);
	class SisaDBResponder extends DBResponder {
		public function edit() {
			$id_barang = $_POST['id_barang'];
			$satuan = $_POST['satuan'];
			$konversi = $_POST['konversi'];
			$satuan_konversi = $_POST['satuan_konversi'];
			$data = $this->dbtable->get_row("
				SELECT id_barang, SUM(sisa) AS 'sisa', satuan, konversi, satuan_konversi
				FROM (
					SELECT smis_gd_dbarang_masuk.id_barang, smis_gd_stok_barang.sisa, smis_gd_stok_barang.satuan, smis_gd_stok_barang.konversi, smis_gd_stok_barang.satuan_konversi	
					FROM smis_gd_stok_barang LEFT JOIN smis_gd_dbarang_masuk ON smis_gd_stok_barang.id_dbarang_masuk = smis_gd_dbarang_masuk.id
					WHERE smis_gd_stok_barang.prop NOT LIKE 'del' AND smis_gd_dbarang_masuk.id_barang = '" . $id_barang . "' AND smis_gd_stok_barang.satuan = '" . $satuan . "' AND smis_gd_stok_barang.konversi = '" . $konversi . "' AND smis_gd_stok_barang.satuan_konversi = '" . $satuan_konversi . "'
				) v_stok_barang
				GROUP BY id_barang, satuan, konversi, satuan_konversi
			");
			return $data;
		}
	}
	$sisa_dbresponder = new SisaDBResponder(
		$sisa_dbtable,
		$sisa_table,
		$sisa_adapter
	);
	
	$super_command = new SuperCommand();
	$super_command->addResponder("barang", $barang_dbresponder);
	$super_command->addResponder("sisa", $sisa_dbresponder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}
	
	$barang_keluar_modal = new Modal("barang_keluar_add_form", "smis_form_container", "barang_keluar");
	$barang_keluar_modal->setTitle("Barang Keluar");
	$barang_keluar_modal->setClass(Modal::$FULL_MODEL);
	$id_hidden = new Hidden("barang_keluar_id", "barang_keluar_id", "");
	$barang_keluar_modal->addElement("", $id_hidden);
	$tanggal_text = new Text("barang_keluar_tanggal", "barang_keluar_tanggal", "");
	$tanggal_text->setClass("mydate");
	$tanggal_text->setAtribute("data-date-format='yyyy-m-d'");
	$barang_keluar_modal->addElement("Tanggal", $tanggal_text);
	class UnitServiceConsumer extends ServiceConsumer {
		public function __construct($db) {
			parent::__construct($db, "is_inventory");
		}		
		public function proceedResult() {
			$content = array();
			$result = json_decode($this->result, true);
			foreach($result as $autonomous) {
				foreach($autonomous as $entity=>$res) {
					if($this->isRawat($entity) == "0" && $res['value_barang']=="1"){
						$option = array();
						$option['value'] = $entity;
						$option['name'] = ArrayAdapter::format("unslug", $res['name']);
						$content[] = $option;
					}
				}
			}
			return $content;
		}
		private function isRawat($slug) {
			if (strpos($slug, "poli_gigi") >= 0)
				return "0";
			global $db;
			return $db->get_var("
				SELECT
					COUNT(*) jumlah
				FROM
					smis_adm_prototype
				WHERE
					slug LIKE '" . $slug . "'
						AND parent LIKE 'rawat'
			") > 0 ? "1" : "0";		
		}
	}
	$unit_service_consumer = new UnitServiceConsumer($db);
	$unit_service_consumer->execute();
	$unit_option = $unit_service_consumer->getContent();
	$unit_select = new Select("barang_keluar_unit", "barang_keluar_unit", $unit_option);
	$barang_keluar_modal->addElement("Unit", $unit_select);
	class DBarangKeluarTable extends Table {
		public function getHeaderButton() {
			$btn_group = new ButtonGroup("noprint");
			$btn = new Button("", "", "Tambah");
			$btn->setAction($this->action . ".show_add_form()");
			$btn->setClass("btn-primary");
			$btn->setAtribute("id='dbarang_keluar_add'");
			$btn->setIcon("icon-plus icon-white");
			$btn->setIsButton(Button::$ICONIC);
			$btn_group->addElement($btn);
			return $btn_group->getHtml();
		}
	}
	$dbarang_keluar_table = new DBarangKeluarTable(
		array("Nama Barang", "Jenis Barang", "Jumlah", "Keterangan"),
		"",
		null,
		true
	);
	$dbarang_keluar_table->setName("dbarang_keluar");
	$dbarang_keluar_table->setFooterVisible(false);
	$barang_keluar_modal->addBody("dbarang_keluar_table", $dbarang_keluar_table);
	$save_button = new Button("", "", "Simpan");
	$save_button->setClass("btn-success");
	$save_button->setAtribute("id='barang_keluar_save'");
	$save_button->setIcon("fa fa-floppy-o");
	$save_button->setIsButton(Button::$ICONIC);
	$barang_keluar_modal->addFooter($save_button);
	$ok_button = new Button("", "", "OK");
	$ok_button->setClass("btn-success");
	$ok_button->setAtribute("id='barang_keluar_ok'");
	$ok_button->setAction("$($(this).data('target')).smodal('hide')");
	$barang_keluar_modal->addFooter($ok_button);
	
	$dbarang_keluar_modal = new Modal("dbarang_keluar_add_form", "smis_form_container", "dbarang_keluar");
	$dbarang_keluar_modal->setTitle("Detail Barang Keluar");
	$id_hidden = new Hidden("dbarang_keluar_id", "dbarang_keluar_id", "");
	$dbarang_keluar_modal->addElement("", $id_hidden);
	$id_barang_hidden = new Hidden("dbarang_keluar_id_barang", "dbarang_keluar_id_barang", "");
	$dbarang_keluar_modal->addElement("", $id_barang_hidden);
	$nama_barang_button = new Button("", "", "Pilih");
	$nama_barang_button->setClass("btn-info");
	$nama_barang_button->setAction("barang.chooser('barang', 'barang_button', 'barang', barang)");
	$nama_barang_button->setIcon("icon-white icon-list-alt");
	$nama_barang_button->setIsButton(Button::$ICONIC);
	$nama_barang_button->setAtribute("id='barang_browse'");
	$nama_barang_text = new Text("dbarang_keluar_nama_barang", "dbarang_keluar_nama_barang", "");
	$nama_barang_text->setClass("smis-one-option-input");
	$nama_barang_text->setAtribute("disabled='disabled'");
	$nama_barang_input_group = new InputGroup("");
	$nama_barang_input_group->addComponent($nama_barang_text);
	$nama_barang_input_group->addComponent($nama_barang_button);
	$dbarang_keluar_modal->addElement("Nama Barang", $nama_barang_input_group);
	$nama_jenis_barang_text = new Text("dbarang_keluar_nama_jenis_barang", "dbarang_keluar_nama_jenis_barang", "");
	$nama_jenis_barang_text->setAtribute("disabled='disabled'");
	$dbarang_keluar_modal->addElement("Jenis Barang", $nama_jenis_barang_text);
	$satuan_select = new Select("dbarang_keluar_satuan", "dbarang_keluar_satuan", "");
	$dbarang_keluar_modal->addElement("Satuan", $satuan_select);
	$konversi_hidden = new Hidden("dbarang_keluar_konversi", "dbarang_keluar_konversi", "");
	$konversi_hidden->setAtribute("disabled='disabled'");
	$dbarang_keluar_modal->addElement("", $konversi_hidden);
	$satuan_konversi_hidden = new Hidden("dbarang_keluar_satuan_konversi", "dbarang_keluar_satuan_konversi", "");
	$dbarang_keluar_modal->addElement("", $satuan_konversi_hidden);
	$stok_hidden = new Hidden("dbarang_keluar_stok", "dbarang_keluar_stok", "");
	$dbarang_keluar_modal->addElement("", $stok_hidden);
	$f_stok_text = new Text("dbarang_keluar_f_stok", "dbarang_keluar_f_stok", "");
	$f_stok_text->setAtribute("disabled='disabled'");
	$dbarang_keluar_modal->addElement("Stok", $f_stok_text);
	$jumlah_lama_hidden = new Hidden("dbarang_keluar_jumlah_lama", "dbarang_keluar_jumlah_lama", "");
	$dbarang_keluar_modal->addElement("", $jumlah_lama_hidden);
	$jumlah_text = new Text("dbarang_keluar_jumlah", "dbarang_keluar_jumlah", "");
	$dbarang_keluar_modal->addElement("Jumlah", $jumlah_text);
	$dbarang_keluar_button = new Button("", "", "Simpan");
	$dbarang_keluar_button->setClass("btn-success");
	$dbarang_keluar_button->setAtribute("id='dbarang_keluar_save'");
	$dbarang_keluar_button->setIcon("fa fa-floppy-o");
	$dbarang_keluar_button->setIsButton(Button::$ICONIC);
	$dbarang_keluar_modal->addFooter($dbarang_keluar_button);
	
	echo $dbarang_keluar_modal->getHtml();
	echo $barang_keluar_modal->getHtml();
	echo $barang_keluar_table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");	
?>
<script type="text/javascript">
	function BarangKeluarAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	BarangKeluarAction.prototype.constructor = BarangKeluarAction;
	BarangKeluarAction.prototype = new TableAction();
	BarangKeluarAction.prototype.show_add_form = function() {
		row_id = 0;
		var today = new Date();
		$("#barang_keluar_id").val("");
		$("#barang_keluar_tanggal").val(today.getFullYear() + "-" + (Number(today.getMonth())+1) + "-" + today.getDate());
		$("#barang_keluar_tanggal").removeAttr("disabled");
		$("#barang_keluar_unit").val("");
		$("#barang_keluar_unit").removeAttr("disabled");
		$("#dbarang_keluar_list").children().remove();
		$("#dbarang_keluar_add").show();
		$("#modal_alert_barang_keluar_add_form").html("");
		$(".error_field").removeClass("error_field");
		$("#barang_keluar_save").removeAttr("onclick");
		$("#barang_keluar_save").attr("onclick", "barang_keluar.save()");
		$("#barang_keluar_save").show();
		$("#barang_keluar_ok").hide();
		$("#barang_keluar_add_form").smodal("show");
	};
	BarangKeluarAction.prototype.validate = function() {
		var valid = true;
		var invalid_msg = "";
		var tanggal = $("#barang_keluar_tanggal").val();
		var unit = $("#barang_keluar_unit").find(":selected").text();
		var nord = $("#dbarang_keluar_list").children().length;
		$(".error_field").removeClass("error_field");
		if (tanggal == "") {
			valid = false;
			invalid_msg += "<br/><strong>Tanggal</strong> tidak boleh kosong";
			$("#barang_keluar_tanggal").addClass("error_field");
		}
		if (unit == "") {
			valid = false;
			invalid_msg += "<br/><strong>Unit</strong> tidak boleh kosong";
			$("#barang_keluar_unit").addClass("error_field");
		}
		if (nord == 0) {
			valid = false;
			invalid_msg += "<br/><strong>Detail</strong> tidak boleh kosong";
		}
		if (!valid) {
			$("#modal_alert_barang_keluar_add_form").html(
				"<div class='alert alert-block alert-danger'>" +
					"<h4>Peringatan</h4>" +
					invalid_msg +
				"</div>"
			);
		}
		return valid;
	};
	BarangKeluarAction.prototype.save = function() {
		if (!this.validate()) {
			return;
		}
		$("#barang_keluar_add_form").smodal("hide");
		showLoading();
		var self = this;
		var data = this.getRegulerData();
		data['super_command'] = "barang_keluar";
		data['command'] = "save";
		data['push_command'] = "save";
		data['id'] = "";
		data['tanggal'] = $("#barang_keluar_tanggal").val();
		data['unit'] = $("#barang_keluar_unit").val();
		data['status'] = "belum";
		data['keterangan'] = "";
		var detail = {};
		var nor = $("tbody#dbarang_keluar_list").children("tr").length;
		for(var i = 0; i < nor; i++) {
			var d_data = {};
			var prefix = $("tbody#dbarang_keluar_list").children('tr').eq(i).prop("id");
			d_data['id'] = $("#" + prefix + "_id").text();
			d_data['id_barang'] = $("#" + prefix + "_id_barang").text();
			d_data['nama_barang'] = $("#" + prefix + "_nama_barang").text();
			d_data['nama_jenis_barang'] = $("#" + prefix + "_nama_jenis_barang").text();
			d_data['jumlah'] = $("#" + prefix + "_jumlah").text();
			d_data['satuan'] = $("#" + prefix + "_satuan").text();
			d_data['konversi'] = $("#" + prefix + "_konversi").text();
			d_data['satuan_konversi'] = $("#" + prefix + "_satuan_konversi").text();
			detail[i] = d_data;
		}
		data['detail'] = detail;
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) { 
					$("#barang_keluar_add_form").smodal("show");
				} else {
					self.view();
				}
				dismissLoading();
			}
		);
	};
	BarangKeluarAction.prototype.edit = function(id) {
		var self = this;
		var data = this.getRegulerData();
		data['super_command'] = "barang_keluar";
		data['command'] = "edit";
		data['id'] = id;
		$.post(	
			"",
			data,
			function (response) {
				var json = getContent(response);
				if (json == null) return;
				$("#barang_keluar_id").val(id);
				$("#barang_keluar_tanggal").val(json.header.tanggal);
				$("#barang_keluar_tanggal").removeAttr("disabled");
				$("#barang_keluar_unit").val(json.header.unit);
				$("#barang_keluar_unit").removeAttr("disabled");
				if (json.header.status == "belum") {
					$("#barang_keluar_tanggal").attr("disabled", "disabled");
					$("#barang_keluar_unit").attr("disabled", "disabled");
				}
				$("#dbarang_keluar_add").show();
				row_id = 0;
				$("#dbarang_keluar_list").children("tr").remove();
				for(var i = 0; i < json.detail.length; i++) {
					var dbarang_keluar_id = json.detail[i].id;
					var dbarang_keluar_id_barang_keluar = json.detail[i].id_barang_keluar;
					var dbarang_keluar_id_barang = json.detail[i].id_barang;
					var dbarang_keluar_nama_barang = json.detail[i].nama_barang;
					var dbarang_keluar_nama_jenis_barang = json.detail[i].nama_jenis_barang;
					var dbarang_keluar_jumlah = json.detail[i].jumlah;
					var dbarang_keluar_satuan = json.detail[i].satuan;
					var dbarang_keluar_konversi = json.detail[i].konversi;
					var dbarang_keluar_satuan_konversi = json.detail[i].satuan_konversi;
					$("tbody#dbarang_keluar_list").append(
						"<tr id='data_" + row_id + "'>" +
							"<td style='display: none;' id='data_" + row_id + "_id'>" + dbarang_keluar_id + "</td>" +
							"<td style='display: none;' id='data_" + row_id + "_id_barang'>" + dbarang_keluar_id_barang + "</td>" +
							"<td style='display: none;' id='data_" + row_id + "_jumlah_lama'>" + dbarang_keluar_jumlah + "</td>" +
							"<td style='display: none;' id='data_" + row_id + "_jumlah'>" + dbarang_keluar_jumlah + "</td>" +
							"<td style='display: none;' id='data_" + row_id + "_satuan'>" + dbarang_keluar_satuan + "</td>" +
							"<td style='display: none;' id='data_" + row_id + "_konversi'>" + dbarang_keluar_konversi + "</td>" +
							"<td style='display: none;' id='data_" + row_id + "_satuan_konversi'>" + dbarang_keluar_satuan_konversi + "</td>" +
							"<td id='data_" + row_id + "_nama_barang'>" + dbarang_keluar_nama_barang + "</td>" +
							"<td id='data_" + row_id + "_nama_jenis_barang'>" + dbarang_keluar_nama_jenis_barang + "</td>" +
							"<td id='data_" + row_id + "_f_jumlah'>" + dbarang_keluar_jumlah + " " + dbarang_keluar_satuan + "</td>" +
							"<td id='data_" + row_id + "_keterangan'>1 " + dbarang_keluar_satuan + " = " + dbarang_keluar_konversi + " " + dbarang_keluar_satuan_konversi + "</td>" +
							"<td>" + 
								"<div class='btn-group noprint'>" +
									"<a href='#' onclick='dbarang_keluar.edit_jumlah(" + row_id + ")' data-content='Ubah' data-toggle='popover' class='input btn btn-warning'>" + 
										"<i class='icon-edit icon-white'></i>" +
									"</a>" +
									"<a href='#' onclick='dbarang_keluar.delete(" + row_id + ")' data-content='Hapus' data-toggle='popover' class='input btn btn-danger'>" + 
										"<i class='icon-remove icon-white'></i>" + 
									"</a>" +
								 "</div>" +
							"</td>" +
						"</tr>"
					);
					row_id++;
				}
				$("#modal_alert_barang_keluar_add_form").html("");
				$(".error_field").removeClass("error_field");
				$("#barang_keluar_save").removeAttr("onclick");
				$("#barang_keluar_save").attr("onclick", "barang_keluar.update(" + id + ")");
				$("#barang_keluar_save").show();
				$("#barang_keluar_ok").hide();
				$("#barang_keluar_add_form").smodal("show");
			}
		);
	};
	BarangKeluarAction.prototype.update = function(id) {
		if (!this.validate()) {
			return;
		}
		$("#barang_keluar_add_form").smodal("hide");
		showLoading();
		var self = this;
		var data = this.getRegulerData();
		data['super_command'] = "barang_keluar";
		data['command'] = "save";
		data['push_command'] = "save";
		data['id'] = id;
		data['tanggal'] = $("#barang_keluar_tanggal").val();
		data['unit'] = $("#barang_keluar_unit").val();
		data['status'] = "belum";
		data['keterangan'] = "";
		var detail = {};
		var nor = $("tbody#dbarang_keluar_list").children("tr").length;
		for(var i = 0; i < nor; i++) {
			var d_data = {};
			var prefix = $("tbody#dbarang_keluar_list").children('tr').eq(i).prop("id");
			d_data['id'] = $("#" + prefix + "_id").text();
			d_data['id_barang'] = $("#" + prefix + "_id_barang").text();
			d_data['nama_barang'] = $("#" + prefix + "_nama_barang").text();
			d_data['nama_jenis_barang'] = $("#" + prefix + "_nama_jenis_barang").text();
			d_data['jumlah'] = $("#" + prefix + "_jumlah").text();
			d_data['jumlah_lama'] = $("#" + prefix + "_jumlah_lama").text();
			d_data['satuan'] = $("#" + prefix + "_satuan").text();
			d_data['konversi'] = $("#" + prefix + "_konversi").text();
			d_data['satuan_konversi'] = $("#" + prefix + "_satuan_konversi").text();
			if ($("#" + prefix).attr("class") == "deleted") {
				d_data['cmd'] = "delete";
			} else if ($("#" + prefix + "_id").text() == "") {
				d_data['cmd'] = "insert";
			} else {
				d_data['cmd'] = "update";
			}
			detail[i] = d_data;
		}
		data['detail'] = detail;
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) { 
					$("#barang_keluar_add_form").smodal("show");
				} else {
					self.view();
				}
				dismissLoading();
			}
		);
	};
	BarangKeluarAction.prototype.detail = function(id) {
		var self = this;
		var data = this.getRegulerData();
		data['super_command'] = "barang_keluar";
		data['command'] = "edit";
		data['id'] = id;
		$.post(	
			"",
			data,
			function (response) {
				var json = getContent(response);
				if (json == null) return;
				$("#barang_keluar_id").val(id);
				$("#barang_keluar_tanggal").val(json.header.tanggal);
				$("#barang_keluar_tanggal").removeAttr("disabled");
				$("#barang_keluar_tanggal").attr("disabled", "disabled");
				$("#barang_keluar_unit").val(json.header.unit);
				$("#barang_keluar_unit").removeAttr("disabled");
				$("#barang_keluar_unit").attr("disabled", "disabled");
				$("#dbarang_keluar_add").hide();
				row_id = 0;
				$("#dbarang_keluar_list").children("tr").remove();
				for(var i = 0; i < json.detail.length; i++) {
					var dbarang_keluar_id = json.detail[i].id;
					var dbarang_keluar_id_barang_keluar = json.detail[i].id_barang_keluar;
					var dbarang_keluar_id_barang = json.detail[i].id_barang;
					var dbarang_keluar_nama_barang = json.detail[i].nama_barang;
					var dbarang_keluar_nama_jenis_barang = json.detail[i].nama_jenis_barang;
					var dbarang_keluar_jumlah = json.detail[i].jumlah;
					var dbarang_keluar_satuan = json.detail[i].satuan;
					var dbarang_keluar_konversi = json.detail[i].konversi;
					var dbarang_keluar_satuan_konversi = json.detail[i].satuan_konversi;
					$("tbody#dbarang_keluar_list").append(
						"<tr id='data_" + row_id + "'>" +
							"<td style='display: none;' id='data_" + row_id + "_id'>" + dbarang_keluar_id + "</td>" +
							"<td style='display: none;' id='data_" + row_id + "_id_barang'>" + dbarang_keluar_id_barang + "</td>" +
							"<td style='display: none;' id='data_" + row_id + "_jumlah_lama'>" + dbarang_keluar_jumlah + "</td>" +
							"<td style='display: none;' id='data_" + row_id + "_jumlah'>" + dbarang_keluar_jumlah + "</td>" +
							"<td style='display: none;' id='data_" + row_id + "_satuan'>" + dbarang_keluar_satuan + "</td>" +
							"<td style='display: none;' id='data_" + row_id + "_konversi'>" + dbarang_keluar_konversi + "</td>" +
							"<td style='display: none;' id='data_" + row_id + "_satuan_konversi'>" + dbarang_keluar_satuan_konversi + "</td>" +
							"<td id='data_" + row_id + "_nama_barang'>" + dbarang_keluar_nama_barang + "</td>" +
							"<td id='data_" + row_id + "_nama_jenis_barang'>" + dbarang_keluar_nama_jenis_barang + "</td>" +
							"<td id='data_" + row_id + "_f_jumlah'>" + dbarang_keluar_jumlah + " " + dbarang_keluar_satuan + "</td>" +
							"<td id='data_" + row_id + "_keterangan'>1 " + dbarang_keluar_satuan + " = " + dbarang_keluar_konversi + " " + dbarang_keluar_satuan_konversi + "</td>" +
							"<td></td>" +
						"</tr>"
					);
					row_id++;
				}
				$("#modal_alert_barang_keluar_add_form").html("");
				$(".error_field").removeClass("error_field");
				$("#barang_keluar_save").removeAttr("onclick");
				$("#barang_keluar_save").hide();
				$("#barang_keluar_ok").show();
				$("#barang_keluar_add_form").smodal("show");
			}
		);
	};
	BarangKeluarAction.prototype.del = function(id) {
		var self = this;
		var data = this.getRegulerData();
		data['super_command'] = "barang_keluar";
		data['command'] = "del";
		data['id'] = id;
		data['push_command'] = "delete";
		bootbox.confirm(
			"Anda yakin menghapus data ini?", 
			function(result) {
				if(result) {
					showLoading();
					$.post(
						'',
						data,
						function(response) {
							var json = getContent(response);
							if (json == null) return;
							self.view();
							dismissLoading();
						}
					);
				}
			}
		);
	};
	BarangKeluarAction.prototype.export_pdf = function(id, status) {
		var self = this;
		var data = this.getRegulerData();
		data['super_command'] = "barang_keluar";
		data['command'] = "export_pdf";
		data['id'] = id;
		data['status'] = status;
		showLoading();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) {
					dismissLoading();
					return;
				}
				var getUrl = window.location['pathname'] + json;
				window.open(getUrl, 'pdf');
				dismissLoading();
			}
		);
	};
	
	function DBarangKeluarAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	DBarangKeluarAction.prototype.constructor = DBarangKeluarAction;
	DBarangKeluarAction.prototype = new TableAction();
	DBarangKeluarAction.prototype.show_add_form = function() {
		$("#dbarang_keluar_id").val("");
		$("#dbarang_keluar_id_barang").val("");
		$("#dbarang_keluar_nama_jenis_barang").val("");
		$("#dbarang_keluar_nama_barang").val("");
		$("#dbarang_keluar_nama_barang").removeAttr("disabled");
		$("#barang_browse").removeAttr("onclick");
		$("#barang_browse").attr("onclick", "barang.chooser('barang', 'barang_button', 'barang', barang)");
		$("#barang_browse").removeClass("btn-info");
		$("#barang_browse").removeClass("btn-inverse");
		$("#barang_browse").addClass("btn-info");
		$("#dbarang_keluar_satuan").html("");
		$("#dbarang_keluar_satuan").removeAttr("onchange");
		$("#dbarang_keluar_satuan").attr("onchange", "barang.setDetailInfo()");
		$("#dbarang_keluar_satuan").removeAttr("disabled");
		$("#dbarang_keluar_satuan").val("");
		$("#dbarang_keluar_konversi").val("");
		$("#dbarang_keluar_satuan_konversi").val("");
		$("#dbarang_keluar_stok").val("");
		$("#dbarang_keluar_f_stok").val("");
		$("#dbarang_keluar_jumlah_lama").val(0);
		$("#dbarang_keluar_jumlah").val("");
		$("#modal_alert_dbarang_keluar_add_form").html("");
		$(".error_field").removeClass("error_field");
		$("#dbarang_keluar_save").removeAttr("onclick");
		$("#dbarang_keluar_save").attr("onclick", "dbarang_keluar.save()");
		$("#dbarang_keluar_add_form").smodal("show");
	};
	DBarangKeluarAction.prototype.validate = function() {
		var valid = true;
		var invalid_msg = "";
		var nama_barang = $("#dbarang_keluar_nama_barang").val();
		var satuan = $("#dbarang_keluar_satuan").val();
		var stok = $("#dbarang_keluar_stok").val();
		var jumlah = $("#dbarang_keluar_jumlah").val();
		$(".error_field").removeClass("error_field");
		if (nama_barang == "") {
			valid = false;
			invalid_msg += "</br><strong>Nama Barang</strong> tidak boleh kosong";
			$("#dbarang_keluar_nama_barang").addClass("error_field");
		}
		if (satuan == "") {
			valid = false;
			invalid_msg += "</br><strong>Satuan</strong> tidak boleh kosong";
			$("#dbarang_keluar_satuan").addClass("error_field");
		}
		if (jumlah == "") {
			valid = false;
			invalid_msg += "</br><strong>Jumlah</strong> tidak boleh kosong";
			$("#dbarang_keluar_jumlah").addClass("error_field");
		} else if (!is_numeric(jumlah)) {
			valid = false;
			invalid_msg += "</br><strong>Jumlah</strong> seharusnya numerik (0-9)";
			$("#dbarang_keluar_jumlah").addClass("error_field");
		} else if (stok != "" && is_numeric(stok) && parseFloat(jumlah) > parseFloat(stok)) {
			valid = false;
			invalid_msg += "</br><strong>Jumlah</strong> tidak boleh melebihi stok";
			$("#dbarang_keluar_jumlah").addClass("error_field");
		}
		if (!valid) {
			$("#modal_alert_dbarang_keluar_add_form").html(
				"<div class='alert alert-block alert-danger'>" +
					"<h4>Peringatan</h4>" +
					invalid_msg +
				"</div>"
			);
		}
		return valid;
	};
	DBarangKeluarAction.prototype.save = function() {
		if (!this.validate()) {
			return;
		}
		var dbarang_keluar_id = $("#dbarang_keluar_id").val();
		var dbarang_keluar_id_barang = $("#dbarang_keluar_id_barang").val();
		var dbarang_keluar_nama_jenis_barang = $("#dbarang_keluar_nama_jenis_barang").val();
		var dbarang_keluar_nama_barang = $("#dbarang_keluar_nama_barang").val();
		var dbarang_keluar_jumlah_lama = $("#dbarang_keluar_jumlah_lama").val();
		var dbarang_keluar_jumlah = $("#dbarang_keluar_jumlah").val();
		var dbarang_keluar_satuan = $("#dbarang_keluar_satuan").find(":selected").text();
		var dbarang_keluar_konversi = $("#dbarang_keluar_konversi").val();
		var dbarang_keluar_satuan_konversi = $("#dbarang_keluar_satuan_konversi").val();
		$("tbody#dbarang_keluar_list").append(
			"<tr id='data_" + row_id + "'>" +
				"<td style='display: none;' id='data_" + row_id + "_id'>" + dbarang_keluar_id + "</td>" +
				"<td style='display: none;' id='data_" + row_id + "_id_barang'>" + dbarang_keluar_id_barang + "</td>" +
				"<td style='display: none;' id='data_" + row_id + "_jumlah_lama'>" + dbarang_keluar_jumlah_lama + "</td>" +
				"<td style='display: none;' id='data_" + row_id + "_jumlah'>" + dbarang_keluar_jumlah + "</td>" +
				"<td style='display: none;' id='data_" + row_id + "_satuan'>" + dbarang_keluar_satuan + "</td>" +
				"<td style='display: none;' id='data_" + row_id + "_konversi'>" + dbarang_keluar_konversi + "</td>" +
				"<td style='display: none;' id='data_" + row_id + "_satuan_konversi'>" + dbarang_keluar_satuan_konversi + "</td>" +
				"<td id='data_" + row_id + "_nama_barang'>" + dbarang_keluar_nama_barang + "</td>" +
				"<td id='data_" + row_id + "_nama_jenis_barang'>" + dbarang_keluar_nama_jenis_barang + "</td>" +
				"<td id='data_" + row_id + "_f_jumlah'>" + dbarang_keluar_jumlah + " " + dbarang_keluar_satuan + "</td>" +
				"<td id='data_" + row_id + "_keterangan'>1 " + dbarang_keluar_satuan + " = " + dbarang_keluar_konversi + " " + dbarang_keluar_satuan_konversi + "</td>" +
				"<td>" + 
					"<div class='btn-group noprint'>" +
						"<a href='#' onclick='dbarang_keluar.edit(" + row_id + ")' data-content='Ubah' data-toggle='popover' class='input btn btn-warning'>" + 
							"<i class='icon-edit icon-white'></i>" +
						"</a>" +
						"<a href='#' onclick='dbarang_keluar.delete(" + row_id + ")' data-content='Hapus' data-toggle='popover' class='input btn btn-danger'>" + 
							"<i class='icon-remove icon-white'></i>" + 
						"</a>" +
					 "</div>" +
				"</td>" +
			"</tr>"
		);
		row_id++;
		$("#dbarang_keluar_add_form").smodal("hide");
	};
	DBarangKeluarAction.prototype.edit = function(r_num) {
		var dbarang_keluar_id = $("#data_" + r_num + "_id").text();
		var dbarang_keluar_id_barang = $("#data_" + r_num + "_id_barang").text();
		var dbarang_keluar_nama_jenis_barang = $("#data_" + r_num + "_nama_jenis_barang").text();
		var dbarang_keluar_nama_barang = $("#data_" + r_num + "_nama_barang").text();
		var dbarang_keluar_jumlah = $("#data_" + r_num + "_jumlah").text();
		var dbarang_keluar_satuan = $("#data_" + r_num + "_konversi").text() + "_" + $("#data_" + r_num + "_satuan_konversi").text();
		$("#dbarang_keluar_id").val(dbarang_keluar_id);
		$("#dbarang_keluar_jumlah").val(dbarang_keluar_jumlah);
		$("#dbarang_keluar_satuan").html("");
		var self = this;
		var data = this.getRegulerData();
		data['super_command'] = "barang";
		data['command'] = "edit";
		data['id'] = dbarang_keluar_id_barang;
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#dbarang_keluar_id_barang").val(json.header.id_barang);
				$("#dbarang_keluar_nama_barang").val(json.header.nama_barang);
				$("#dbarang_keluar_nama_barang").removeAttr("disabled");
				$("#dbarang_keluar_nama_jenis_barang").val(json.header.nama_jenis_barang);
				$("#barang_browse").removeAttr("onclick");
				$("#barang_browse").attr("onclick", "barang.chooser('barang', 'barang_button', 'barang', barang)");
				$("#barang_browse").removeClass("btn-info");
				$("#barang_browse").removeClass("btn-inverse");
				$("#barang_browse").addClass("btn-info");
				$("#dbarang_keluar_satuan").html(json.satuan_option);
				$("#dbarang_keluar_satuan").val(dbarang_keluar_satuan);
				var part = $("#dbarang_keluar_satuan").val().split("_");
				$("#dbarang_keluar_konversi").val(part[0]);
				$("#dbarang_keluar_satuan_konversi").val(part[1]);
				data = self.getRegulerData();
				data['super_command'] = "sisa";
				data['command'] = "edit";
				data['id_barang'] = $("#dbarang_keluar_id_barang").val();
				data['satuan'] = $("#dbarang_keluar_satuan").find(":selected").text();
				data['konversi'] = $("#dbarang_keluar_konversi").val();
				data['satuan_konversi'] = $("#dbarang_keluar_satuan_konversi").val();
				$.post(
					"",
					data,
					function(response) {
						var json = getContent(response);
						if (json == null) return;
						$("#dbarang_keluar_stok").val(json.sisa);
						$("#dbarang_keluar_f_stok").val(json.sisa + " " + json.satuan);
						$("#dbarang_keluar_satuan").removeAttr("disabled");
						$("#modal_alert_dbarang_keluar_add_form").html("");
						$(".error_field").removeClass("error_field");
						$("#dbarang_keluar_save").removeAttr("onclick");
						$("#dbarang_keluar_save").attr("onclick", "dbarang_keluar.update(" + r_num + ")");
						$("#dbarang_keluar_add_form").smodal("show");
					}
				);
			}
		);
	};
	DBarangKeluarAction.prototype.edit_jumlah = function (r_num) {
		var dbarang_keluar_id = $("#data_" + r_num + "_id").text();
		var dbarang_keluar_id_barang = $("#data_" + r_num + "_id_barang").text();
		var dbarang_keluar_nama_jenis_barang = $("#data_" + r_num + "_nama_jenis_barang").text();
		var dbarang_keluar_nama_barang = $("#data_" + r_num + "_nama_barang").text();
		var dbarang_keluar_jumlah = $("#data_" + r_num + "_jumlah").text();
		var dbarang_keluar_satuan = $("#data_" + r_num + "_konversi").text() + "_" + $("#data_" + r_num + "_satuan_konversi").text();
		$("#dbarang_keluar_id").val(dbarang_keluar_id);
		$("#dbarang_keluar_jumlah").val(dbarang_keluar_jumlah);
		$("#dbarang_keluar_satuan").html("");
		var self = this;
		var data = this.getRegulerData();
		data['super_command'] = "barang";
		data['command'] = "edit";
		data['id'] = dbarang_keluar_id_barang;
		$.post(
			"",
			data,
			function (response) {
				var json = getContent(response);
				if (json == null) return;
				$("#dbarang_keluar_id_barang").val(json.header.id_barang);
				$("#dbarang_keluar_nama_barang").val(json.header.nama_barang);
				$("#dbarang_keluar_nama_barang").removeAttr("disabled");
				$("#dbarang_keluar_nama_barang").attr("disabled", "disabled");
				$("#dbarang_keluar_nama_jenis_barang").val(json.header.nama_jenis_barang);
				$("#barang_browse").removeAttr("onclick");
				$("#barang_browse").removeClass("btn-info");
				$("#barang_browse").removeClass("btn-inverse");
				$("#barang_browse").addClass("btn-inverse");
				$("#dbarang_keluar_satuan").html(json.satuan_option);
				$("#dbarang_keluar_satuan").val(dbarang_keluar_satuan);
				var part = $("#dbarang_keluar_satuan").val().split("_");
				$("#dbarang_keluar_konversi").val(part[0]);
				$("#dbarang_keluar_satuan_konversi").val(part[1]);
				data = self.getRegulerData();
				data['super_command'] = "sisa";
				data['command'] = "edit";
				data['id_barang'] = $("#dbarang_keluar_id_barang").val();
				data['satuan'] = $("#dbarang_keluar_satuan").find(":selected").text();
				data['konversi'] = $("#dbarang_keluar_konversi").val();
				data['satuan_konversi'] = $("#dbarang_keluar_satuan_konversi").val();
				$.post(
					"",
					data,
					function(response) {
						var json = getContent(response);
						if (json == null) return;
						$("#dbarang_keluar_stok").val(json.sisa);
						$("#dbarang_keluar_f_stok").val(json.sisa + " " + json.satuan);
						$("#dbarang_keluar_satuan").removeAttr("disabled");
						$("#dbarang_keluar_satuan").attr("disabled", "disabled");
						$("#modal_alert_dbarang_keluar_add_form").html("");
						$(".error_field").removeClass("error_field");
						$("#dbarang_keluar_save").removeAttr("onclick");
						$("#dbarang_keluar_save").attr("onclick", "dbarang_keluar.update(" + r_num + ")");
						$("#dbarang_keluar_add_form").smodal("show");
					}
				);
			}
		);
	};
	DBarangKeluarAction.prototype.edit_jumlah = function(r_num) {
		var dbarang_keluar_id = $("#data_" + r_num + "_id").text();
		var dbarang_keluar_id_barang = $("#data_" + r_num + "_id_barang").text();
		var dbarang_keluar_nama_jenis_barang = $("#data_" + r_num + "_nama_jenis_barang").text();
		var dbarang_keluar_nama_barang = $("#data_" + r_num + "_nama_barang").text();
		var dbarang_keluar_jumlah = $("#data_" + r_num + "_jumlah").text();
		var dbarang_keluar_satuan = $("#data_" + r_num + "_konversi").text() + "_" + $("#data_" + r_num + "_satuan_konversi").text();
		$("#dbarang_keluar_id").val(dbarang_keluar_id);
		$("#dbarang_keluar_jumlah").val(dbarang_keluar_jumlah);
		$("#dbarang_keluar_satuan").html("");
		var self = this;
		var data = this.getRegulerData();
		data['super_command'] = "barang";
		data['command'] = "edit";
		data['id'] = dbarang_keluar_id_barang;
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#dbarang_keluar_id_barang").val(json.header.id_barang);
				$("#dbarang_keluar_nama_barang").val(json.header.nama_barang);
				$("#dbarang_keluar_nama_jenis_barang").val(json.header.nama_jenis_barang);
				$("#barang_browse").removeAttr("onclick");
				$("#barang_browse").removeClass("btn-info");
				$("#barang_browse").removeClass("btn-inverse");
				$("#barang_browse").addClass("btn-inverse");
				$("#dbarang_keluar_satuan").html(json.satuan_option);
				$("#dbarang_keluar_satuan").val(dbarang_keluar_satuan);
				var part = $("#dbarang_keluar_satuan").val().split("_");
				$("#dbarang_keluar_konversi").val(part[0]);
				$("#dbarang_keluar_satuan_konversi").val(part[1]);
				data = self.getRegulerData();
				data['super_command'] = "sisa";
				data['command'] = "edit";
				data['id_barang'] = $("#dbarang_keluar_id_barang").val();
				data['satuan'] = $("#dbarang_keluar_satuan").find(":selected").text();
				data['konversi'] = $("#dbarang_keluar_konversi").val();
				data['satuan_konversi'] = $("#dbarang_keluar_satuan_konversi").val();
				$.post(
					"",
					data,
					function(response) {
						var json = getContent(response);
						if (json == null) return;
						$("#dbarang_keluar_stok").val(json.sisa);
						$("#dbarang_keluar_f_stok").val(json.sisa + " " + json.satuan);
						$("#dbarang_keluar_satuan").removeAttr("disabled");
						$("#dbarang_keluar_satuan").attr("disabled", "disabled");
						$("#modal_alert_dbarang_keluar_add_form").html("");	
						$(".error_field").removeClass("error_field");					
						$("#dbarang_keluar_save").removeAttr("onclick");
						$("#dbarang_keluar_save").attr("onclick", "dbarang_keluar.update(" + r_num + ")");
						$("#dbarang_keluar_add_form").smodal("show");
					}
				);
			}
		);
	};
	DBarangKeluarAction.prototype.update = function(r_num) {
		if (!this.validate()) {
			return;
		}
		var dbarang_keluar_id_barang = $("#dbarang_keluar_id_barang").val();
		var dbarang_keluar_nama_jenis_barang = $("#dbarang_keluar_nama_jenis_barang").val();
		var dbarang_keluar_nama_barang = $("#dbarang_keluar_nama_barang").val();
		var dbarang_keluar_jumlah = $("#dbarang_keluar_jumlah").val();
		var dbarang_keluar_satuan = $("#dbarang_keluar_satuan").find(":selected").text();
		var dbarang_keluar_konversi = $("#dbarang_keluar_konversi").val();
		var dbarang_keluar_satuan_konversi = $("#dbarang_keluar_satuan_konversi").val();
		$("#data_" + r_num + "_id_barang").text(dbarang_keluar_id_barang);
		$("#data_" + r_num + "_nama_barang").text(dbarang_keluar_nama_barang);
		$("#data_" + r_num + "_nama_jenis_barang").text(dbarang_keluar_nama_jenis_barang);
		$("#data_" + r_num + "_jumlah").text(dbarang_keluar_jumlah);
		$("#data_" + r_num + "_satuan").text(dbarang_keluar_satuan);
		$("#data_" + r_num + "_konversi").text(dbarang_keluar_konversi);
		$("#data_" + r_num + "_satuan_konversi").text(dbarang_keluar_satuan_konversi);
		$("#data_" + r_num + "_f_jumlah").text(dbarang_keluar_jumlah + " " + dbarang_keluar_satuan);
		$("#data_" + r_num + "_keterangan").text("1 " + dbarang_keluar_satuan + " = " + dbarang_keluar_konversi + " " + dbarang_keluar_satuan_konversi);
		$("#dbarang_keluar_add_form").smodal("hide");
	};
	DBarangKeluarAction.prototype.delete = function(r_num) {
		var id = $("#data_" + r_num + "_id").text();
		if (id.length == 0) {
			$("#data_" + r_num).remove();
		} else {
			$("#data_" + r_num).attr("style", "display: none;");
			$("#data_" + r_num).attr("class", "deleted");
		}
	};
	
	function BarangAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	BarangAction.prototype.constructor = BarangAction;
	BarangAction.prototype = new TableAction();
	BarangAction.prototype.selected = function(json) {
		$("#dbarang_keluar_id_barang").val(json.header.id_barang);
		$("#dbarang_keluar_nama_barang").val(json.header.nama_barang);
		$("#dbarang_keluar_nama_jenis_barang").val(json.header.nama_jenis_barang);
		$("#dbarang_keluar_satuan").html(json.satuan_option);
		this.setDetailInfo();
	};
	BarangAction.prototype.setDetailInfo = function() {
		var part = $("#dbarang_keluar_satuan").val().split("_");
		$("#dbarang_keluar_konversi").val(part[0]);
		$("#dbarang_keluar_satuan_konversi").val(part[1]);
		var data = this.getRegulerData();
		data['super_command'] = "sisa";
		data['command'] = "edit";
		data['id_barang'] = $("#dbarang_keluar_id_barang").val();
		data['satuan'] = $("#dbarang_keluar_satuan").find(":selected").text();
		data['konversi'] = $("#dbarang_keluar_konversi").val();
		data['satuan_konversi'] = $("#dbarang_keluar_satuan_konversi").val();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#dbarang_keluar_stok").val(json.sisa);
				$("#dbarang_keluar_f_stok").val(json.sisa + " " + json.satuan);
			}
		);
	};
	
	var barang_keluar;
	var dbarang_keluar;
	var barang;
	var row_id;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		$(".mydate").datepicker();
		barang = new BarangAction(
			"barang",
			"gudang_umum",
			"barang_keluar",
			new Array()
		);
		barang.setSuperCommand("barang");
		var dbarang_keluar_columns = new Array("id", "id_barang_keluar", "id_barang", "nama_barang", "nama_jenis_barang", "jumlah", "satuan", "konversi", "satuan_konversi");
		dbarang_keluar = new DBarangKeluarAction(
			"dbarang_keluar",
			"gudang_umum",
			"barang_keluar",
			dbarang_keluar_columns
		);
		var barang_keluar_columns = new Array("id", "tanggal", "unit", "status", "keterangan");
		barang_keluar = new BarangKeluarAction(
			"barang_keluar",
			"gudang_umum",
			"barang_keluar",
			barang_keluar_columns
		);
		barang_keluar.setSuperCommand("barang_keluar");
		barang_keluar.view();
	});
</script>