<?php
	class BarangTAdapter extends ArrayAdapter {
		public function adapt($row) {
			$array = array();
			$array['id'] = $row->id;
			$array['unit'] = $row->unit;
			$array['kode'] = $row->kode;
			$array['Nomor'] = self::format("digit8", $row->id);
			$array['Kode'] = $row->kode;
			if ($row->medis)
				$array['Jenis'] = "Medis";
			else
				$array['Jenis'] = "Non-Medis";
			$array['Barang'] = $row->nama_barang;
			$array['No. BBM'] = $row->no_bbm;
			$array['Merk'] = $row->merk;
			$array['Harga'] = self::format("money Rp.", $row->hna);
			$array['Tahun Perolehan'] = $row->tahun_perolehan;
			$array['Penyusutan'] = $row->usia_penyusutan . " tahun";
			if ($row->kondisi_baik)
				$array['Kondisi'] = "Baik";
			else 
				$array['Kondisi'] = "Rusak";
			if ($row->unit == "")
				$array['Lokasi'] = "-";
			else
				$array['Lokasi'] = self::format("unslug", $row->unit);
			if ($row->status == "sudah") {
				$array['Status'] = "SUDAH DITERIMA";
			} else {
				$array['Status'] = "BELUM DITERIMA";
			}
			return $array;
		}
	}
?>