<?php
	class BarangKeluarAdapter extends ArrayAdapter {
		public function adapt($row) {
			$array = array();
			$array['id'] = $row->id;
			$array['prop'] = $row->prop;
			$array['status'] = $row->status;
			$array['status_acc'] = $row->status_acc;
			$array['Nomor'] = self::format("digit8", $row->id);
			$array['Tanggal Keluar'] = self::format("date d M Y", $row->tanggal);
			$array['Unit'] = self::format("unslug", $row->unit);
			if ($row->prop == "") {
				if ($row->status == "sudah")
					$array['Status'] = "Sudah Diterima";
				else if ($row->status == "dikembalikan")
					$array['Status'] = "Dikembalikan";
				else if ($row->status_acc == 0)
					$array['Status'] = "Menunggu Acc. Mutasi";
				else
					$array['Status'] = "Belum Diterima";
			} else {
				$array['Status'] = "Dibatalkan";
			}
			return $array;
		}
	}
?>