<?php
    require_once("smis-base/smis-include-service-consumer.php");
    global $db;

    $table = new Table(
        array("Nomor", "Tanggal Keluar", "Unit", "Status Acc."),
        "Gudang Umum : Acc. Barang Keluar - Unit",
        null,
        true
    );
    $table->setName("acc_barang_keluar");
    $table->setAddButtonEnable(false);
    $table->setReloadButtonEnable(false);
    $table->setPrintButtonEnable(false);
    $table->setEditButtonEnable(false);
    $table->setDelButtonEnable(false);

    $detail_button = new Button("", "", "Review");
    $detail_button->setIsButton(Button::$ICONIC_TEXT);
    $detail_button->setIcon("icon-eye-open icon-white");
    $detail_button->setClass("btn btn-inverse");
    $table->addContentButton("review", $detail_button);

    if (isset($_POST['command'])) {
        $dbtable = new DBTable($db, "smis_gd_barang_keluar");
        $dbtable->addCustomKriteria("status_acc", " = 0 ");
        $dbtable->addCustomKriteria("status", " LIKE 'belum' ");
        $dbtable->setOrder(" id DESC ");

        if ($_POST['command'] == "confirm") {
            $id['id'] = $_POST['id'];
            global $user;
            $data = [
                'user_acc' => $user->getNameOnly(),
                'status_acc' => 1,
                'tanggal_acc' => date("Y-m-d H:i:s")
            ];
            $dbtable->update($data, $id);

            $barang_keluar_row = $db->get_row("
                SELECT *
                FROM smis_gd_barang_keluar
                WHERE id = '" . $id['id'] . "'
            ");
            $detail = $db->get_result("
                SELECT 
                    a.id AS 'id_stok_barang_keluar', b.id_barang, c.kode_barang, b.nama_barang, b.nama_jenis_barang, c.id_vendor, c.nama_vendor, a.jumlah, b.satuan, b.konversi, b.satuan_konversi, c.hna, c.produsen, c.tanggal_exp, c.no_batch, a.prop
                FROM 
                    smis_gd_stok_barang_keluar a 
                        LEFT JOIN smis_gd_stok_barang c ON a.id_stok_barang = c.id 
                        LEFT JOIN smis_gd_dbarang_keluar b ON a.id_dbarang_keluar = b.id
                WHERE 
                    b.id_barang_keluar = '" . $id['id'] . "'
            ");
            $command = "push_save";
            require_once("gudang_umum/service_consumer/PushBarangServiceConsumer.php");
            $push_barang_service_consumer = new PushBarangServiceConsumer($db, $barang_keluar_row->id, $barang_keluar_row->tanggal, $barang_keluar_row->unit, $barang_keluar_row->status, $barang_keluar_row->keterangan, $detail, $command);
            $push_barang_service_consumer->execute();

            echo json_encode([
                'status' => 1
            ]);
            return;
        } else if ($_POST['command'] == "cancel") {
            $id['id'] = $_POST['id'];
            global $user;
            $data = [
                'user_acc' => $user->getNameOnly(),
                'status_acc' => 0,
                'tanggal_acc' => date("Y-m-d H:i:s"),
                'prop' => "del"
            ];
            $dbtable->update($data, $id);

            $stok_barang_keluar_dbtable = new DBTable($db, "smis_gd_stok_barang_keluar");
            $stok_barang_dbtable = new DBTable($db, "smis_gd_stok_barang");
            $riwayat_dbtable = new DBTable($db, "smis_gd_riwayat_stok_barang");
            $stok_keluar_query = "
                SELECT smis_gd_stok_barang_keluar.*, smis_gd_barang_keluar.unit
                FROM (smis_gd_stok_barang_keluar LEFT JOIN smis_gd_dbarang_keluar ON smis_gd_stok_barang_keluar.id_dbarang_keluar = smis_gd_dbarang_keluar.id) LEFT JOIN smis_gd_barang_keluar ON smis_gd_dbarang_keluar.id_barang_keluar = smis_gd_barang_keluar.id
                WHERE smis_gd_barang_keluar.id = '" . $id['id'] . "' AND smis_gd_stok_barang_keluar.prop NOT LIKE 'del'
                ORDER BY smis_gd_stok_barang_keluar.id DESC
            ";
            $stok_keluar = $db->get_result($stok_keluar_query);
            foreach($stok_keluar as $sk) {
                $stok_keluar_data = array();
                $stok_keluar_data['prop'] = "del";
                $stok_keluar_id['id'] = $sk->id;
                $stok_barang_keluar_dbtable->update($stok_keluar_data, $stok_keluar_id);
                $stok_query = "
                    SELECT *
                    FROM smis_gd_stok_barang
                    WHERE id = '" . $sk->id_stok_barang . "'
                ";
                $stok_barang_row =  $db->get_row($stok_query);
                $stok_data = array();
                $stok_data['sisa'] = $stok_barang_row->sisa + $sk->jumlah;
                $stok_id['id'] = $sk->id_stok_barang;
                $stok_barang_dbtable->update($stok_data, $stok_id);
                //logging riwayat stok barang:
                $data_riwayat = array();
                $data_riwayat['tanggal'] = date("Y-m-d");
                $data_riwayat['id_stok_barang'] = $sk->id_stok_barang;
                $data_riwayat['jumlah_masuk'] = $sk->jumlah;
                $data_riwayat['sisa'] = $stok_barang_row->sisa + $sk->jumlah;
                $data_riwayat['keterangan'] = "Pembatalan Stok Keluar ke " . ArrayAdapter::format("unslug", $sk->unit);
                global $user;
                $data_riwayat['nama_user'] = $user->getName();
                $riwayat_dbtable->insert($data_riwayat);
            }

            //kartu gudang induk:
            $dok_rows = $db->get_result("
                SELECT *
                FROM smis_gd_dbarang_keluar
                WHERE id_barang_keluar = '" . $id['id'] . "' AND prop NOT LIKE 'del'
            ");
            if ($dok_rows != null) {
                $ks_dbtable = new DBTable($db, "smis_gd_kartu_stok");
                $header_row = $db->get_row("
                    SELECT *
                    FROM smis_gd_barang_keluar
                    WHERE id = '" . $id['id'] . "'
                ");
                foreach ($dok_rows as $dr) {    
                    $ks_data = array();
                    $ks_data['f_id'] = $id['id'];
                    $ks_data['unit'] = "Pembatalan Mutasi ke " . ArrayAdapter::format("unslug", $header_row->unit);
                    $ks_data['no_bon'] = $id['id'];
                    $ks_data['id_barang'] = $dr->id_barang;
                    $ks_data['nama_barang'] = $dr->nama_barang;
                    $ks_data['nama_jenis_barang'] = $dr->nama_jenis_barang;
                    $ks_data['tanggal'] = date("Y-m-d");
                    $ks_data['masuk'] = $dr->jumlah;
                    $ks_data['keluar'] = 0;
                    $ks_row = $ks_dbtable->get_row("
                        SELECT SUM(b.sisa) AS 'jumlah'
                        FROM smis_gd_dbarang_masuk a LEFT JOIN smis_gd_stok_barang b ON a.id = b.id_dbarang_masuk
                        WHERE a.prop NOT LIKE 'del' AND a.id_barang = '" . $dr->id_barang . "'
                    ");
                    $ks_data['sisa'] = $ks_row->jumlah + $dr->jumlah;
                    $ks_dbtable->insert($ks_data);
                    $id_kartu_stok = $ks_dbtable->get_inserted_id();

                    $ks_data = array();
                    $ks_data['origin_id'] = $id_kartu_stok;
                    $ks_data_id = array();
                    $ks_data_id['id'] = $id_kartu_stok;
                    $ks_dbtable->update($ks_data, $ks_data_id);
                }
            }

            echo json_encode([
                'status' => 1
            ]);
            return;
        }

        $adapter = new SimpleAdapter();
        $adapter->add("Nomor", "id", "digit8");
        $adapter->add("Tanggal Keluar", "tanggal", "date d M Y");
        $adapter->add("Unit", "unit", "unslug");
        $adapter->add("Status Acc.", "status_acc", "trivial_0_Belum Acc._Sudah Acc.");

        require_once("gudang_umum/responder/BarangKeluarDBResponder.php");
        $dbresponder = new BarangKeluarDBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    $modal = new Modal("acc_barang_keluar_add_form", "smis_form_container", "acc_barang_keluar");
    $modal->setTitle("Acc. Barang Keluar");
    $modal->setClass(Modal::$FULL_MODEL);
    $id_text = new Text("acc_barang_keluar_id", "acc_barang_keluar_id", "");
    $id_text->setAtribute("disabled='disabled'");
    $modal->addElement("Nomor", $id_text);
    $nomor_hidden = new Hidden("acc_barang_keluar_nomor", "acc_barang_keluar_nomor", "");
    $modal->addElement("", $nomor_text);
    $tanggal_text = new Text("acc_barang_keluar_tanggal", "acc_barang_keluar_tanggal", "");
    $tanggal_text->setClass("mydate");
    $tanggal_text->setAtribute("data-date-format='yyyy-m-d'");
    $modal->addElement("Tanggal", $tanggal_text);
    require_once("gudang_umum/service_consumer/UnitServiceConsumer.php");
    $unit_service_consumer = new UnitServiceConsumer($db);
    $unit_service_consumer->execute();
    $unit_option = $unit_service_consumer->getContent();
    $unit_select = new Select("acc_barang_keluar_unit", "acc_barang_keluar_unit", $unit_option);
    $modal->addElement("Unit", $unit_select);
    $dacc_barang_keluar_table = new Table(
        array("No.", "Nama Barang", "Jenis Barang", "Diminta", "Diberikan", "Keterangan", ""),
        "",
        null,
        true
    );
    $dacc_barang_keluar_table->setName("dacc_barang_keluar");
    $dacc_barang_keluar_table->setAction(false);
    $dacc_barang_keluar_table->setFooterVisible(false);
    $modal->addBody("dacc_barang_keluar_table", $dacc_barang_keluar_table);
    $confirm_button = new Button("", "", "Simpan");
    $confirm_button->setClass("btn-success");
    $confirm_button->setAction("acc_barang_keluar.confirm()");
    $confirm_button->setIcon("fa fa-check");
    $confirm_button->setIsButton(Button::$ICONIC);
    $modal->addFooter($confirm_button);
    $cancel_button = new Button("", "", "Batal");
    $cancel_button->setClass("btn-success");
    $cancel_button->setAction("acc_barang_keluar.cancel()");
    $cancel_button->setIcon("fa fa-times");
    $cancel_button->setIsButton(Button::$ICONIC);
    $modal->addFooter($cancel_button);

    echo $modal->getHtml();
    echo $table->getHtml();
?>
<script type="text/javascript">
    var acc_barang_keluar;
    $(document).ready(function() {
        acc_barang_keluar = new TableAction(
            'acc_barang_keluar',
            'gudang_umum',
            'acc_barang_keluar',
            new Array()
        );
        acc_barang_keluar.review = function(id) {
            var data = this.getRegulerData();
            data['command'] = "edit";
            data['id'] = id;
            showLoading();
            $.post(
                '',
                data,
                function(response) {
                    var json = getContent(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    $("#acc_barang_keluar_id").val(id);
                    $("#acc_barang_keluar_nomor").val(json.header.nomor);
                    $("#acc_barang_keluar_tanggal").val(json.header.tanggal);
                    $("#acc_barang_keluar_tanggal").removeAttr("disabled");
                    $("#acc_barang_keluar_tanggal").attr("disabled", "disabled");
                    $("#acc_barang_keluar_unit").val(json.header.unit);
                    $("#acc_barang_keluar_unit").removeAttr("disabled");
                    $("#acc_barang_keluar_unit").attr("disabled", "disabled");
                    $("#dacc_barang_keluar_add").hide();
                    row_id = 0;
                    $("#dacc_barang_keluar_list").children("tr").remove();
                    for (var i = 0; i < json.detail.length; i++) {
                        var dbarang_keluar_id = json.detail[i].id;
                        var dbarang_keluar_id_barang_keluar = json.detail[i].id_barang_keluar;
                        var dbarang_keluar_id_barang = json.detail[i].id_barang;
                        var dbarang_keluar_kode_barang = json.detail[i].kode_barang;
                        var dbarang_keluar_nama_barang = json.detail[i].nama_barang;
                        var dbarang_keluar_nama_jenis_barang = json.detail[i].nama_jenis_barang;
                        var dbarang_keluar_harga_ma = json.detail[i].harga_ma;
                        var dbarang_keluar_stok_entri = json.detail[i].stok_entri;
                        var dbarang_keluar_jumlah_diminta = json.detail[i].jumlah;
                        var dbarang_keluar_jumlah = json.detail[i].jumlah;
                        var dbarang_keluar_satuan = json.detail[i].satuan;
                        var dbarang_keluar_konversi = json.detail[i].konversi;
                        var dbarang_keluar_satuan_konversi = json.detail[i].satuan_konversi;
                        $("tbody#dacc_barang_keluar_list").append(
                            "<tr id='data_" + row_id + "'>" +
                                "<td style='display: none;' id='data_" + row_id + "_id'>" + dbarang_keluar_id + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_kode_barang'>" + dbarang_keluar_kode_barang + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_id_barang'>" + dbarang_keluar_id_barang + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_harga_ma'>" + dbarang_keluar_harga_ma + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_stok_entri'>" + dbarang_keluar_stok_entri + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_jumlah_diminta'>" + dbarang_keluar_jumlah_diminta + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_jumlah_lama'>" + dbarang_keluar_jumlah + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_jumlah'>" + dbarang_keluar_jumlah + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_satuan'>" + dbarang_keluar_satuan + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_konversi'>" + dbarang_keluar_konversi + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_satuan_konversi'>" + dbarang_keluar_satuan_konversi + "</td>" +
                                "<td id='data_" + row_id + "_nomor'>" + (i + 1) + "</td>" +
                                "<td id='data_" + row_id + "_nama_barang'>" + dbarang_keluar_nama_barang + "</td>" +
                                "<td id='data_" + row_id + "_nama_jenis_barang'>" + dbarang_keluar_nama_jenis_barang + "</td>" +
                                "<td id='data_" + row_id + "_f_jumlah_diminta'>" + dbarang_keluar_jumlah_diminta + " " + dbarang_keluar_satuan + "</td>" +
                                "<td id='data_" + row_id + "_f_jumlah'>" + dbarang_keluar_jumlah + " " + dbarang_keluar_satuan + "</td>" +
                                "<td id='data_" + row_id + "_keterangan'>1 " + dbarang_keluar_satuan + " = " + dbarang_keluar_konversi + " " + dbarang_keluar_satuan_konversi + "</td>" +
                                "<td></td>" +
                            "</tr>"
                        );
                        for (var k = 0; k < json.subdetail.length; k++) {
                            if (json.subdetail[k].id == dbarang_keluar_id) {
                                var dbarang_keluar_detail_info_arr = json.subdetail[k].detail_info == null ? new Array() : json.subdetail[k].detail_info.split(',');
                                for (var j = 0; j < dbarang_keluar_detail_info_arr.length; j++) {
                                    var dbarang_keluar_detail_info_parts = dbarang_keluar_detail_info_arr[j].split(';', 3);
                                    var dbarang_keluar_detail_info_tanggal_exp = dbarang_keluar_detail_info_parts[0];
                                    var dbarang_keluar_detail_info_no_batch = dbarang_keluar_detail_info_parts[1];
                                    var dbarang_keluar_detail_info_jumlah = dbarang_keluar_detail_info_parts[2];
                                    $("tbody#dacc_barang_keluar_list").append(
                                        "<tr id='info_" + row_id + "'>" +
                                            "<td></td>" +
                                            "<td></td>" +
                                            "<td>" +
                                                "<small>No. Batch : " + dbarang_keluar_detail_info_no_batch + "</small>" +
                                            "</td>" +
                                            "<td colspan='1'>" +
                                                "<small>Tanggal Exp. : " + dbarang_keluar_detail_info_tanggal_exp + "</small>" +
                                            "</td>" +
                                            "<td>" +
                                                "<small>Jumlah : " + dbarang_keluar_detail_info_jumlah + "</small>" +
                                            "</td>" +
                                            "<td></td>" +
                                            "<td></td>" +
                                        "</tr>"
                                    );
                                }
                            }
                        }
                        row_id++;
                    }
                    $("#acc_barang_keluar_add_form").smodal("show");
                    dismissLoading();
                }
            );
        };
        acc_barang_keluar.confirm = function() {
            var self = this;
            var data = this.getRegulerData();
            data['command'] = "confirm";
            data['id'] = $("#acc_barang_keluar_id").val();
            
            $("#acc_barang_keluar_add_form").smodal("hide");

            bootbox.confirm({
                title     : "Konfirmasi",
                message   : "Yakin melakukan persetujuan Mutasi Barang ini?<br/><br/><b>PERINGATAN</b> : Persetujuan Mutasi Barang ini akan mengirimkan data ke submenu Penerimaan Barang unit terkait dan dapat diterima oleh unit tersebut.",
                buttons   : {
                    confirm : {
                        label       : "Lanjutkan",
                        className   : "btn-success"
                    },
                    cancel : {
                        label       : "Batal",
                        className   : "btn-inverse"
                    }
                },
                callback : function(result) {
                    if (result) {
                        showLoading();
                        $.post(
                            '',
                            data,
                            function(response) {
                                self.view();
                                dismissLoading();
                            }
                        );
                    } else {
                        $("#acc_barang_keluar_add_form").smodal("show");
                    }
                }
            });
        };
        acc_barang_keluar.cancel = function() {
            var self = this;
            var data = this.getRegulerData();
            data['command'] = "cancel";
            data['id'] = $("#acc_barang_keluar_id").val();
            
            $("#acc_barang_keluar_add_form").smodal("hide");

            bootbox.confirm({
                title     : "Konfirmasi",
                message   : "Yakin melakukan pembatalan Mutasi Barang ini?<br/><br/><b>PERINGATAN</b> : Pembatalan Mutasi Barang ini akan mengembalikan stok yang dipakai transaksi.",
                buttons   : {
                    confirm : {
                        label       : "Lanjutkan",
                        className   : "btn-success"
                    },
                    cancel : {
                        label       : "Batal",
                        className   : "btn-inverse"
                    }
                },
                callback : function(result) {
                    if (result) {
                        showLoading();
                        $.post(
                            '',
                            data,
                            function(response) {
                                self.view();
                                dismissLoading();
                            }
                        );
                    } else {
                        $("#acc_barang_keluar_add_form").smodal("show");
                    }
                }
            });
        };
        acc_barang_keluar.view();
    });
</script>