<?php
    class ReturObatUnitTable extends Table {
		public function getBodyContent(){
			$content = "";
			if ($this->content!=NULL) {
				foreach ($this->content as $d) {
					$content .= "<tr>";
					foreach ($this->header as $h) {
						if (array_key_exists($h, $d))
							$content .= "<td>" . $d[$h] . "</td>";
						else
							$content .= "<td></td>";
					}
					if ($this->is_action && array_key_exists('status', $d) && array_key_exists('restok', $d)) {
						$content .= "<td>" . $this->getFilteredContentButton($d['id'], $d['status'], $d['restok'])->getHtml() . "</td>";
					}
					$content .= "</tr>";
				}
			}
			return $content;
		}
		public function getFilteredContentButton($id, $status, $restok) {
			$btn_group = new ButtonGroup("noprint");
			if ($status == "sudah") {
				$btn = new Button("", "", "Lihat");
				$btn->setAction($this->action . ".detail('" . $id . "')");
				if (!$restok) {
					$btn->setClass("btn-success");
				} else {
					$btn->setClass("btn-inverse");
				}
				$btn->setAtribute("data-content='Lihat' data-toggle='popover'");
				$btn->setIcon("icon-eye-open icon-white");
				$btn->setIsButton(Button::$ICONIC_TEXT);
				$btn_group->addElement($btn);
				if (!$restok) {
					$btn = new Button("", "", "Restok");
					$btn->setAction($this->action . ".restock('" . $id . "')");
					$btn->setAtribute("data-content='Restok' data-toggle='popover'");
					$btn->setIcon("fa fa-refresh");
					$btn->setIsButton(Button::$ICONIC_TEXT);
					$btn_group->addElement($btn);
				} else {
					$btn = new Button("", "", "Unduh PDF");
					$btn->setAction($this->action . ".export_pdf('" . $id . "')");
					$btn->setClass("btn-info");
					$btn->setAtribute("data-content='PDF' data-toggle='popover'");
					$btn->setIcon("fa fa-download");
					$btn->setIsButton(Button::$ICONIC_TEXT);
					$btn_group->addElement($btn);
				}
			} else {
				$btn = new Button("", "", "Ubah");
				$btn->setAction($this->action . ".edit('" . $id . "')");
				$btn->setClass("btn-warning");
				$btn->setAtribute("data-content='Ubah' data-toggle='popover'");
				$btn->setIcon("icon-edit icon-white");
				$btn->setIsButton(Button::$ICONIC_TEXT);
				$btn_group->addElement($btn);
			}
			return $btn_group;
		}
	}
?>