<?php
class ObatKeluarTable extends Table {
	public function getBodyContent(){
		$content = "";
		if ($this->content!=NULL) {
			foreach ($this->content as $d) {
				$content .= "<tr>";
				foreach ($this->header as $h) {
					$content .= "<td>" . $d[$h] . "</td>";
				}
				if ($this->is_action) {
					$content .= "<td>" . $this->getFilteredContentButton($d['id'], $d['nomor'], $d['status'], $d['status_acc'], $d['restock'])->getHtml() . "</td>";
				}
				$content .= "</tr>";
			}
		}
		return $content;
	}
	public function getFilteredContentButton($id, $nomor, $status, $status_acc, $restock) {
		$btn_group = new ButtonGroup("noprint");
		if ($status == "sudah") {
			$btn = new Button("", "", "Lihat");
			$btn->setAction($this->action . ".detail('" . $id . "')");
			$btn->setClass("btn-success");
			$btn->setAtribute("data-content='Lihat' data-toggle='popover'");
			$btn->setIcon("icon-eye-open icon-white");
			$btn->setIsButton(Button::$ICONIC_TEXT);
			$btn_group->addElement($btn);
		} else {
			$btn = new Button("", "", "Lihat");
			if ($status == "dikembalikan") {
				$btn->setClass("btn-inverse");
			} else {
				$btn->setClass("btn-info");
			}
			$btn->setAction($this->action . ".detail('" . $id . "')");
			$btn->setAtribute("data-content='Detail' data-toggle='popover'");
			$btn->setIcon("icon-eye-open icon-white");
			$btn->setIsButton(Button::$ICONIC_TEXT);
			$btn_group->addElement($btn);
			if ($status == "dikembalikan" && $restock == 0) {
				$btn = new Button("", "", "Restock");
				$btn->setAction($this->action . ".restock('" . $id . "')");
				$btn->setAtribute("data-content='Restock' data-toggle='popover'");
				$btn->setIcon("fa fa-refresh");
				$btn->setIsButton(Button::$ICONIC_TEXT);
				$btn_group->addElement($btn);
			} else if ($status == "belum" && $status_acc == 0) {
				$btn = new Button("", "", "Edit");
				$btn->setClass("btn-warning");
				$btn->setAction($this->action . ".edit('" . $id . "')");
				$btn->setAtribute("data-content='Edit' data-toggle='popover'");
				$btn->setIcon("fa fa-pencil");
				$btn->setIsButton(Button::$ICONIC_TEXT);
				$btn_group->addElement($btn);
				$btn = new Button("", "", "Batal");
				$btn->setClass("btn-danger");
				$btn->setAction($this->action . ".del('" . $id . "')");
				$btn->setAtribute("data-content='Batal' data-toggle='popover'");
				$btn->setIcon("fa fa-times");
				$btn->setIsButton(Button::$ICONIC_TEXT);
				$btn_group->addElement($btn);
			}
		}
		global $db;
		$mode_format = getSettings($db, "mutasi-output_format", "xls");
		if ($mode_format == "xls") {
			$btn = new Button("", "", "Unduh XLS");
			$btn->setAction($this->action . ".download_au58('" . $id . "', '" . $status . "')");
			$btn->setClass("btn-inverse");
			$btn->setAtribute("data-content='Unduh XLS' data-toggle='popover'");
			$btn->setIcon("fa fa-download");
			$btn->setIsButton(Button::$ICONIC_TEXT);
			$btn_group->addElement($btn);
		} else {
			$btn = new Button("", "", "Unduh PDF");
			$btn->setAction($this->action . ".export_pdf('" . $id . "', '" . $status . "')");
			$btn->setClass("btn-inverse");
			$btn->setAtribute("data-content='Unduh PDF' data-toggle='popover'");
			$btn->setIcon("fa fa-download");
			$btn->setIsButton(Button::$ICONIC_TEXT);
			$btn_group->addElement($btn);
		}
		return $btn_group;
	}
}
?>