<?php 
	require_once("smis-base/smis-include-service-consumer.php");
	require_once("gudang_farmasi/table/ReturObatUnitTable.php");
	require_once("gudang_farmasi/adapter/ReturObatUnitAdapter.php");
	require_once("gudang_farmasi/responder/ReturObatUnitDBResponder.php");
	
	$retur_obat_table = new ReturObatUnitTable(
		array("Unit", "Nomor", "Tanggal Retur", "Nama Obat", "Jenis Obat", "Produsen", "Vendor", "Jumlah", "Status"),
		"Gudang Farmasi : Retur Obat Unit",
		null,
		true
	);
	$retur_obat_table->setName("retur_obat");
	$retur_obat_table->setAddButtonEnable(false);
	
	if (isset($_POST['command'])) {
		$retur_obat_adapter = new ReturObatUnitAdapter();
		$columns = array("id", "f_id", "unit", "tanggal", "id_obat", "nama_obat", "nama_jenis_obat", "jumlah", "satuan", "konversi", "satuan_konversi", "hna", "tanggal_exp", "no_batch", "turunan", "keterangan", "status", "id_vendor", "nama_vendor", "produsen", "restok");
		$retur_obat_dbtable = new DBTable(
			$db,
			"smis_fr_retur_obat_unit",
			$columns
		);
		$filter = "";
		if (isset($_POST['kriteria'])) {
			$filter = " AND (nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%' OR unit LIKE '%" . $_POST['kriteria'] . "%' OR nama_vendor LIKE '%" . $_POST['kriteria'] . "%' OR produsen LIKE '%" . $_POST['kriteria'] . "%')";
		}
		$query_value = "
			SELECT *
			FROM smis_fr_retur_obat_unit
			WHERE prop NOT LIKE 'del' AND status != 'dikembalikan' " . $filter . "
		";
		$query_count = "
			SELECT COUNT(*)
			FROM smis_fr_retur_obat_unit
			WHERE prop NOT LIKE 'del' AND status != 'dikembalikan' " . $filter . "
		";
		$retur_obat_dbtable->setPreferredQuery(true, $query_value, $query_count);
		
		$retur_obat_dbresponder = new ReturObatUnitDBResponder(
			$retur_obat_dbtable,
			$retur_obat_table,
			$retur_obat_adapter
		);
		$data = $retur_obat_dbresponder->command($_POST['command']);
		//set_retur_obat_status:
		if (isset($_POST['push_command'])) {
			class SetReturObatStatusServiceConsumer extends ServiceConsumer {
				public function __construct($db, $id, $status, $unit, $command) {
					$array = array();
					$array['id'] = $id;
					$array['status'] = $status;
					$array['command'] = $command;
					global $user;
					$array['username'] = $user->getName();
					parent::__construct($db, "set_status_retur_obat", $array, $unit);
				}
				public function proceedResult() {
					$content = array();
					$result = json_decode($this->result,true);
					foreach ($result as $autonomous) {
						foreach ($autonomous as $entity) {
							if ($entity != null || $entity != "")
								return $entity;
						}
					}
					return $content;
				}
			}
			$retur_obat_dbtable = new DBTable($db, "smis_fr_retur_obat_unit");
			$retur_obat_row = $retur_obat_dbtable->get_row("
				SELECT f_id, unit, status
				FROM smis_fr_retur_obat_unit
				WHERE id = '" . $data['content']['id'] . "'
			");
			$command = "push_" . $_POST['push_command'];
			$set_retur_obat_status_service_consumer = new SetReturObatStatusServiceConsumer($db, $retur_obat_row->f_id, $retur_obat_row->status, $retur_obat_row->unit, $command);
			$set_retur_obat_status_service_consumer->execute();
		}
		echo json_encode($data);
		return;
	}
	
	$retur_obat_modal = new Modal("retur_obat_add_form", "smis_form_container", "retur_obat");
	$retur_obat_modal->setTitle("Retur Obat");
	$id_hidden = new Hidden("retur_obat_id", "retur_obat_id", "");
	$retur_obat_modal->addElement("", $id_hidden);
	$id_stok_obat_hidden = new Hidden("retur_obat_id_stok_obat", "retur_obat_id_stok_obat", "");
	$retur_obat_modal->addElement("", $id_stok_obat_hidden);
	$tanggal_text = new Text("retur_obat_tanggal", "retur_obat_tanggal", "");
	$tanggal_text->setAtribute("disabled='disabled'");
	$retur_obat_modal->addElement("Tanggal", $tanggal_text);
	$nama_obat_text = new Text("retur_obat_nama_obat", "retur_obat_nama_obat", "");
	$nama_obat_text->setAtribute("disabled='disabled'");
	$retur_obat_modal->addElement("Nama Obat", $nama_obat_text);
	$nama_jenis_text = new Text("retur_obat_jenis", "retur_obat_jenis", "");
	$nama_jenis_text->setAtribute("disabled='disabled'");
	$retur_obat_modal->addElement("Jenis Obat", $nama_jenis_text);
	$produsen_text = new Text("retur_obat_produsen", "retur_obat_produsen", "");
	$produsen_text->setAtribute("disabled='disabled'");
	$retur_obat_modal->addElement("Produsen", $produsen_text);
	$vendor_text = new Text("retur_obat_vendor", "retur_obat_vendor", "");
	$vendor_text->setAtribute("disabled='disabled'");
	$retur_obat_modal->addElement("Vendor", $vendor_text);
	$f_jumlah_text = new Text("retur_obat_f_jumlah", "retur_obat_f_jumlah", "");
	$f_jumlah_text->setAtribute("disabled='disabled'");
	$retur_obat_modal->addElement("Jumlah", $f_jumlah_text);
	$keterangan_textarea = new TextArea("retur_obat_keterangan", "retur_obat_keterangan", "");
	$keterangan_textarea->setLine(2);
	$keterangan_textarea->setAtribute("disabled='disabled'");
	$retur_obat_modal->addElement("Keterangan", $keterangan_textarea);
	$retur_obat_button = new Button("", "", "Terima");
	$retur_obat_button->setClass("btn-success");
	$retur_obat_button->setAtribute("id='retur_obat_accept'");
	$retur_obat_button->setAction("retur_obat.accept()");
	$retur_obat_button->setIcon("fa fa-check");
	$retur_obat_button->setIsButton(Button::$ICONIC);
	$retur_obat_modal->addFooter($retur_obat_button);
	$retur_obat_button = new Button("", "", "Kembalikan");
	$retur_obat_button->setClass("btn-danger");
	$retur_obat_button->setAtribute("id='retur_obat_return'");
	$retur_obat_button->setAction("retur_obat.return()");
	$retur_obat_button->setIcon("fa fa-times");
	$retur_obat_button->setIsButton(Button::$ICONIC);
	$retur_obat_modal->addFooter($retur_obat_button);
	$retur_obat_button = new Button("", "", "OK");
	$retur_obat_button->setClass("btn-success");
	$retur_obat_button->setAtribute("id='retur_obat_ok'");
	$retur_obat_button->setAction("$($(this).data('target')).smodal('hide')");
	$retur_obat_modal->addFooter($retur_obat_button);
	
	echo $retur_obat_modal->getHtml();
	echo $retur_obat_table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	function ReturObatAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	ReturObatAction.prototype.constructor = ReturObatAction;
	ReturObatAction.prototype = new TableAction();
	ReturObatAction.prototype.edit = function(id) {
		var data = this.getRegulerData();
		data['command'] = "edit";
		data['id'] = id;
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#retur_obat_id").val(json.id);
				$("#retur_obat_tanggal").val(json.tanggal);
				$("#retur_obat_nama_obat").val(json.nama_obat);
				$("#retur_obat_jenis").val(json.nama_jenis_obat);
				$("#retur_obat_produsen").val(json.produsen);
				$("#retur_obat_vendor").val(json.nama_vendor);
				$("#retur_obat_f_jumlah").val(json.jumlah + " " + json.satuan);
				$("#retur_obat_keterangan").val(json.keterangan);
				$("#retur_obat_accept").show();
				$("#retur_obat_return").show();
				$("#retur_obat_ok").hide();
				$("#retur_obat_add_form").smodal("show");
			}
		);
	};
	ReturObatAction.prototype.accept = function() {
		$("#retur_obat_add_form").smodal("hide");
		showLoading();
		var self = this;
		var data = this.getRegulerData();
		data['command'] = "save";
		data['push_command'] = "save";
		data['id'] = $("#retur_obat_id").val();
		data['status'] = "sudah";
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) {
					$("#retur_obat_add_form").smodal("show");
				} else {
					self.view();
				}
				dismissLoading();
			}
		);
	};
	ReturObatAction.prototype.return = function() {
		$("#retur_obat_add_form").smodal("hide");
		showLoading();
		var self = this;
		var data = this.getRegulerData();
		data['command'] = "save";
		data['push_command'] = "save";
		data['id'] = $("#retur_obat_id").val();
		data['status'] = "dikembalikan";
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) {
					$("#retur_obat_add_form").smodal("show");
				} else {
					self.view();
				}
				dismissLoading();
			}
		);
	};
	ReturObatAction.prototype.detail = function(id) {
		var data = this.getRegulerData();
		data['command'] = "edit";
		data['id'] = id;
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#retur_obat_id").val(json.id);
				$("#retur_obat_tanggal").val(json.tanggal);
				$("#retur_obat_nama_obat").val(json.nama_obat);
				$("#retur_obat_jenis").val(json.nama_jenis_obat);
				$("#retur_obat_produsen").val(json.produsen);
				$("#retur_obat_vendor").val(json.nama_vendor);
				$("#retur_obat_f_jumlah").val(json.jumlah + " " + json.satuan);
				$("#retur_obat_keterangan").val(json.keterangan);
				$("#retur_obat_accept").hide();
				$("#retur_obat_return").hide();
				$("#retur_obat_ok").show();
				$("#retur_obat_add_form").smodal("show");
			}
		);
	};
	ReturObatAction.prototype.restock = function(id) {
		var self = this;
		bootbox.confirm(
			"Yakin memasukkan Stok Retur ini ke Perbekalan?",
			function(result) {
				if (result) {
					var data = self.getRegulerData();
					data['command'] = "save";
					data['id'] = id;
					data['restok'] = "1";
					$.post(
						"",
						data,
						function(response) {
							var json = getContent(response);
							if (json == null) return;
							self.view();
						}
					);
				}
			}
		);
	};
	ReturObatAction.prototype.cancel_restock = function(id) {
		var self = this;
		bootbox.confirm(
			"Yakin membatalkan Restok Retur ini ke Perbekalan?",
			function(result) {
				if (result) {
					var data = self.getRegulerData();
					data['command'] = "save";
					data['id'] = id;
					data['restok'] = "0";
					$.post(
						"",
						data,
						function(response) {
							var json = getContent(response);
							if (json == null) return;
							self.view();
						}
					);
				}
			}
		);
	};
	ReturObatAction.prototype.export_pdf = function(id) {
		var data = this.getRegulerData();
		data['command'] = "export_pdf";
		data['id'] = id;
		showLoading();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) {
					dismissLoading();
					return;
				}
				var getUrl = window.location['pathname'] + json;
				window.open(getUrl, 'pdf');
				dismissLoading();
			}
		);
	};
	
	var retur_obat;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		$("#smis-chooser-modal").on("show", function() {
			$("#smis-chooser-modal").removeClass("full_model");
			$("#smis-chooser-modal").addClass("full_model");
		});
		$("#smis-chooser-modal").on("hidden", function() {
			$("#smis-chooser-modal").removeClass("full_model");
		});
		var retur_obat_columns = new Array("id", "f_id", "unit", "tanggal", "id_obat", "nama_obat", "nama_jenis_obat", "jumlah", "satuan", "konversi", "satuan_konversi", "hna", "tanggal_exp", "turunan", "keterangan", "status", "id_vendor", "nama_vendor", "produsen", "restok");
		retur_obat = new ReturObatAction(
			"retur_obat",
			"gudang_farmasi",
			"retur_obat_unit",
			retur_obat_columns
		);
		retur_obat.view();
	});
</script>