<?php
	require_once("smis-base/smis-include-service-consumer.php");
	global $db;

	$id = isset($_POST['id']) ? $_POST['id'] : "";
	$tanggal = date("Y-m-d");
	$id_vendor = "";
	$nama_vendor = "";
	$no_faktur = "";
	$tanggal_faktur = "";
	$keterangan = "";
	$readonly = false;
	if ($id != "") {
		$readonly = true;
		$h_data = $db->get_row("
			SELECT
				*
			FROM
				smis_fr_h_retur_obat_non_faktur
			WHERE
				id = '" . $id . "'
		");
		if ($h_data != null) {
			$tanggal = $h_data->tanggal;
			$id_vendor = $h_data->id_vendor;
			$nama_vendor = $h_data->nama_vendor;
			$no_faktur = $h_data->no_faktur;
			$tanggal_faktur = $h_data->tanggal_faktur;
			$keterangan = $h_data->keterangan;
		}
	}

	$header_form = new Form("", "", "Gudang Farmasi : Retur Pembelian (Batch Non-Faktur)");
	$id_hidden = new Hidden("retur_keluar_non_faktur_id", "retur_keluar_non_faktur_id", $id);
	$header_form->addElement("", $id_hidden);
	$tanggal_text = new Text("retur_keluar_non_faktur_tanggal", "retur_keluar_non_faktur_tanggal", $tanggal);
	if (!$readonly) {
		$tanggal_text->setAtribute("data-date-format='yyyy-mm-dd'");
		$tanggal_text->setClass("mydate");
	} else {
		$tanggal_text->setAtribute("disabled='disabled'");
	}
	$header_form->addElement("Tanggal", $tanggal_text);
	$id_vendor_hidden = new Hidden("retur_keluar_non_faktur_id_vendor", "retur_keluar_non_faktur_id_vendor", $id_vendor);
	$header_form->addElement("", $id_vendor_hidden);
	$nama_vendor_text = new Text("retur_keluar_non_faktur_nama_vendor", "retur_keluar_non_faktur_nama_vendor", $nama_vendor);
	$nama_vendor_text->setAtribute("disabled='disabled'");
	if (!$readonly) {
		$nama_vendor_text->setClass("smis-one-option-input");
		$vendor_browse_button = new Button("", "", "Pilih");
		$vendor_browse_button->setClass("btn-info");
		$vendor_browse_button->setIsButton(Button::$ICONIC);
		$vendor_browse_button->setIcon("fa fa-list");
		$vendor_browse_button->setAction("vendor.chooser('vendor', 'vendor', 'vendor', vendor)");
		$vendor_browse_button->setAtribute("id='vendor_browse'");
		$vendor_input_group = new InputGroup("");
		$vendor_input_group->addComponent($nama_vendor_text);
		$vendor_input_group->addComponent($vendor_browse_button);
		$header_form->addElement("Vendor", $vendor_input_group);
	} else
		$header_form->addElement("Vendor", $nama_vendor_text);
	$no_faktur_text = new Text("retur_keluar_non_faktur_no_faktur", "retur_keluar_non_faktur_no_faktur", $no_faktur);
	if ($readonly) {
		$no_faktur_text->setAtribute("disabled='disabled'");
	}
	$header_form->addElement("No. Faktur", $no_faktur_text);
	$tanggal_faktur_text = new Text("retur_keluar_non_faktur_tanggal_faktur", "retur_keluar_non_faktur_tanggal_faktur", $tanggal_faktur);
	if (!$readonly) {
		$tanggal_faktur_text->setAtribute("data-date-format='yyyy-mm-dd'");
		$tanggal_faktur_text->setClass("mydate");
	} else {
		$tanggal_faktur_text->setAtribute("disabled='disabled'");
	}
	$header_form->addElement("Tgl. Faktur", $tanggal_faktur_text);
	$keterangan_textarea = new TextArea("retur_keluar_non_faktur_keterangan", "retur_keluar_non_faktur_keterangan", $keterangan);
	$keterangan_textarea->setLine(3);
	if ($readonly) {
		$keterangan_textarea->setAtribute("disabled='disabled'");
	}
	$header_form->addElement("Keterangan", $keterangan_textarea);

	$detail_form = new Form("", "", "");
	$row_num_hidden = new Hidden("dretur_keluar_non_faktur_row_num", "dretur_keluar_non_faktur_row_num", "");
	$detail_form->addElement("", $row_num_hidden);
	$id_stok_obat_hidden = new Hidden("dretur_keluar_non_faktur_id_stok_obat", "dretur_keluar_non_faktur_id_stok_obat", "");
	$detail_form->addElement("", $id_stok_obat_hidden);
	$kode_obat_text = new Text("dretur_keluar_non_faktur_kode_obat", "dretur_keluar_non_faktur_kode_obat", "");
	$kode_obat_text->setAtribute("disabled='disabled'");
	$detail_form->addElement("Kode Obat", $kode_obat_text);
	$nama_obat_text = new Text("dretur_keluar_non_faktur_nama_obat", "dretur_keluar_non_faktur_nama_obat", "");
	$nama_obat_text->setAtribute("disabled='disabled'");
	$nama_obat_text->setClass("smis-one-option-input");
	$obat_browse_button = new Button("", "", "Pilih");
	$obat_browse_button->setClass("btn-info");
	$obat_browse_button->setIsButton(Button::$ICONIC);
	$obat_browse_button->setIcon("fa fa-list");
	$obat_browse_button->setAction("obat.chooser('obat', 'obat', 'obat', obat)");
	$obat_browse_button->setAtribute("id='obat_browse'");
	$obat_input_group = new InputGroup("");
	$obat_input_group->addComponent($nama_obat_text);
	$obat_input_group->addComponent($obat_browse_button);
	$detail_form->addElement("Nama Obat", $obat_input_group);
	$tanggal_exp_text = new Text("dretur_keluar_non_faktur_tanggal_exp", "dretur_keluar_non_faktur_tanggal_exp", "");
	$tanggal_exp_text->setAtribute("disabled='disabled'");
	$detail_form->addElement("Tgl. ED", $tanggal_exp_text);
	$sisa_text = new Text("dretur_keluar_non_faktur_sisa", "dretur_keluar_non_faktur_sisa", "");
	$sisa_text->setAtribute("disabled='disabled'");
	$detail_form->addElement("Sisa", $sisa_text);
	$jumlah_text = new Text("dretur_keluar_non_faktur_jumlah", "dretur_keluar_non_faktur_jumlah", "");
	$detail_form->addElement("Jumlah", $jumlah_text);
	$satuan_text = new Text("dretur_keluar_non_faktur_satuan", "dretur_keluar_non_faktur_satuan", "");
	$satuan_text->setAtribute("disabled='disabled'");
	$detail_form->addElement("Satuan", $satuan_text);

	$save_button = new Button("", "", "Tambahkan");
	$save_button->setClass("btn-info");
	$save_button->setIsButton(Button::$ICONIC_TEXT);
	$save_button->setIcon("fa fa-chevron-right");
	$save_button->setAction("dretur_keluar_non_faktur.save()");
	$save_button->setAtribute("id='dretur_keluar_non_faktur_save'");

	$update_button = new Button("", "", "Perbarui");
	$update_button->setClass("btn-info");
	$update_button->setIsButton(Button::$ICONIC_TEXT);
	$update_button->setIcon("fa fa-chevron-right");
	$update_button->setAction("dretur_keluar_non_faktur.save()");
	$update_button->setAtribute("id='dretur_keluar_non_faktur_update'");

	$cancel_button = new Button("", "", "Batal");
	$cancel_button->setClass("btn-danger");
	$cancel_button->setIsButton(Button::$ICONIC_TEXT);
	$cancel_button->setIcon("icon-white icon-remove");
	$cancel_button->setAction("dretur_keluar_non_faktur.cancel()");
	$cancel_button->setAtribute("id='dretur_keluar_non_faktur_cancel'");	

	$button_group = new ButtonGroup("");
	$button_group->addButton($update_button);
	$button_group->addButton($cancel_button);

	if (!$readonly)
		$detail_form->addElement("", $save_button);
	$detail_form->addElement("", $button_group);

	$table = new Table(
		array("No.", "ID-Stok", "Kode", "Obat", "Tgl. ED", "Jumlah", "Satuan", "Ubah", "Hapus"),
		"",
		null,
		true
	);
	$table->setName("dretur_keluar_non_faktur");
	$table->setFooterVisible(false);
	$table->setAction(false);

	$button_group = new ButtonGroup("");
	$back_button = new Button("", "", "Kembali");
	$back_button->setClass("btn-inverse");
	$back_button->setIsButton(Button::$ICONIC_TEXT);
	$back_button->setIcon("fa fa-chevron-left");
	$back_button->setAction("retur_keluar_non_faktur.back()");
	$back_button->setAtribute("id='retur_keluar_non_faktur_back'");
	$button_group->addButton($back_button);
	if (!$readonly) {
		$save_button = new Button("", "", "Simpan Draft");
		$save_button->setClass("btn-success");
		$save_button->setIsButton(Button::$ICONIC_TEXT);
		$save_button->setIcon("fa fa-floppy-o");
		$save_button->setAction("retur_keluar_non_faktur.save()");
		$save_button->setAtribute("id='retur_keluar_non_faktur_save'");
		$button_group->addButton($save_button);
	}

	$vendor_table = new Table(
		array("Nama", "NPWP", "Alamat", "No. Telp."),
		"",
		null,
		true
	);
	$vendor_table->setName("vendor");
	$vendor_table->setModel(Table::$SELECT);
	$vendor_adapter = new SimpleAdapter();
	$vendor_adapter->add("Nama", "nama");
	$vendor_adapter->add("NPWP", "npwp");
	$vendor_adapter->add("Alamat", "alamat");
	$vendor_adapter->add("No. Telp.", "telpon");
	$vendor_service_responder = new ServiceResponder(
		$db,
		$vendor_table,
		$vendor_adapter,
		"get_daftar_vendor_medis"
	);
	
	$obat_table = new Table(array("ID-Stok", "Kode", "Obat", "Sisa", "Satuan"));
	$obat_table->setName("obat");
	$obat_table->setModel(Table::$SELECT);
	$obat_adapter = new SimpleAdapter();
	$obat_adapter->add("ID-Stok", "id");
	$obat_adapter->add("Kode", "kode_obat");
	$obat_adapter->add("Obat", "nama_obat");
	$obat_adapter->add("Sisa", "sisa");
	$obat_adapter->add("Satuan", "satuan");
	$obat_dbtable = new DBTable($db, "smis_fr_stok_obat");
	$obat_dbtable->addCustomKriteria(" sisa ", " > 0 ");
	$obat_dbtable->setOrder(" nama_obat ASC ");
	$obat_dbresponder = new DBResponder(
		$obat_dbtable,
		$obat_table,
		$obat_adapter
	);

	$super_command = new SuperCommand();
	$super_command->addResponder("vendor", $vendor_service_responder);
	$super_command->addResponder("obat", $obat_dbresponder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "show_detail") {
			$id = $_POST['id'];
			$readonly = isset($_POST['readonly']) ? $_POST['readonly'] : false;
			$dbtable = new DBTable($db, "smis_fr_h_retur_obat_non_faktur");
			$header_row = $dbtable->select($id);
			$detail_rows = $dbtable->get_result("
				SELECT 
					a.*, b.kode_obat, b.nama_obat, b.tanggal_exp, b.satuan
				FROM 
					smis_fr_d_retur_obat_non_faktur a 
						LEFT JOIN smis_fr_stok_obat b ON a.id_stok_obat = b.id
				WHERE 
					a.id_h_retur_obat_non_faktur = '" . $id . "' 
						AND a.prop LIKE ''
			");
			$html = "";
			$num = 0;
			if ($detail_rows != null) {
				foreach ($detail_rows as $row) {
					$html_edit_action = "";
					$html_del_action = "";
					if (!$readonly) {
						$html_edit_action = "<a href='#' onclick='dretur_keluar_non_faktur.edit(" . $num . ")' class='input btn btn-warning'><i class='fa fa-pencil'></i></a>";
						$html_del_action = "<a href='#' onclick='dretur_keluar_non_faktur.del(" . $num . ")' class='input btn btn-danger'><i class='fa fa-trash'></i></a>";
					}
					$html .= "
						<tr id='data_" . $num . "'>
							<td id='nomor'>" . ($num + 1) . "</td>
							<td id='id' style='display: none;'>" . $row->id . "</td>
							<td id='id_stok_obat'><small>" . $row->id_stok_obat . "</small></td>
							<td id='kode_obat'><small>" . $row->kode_obat . "</small></td>
							<td id='nama_obat'><small>" . $row->nama_obat . "</small></td>
							<td id='tanggal_exp'><small>" . $row->tanggal_exp . "</small></td>
							<td id='jumlah_lama' style='display: none;'>" . $row->jumlah . "</td>
							<td id='jumlah'><small>" . $row->jumlah . "</small></td>
							<td id='satuan'><small>" . $row->satuan . "</small></td>
							<td>" . $html_edit_action . "</td>
							<td>" . $html_del_action . "</td>
						</tr>";
					$num++;
				}
			}
			$data = array();
			$data['html'] = $html;
			$data['row_num'] = $num;
			echo json_encode($data);
		} else {
			$adapter = new SimpleAdapter();
			$dbtable = new DBTable($db, "smis_fr_h_retur_obat_non_faktur");
			require_once("gudang_farmasi/responder/ReturKeluarNonFakturBatchDBResponder.php");
			$dbresponder = new ReturKeluarNonFakturBatchDBResponder(
				$dbtable,
				$table,
				$adapter
			);
			$data = $dbresponder->command($_POST['command']);
			echo json_encode($data);
		}
		return;
	}

	echo $header_form->getHtml();
	echo "<div id='table_content'>" .
			 "<div class='row-fluid'>";
	if (!$readonly) {
		echo	 "<div class='span4'>" .
					 $detail_form->getHtml() .
				 "</div>" .
				 "<div class='span8'>" .
					 $table->getHtml() .
					 "<div align='right'>" . $button_group->getHtml() . "</div>" .
				 "</div>";
	} else {
		echo	 "<div class='span12'>" .
					 $table->getHtml() .
					 "<div align='right'>" . $button_group->getHtml() . "</div>" .
				 "</div>";
	}
	echo 	 "</div>" .
		 "</div>";
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
	var retur_keluar_non_faktur;
	var dretur_keluar_non_faktur;
	var vendor;
	var obat;
	var row_num;

	$(document).ready(function() {
		$(".mydate").datepicker();
		obat = new TableAction(
			"obat",
			"gudang_farmasi",
			"retur_keluar_non_faktur_batch_form",
			new Array()
		);
		obat.selected = function(json) {
			$("#dretur_keluar_non_faktur_id_stok_obat").val(json.id);
			$("#dretur_keluar_non_faktur_kode_obat").val(json.kode_obat);
			$("#dretur_keluar_non_faktur_nama_obat").val(json.nama_obat);
			$("#dretur_keluar_non_faktur_tanggal_exp").val(json.tanggal_exp);
			$("#dretur_keluar_non_faktur_sisa").val(json.sisa);
			$("#dretur_keluar_non_faktur_satuan").val(json.satuan);
		};
		obat.setSuperCommand("obat");

		vendor = new TableAction(
			"vendor",
			"gudang_farmasi",
			"retur_keluar_non_faktur_batch_form",
			new Array()	
		);
		vendor.selected = function(json) {
			$("#retur_keluar_non_faktur_id_vendor").val(json.id);
			$("#retur_keluar_non_faktur_nama_vendor").val(json.nama);
		};
		vendor.setSuperCommand("vendor");

		retur_keluar_non_faktur = new TableAction(
			"retur_keluar_non_faktur",
			"gudang_farmasi",
			"retur_keluar_non_faktur_batch_form",
			new Array()
		);
		retur_keluar_non_faktur.back = function() {
			var data = this.getRegulerData();
			data['action'] = "retur_keluar_non_faktur_batch";
			data['super_command'] = "";
			data['kriteria'] = "";
			data['max'] = 5;
			data['number'] = 0;
			LoadSmisPage(data);
		};
		retur_keluar_non_faktur.show_detail_form = function(id) {
			console.log(id);
			if (id == 0 || id == "")
				return;
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "show_detail";
			data['id'] = id;
			data['readonly'] = false;
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) return;
					$("#dretur_keluar_non_faktur_list").html(json.html);
					row_num = json.row_num;
				}
			);
		};
		retur_keluar_non_faktur.getSaveData = function() {
			var data = this.getRegulerData();
			data['command'] = "save";
			data['id'] = $("#retur_keluar_non_faktur_id").val();
			data['tanggal'] = $("#retur_keluar_non_faktur_tanggal").val();
			data['id_vendor'] = $("#retur_keluar_non_faktur_id_vendor").val();
			data['nama_vendor'] = $("#retur_keluar_non_faktur_nama_vendor").val();
			data['no_faktur'] = $("#retur_keluar_non_faktur_no_faktur").val();
			data['tanggal_faktur'] = $("#retur_keluar_non_faktur_tanggal_faktur").val();
			data['keterangan'] = $("#retur_keluar_non_faktur_keterangan").val();
			var detail = {};
			var n_row = $("tbody#dretur_keluar_non_faktur_list tr").length;
			for (var i = 0; i < n_row; i++) {
				var d_data = {};
				d_data['id'] = $("tbody#dretur_keluar_non_faktur_list tr:eq(" + i + ") td#id").text();
				d_data['id_stok_obat'] = $("tbody#dretur_keluar_non_faktur_list tr:eq(" + i + ") td#id_stok_obat").text();
				d_data['nama_obat'] = $("tbody#dretur_keluar_non_faktur_list tr:eq(" + i + ") td#nama_obat").text();
				d_data['jumlah_lama'] = $("tbody#dretur_keluar_non_faktur_list tr:eq(" + i + ") td#jumlah_lama").text();
				d_data['jumlah'] = $("tbody#dretur_keluar_non_faktur_list tr:eq(" + i + ") td#jumlah").text();
				d_data['prop'] = $("tbody#dretur_keluar_non_faktur_list tr:eq(" + i + ")").attr("class") == "deleted" ? "del" : "";
				detail[i] = d_data;
			}
			data['detail'] = detail;
			return data;
		};
		retur_keluar_non_faktur.validate = function() {
			var valid = true;
			var invalid_msg = "";
			var tanggal = $("#retur_keluar_non_faktur_tanggal").val();
			var id_vendor = $("#retur_keluar_non_faktur_id_vendor").val();
			var no_faktur = $("#retur_keluar_non_faktur_no_faktur").val();
			var tanggal_faktur = $("#retur_keluar_non_faktur_tanggal_faktur").val();
			var keterangan = $("#retur_keluar_non_faktur_keterangan").val();
			var n_row = $("#dretur_keluar_non_faktur_list tr").length;
			var jumlah_detail = 0;
			for (var i = 0; i < n_row; i++) {
				var deleted = $("tbody#dretur_keluar_non_faktur_list tr:eq(" + i + ")").attr("class") == "deleted" ? true : false;
				if (!deleted)
					jumlah_detail++;
			}
			
			if (tanggal == "") {
				valid = false;
				invalid_msg += "</br><strong>Tanggal</strong> tidak boleh kosong";
				$("#retur_keluar_non_faktur_tanggal").addClass("error");
			}
			if (id_vendor == "") {
				valid = false;
				invalid_msg += "</br><strong>Vendor</strong> tidak boleh kosong";
				$("#retur_keluar_non_faktur_nama_vendor").addClass("error");
			}
			if (no_faktur == "") {
				valid = false;
				invalid_msg += "</br><strong>No. Faktur</strong> tidak boleh kosong";
				$("#retur_keluar_non_faktur_no_faktur").addClass("error");
			}
			if (tanggal_faktur == "") {
				valid = false;
				invalid_msg += "</br><strong>Tgl. Faktur</strong> tidak boleh kosong";
				$("#retur_keluar_non_faktur_tanggal_faktur").addClass("error");
			}
			if (keterangan == "") {
				valid = false;
				invalid_msg += "</br><strong>Keterangan</strong> tidak boleh kosong";
				$("#retur_keluar_non_faktur_keterangan").addClass("error");
			}
			if (jumlah_detail == 0) {
				valid = false;
				invalid_msg += "</br><strong>Detail Retur Pembelian</strong> tidak boleh kosong";
			}
			
			if (!valid)
				bootbox.alert(invalid_msg);
			return valid;
		};
		retur_keluar_non_faktur.save = function() {
			if (!this.validate())
				return;
			var self = this;
			var data = this.getSaveData();
			showLoading();
			$.post(
				"",
				data,
				function(response) {
					var json = getContent(response);
					if (json == null) {
						dismissLoading();
						return;
					}
					if (json.success == 0) {
						dimissLoading();
						bootbox.alert({
							message : json.message,
							title 	: "Transaksi Gagal"
						});
						return;
					}
					dismissLoading();
					self.back();
				}
			);
		};

		dretur_keluar_non_faktur = new TableAction(
			"dretur_keluar_non_faktur",
			"gudang_farmasi",
			"retur_keluar_non_faktur_batch_form",
			new Array()	
		);
		dretur_keluar_non_faktur.setEditMode = function(enable) {
			if (enable == "true") {
				$("#dretur_keluar_non_faktur_save").show();
				$("#dretur_keluar_non_faktur_update").hide();
				$("#dretur_keluar_non_faktur_cancel").hide();
			} else {
				$("#dretur_keluar_non_faktur_save").hide();
				$("#dretur_keluar_non_faktur_update").show();
				$("#dretur_keluar_non_faktur_cancel").show();
			}
		};
		dretur_keluar_non_faktur.validate = function() {
			var valid = true;
			var invalid_msg = "";
			var id_stok_obat = $("#dretur_keluar_non_faktur_id_stok_obat").val();
			var sisa = $("#dretur_keluar_non_faktur_sisa").val();
			var jumlah = $("#dretur_keluar_non_faktur_jumlah").val();
			if (id_stok_obat == "") {
				valid = false;
				invalid_msg += "</br><strong>Obat</strong> harus dipilih terlebih dahulu";
				$("#dretur_keluar_non_faktur_nama_obat").addClass("error");
			}
			if (sisa == "") {
				valid = false;
				invalid_msg += "</br><strong>Sisa</strong> tidak tersedia";
				$("#dretur_keluar_non_faktur_sisa").addClass("error");
			}
			if (jumlah == "") {
				valid = false;
				invalid_msg += "</br><strong>Jumlah</strong> harus terisi";
				$("#dretur_keluar_non_faktur_jumlah").addClass("error");
			} else if (parseFloat(jumlah) > parseFloat(sisa)) {
				valid = false;
				invalid_msg += "</br><strong>Jumlah</strong> tidak dapat dipenuhi <strong>Sisa</strong>";
				$("#dretur_keluar_non_faktur_jumlah").addClass("error");	
			}
			if (!valid)
				bootbox.alert(invalid_msg);
			return valid;
		};
		dretur_keluar_non_faktur.clear = function() {
			$("#dretur_keluar_non_faktur_row_num").val("");
			$("#dretur_keluar_non_faktur_id_stok_obat").val("");
			$("#dretur_keluar_non_faktur_kode_obat").val("");
			$("#dretur_keluar_non_faktur_nama_obat").val("");
			$("#dretur_keluar_non_faktur_tanggal_exp").val("");
			$("#dretur_keluar_non_faktur_sisa").val("");
			$("#dretur_keluar_non_faktur_jumlah").val("");
			$("#dretur_keluar_non_faktur_satuan").val("");
		};
		dretur_keluar_non_faktur.refreshNumber = function() {
			var n_row = $("tbody#dretur_keluar_non_faktur_list tr").length;
			var nomor = 1;
			for (var i = 0; i < n_row; i++) {
				var deleted = $("tbody#dretur_keluar_non_faktur_list tr:eq(" + i + ")").attr("class") == "deleted" ? true : false;
				if (!deleted)
					$("tbody#dretur_keluar_non_faktur_list tr:eq(" + i + ") td#nomor").html("<small>" + nomor++ + "</small>");
			}
		};
		dretur_keluar_non_faktur.save = function() {
			if (!this.validate()) {
				return;
			}

			var r_num = $("#dretur_keluar_non_faktur_row_num").val();
			var id_stok_obat = $("#dretur_keluar_non_faktur_id_stok_obat").val();
			var kode_obat = $("#dretur_keluar_non_faktur_kode_obat").val();
			var nama_obat = $("#dretur_keluar_non_faktur_nama_obat").val();
			var tanggal_exp = $("#dretur_keluar_non_faktur_tanggal_exp").val();
			var jumlah = $("#dretur_keluar_non_faktur_jumlah").val();
			var satuan = $("#dretur_keluar_non_faktur_satuan").val();

			if (r_num == "") {
				/// Append :
				$("tbody#dretur_keluar_non_faktur_list").append(
					"<tr id='data_" + row_num + "'>" +
						"<td id='nomor'></td>" +
						"<td id='id' style='display: none;'></td>" +
						"<td id='id_stok_obat'><small>" + id_stok_obat + "</small></td>" +
						"<td id='kode_obat'><small>" + kode_obat + "</small></td>" +
						"<td id='nama_obat'><small>" + nama_obat + "</small></td>" +
						"<td id='tanggal_exp'><small>" + tanggal_exp + "</small></td>" +
						"<td id='jumlah_lama' style='display: none;'>0</td>" +
						"<td id='jumlah'><small>" + jumlah + "</small></td>" +
						"<td id='satuan'><small>" + satuan + "</small></td>" +
						"<td>" + 
							"<a href='#' onclick='dretur_keluar_non_faktur.edit(" + row_num + ")' class='input btn btn-warning'><i class='fa fa-pencil'></i></a>" +
						"</td>" +
						"<td>" + 
							"<a href='#' onclick='dretur_keluar_non_faktur.del(" + row_num + ")' class='input btn btn-danger'><i class='fa fa-trash'></i></a>" +
						"</td>" +
					"</tr>"
				);
				row_num++;
			} else {
				/// Update :
				$("tr#data_" + r_num + " td#jumlah").html("<small>" + jumlah + "</small>");
			}

			this.clear();
			this.setEditMode("true");
			this.refreshNumber();
		};
		dretur_keluar_non_faktur.edit = function(r_num) {
			var id_stok_obat = $("tr#data_" + r_num + " td#id_stok_obat").text();
			var kode_obat = $("tr#data_" + r_num + " td#kode_obat").text();
			var nama_obat = $("tr#data_" + r_num + " td#nama_obat").text();
			var tanggal_exp = $("tr#data_" + r_num + " td#tanggal_exp").text();
			var jumlah = $("tr#data_" + r_num + " td#jumlah").text();
			var satuan = $("tr#data_" + r_num + " td#satuan").text();

			this.setEditMode("false");

			var data = this.getRegulerData();
			data['super_command'] = "obat";
			data['command'] = "edit";
			data['id'] = id_stok_obat;
			showLoading();
			$.post(
				"",
				data,
				function(response) {
					var json = getContent(response);
					if (json == null) {
						dismissLoading();
						return;
					}
					var sisa = json.sisa;
					$("#dretur_keluar_non_faktur_row_num").val(r_num);
					$("#dretur_keluar_non_faktur_id_stok_obat").val(id_stok_obat);
					$("#dretur_keluar_non_faktur_kode_obat").val(kode_obat);
					$("#dretur_keluar_non_faktur_nama_obat").val(nama_obat);
					$("#dretur_keluar_non_faktur_tanggal_exp").val(tanggal_exp);
					$("#dretur_keluar_non_faktur_sisa").val(sisa);
					$("#dretur_keluar_non_faktur_jumlah").val(jumlah);
					$("#dretur_keluar_non_faktur_satuan").val(satuan);
					dismissLoading();
				}
			);
		};
		dretur_keluar_non_faktur.del = function(r_num) {
			var id = $("tr#data_" + r_num + " td#id").text();
			if (id.length == 0) {
				$("#data_" + r_num).remove();
			} else {
				$("#data_" + r_num).attr("style", "display: none;");
				$("#data_" + r_num).attr("class", "deleted");
			}
			this.refreshNumber();
		};
		dretur_keluar_non_faktur.cancel = function() {
			this.clear();
			this.setEditMode("true");
		};

		var id = "<?php echo $_POST['id']; ?>";
		row_num = 0;
		retur_keluar_non_faktur.show_detail_form(id);
		dretur_keluar_non_faktur.setEditMode("true");
	});
</script>
<style type="text/css">
	textarea {
		resize: none;
	}
</style>