<?php
	require_once("gudang_farmasi/table/ReturKeluarBatchNFTable.php");
	global $db;

	$table = new ReturKeluarBatchNFTable(
		array("No.", "Tanggal", "Vendor", "No. Faktur", "Tgl. Faktur", "Keterangan", "Status"),
		"Gudang Farmasi : Retur Pembelian (Batch Non-Faktur)",
		null,
		true
	);
	$table->setName("retur_keluar_non_faktur_batch");
	$table->setReloadButtonEnable(false);
	$table->setPrintButtonEnable(false);

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "export_xls") {
			require_once("smis-libs-out/php-excel/PHPExcel.php");
			$id = $_POST['id'];
			
			$objPHPExcel = PHPExcel_IOFactory::load("gudang_farmasi/templates/template_retur_pembelian.xlsx");
			$objPHPExcel->setActiveSheetIndexByName("RETUR PEMBELIAN");
			$objWorksheet = $objPHPExcel->getActiveSheet();
			
			$header_info = $db->get_row("
				SELECT 
					*
				FROM 
					smis_fr_h_retur_obat_non_faktur
				WHERE 
					id = '" . $id . "'
			");
			$nama_klinik = "KLINIK CASAMEDICAL";
			$objWorksheet->setCellValue("B2", $nama_klinik);
			$objWorksheet->setCellValue("B3", "REKANAN : " . ArrayAdapter::format("unslug", $header_info->nama_vendor));
			$objWorksheet->setCellValue("B4", "NO. FAKTUR : " . $header_info->no_faktur);
			$objWorksheet->setCellValue("B5", "TGL. FAKTUR : " . ArrayAdapter::format("date d-m-Y", $header_info->tanggal_faktur));
			$objWorksheet->setCellValue("K13", "Batam, " . ArrayAdapter::format("date d-m-Y", $header_info->tanggal));
			$objWorksheet->setCellValue("K17", "");
			$objWorksheet->setCellValue("K18", "SIPA : ");
			$detail_info = $db->get_result("
				SELECT 
					a.*, b.nama_obat, b.kode_obat, b.satuan, b.tanggal_exp, b.hna, b.no_batch
				FROM 
					smis_fr_d_retur_obat_non_faktur a
						LEFT JOIN smis_fr_stok_obat b ON a.id_stok_obat = b.id
				WHERE 
					a.prop LIKE ''
						AND a.id_h_retur_obat_non_faktur = '" . $id . "'
			");
			if (count($detail_info) - 2 > 0)
				$objWorksheet->insertNewRowBefore(10, count($detail_info) - 2);

			$start_row_num = 9;
			$end_row_num = 10;
			$row_num = $start_row_num;
			$number = 1;
			foreach ($detail_info as $di) {
				$objWorksheet->setCellValue("B" . $row_num, $number++);
				$objWorksheet->setCellValue("C" . $row_num, $di->kode_obat);
				$objWorksheet->setCellValue("D" . $row_num, $di->nama_obat);
				$objWorksheet->setCellValue("E" . $row_num, $di->jumlah);
				$objWorksheet->setCellValue("F" . $row_num, $di->satuan);
				$objWorksheet->setCellValue("G" . $row_num, ArrayAdapter::format("date d-m-Y", $di->tanggal_exp));
				$objWorksheet->setCellValue("H" . $row_num, $di->no_batch);
				$objWorksheet->setCellValue("I" . $row_num, $di->hna);
				$objWorksheet->setCellValue("J" . $row_num, $di->hna * $di->jumlah);
				$objWorksheet->setCellValue("K" . $row_num, $header_info->keterangan);
				$objWorksheet->getStyle("E" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
				$objWorksheet->getStyle("I" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->getStyle("J" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$row_num++;
			}
			
			header("Content-type: application/vnd.ms-excel");	
			header("Content-Disposition: attachment; filename=RETUR_PEMBELIAN_BATCH_NON_FAKTUR-" . ArrayAdapter::format("only-digit6", $header_info->id) . "_" . ArrayAdapter::format("date Ymd", $header_info->tanggal) . ".xlsx");
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objWriter->save("php://output");
			return;
		}
		$dbtable = new DBTable($db, "smis_fr_h_retur_obat_non_faktur");
		$dbtable->setOrder(" tanggal ASC ");
		$adapter = new SimpleAdapter(true, "No.");
		$adapter->add("id", "id");
		$adapter->add("dibatalkan", "dibatalkan");
		$adapter->add("Tanggal", "tanggal", "date d M Y");
		$adapter->add("Vendor", "nama_vendor");
		$adapter->add("No. Faktur", "no_faktur");
		$adapter->add("Tgl. Faktur", "tanggal_faktur", "date d M Y");
		$adapter->add("Keterangan", "keterangan");
		$adapter->add("Status", "dibatalkan", "trivial_1_Dibatalkan_-");
		require_once("gudang_farmasi/responder/ReturKeluarNonFakturBatchDBResponder.php");
		$dbresponder = new ReturKeluarNonFakturBatchDBResponder(
			$dbtable,
			$table,
			$adapter
		);
		$data = $dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}

	echo $table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	var retur_keluar_non_faktur_batch;
	$(document).ready(function() {
		retur_keluar_non_faktur_batch = new TableAction(
			"retur_keluar_non_faktur_batch",
			"gudang_farmasi",
			"retur_keluar_non_faktur_batch",
			new Array()
		);
		retur_keluar_non_faktur_batch.show_add_form = function() {
			var data = this.getRegulerData();
			data['action'] = "retur_keluar_non_faktur_batch_form";
			data['id'] = "";
			LoadSmisPage(data);
		};
		retur_keluar_non_faktur_batch.detail = function(id) {
			var data = this.getRegulerData();
			data['action'] = "retur_keluar_non_faktur_batch_form";
			data['id'] = id;
			LoadSmisPage(data);	
		};
		retur_keluar_non_faktur_batch.cancel = function(id) {
			var self = this;
			bootbox.confirm({
				message : "Yakin membatalkan transaksi ini?",
				title 	: "Konfirmasi Pembatalan",
				buttons	: {
                    confirm : {
	                    label: 'Ya',
	                    className: 'btn-success'
                    },
                    cancel : {
	                    label: 'Tidak',
	                    className: 'btn-danger'
                    }
                },
                callback : function (result) {
                    if (result) {
                    	var data = self.getRegulerData();
                    	data['command'] = "save";
                    	data['id'] = id;
                    	data['dibatalkan'] = 1;
                    	showLoading();
                    	$.post(
                    		"",
                    		data,
                    		function(response) {
                    			var json = getContent(response);
                    			if (json == null) {
                    				dismissLoading();
                    				return;
                    			}
                    			dismissLoading();
                    			self.view();
                    		}
                    	);
                    }
                }
			});
		};
		retur_keluar_non_faktur_batch.export_xls = function(id) {
			var data = this.getRegulerData();
			data['command'] = "export_xls";
			data['id'] = id;
			showLoading();
			postForm(data);
			dismissLoading();
		};
		retur_keluar_non_faktur_batch.view();
	});
</script>