<?php
    class ReturObatUnitDBResponder extends DBResponder {
        public function command($command) {
            if ($command != "export_pdf")
                return parent::command($command);
            $pack = new ResponsePackage();
            if ($command == "export_pdf") {
                $content = $this->export_pdf();
                $pack->setContent($content);
                $pack->setStatus(ResponsePackage::$STATUS_OK);
            }
            return $pack->getPackage();
        }

        public function export_pdf() {
            $id = $_POST['id'];

            $row = $this->dbtable->get_db()->get_row("
                SELECT *
                FROM smis_fr_retur_obat_unit
                WHERE id = '" . $id . "'
            ");

            $nama_instansi = "KLINIK CASA MEDICAL PANBIL";
            $alamat_instansi_1 = "Komp. Panbil Komersil Area Blok A";
            $alamat_instansi_2 = "No. 3A Kelurahan Muka Kuning";

            $tanggal = ArrayAdapter::format("date d-m-Y", $row->tanggal);
            $unit = ArrayAdapter::format("unslug", $row->unit);

            $margin_left = 10;
            $margin_top = 10;

            require_once("smis-libs-out/fpdf/fpdf.php");
            $fpdf = new FPDF("P", "mm", "A4");
            $fpdf->SetMargins($margin_left, $margin_top);

            $fpdf->AddPage();
            $fpdf->SetFont("Arial", "", 12);
            $fpdf->SetY($fpdf->GetY());
            $fpdf->SetX(56);
            $fpdf->Image(getLogo(), 13, 9, 20, 20);
            $fpdf->Cell(100, 5, $nama_instansi, 0, 0, "C");
            $fpdf->Cell(55, 5, "", 0, 0);
            $fpdf->Ln(5);
            $fpdf->SetX(56);
            $fpdf->Cell(100, 5, $alamat_instansi_1, 0, 0, "C");
            $fpdf->Cell(55, 5, "", 0, 0);
            $fpdf->Ln(5);
            $fpdf->SetX(56);
            $fpdf->Cell(100, 5, $alamat_instansi_2, 0, 0, "C");
            $fpdf->Cell(55, 5, "", 0, 0);
            $fpdf->Ln(10);
            $fpdf->SetX(10);
            $fpdf->SetFont("Arial", "B", 12);
            $fpdf->Cell(190, 5, "BUKTI RETUR BARANG", 0, 0, "C");
            $fpdf->Ln(5);
            $fpdf->SetX(10);
            $fpdf->SetFont("Arial", "", 12);
            $fpdf->Cell(190, 5, "Unit : " . $unit, 0, 0, "C");
            $fpdf->Ln(10);

            $fpdf->SetX(2);
            $fpdf->Cell(10, 5, "", 0, 0);
            $fpdf->Cell(30, 5, "No. Retur", 0, 0);
            $fpdf->Cell(5, 5, ":", 0, 0, "C");
            $fpdf->Cell(5, 5, ArrayAdapter::format("only-digit8", $row->f_id), 0, 1);
            $fpdf->SetX(2);
            $fpdf->Cell(10, 5, "", 0, 0);
            $fpdf->Cell(30, 5, "Tanggal", 0, 0);
            $fpdf->Cell(5, 5, ":", 0, 0, "C");
            $fpdf->Cell(5, 5, $tanggal, 0, 1);
            $fpdf->SetX(2);
            $fpdf->Cell(10, 5, "", 0, 0);
            $fpdf->Cell(30, 5, "Nama Obat", 0, 0);
            $fpdf->Cell(5, 5, ":", 0, 0, "C");
            $fpdf->Cell(5, 5, $row->nama_obat, 0, 1);
            $fpdf->SetX(2);
            $fpdf->Cell(10, 5, "", 0, 0);
            $fpdf->Cell(30, 5, "Jenis Obat", 0, 0);
            $fpdf->Cell(5, 5, ":", 0, 0, "C");
            $fpdf->Cell(5, 5, $row->nama_jenis_obat, 0, 1);
            $fpdf->SetX(2);
            $fpdf->Cell(10, 5, "", 0, 0);
            $fpdf->Cell(30, 5, "Pridusen", 0, 0);
            $fpdf->Cell(5, 5, ":", 0, 0, "C");
            $fpdf->Cell(5, 5, $row->produsen, 0, 1);
            $fpdf->SetX(2);
            $fpdf->Cell(10, 5, "", 0, 0);
            $fpdf->Cell(30, 5, "Vendor", 0, 0);
            $fpdf->Cell(5, 5, ":", 0, 0, "C");
            $fpdf->Cell(5, 5, $row->nama_vendor, 0, 1);
            $fpdf->SetX(2);
            $fpdf->Cell(10, 5, "", 0, 0);
            $fpdf->Cell(30, 5, "Jumlah", 0, 0);
            $fpdf->Cell(5, 5, ":", 0, 0, "C");
            $fpdf->Cell(5, 5, $row->jumlah . " " . $row->satuan, 0, 1);
            $fpdf->SetX(2);
            $fpdf->Cell(10, 5, "", 0, 0);
            $fpdf->Cell(30, 5, "Tanggal Exp.", 0, 0);
            $fpdf->Cell(5, 5, ":", 0, 0, "C");
            $fpdf->Cell(5, 5, ArrayAdapter::format("date d-m-Y", $row->tanggal_exp), 0, 1);
            $fpdf->SetX(2);
            $fpdf->Cell(10, 5, "", 0, 0);
            $fpdf->Cell(30, 5, "Keterangan", 0, 0);
            $fpdf->Cell(5, 5, ":", 0, 0, "C");
            $fpdf->Cell(5, 5, $row->keterangan, 0, 1);

            global $user;
            $md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
            $filename = "retur_obat_unit.pdf";
            $pathfile = "smis-temp/" . $md5 . $filename;
            $fpdf->Output($pathfile, "F");
            return $pathfile;
        }

        public function save() {
            $data = $this->postToArray();
            global $user;
            $data['username_receiver'] = $user->getName();
            $id['id'] = $_POST['id'];
            $result = $this->dbtable->update($data, $id);
            $success['type'] = "update";
            if (isset($_POST['restok'])) {
                if ($_POST['restok'] == true) {
                    //menambah stok:
                    $retur_data = $this->dbtable->get_row("
                        SELECT *
                        FROM smis_fr_retur_obat_unit
                        WHERE id = '" . $id['id'] . "'
                    ");
                    $stok_keluar_data = $this->dbtable->get_row("
                        SELECT *
                        FROM smis_fr_stok_obat_keluar
                        WHERE id = '" . $retur_data->lf_id . "'
                    ");
                    if ($stok_keluar_data != null) {
                        $stok_data = $this->dbtable->get_row("
                            SELECT a.*, b.id_obat
                            FROM smis_fr_stok_obat a LEFT JOIN smis_fr_dobat_f_masuk b ON a.id_dobat_masuk = b.id
                            WHERE a.id = '" . $stok_keluar_data->id_stok_obat . "'
                        ");
                        $new_stok_data = array();
                        $new_stok_data['sisa'] = $stok_data->sisa + $retur_data->jumlah;
                        $new_stok_data['autonomous'] = "[".getSettings($this->dbtable->get_db(), "smis_autonomous_id", "")."]";
                        $new_stok_data['duplicate'] = 0;
                        $new_stok_data['time_updated'] = date("Y-m-d H:i:s");
                        $new_stok_data['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                        $new_stok_id = array();
                        $new_stok_id['id'] = $stok_keluar_data->id_stok_obat;
                        $stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
                        $stok_dbtable->update($new_stok_data, $new_stok_id);

                        //kartu gudang induk:
                        $ks_data = array();
                        $ks_data['f_id'] = $retur_data->id;
                        $ks_data['unit'] = ArrayAdapter::format("unslug", $retur_data->unit);
                        $ks_data['no_bon'] = $retur_data->id;
                        $ks_data['id_obat'] = $stok_data->id_obat;
                        $ks_data['kode_obat'] = $stok_data->kode_obat;
                        $ks_data['nama_obat'] = $stok_data->nama_obat;
                        $ks_data['nama_jenis_obat'] = $stok_data->nama_jenis_obat;
                        $ks_data['tanggal'] = date("Y-m-d");
                        $ks_data['masuk'] = $retur_data->jumlah;
                        $ks_data['keluar'] = 0;
                        $ks_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_kartu_stok");
                        $ks_row = $ks_dbtable->get_row("
                            SELECT SUM(b.sisa) AS 'jumlah'
                            FROM smis_fr_dobat_f_masuk a LEFT JOIN smis_fr_stok_obat b ON a.id = b.id_dobat_masuk
                            WHERE a.prop NOT LIKE 'del' AND a.id_obat = '" . $stok_data->id_obat . "'
                        ");
                        $ks_data['sisa'] = $ks_row->jumlah;
                        $ks_data['autonomous'] = "[".getSettings($this->dbtable->get_db(), "smis_autonomous_id", "")."]";
                        $ks_data['duplicate'] = 0;
                        $ks_data['time_updated'] = date("Y-m-d H:i:s");
                        $ks_data['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                        $ks_dbtable->insert($ks_data);
                        $id_kartu_stok = $ks_dbtable->get_inserted_id();

                        $ks_data = array();
                        $ks_data['origin_id'] = $id_kartu_stok;
                        $ks_data_id = array();
                        $ks_data_id['id'] = $id_kartu_stok;
                        $ks_dbtable->update($ks_data, $ks_data_id);

                        //logging riwayat stok:
                        $riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_riwayat_stok_obat");
                        $data_riwayat = array();
                        $data_riwayat['tanggal'] = date("Y-m-d");
                        $data_riwayat['id_stok_obat'] = $stok_keluar_data->id_stok_obat;
                        $data_riwayat['jumlah_masuk'] = $retur_data->jumlah;
                        $data_riwayat['sisa'] = $stok_data->sisa + $retur_data->jumlah;
                        $data_riwayat['keterangan'] = "Restok Retur Obat dari Unit " . ArrayAdapter::format("unslug", $retur_data->unit);
                        global $user;
                        $data_riwayat['nama_user'] = $user->getName();
                        $data_riwayat['origin'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                        $data_riwayat['autonomous'] = "[".getSettings($this->dbtable->get_db(), "smis_autonomous_id", "")."]";
                        $data_riwayat['duplicate'] = 0;
                        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
                        $data_riwayat['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                        $riwayat_dbtable->insert($data_riwayat);
                        $id_riwayat_stok = $riwayat_dbtable->get_inserted_id();

                        $data_riwayat = array();
                        $data_riwayat['origin_id'] = $id_riwayat_stok;
                        $data_riwayat_id = array();
                        $data_riwayat_id['id'] = $id_riwayat_stok;
                        $riwayat_dbtable->update($data_riwayat, $data_riwayat_id);
                    } else {
                        // insert dobat masuk:
                        $dobat_f_masuk_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_dobat_f_masuk");
                        $data_dobat_f_masuk = array();
                        $data_dobat_f_masuk['id_obat_f_masuk'] = "0";
                        $data_dobat_f_masuk['id_dpo'] = "-1";
                        $data_dobat_f_masuk['id_obat'] = $retur_data->id_obat;
                        $data_dobat_f_masuk['nama_obat'] = $retur_data->nama_obat;
                        $data_dobat_f_masuk['nama_jenis_obat'] = $retur_data->nama_jenis_obat;
                        $data_dobat_f_masuk['formularium'] = "0";
                        $data_dobat_f_masuk['generik'] = "0";
                        $data_dobat_f_masuk['berlogo'] = "0";
                        $data_dobat_f_masuk['medis'] = "1";
                        $data_dobat_f_masuk['label'] = $retur_data->label;
                        $data_dobat_f_masuk['jumlah'] = $retur_data->jumlah;
                        $data_dobat_f_masuk['sisa'] = 0;
                        $data_dobat_f_masuk['satuan'] = $retur_data->satuan;
                        $data_dobat_f_masuk['konversi'] = $retur_data->konversi;
                        $data_dobat_f_masuk['satuan_konversi'] = $retur_data->satuan_konversi;
                        $data_dobat_f_masuk['hna'] = $retur_data->hna;
                        $data_dobat_f_masuk['selisih'] = 0;
                        $data_dobat_f_masuk['diskon'] = 0;
                        $data_dobat_f_masuk['t_diskon'] = 'persen';
                        $data_dobat_f_masuk['origin'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                        $data_dobat_f_masuk['autonomous'] = "[".getSettings($this->dbtable->get_db(), "smis_autonomous_id", "")."]";
                        $data_dobat_f_masuk['duplicate'] = 0;
                        $data_dobat_f_masuk['time_updated'] = date("Y-m-d H:i:s");
                        $data_dobat_f_masuk['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                        $dobat_f_masuk_dbtable->insert($data_dobat_f_masuk);
                        $id_dobat_f_masuk = $dobat_f_masuk_dbtable->get_inserted_id();

                        $data_dobat_f_masuk = array();
                        $data_dobat_f_masuk['origin_id'] = $id_dobat_f_masuk;
                        $data_dobat_f_masuk_id = array();
                        $data_dobat_f_masuk_id['id'] = $id_dobat_f_masuk;
                        $dobat_f_masuk_dbtable->update($data_dobat_f_masuk, $data_dobat_f_masuk_id);
                        // insert stok obat:
                        $stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
                        $data_stok = array();
                        $data_stok['id_dobat_masuk'] = $id_dobat_f_masuk;
                        $data_stok['nama_obat'] = $retur_data->nama_obat;
                        $data_stok['nama_jenis_obat'] = $retur_data->nama_jenis_obat;
                        $data_stok['formularium'] = "0";
                        $data_stok['berlogo'] = "0";
                        $data_stok['generik'] = "0";
                        $data_stok['label'] = $retur_data->label;
                        $data_stok['id_vendor'] = $retur_data->id_vendor;
                        $data_stok['nama_vendor'] = $retur_data->nama_vendor;
                        $data_stok['jumlah'] = $retur_data->jumlah;
                        $data_stok['sisa'] = $retur_data->jumlah;
                        $data_stok['retur'] = 0;
                        $data_stok['satuan'] = $retur_data->satuan;
                        $data_stok['konversi'] = $retur_data->konversi;
                        $data_stok['satuan_konversi'] = $retur_data->satuan_konversi;
                        $data_stok['hna'] = $retur_data->hna;
                        $data_stok['produsen'] = $retur_data->produsen;
                        $data_stok['tanggal_exp'] = $retur_data->tanggal_exp;
                        $data_stok['no_batch'] = $retur_data->no_batch;
                        $data_stok['turunan'] = 0;
                        $data_stok['origin'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                        $data_stok['autonomous'] = "[".getSettings($this->dbtable->get_db(), "smis_autonomous_id", "")."]";
                        $data_stok['duplicate'] = 0;
                        $data_stok['time_updated'] = date("Y-m-d H:i:s");
                        $data_stok['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                        $stok_dbtable->insert($data_stok);
                        $id_stok_obat = $stok_dbtable->get_inserted_id();

                        $data_stok = array();
                        $data_stok['origin_id'] = $id_stok_obat;
                        $data_stok_id = array();
                        $data_stok_id['id'] = $id_stok_obat;
                        $stok_dbtable->update($data_stok, $data_stok_id);
                        // logging riwayat stok:
                        $riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_riwayat_stok_obat");
                        $data_riwayat = array();
                        $data_riwayat['tanggal'] = date("Y-m-d");
                        $data_riwayat['id_stok_obat'] = $id_stok_obat;
                        $data_riwayat['jumlah_masuk'] = $retur_data->jumlah;
                        $data_riwayat['sisa'] = $retur_data->jumlah;
                        $data_riwayat['keterangan'] = "Restok Retur Obat dari Unit " . ArrayAdapter::format("unslug", $retur_data->unit);
                        global $user;
                        $data_riwayat['nama_user'] = $user->getName();
                        $data_riwayat['origin'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                        $data_riwayat['autonomous'] = "[".getSettings($this->dbtable->get_db(), "smis_autonomous_id", "")."]";
                        $data_riwayat['duplicate'] = 0;
                        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
                        $data_riwayat['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                        $riwayat_dbtable->insert($data_riwayat);
                        $id_riwayat_stok = $riwayat_dbtable->get_inserted_id();

                        $data_riwayat = array();
                        $data_riwayat['origin_id'] = $id_riwayat_stok;
                        $data_riwayat_id = array();
                        $data_riwayat_id['id'] = $id_riwayat_stok;
                        $riwayat_dbtable->update($data_riwayat, $data_riwayat_id);
                        //kartu gudang induk:
                        $ks_data = array();
                        $ks_data['f_id'] = $retur_data->id;
                        $ks_data['unit'] = ArrayAdapter::format("unslug", $retur_data->unit);
                        $ks_data['no_bon'] = $retur_data->id;
                        $ks_data['id_obat'] = $retur_data->id_obat;
                        $ks_data['kode_obat'] = $retur_data->kode_obat;
                        $ks_data['nama_obat'] = $retur_data->nama_obat;
                        $ks_data['nama_jenis_obat'] = $retur_data->nama_jenis_obat;
                        $ks_data['tanggal'] = date("Y-m-d");
                        $ks_data['masuk'] = $retur_data->jumlah;
                        $ks_data['keluar'] = 0;
                        $ks_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_kartu_stok");
                        $ks_row = $ks_dbtable->get_row("
                            SELECT SUM(b.sisa) AS 'jumlah'
                            FROM smis_fr_dobat_f_masuk a LEFT JOIN smis_fr_stok_obat b ON a.id = b.id_dobat_masuk
                            WHERE a.prop NOT LIKE 'del' AND a.id_obat = '" . $retur_data->id_obat . "'
                        ");
                        $ks_data['sisa'] = $ks_row->jumlah;
                        $ks_data['origin'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                        $ks_data['autonomous'] = "[".getSettings($this->dbtable->get_db(), "smis_autonomous_id", "")."]";
                        $ks_data['duplicate'] = 0;
                        $ks_data['time_updated'] = date("Y-m-d H:i:s");
                        $ks_data['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                        $ks_dbtable->insert($ks_data);
                        $id_kartu_stok = $ks_dbtable->get_inserted_id();

                        $ks_data = array();
                        $ks_data['origin_id'] = $id_kartu_stok;
                        $ks_data_id = array();
                        $ks_data_id['id'] = $id_kartu_stok;
                        $ks_dbtable->update($ks_data, $ks_data_id);
                    }
                } else {
                    //mengurangi stok:
                    $retur_data = $this->dbtable->get_row("
                        SELECT *
                        FROM smis_fr_retur_obat_unit
                        WHERE id = '" . $id['id'] . "'
                    ");
                    $stok_keluar_data = $this->dbtable->get_row("
                        SELECT *
                        FROM smis_fr_stok_obat_keluar
                        WHERE id = '" . $retur_data->lf_id . "'
                    ");
                    $stok_data = $this->dbtable->get_row("
                        SELECT *
                        FROM smis_fr_stok_obat
                        WHERE id = '" . $stok_keluar_data->id_stok_obat . "'
                    ");
                    $new_stok_data = array();
                    $new_stok_data['sisa'] = $stok_data->sisa - $retur_data->jumlah;
                    $new_stok_data['autonomous'] = "[".getSettings($this->dbtable->get_db(), "smis_autonomous_id", "")."]";
                    $new_stok_data['duplicate'] = 0;
                    $new_stok_data['time_updated'] = date("Y-m-d H:i:s");
                    $new_stok_data['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                    $new_stok_id = array();
                    $new_stok_id['id'] = $stok_keluar_data->id_stok_obat;
                    $stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
                    $stok_dbtable->update($new_stok_data, $new_stok_id);
                    //logging riwayat stok:
                    $riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_riwayat_stok_obat");
                    $data_riwayat = array();
                    $data_riwayat['tanggal'] = date("Y-m-d");
                    $data_riwayat['id_stok_obat'] = $stok_keluar_data->id_stok_obat;
                    $data_riwayat['jumlah_keluar'] = $retur_data->jumlah;
                    $data_riwayat['sisa'] = $stok_data->sisa - $retur_data->jumlah;
                    $data_riwayat['keterangan'] = "Pembatalan Restok Retur Obat dari Unit " . ArrayAdapter::format("unslug", $retur_data->unit);
                    $data_riwayat['origin'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                    $data_riwayat['autonomous'] = "[".getSettings($this->dbtable->get_db(), "smis_autonomous_id", "")."]";
                    $data_riwayat['duplicate'] = 0;
                    $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
                    $data_riwayat['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                    global $user;
                    $data_riwayat['nama_user'] = $user->getName();
                    $riwayat_dbtable->insert($data_riwayat);
                    $id_riwayat_stok = $riwayat_dbtable->get_inserted_id();

                    $data_riwayat = array();
                    $data_riwayat['origin_id'] = $id_riwayat_stok;
                    $data_riwayat_id = array();
                    $data_riwayat_id['id'] = $id_riwayat_stok;
                    $riwayat_dbtable->update($data_riwayat, $data_riwayat_id);
                    //kartu gudang induk:
                    $ks_data = array();
                    $ks_data['f_id'] = $retur_data->id;
                    $ks_data['unit'] = ArrayAdapter::format("unslug", $retur_data->unit);
                    $ks_data['no_bon'] = $retur_data->id;
                    $ks_data['id_obat'] = $retur_data->id_obat;
                    $ks_data['kode_obat'] = $retur_data->kode_obat;
                    $ks_data['nama_obat'] = $retur_data->nama_obat;
                    $ks_data['nama_jenis_obat'] = $retur_data->nama_jenis_obat;
                    $ks_data['tanggal'] = date("Y-m-d");
                    $ks_data['masuk'] = 0;
                    $ks_data['keluar'] = $retur_data->jumlah;
                    $ks_data['origin'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                    $ks_data['autonomous'] = "[".getSettings($this->dbtable->get_db(), "smis_autonomous_id", "")."]";
                    $ks_data['duplicate'] = 0;
                    $ks_data['time_updated'] = date("Y-m-d H:i:s");
                    $ks_data['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
                    $ks_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_kartu_stok");
                    $ks_row = $ks_dbtable->get_row("
                        SELECT SUM(b.sisa) AS 'jumlah'
                        FROM smis_fr_dobat_f_masuk a LEFT JOIN smis_fr_stok_obat b ON a.id = b.id_dobat_masuk
                        WHERE a.prop NOT LIKE 'del' AND a.id_obat = '" . $retur_data->id_obat . "'
                    ");
                    $ks_data['sisa'] = $ks_row->jumlah;
                    $ks_dbtable->insert($ks_data);
                    $id_kartu_stok = $ks_dbtable->get_inserted_id();

                    $ks_data = array();
                    $ks_data['origin_id'] = $id_kartu_stok;
                    $ks_data_id = array();
                    $ks_data_id['id'] = $id_kartu_stok;
                    $ks_dbtable->update($ks_data, $ks_data_id);
                }
            }
            $success['id'] = $id['id'];
            $success['success'] = 1;
            if ($result === false) $success['success'] = 0;
            return $success;
        }
    }
?>