<?php
	class ReturKeluarNonFakturBatchDBResponder extends DBResponder {
		private $message;

		public function command($command) {
			if ($command != "save") {
				return parent::command($command);
			}
			$response_package = new ResponsePackage();
			if ($command == "save") {
				$content = $this->save();
				$response_package->setContent($content);
				$response_package->setStatus(ResponsePackage::$STATUS_OK);
				if ($content['success'] == 1) {
					$response_package->setAlertVisible(true);
					$response_package->setAlertContent("Data Saved", "Your Data Had Been Saved", ResponsePackage::$TIPE_INFO);
				} else {
					$response_package->setAlertVisible(false);
				}
			}
			return $response_package->getPackage();
		}

		public function save() {
			$id['id'] = $_POST['id'];
			$success = false;
			$response = array();
			$this->message = "";
			$db = $this->dbtable->get_db();
			$db->set_autocommit(false);
			$db->begin_transaction();
			if ($id['id'] == "") {
				// Insert Header :
				$result = $this->dbtable->insert([
					'tanggal' 			=> $_POST['tanggal'],
					'id_vendor' 		=> $_POST['id_vendor'],
					'nama_vendor' 		=> $_POST['nama_vendor'],
					'no_faktur' 		=> $_POST['no_faktur'],
					'tanggal_faktur' 	=> $_POST['tanggal_faktur'],
					'keterangan' 		=> $_POST['keterangan']
				]);
				if ($result === false) {
					$this->message .= "<br/>Retur Pembelian Gagal Disimpan";
					$success = false;
				} else {
					$id['id'] = $this->dbtable->get_inserted_id();
					$response['type'] = "insert";
					if (isset($_POST['detail'])) {
						$success = $this->saveDetail($id);
					}
				}
			} else {
				// Update Header :
				$result = $this->dbtable->update([
					'dibatalkan' => $_POST['dibatalkan']
				], $id);
				if ($result === false) {
					$success = false;
					$this->message .= "<br/>Pembatalan Retur Pembelian Gagal Disimpan";
				} else {
					$response['type'] = "update";
					$success = $this->cancelDetail($id);
				}
			}
			if ($success) {
				$db->commit();
			} else {
				$db->rollback();
			}
			$db->set_autocommit(true);
			$response['id'] = $id['id'];
			$response['message'] = $this->message;
			$response['success'] = 1;
			if ($success === false) {
				$response['success'] = 0;
			}
			return $response;
		}

		private function saveDetail($id) {
			$success = true;
			$detail_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_d_retur_obat_non_faktur");
			$stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
			$riwayat_stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_riwayat_stok_obat");
			$kartu_stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_kartu_stok");

			$detail = $_POST['detail'];
			foreach ($detail as $d) {
				if ($d['id'] == "") {
					/// Insert Detail :
					$result = $detail_dbtable->insert([
						'id_h_retur_obat_non_faktur' 	=> $id['id'],
						'id_stok_obat' 					=> $d['id_stok_obat'],
						'jumlah'						=> $d['jumlah']
					]);
					if ($result === false) {
						$success = false;
						$this->message .= "<br/>" . $d['nama_obat'] . " Gagal Disimpan Sebagai Detail";
						continue;
					}

					$sisa_stok = $stok_dbtable->get_var("
						SELECT
							sisa
						FROM
							smis_fr_stok_obat
						WHERE
							id = '" . $d['id_stok_obat'] . "'
					");
					if ($sisa_stok != null && $sisa_stok != 0) {
						if ($d['jumlah'] > $sisa_stok) {
							$success = false;
							$this->message .= "<br/>" . $d['nama_obat'] . " Tidak Memiliki Cukup Stok (Sisa : " . $sisa_stok . ", Jumlah Retur : " . $d['jumlah'] . ")";
							continue;	
						}
						/// Update Stok :
						$result = $stok_dbtable->update([
							'sisa' => $sisa_stok - $d['jumlah']
						], [
							'id' => $d['id_stok_obat']
						]);
						if ($result === false) {
							$success = false;
							$this->message .= "<br/>" . $d['nama_obat'] . " Gagal Memperbarui Data Stok";
							continue;		
						}

						/// Riwayat Stok :
						global $user;
						$result = $riwayat_stok_dbtable->insert([
							'tanggal' 		=> date("Y-m-d"),
							'id_stok_obat'	=> $d['id_stok_obat'],
							'jumlah_masuk'	=> 0,
							'jumlah_keluar'	=> $d['jumlah'],
							'sisa'			=> $sisa_stok - $d['jumlah'],
							'keterangan'	=> "Retur Pembelian Non-Faktur ID : " . $id['id'],
							'nama_user'		=> $user->getName()
						]);
						if ($result === false) {
							$success = false;
							$this->message .= "<br/>" . $d['nama_obat'] . " Gagal Menyimpan Riwayat Stok Obat";
							continue;		
						}

						/// Kartu Stok :
						$stok_row = $stok_dbtable->get_row("
							SELECT
								a.*, b.id_obat
							FROM
								smis_fr_stok_obat a
									INNER JOIN smis_fr_dobat_f_masuk b ON a.id_dobat_masuk = b.id
							WHERE
								a.id = '" . $d['id_stok_obat'] . "'
						");
						$rekap_sisa_stok = $stok_dbtable->get_var("
							SELECT
								SUM(a.sisa) sisa
							FROM
								smis_fr_stok_obat a
									INNER JOIN smis_fr_dobat_f_masuk b ON a.id_dobat_masuk = b.id
							WHERE
								b.id_obat = '" . $stok_row->id_obat . "'	
						");
						$result = $kartu_stok_dbtable->insert([
							'f_id' 				=> $id['id'],
							'no_bon' 			=> "Retur Pembelian Non-Faktur",
							'unit' 				=> "Gudang Farmasi",
							'id_obat'			=> $stok_row->id_obat,
							'kode_obat'			=> $stok_row->kode_obat,
							'nama_obat'			=> $stok_row->nama_obat,
							'nama_jenis_obat'	=> $stok_row->nama_jenis_obat,
							'tanggal'			=> date("Y-m-d"),
							'masuk'				=> 0,
							'keluar'			=> $d['jumlah'],
							'sisa'				=> $rekap_sisa_stok
						]);
						if ($result === false) {
							$success = false;
							$this->message .= "<br/>" . $d['nama_obat'] . " Gagal Menyimpan Kartu Stok Obat";
							continue;		
						}
					} else {
						$success = false;
						$this->message .= "<br/>" . $d['nama_obat'] . " Tidak Memiliki Stok (Sisa : " . $sisa_stok . ")";
						continue;
					}
				} else {
					/// Update Detail :
					$result = $detail_dbtable->update([
						'id_h_retur_obat_non_faktur' 	=> $id['id'],
						'id_stok_obat' 					=> $d['id_stok_obat'],
						'jumlah'						=> $d['jumlah'],
						'prop'							=> $d['prop']
					], [
						'id' => $d['id']
					]);
					if ($result === false) {
						$success = false;
						$this->message .= "<br/>" . $d['nama_obat'] . " Gagal Diperbarui Sebagai Detail";
						continue;	 
					}

					$jumlah_masuk = 0;
					$jumlah_keluar = 0;
					if ($d['jumlah_lama'] > $d['jumlah']) {
						$jumlah_masuk = $d['jumlah_lama'] - $d['jumlah'];
					} else {
						$jumlah_keluar = $d['jumlah'] - $d['jumlah_lama'];
					}

					$sisa_stok = $stok_dbtable->get_var("
						SELECT
							sisa
						FROM
							smis_fr_stok_obat
						WHERE
							id = '" . $d['id_stok_obat'] . "'
					");
					
					if ($jumlah_keluar > 0) {
						if ($sisa_stok != null && $sisa_stok != 0) {
							if ($jumlah_keluar > $sisa_stok) {
								$success = false;
								$this->message .= "<br/>" . $d['nama_obat'] . " Tidak Memiliki Cukup Stok (Sisa : " . $sisa_stok . ", Selisih Jumlah Retur : " . $jumlah_keluar . ")";
								continue;	
							}
							/// Update Stok :
							$result = $stok_dbtable->update([
								'sisa' => $sisa_stok - $jumlah_keluar
							], [
								'id' => $d['id_stok_obat']
							]);
							if ($result === false) {
								$success = false;
								$this->message .= "<br/>" . $d['nama_obat'] . " Gagal Memperbarui Data Stok";
								continue;		
							}

							/// Riwayat Stok :
							global $user;
							$result = $riwayat_stok_dbtable->insert([
								'tanggal' 		=> date("Y-m-d"),
								'id_stok_obat'	=> $d['id_stok_obat'],
								'jumlah_masuk'	=> 0,
								'jumlah_keluar'	=> $jumlah_keluar,
								'sisa'			=> $sisa_stok - $jumlah_keluar,
								'keterangan'	=> "Retur Pembelian Non-Faktur ID : " . $id['id'],
								'nama_user'		=> $user->getName()
							]);
							if ($result === false) {
								$success = false;
								$this->message .= "<br/>" . $d['nama_obat'] . " Gagal Menyimpan Riwayat Stok Obat";
								continue;		
							}

							/// Kartu Stok :
							$stok_row = $stok_dbtable->get_row("
								SELECT
									a.*, b.id_obat
								FROM
									smis_fr_stok_obat a
										INNER JOIN smis_fr_dobat_f_masuk b ON a.id_dobat_masuk = b.id
								WHERE
									a.id = '" . $d['id_stok_obat'] . "'
							");
							$rekap_sisa_stok = $stok_dbtable->get_var("
								SELECT
									SUM(a.sisa) sisa
								FROM
									smis_fr_stok_obat a
										INNER JOIN smis_fr_dobat_f_masuk b ON a.id_dobat_masuk = b.id
								WHERE
									b.id_obat = '" . $stok_row->id_obat . "'	
							");
							$result = $kartu_stok_dbtable->insert([
								'f_id' 				=> $id['id'],
								'no_bon' 			=> "Retur Pembelian Non-Faktur",
								'unit' 				=> "Gudang Farmasi",
								'id_obat'			=> $stok_row->id_obat,
								'kode_obat'			=> $stok_row->kode_obat,
								'nama_obat'			=> $stok_row->nama_obat,
								'nama_jenis_obat'	=> $stok_row->nama_jenis_obat,
								'tanggal'			=> date("Y-m-d"),
								'masuk'				=> 0,
								'keluar'			=> $jumlah_keluar,
								'sisa'				=> $rekap_sisa_stok
							]);
							if ($result === false) {
								$success = false;
								$this->message .= "<br/>" . $d['nama_obat'] . " Gagal Menyimpan Kartu Stok Obat";
								continue;		
							}
						} else {
							$success = false;
							$this->message .= "<br/>" . $d['nama_obat'] . " Tidak Memiliki Stok (Sisa : " . $sisa_stok . ")";
							continue;
						}
					} else if ($jumlah_masuk > 0) {
						/// Update Stok :
						$result = $stok_dbtable->update([
							'sisa' => $sisa_stok + $jumlah_masuk
						], [
							'id' => $d['id_stok_obat']
						]);
						if ($result === false) {
							$success = false;
							$this->message .= "<br/>" . $d['nama_obat'] . " Gagal Memperbarui Data Stok";
							continue;		
						}

						/// Riwayat Stok :
						global $user;
						$result = $riwayat_stok_dbtable->insert([
							'tanggal' 		=> date("Y-m-d"),
							'id_stok_obat'	=> $d['id_stok_obat'],
							'jumlah_masuk'	=> $jumlah_masuk,
							'jumlah_keluar'	=> 0,
							'sisa'			=> $sisa_stok + $jumlah_masuk,
							'keterangan'	=> "Retur Pembelian Non-Faktur ID : " . $id['id'],
							'nama_user'		=> $user->getName()
						]);
						if ($result === false) {
							$success = false;
							$this->message .= "<br/>" . $d['nama_obat'] . " Gagal Menyimpan Riwayat Stok Obat";
							continue;		
						}

						/// Kartu Stok :
						$stok_row = $stok_dbtable->get_row("
							SELECT
								a.*, b.id_obat
							FROM
								smis_fr_stok_obat a
									INNER JOIN smis_fr_dobat_f_masuk b ON a.id_dobat_masuk = b.id
							WHERE
								a.id = '" . $d['id_stok_obat'] . "'
						");
						$rekap_sisa_stok = $stok_dbtable->get_var("
							SELECT
								SUM(a.sisa) sisa
							FROM
								smis_fr_stok_obat a
									INNER JOIN smis_fr_dobat_f_masuk b ON a.id_dobat_masuk = b.id
							WHERE
								b.id_obat = '" . $stok_row->id_obat . "'	
						");
						$result = $kartu_stok_dbtable->insert([
							'f_id' 				=> $id['id'],
							'no_bon' 			=> "Retur Pembelian Non-Faktur",
							'unit' 				=> "Gudang Farmasi",
							'id_obat'			=> $stok_row->id_obat,
							'kode_obat'			=> $stok_row->kode_obat,
							'nama_obat'			=> $stok_row->nama_obat,
							'nama_jenis_obat'	=> $stok_row->nama_jenis_obat,
							'tanggal'			=> date("Y-m-d"),
							'masuk'				=> $jumlah_masuk,
							'keluar'			=> 0,
							'sisa'				=> $rekap_sisa_stok
						]);
						if ($result === false) {
							$success = false;
							$this->message .= "<br/>" . $d['nama_obat'] . " Gagal Menyimpan Kartu Stok Obat";
							continue;		
						}
					}
				}
			}

			return $success;
		}	

		private function cancelDetail($id) {
			$success = true;
			$detail_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_d_retur_obat_non_faktur");
			$stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
			$riwayat_stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_riwayat_stok_obat");
			$kartu_stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_kartu_stok");

			$detail = $detail_dbtable->get_result("
				SELECT
					*
				FROM
					smis_fr_d_retur_obat_non_faktur
				WHERE
					prop LIKE ''
						AND id_h_retur_obat_non_faktur = '" . $id['id'] . "'
			");

			if ($detail != null) {
				foreach ($detail as $d) {
					$sisa_stok = $stok_dbtable->get_var("
						SELECT
							sisa
						FROM
							smis_fr_stok_obat
						WHERE
							id = '" . $d->id_stok_obat . "'
					");
					$nama_obat = $stok_dbtable->get_var("
						SELECT
							nama_obat
						FROM
							smis_fr_stok_obat
						WHERE
							id = '" . $d->id_stok_obat . "'
					");

					/// Update Stok :
					$result = $stok_dbtable->update([
						'sisa' => $sisa_stok + $d->jumlah
					], [
						'id' => $d->id_stok_obat
					]);
					if ($result === false) {
						$success = false;
						$this->message .= "<br/>" . $nama_obat . " Gagal Memperbarui Data Stok";
						continue;		
					}

					/// Riwayat Stok :
					global $user;
					$result = $riwayat_stok_dbtable->insert([
						'tanggal' 		=> date("Y-m-d"),
						'id_stok_obat'	=> $d->id_stok_obat,
						'jumlah_masuk'	=> $d->jumlah,
						'jumlah_keluar'	=> 0,
						'sisa'			=> $sisa_stok + $d->jumlah,
						'keterangan'	=> "Pembatalan Retur Pembelian Non-Faktur ID : " . $id['id'],
						'nama_user'		=> $user->getName()
					]);
					if ($result === false) {
						$success = false;
						$this->message .= "<br/>" . $nama_obat . " Gagal Menyimpan Riwayat Stok Obat";
						continue;		
					}

					/// Kartu Stok :
					$stok_row = $stok_dbtable->get_row("
						SELECT
							a.*, b.id_obat
						FROM
							smis_fr_stok_obat a
								INNER JOIN smis_fr_dobat_f_masuk b ON a.id_dobat_masuk = b.id
						WHERE
							a.id = '" . $d->id_stok_obat . "'
					");
					$rekap_sisa_stok = $stok_dbtable->get_var("
						SELECT
							SUM(a.sisa) sisa
						FROM
							smis_fr_stok_obat a
								INNER JOIN smis_fr_dobat_f_masuk b ON a.id_dobat_masuk = b.id
						WHERE
							b.id_obat = '" . $stok_row->id_obat . "'	
					");
					$result = $kartu_stok_dbtable->insert([
						'f_id' 				=> $id['id'],
						'no_bon' 			=> "Pembatalan Retur Pembelian Non-Faktur",
						'unit' 				=> "Gudang Farmasi",
						'id_obat'			=> $stok_row->id_obat,
						'kode_obat'			=> $stok_row->kode_obat,
						'nama_obat'			=> $stok_row->nama_obat,
						'nama_jenis_obat'	=> $stok_row->nama_jenis_obat,
						'tanggal'			=> date("Y-m-d"),
						'masuk'				=> $d->jumlah,
						'keluar'			=> 0,
						'sisa'				=> $rekap_sisa_stok
					]);
					if ($result === false) {
						$success = false;
						$this->message .= "<br/>" . $nama_obat . " Gagal Menyimpan Kartu Stok Obat";
						continue;		
					}
				}
			}

			return $success;
		}
	}
?>