<?php
require_once("smis-base/smis-include-duplicate.php");

class ObatKeluarDBResponder extends DuplicateResponder {
    protected $message_failure;
    
    public function addMessage($msg,$hidden_tbl_name=""){
		$this->message_failure.="<li data-stable='".$hidden_tbl_name."' >".$msg."</li>";
	}
	public function getMessage(){
		return "<ul>".$this->message_failure."</ul>";
	}
    
	public function command($command) {
		if ($command != "print_mutasi" && $command != "restock" && $command != "export_pdf")
			return parent::command($command);
		$pack = new ResponsePackage();
		if ($command == "print_mutasi") {
			$content = $this->print_mutasi();
			$pack->setContent($content);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
		} else if ($command == "restock") {
			$content = $this->restock();
			$pack->setContent($content);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
		}
		if ($command == "export_pdf") {
			$content = $this->export_pdf();
			$pack->setContent($content);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
		}
		return $pack->getPackage();
	}
	private function export_pdf() {
		$id = $_POST['id'];
		
		$header_row = $this->dbtable->get_db()->get_row("
			SELECT *
			FROM smis_fr_obat_keluar
			WHERE id = '" . $id . "'
		");

		$nama_instansi = "KLINIK CASA MEDICAL PANBIL";
		$alamat_instansi_1 = "Komp. Panbil Komersil Area Blok A";
		$alamat_instansi_2 = "No. 3A Kelurahan Muka Kuning";
		$no_izin_instansi = getSettings($this->dbtable->get_db(), "instansi_no_ijin", "");

		$nomor = $header_row->nomor;
		$tanggal = ArrayAdapter::format("date d-m-Y", $header_row->tanggal);
		$unit = ArrayAdapter::format("unslug", $header_row->unit);

		$manager_umum = getSettings($this->dbtable->get_db(), "mutasi-nama_manager_umum", "");		
		$verifikator = getSettings($this->dbtable->get_db(), "mutasi-nama_verifikator", "");
		global $user;
		$petugas_gudang = $user->getNameOnly(); // getSettings($this->dbtable->get_db(), "mutasi-nama_petugas_gudang", "");

		$margin_left = 10;
		$margin_top = 10;
		$total = 0;
		$jumlah_item = 0;
		$jumlah_item_per_halaman = getSettings($this->dbtable->get_db(), "mutasi-n_item_per_page", 13);
		$jumlah_detail_row = $this->dbtable->get_db()->get_row("
			SELECT COUNT(*) jumlah
			FROM smis_fr_dobat_keluar
			WHERE id_obat_keluar = '" . $id . "' AND prop = ''
		");
		if ($jumlah_detail_row != null)
			$jumlah_item += $jumlah_detail_row->jumlah;
		$jumlah_halaman = $jumlah_item % $jumlah_item_per_halaman == 0 ? $jumlah_item / $jumlah_item_per_halaman : floor($jumlah_item / $jumlah_item_per_halaman) + 1;

		require_once("smis-libs-out/fpdf/fpdf.php");
		$fpdf = new FPDF("P", "mm", "A4");
		$fpdf->SetMargins($margin_left, $margin_top);

		$fpdf->AddPage();
		$fpdf->SetFont("Arial", "", 12);
		$fpdf->SetY($fpdf->GetY());
		$fpdf->SetX(56);
		$fpdf->Image(getLogo(), 13, 9, 20, 20);
		$fpdf->Cell(70, 5, $nama_instansi, 0, 0, "C");
		$fpdf->Cell(25, 5, "", 0, 0);
		$fpdf->Cell(20, 5, "Nomor", 0, 0);
		$fpdf->Cell(40, 5, ": " . $nomor, 0, 0);
		$fpdf->Ln(5);
		$fpdf->SetX(56);
		$fpdf->Cell(70, 5, $alamat_instansi_1, 0, 0, "C");
		$fpdf->Cell(25, 5, "", 0, 0);
		$fpdf->Cell(20, 5, "Tanggal", 0, 0);
		$fpdf->Cell(40, 5, ": " . $tanggal, 0, 0);
		$fpdf->Ln(5);
		$fpdf->SetX(56);
		$fpdf->Cell(70, 5, $alamat_instansi_2, 0, 0, "C");
		$fpdf->Cell(25, 5, "", 0, 0);
		$fpdf->Cell(20, 5, "", 0, 0);
		$fpdf->Cell(40, 5, "", 0, 0);
		$fpdf->Ln(10);
		$fpdf->SetX(10);
		$fpdf->SetFont("Arial", "B", 12);
		$fpdf->Cell(190, 5, "BUKTI PENGELUARAN BARANG / BAHAN PELENGKAP", 0, 0, "C");
		$fpdf->Ln(5);
		$fpdf->SetX(10);
		$fpdf->SetFont("Arial", "", 12);
		$fpdf->Cell(190, 5, "Unit : " . $unit, 0, 0, "C");
		$fpdf->Ln(10);
		$last_y = $fpdf->GetY();

		$fpdf->SetX(2);
		$fpdf->Cell(24, 10, "Kode", 1, 0, "C");
		$fpdf->Cell(72, 10, "Nama Barang", 1, 0, "C");
		$fpdf->Cell(10, 10, "Sat.", 1, 0, "C");
		$fpdf->Cell(15, 10, "", 0, 0, "C");
		$fpdf->Cell(15, 10, "", 0, 0, "C");
		$fpdf->Cell(15, 10, "", 0, 0, "C");
		$fpdf->Cell(15, 10, "", 0, 0, "C");
		$fpdf->Cell(25, 10, "", 0, 0, "C");
		$fpdf->Cell(15, 10, "", 0, 0, "C");
		$fpdf->Ln(10);
		$fpdf->SetX(2);
		$fpdf->Cell(24, 5, "1", 1, 0, "C");
		$fpdf->Cell(72, 5, "2", 1, 0, "C");
		$fpdf->Cell(10, 5, "3", 1, 0, "C");
		$fpdf->Cell(15, 5, "4", 1, 0, "C");
		$fpdf->Cell(15, 5, "5", 1, 0, "C");
		$fpdf->Cell(15, 5, "6", 1, 0, "C");
		$fpdf->Cell(15, 5, "7", 1, 0, "C");
		$fpdf->Cell(25, 5, "8", 1, 0, "C");
		$fpdf->Cell(15, 5, "9", 1, 0, "C");
		$fpdf->SetY($last_y);
		$fpdf->SetX(2);
		$fpdf->Cell(24, 5, "", 0, 0, "C");
		$fpdf->Cell(72, 5, "", 0, 0, "C");
		$fpdf->Cell(10, 5, "", 0, 0, "C");
		$fpdf->Cell(60, 5, "Banyaknya", 1, 0, "C");
		$fpdf->Cell(40, 5, "Nilai", 1, 0, "C");
		$fpdf->Ln(4.8);
		$fpdf->SetX(2);
		$fpdf->Cell(24, 5, "", 0, 0, "C");
		$fpdf->Cell(72, 5, "", 0, 0, "C");
		$fpdf->Cell(10, 5, "", 0, 0, "C");
		$fpdf->Cell(15, 5, "Stok", 1, 0, "C");
		$fpdf->Cell(15, 5, "Diminta", 1, 0, "C");
		$fpdf->Cell(15, 5, "Keluar", 1, 0, "C");
		$fpdf->Cell(15, 5, "Setuju", 1, 0, "C");
		$fpdf->Cell(25, 5, "Harga", 1, 0, "C");
		$fpdf->Cell(15, 5, "Jml.", 1, 0, "C");
		$fpdf->Ln(10.5);

		$detail_rows = $this->dbtable->get_db()->get_result("
			SELECT *
			FROM smis_fr_dobat_keluar
			WHERE id_obat_keluar = '" . $id . "' AND prop = ''
		");

		if ($detail_rows != null) {
			foreach ($detail_rows as $detail_row) {
				$fpdf->SetX(2);
				$fpdf->Cell(24, 5, substr($detail_row->kode_obat, 0, 9), 1, 0);
				$fpdf->Cell(72, 5, substr($detail_row->nama_obat, 0, 33), 1, 0);
				$fpdf->Cell(10, 5, substr($detail_row->satuan, 0, 4), 1, 0);
				$fpdf->Cell(15, 5, $detail_row->stok_entri, 1, 0, "R");
				$fpdf->Cell(15, 5, $detail_row->jumlah_diminta, 1, 0, "R");
				$fpdf->Cell(15, 5, $detail_row->jumlah, 1, 0, "R");
				$fpdf->Cell(15, 5, $detail_row->jumlah, 1, 0, "R");
				$fpdf->Cell(25, 5, number_format($detail_row->harga_ma, 2, ',', '.'), 1, 0, "R");
				$fpdf->Cell(15, 5, "", 1, 1, "R");
				$stok_keluar_rows = $this->dbtable->get_db()->get_result("
					SELECT SUM(a.jumlah) jumlah, CASE WHEN b.tanggal_exp = '0000-00-00' THEN 'N/A' ELSE b.tanggal_exp END tanggal_exp, b.no_batch
					FROM smis_fr_stok_obat_keluar a INNER JOIN smis_fr_stok_obat b ON a.id_stok_obat = b.id
					WHERE a.id_dobat_keluar = '" . $detail_row->id . "' AND a.prop = ''
					GROUP BY tanggal_exp, no_batch
				");
				if ($stok_keluar_rows != null) {
					foreach ($stok_keluar_rows as $sk) {
						$fpdf->SetX(2);
						$fpdf->Cell(24, 5, "", 1, 0);
						$fpdf->Cell(72, 5, "", 1, 0);
						$fpdf->Cell(55, 5, "NB : " . $sk->no_batch, 1, 0);
						$ed = $sk->tanggal_exp == 'N/A' ? "N/A" : ArrayAdapter::format("date d-m-Y", $sk->tanggal_exp);
						$fpdf->Cell(40, 5, "ED : " . $ed, 1, 0);
						$fpdf->Cell(15, 5, $sk->jumlah, 1, 1, "R");
					}
				}
			}
		}
		$fpdf->SetX(2);
		$last_x = $fpdf->GetX();
		$last_y = $fpdf->GetY();
		$fpdf->Cell(206, 25, "", 1, 1, "C");
		$fpdf->SetX($last_x);
		$fpdf->SetY($last_y);
		
		$footer_sentence_1 = "Diperiksa oleh,";
		$footer_sentence_2 = "Dikeluarkan oleh,";
		$footer_sentence_3 = "Diterima oleh,";
		$footer_title_1 = "Verifikator,";
		$footer_title_2 = "Petugas Gudang";
		$footer_title_3 = "Apoteker/Asisten Apoteker";
		$footer_pic_1 = "(" . $verifikator . ")";
		$footer_pic_2 = "(" . $petugas_gudang . ")";
		$footer_pic_3 = "(__________________)";

		$fpdf->SetX(2);
		$fpdf->Cell(60, 5, $footer_sentence_1, 0, 0, "C");
		$fpdf->Cell(19, 5, "", 0, 0, "C");
		$fpdf->Cell(50, 5, $footer_sentence_2, 0, 0, "C");
		$fpdf->Cell(19, 5, "", 0, 0, "C");
		$fpdf->Cell(50, 5, $footer_sentence_3, 0, 1, "C");
		$fpdf->SetX(2);
		$fpdf->Cell(60, 5, $footer_title_1, 0, 0, "C");
		$fpdf->Cell(19, 5, "", 0, 0, "C");
		$fpdf->Cell(50, 5, $footer_title_2, 0, 0, "C");
		$fpdf->Cell(19, 5, "", 0, 0, "C");
		$fpdf->Cell(50, 5, $footer_title_3, 0, 1, "C");
		$fpdf->SetX(2);
		$fpdf->Cell(177, 10, "", 0, 1, "C");
		$fpdf->SetX(2);
		$fpdf->Cell(60, 5, $footer_pic_1, 0, 0, "C");
		$fpdf->Cell(19, 5, "", 0, 0, "C");
		$fpdf->Cell(50, 5, $footer_pic_2, 0, 0, "C");
		$fpdf->Cell(19, 5, "", 0, 0, "C");
		$fpdf->Cell(50, 5, $footer_pic_3, 0, 1, "C");

		global $user;
	    $md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
		$filename = "mutasi_" . $unit . ".pdf";
		$pathfile = "smis-temp/" . $md5 . $filename;
		$fpdf->Output($pathfile, "F");
		return $pathfile;
	}
	public function print_mutasi() {
		$id = $_POST['id'];
		$status = $_POST['status'];
		$row_header = $this->dbtable->get_row("
			SELECT *
			FROM smis_fr_obat_keluar
			WHERE id = '" . $id . "'
		");
		$rows_detail = $this->dbtable->get_result("
			SELECT smis_fr_stok_obat.nama_obat, smis_fr_stok_obat.kode_obat, smis_fr_stok_obat.satuan, smis_fr_stok_obat.tanggal_exp, smis_fr_stok_obat_keluar.jumlah, smis_fr_stok_obat.hna
			FROM (smis_fr_stok_obat_keluar LEFT JOIN smis_fr_dobat_keluar ON smis_fr_stok_obat_keluar.id_dobat_keluar = smis_fr_dobat_keluar.id) LEFT JOIN smis_fr_stok_obat ON smis_fr_stok_obat_keluar.id_stok_obat = smis_fr_stok_obat.id
			WHERE smis_fr_dobat_keluar.id_obat_keluar = '" . $id . "'
		");
		$print_data .= "<table width='100%' border='1'>
							<tr>
								<th width='35%' colspan='2'>
									<center>
										GUDANG FARMASI</br>
										</br>
										&nbsp;
									</center>
								</th>
								<th width='35%' colspan='2'>
									<center>
										BUKTI KELUAR</br>
										(Surat Pengantar)</br>
										Ke: " . ArrayAdapter::format("unslug", $row_header->unit) . "
									</center>
								</th>
								<th width='30%' colspan='2'>
									<table border='0'>
										<tr>
											<td>Bon</td>
											<td>:</td>
											<td>" . ArrayAdapter::format("digit8",  $row_header->id) . "</td>	
										</tr>
										<tr>
											<td>Tgl</td>
											<td>:</td>
											<td>" . ArrayAdapter::format("date d/m/Y", $row_header->tanggal) . "</td>
										</tr>
										<tr>
											<td colspan='3'>&nbsp;</td>
										</tr>
									</table>
								</th>
							</tr>
							<tr>
								<th>NAMA OBAT</th>
								<th>KODE OBAT</th>
								<th>SAT</th>
								<th>TGL. EXPIRED</th>
								<th>JUMLAH</th>
								<th>HARGA</th>
							</tr>";
		if (count($rows_detail) > 0) {
			foreach($rows_detail as $d) {
				$prefix_kode_obat = substr($d->kode_obat, 0, 3);
				$kode_obat = substr($d->kode_obat, 4);
				if ($prefix_kode_obat == "REG")
					$kode_obat = "309." . $kode_obat;
				else if ($prefix_kode_obat == "JKN")
					$kode_obat = "319." . $kode_obat;
				$print_data .= "<tr>
									<td>" . $d->nama_obat . "</td>
									<td>" . $kode_obat . "</td>
									<td>" . $d->satuan . "</td>
									<td>" . ArrayAdapter::format("date d/m/Y", $d->tanggal_exp) . "</td>
									<td>" . ArrayAdapter::format("number", $d->jumlah) . "</td>
									<td>" . ArrayAdapter::format("money Rp. ", $d->hna) . "</td>
								</tr>";
			}
		} else {
			$print_data .= "<tr>
								<td colspan='6' align='center'><i>Tidak terdapat data detail mutasi obat</i></td>
							</tr>";
		}
		$print_data .= "</table>";
		$print_data .= "<br/>";
		$print_data .= "<table border='0' class='united' width='100%'>
							<tr>
								<td align='center'>Gudang Obat</td>
								<td>&Tab;</td>
								<td align='center'>Penerima</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
								<td>&Tab;</td>
								<td>&nbsp;</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
								<td>&Tab;</td>
								<td>&nbsp;</td>
							</tr>
							<tr>
								<td>&nbsp;</td>
								<td>&Tab;</td>
								<td>&nbsp;</td>
							</tr>
							<tr>
								<td align='center'><b>(___________________)</b></td>
								<td>&Tab;</td>
								<td align='center'><b>(___________________)</b></td>
							</tr>
						</table>";
		return $print_data;
	}
	private function restock() {
		$id = $_POST['id'];
		$header_data = array(
			"restock" => 1
		);
		$header_id['id'] = $id;
		$this->dbtable->update($header_data, $header_id);
		$row = $this->dbtable->select($id);
		$dobat_keluar_rows = $this->dbtable->get_result("
			SELECT *
			FROM smis_fr_dobat_keluar
			WHERE id_obat_keluar = '" . $id . "' AND prop NOT LIKE 'del'
		");
		foreach ($dobat_keluar_rows as $dokr) {
			$stok_obat_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat_keluar");
			$stok_keluar_query = "
				SELECT *
				FROM smis_fr_stok_obat_keluar
				WHERE id_dobat_keluar = '" . $dokr->id . "'
				ORDER BY id DESC
			";
			$stok_keluar = $stok_obat_keluar_dbtable->get_result($stok_keluar_query);
			foreach($stok_keluar as $sk) {
				$stok_keluar_data = array();
				$stok_keluar_data['jumlah'] = 0;
				$stok_keluar_data['prop'] = "del";
				$stok_keluar_data['autonomous'] = "[".getSettings($this->dbtable->get_db(), "smis_autonomous_id", "")."]";
		        $stok_keluar_data['duplicate'] = 0;
		        $stok_keluar_data['time_updated'] = date("Y-m-d H:i:s");
				$stok_keluar_id['id'] = $sk->id;
				$stok_obat_keluar_dbtable->update($stok_keluar_data, $stok_keluar_id);
				$stok_obat_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
				$stok_query = "
					SELECT *
					FROM smis_fr_stok_obat
					WHERE id = '" . $sk->id_stok_obat . "'
				";
				$stok_obat_row = $stok_obat_dbtable->get_row($stok_query);
				$stok_data = array();
				$stok_data['sisa'] = $stok_obat_row->sisa + $sk->jumlah;
				$stok_data['autonomous'] = "[".getSettings($this->dbtable->get_db(), "smis_autonomous_id", "")."]";
		        $stok_data['duplicate'] = 0;
		        $stok_data['time_updated'] = date("Y-m-d H:i:s");
				$stok_id['id'] = $sk->id_stok_obat;
				$stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
				$stok_dbtable->update($stok_data, $stok_id);
				//logging riwayat stok obat:
				$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_riwayat_stok_obat");
				$data_riwayat = array();
				$data_riwayat['tanggal'] = date("Y-m-d");
				$data_riwayat['id_stok_obat'] = $sk->id_stok_obat;
				$data_riwayat['jumlah_masuk'] = $sk->jumlah;
				$data_riwayat['sisa'] = $stok_obat_row->sisa + $sk->jumlah;
				$data_riwayat['keterangan'] = "Pembatalan Stok Keluar ke " . ArrayAdapter::format("unslug", $row->unit);
				global $user;
				$data_riwayat['nama_user'] = $_POST['nama_user'];
				$data_riwayat['autonomous'] = "[".getSettings($this->dbtable->get_db(), "smis_autonomous_id", "")."]";
		        $data_riwayat['duplicate'] = 0;
		        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
		        $data_riwayat['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
				$riwayat_dbtable->insert($data_riwayat);
				$id_riwayat = $riwayat_dbtable->get_inserted_id();

				$data_riwayat = array();
				$data_riwayat['origin_id'] = $id_riwayat;
				$data_riwayat_id = array();
				$data_riwayat_id['id'] = $id_riwayat;
				$riwayat_dbtable->update($data_riwayat, $data_riwayat_id);
			}
			//kartu gudang induk:
			$ks_data = array();
			$ks_data['f_id'] = $id['id'];
			$ks_data['unit'] = "Pengembalian Mutasi " . ArrayAdapter::format("unslug", $row->unit);
			$ks_data['no_bon'] = $id['id'];
			$ks_data['id_obat'] = $dokr->id_obat;
			$ks_data['kode_obat'] = $dokr->kode_obat;
			$ks_data['nama_obat'] = $dokr->nama_obat;
			$ks_data['nama_jenis_obat'] = $dokr->nama_jenis_obat;
			$ks_data['tanggal'] = date("Y-m-d");
			$ks_data['masuk'] = $dokr->jumlah;
			$ks_data['keluar'] = 0;
			$ks_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_kartu_stok");
			$ks_row = $ks_dbtable->get_row("
				SELECT SUM(b.sisa) AS 'jumlah'
				FROM smis_fr_dobat_f_masuk a LEFT JOIN smis_fr_stok_obat b ON a.id = b.id_dobat_masuk
				WHERE a.prop NOT LIKE 'del' AND a.id_obat = '" . $dokr->id_obat . "'
			");
			$ks_data['sisa'] = $ks_row->jumlah + $dokr->jumlah;
			$ks_data['autonomous'] = "[".getSettings($this->dbtable->get_db(), "smis_autonomous_id", "")."]";
	        $ks_data['duplicate'] = 0;
	        $ks_data['time_updated'] = date("Y-m-d H:i:s");
	        $ks_data['origin_updated'] = getSettings($this->dbtable->get_db(), "smis_autonomous_id", "");
			$ks_dbtable->insert($ks_data);
			$id_kartu_stok = $ks_dbtable->get_inserted_id();

			$ks_data = array();
			$ks_data['origin_id'] = $id_kartu_stok;
			$ks_data_id = array();
			$ks_data_id['id'] = $id_kartu_stok;
			$ks_dbtable->update($ks_data, $ks_data_id);
		}
		$success['success'] = 1;
		$success['id'] = $_POST['id'];
		return $success;
	}
	public function save() {
		$header_data = $this->postToArray();
		global $user;
		$header_data['user_pengirim'] = $user->getName();
		$id['id'] = $_POST['id'];
        $berhasil=true;
		$this->dbtable->get_db()->set_autocommit(false);
		$this->dbtable->get_db()->begin_transaction();
		$nama_obat_gagal = "";
		$kode_obat_gagal = "";
		if ($id['id'] == 0 || $id['id'] == "") {
			//do insert header here:
			$result = $this->dbtable->insert($header_data);
			$id['id'] = $this->dbtable->get_inserted_id();
			$data = array();
			$data['nomor'] = $id['id'];
			$this->dbtable->update($data, $id);
			$success['type'] = "insert";
			if (isset($_POST['detail'])) {
				//do insert detail here:
				$dobat_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_dobat_keluar");
				$ks_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_kartu_stok");
				$detail = $_POST['detail'];
				foreach($detail as $d) {
					$detail_data = array();
					$detail_data['id_obat_keluar'] = $id['id'];
					$detail_data['id_obat'] = $d['id_obat'];
					$detail_data['kode_obat'] = $d['kode_obat'];
					$detail_data['nama_obat'] = $d['nama_obat'];
					$detail_data['nama_jenis_obat'] = $d['nama_jenis_obat'];
					$detail_data['stok_entri'] = $d['stok_entri'];
					$detail_data['harga_ma'] = $d['harga_ma'];
					$detail_data['jumlah_diminta'] = $d['jumlah_diminta'];
					$detail_data['jumlah'] = $d['jumlah'];
					$detail_data['satuan'] = $d['satuan'];
					$detail_data['konversi'] = $d['konversi'];
					$detail_data['satuan_konversi'] = $d['satuan_konversi'];
					$detail_data['autonomous'] = "[".$this->getAutonomous()."]";
			        $detail_data['duplicate'] = 0;
			        $detail_data['time_updated'] = date("Y-m-d H:i:s");
			        $detail_data['origin_updated'] = $this->getAutonomous();
			        $detail_data['origin'] = $this->getAutonomous();
					$dobat_keluar_dbtable->insert($detail_data);
					$id_dobat_keluar = $dobat_keluar_dbtable->get_inserted_id();

					$detail_data = array();
					$detail_data['origin_id'] = $id_dobat_keluar;
					$detail_data_id = array();
					$detail_data_id['id'] = $id_dobat_keluar;
					$dobat_keluar_dbtable->update($detail_data, $detail_data_id);
					
					//kartu gudang induk:
					$ks_data = array();
					$ks_data['f_id'] = $id_dobat_keluar;
					$ks_data['unit'] = ArrayAdapter::format("unslug", $header_data['unit']);
					$ks_data['no_bon'] = ArrayAdapter::format("unslug", $id['id']);
					$ks_data['id_obat'] = $d['id_obat'];
					$ks_data['kode_obat'] = $d['kode_obat'];
					$ks_data['nama_obat'] = $d['nama_obat'];
					$ks_data['nama_jenis_obat'] = $d['nama_jenis_obat'];
					$ks_data['tanggal'] = $header_data['tanggal'];
					$ks_data['masuk'] = 0;
					$ks_data['keluar'] = $d['jumlah'];
					$ks_row = $ks_dbtable->get_row("
						SELECT SUM(b.sisa) AS 'jumlah'
						FROM smis_fr_dobat_f_masuk a LEFT JOIN smis_fr_stok_obat b ON a.id = b.id_dobat_masuk
						WHERE b.prop NOT LIKE 'del' AND a.id_obat = '" . $d['id_obat'] . "'
					");
                    if($ks_row->jumlah < $d['jumlah']) {
                        $berhasil = false;
                        $kode_obat_gagal = $d['kode_obat'];
                        $nama_obat_gagal = $d['nama_obat'];
						$this->addMessage("<b>" . $nama_obat_gagal . "</b> tidak dapat disimpan. (Stok tidak mencukupi, kekurangan " . $jumlah . " " . $d['satuan'] . ")");
                    }
					$ks_data['sisa'] = $ks_row->jumlah - $d['jumlah'];
					$ks_data['autonomous'] = "[".$this->getAutonomous()."]";
			        $ks_data['duplicate'] = 0;
			        $ks_data['time_updated'] = date("Y-m-d H:i:s");
			        $ks_data['origin_updated'] = $this->getAutonomous();
			        $ks_data['origin'] = $this->getAutonomous();
					$ks_dbtable->insert($ks_data);
					$id_kartu_stok = $ks_dbtable->get_inserted_id();

					$ks_data = array();
					$ks_data['origin_id'] = $id_kartu_stok;
					$ks_data_id = array();
					$ks_data_id['id'] = $id_kartu_stok;
					$ks_dbtable->update($ks_data, $ks_data_id);
					
					$id_detail = $dobat_keluar_dbtable->get_inserted_id();
					$stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
					$stok_query = "
						SELECT smis_fr_stok_obat.id, v_dobat_masuk.id_obat, smis_fr_stok_obat.nama_obat, smis_fr_stok_obat.nama_jenis_obat, smis_fr_stok_obat.sisa, smis_fr_stok_obat.satuan, smis_fr_stok_obat.konversi, smis_fr_stok_obat.satuan_konversi, smis_fr_stok_obat.label
						FROM smis_fr_stok_obat LEFT JOIN (
							SELECT label, id, id_obat
							FROM smis_fr_dobat_f_masuk
						) v_dobat_masuk ON smis_fr_stok_obat.id_dobat_masuk = v_dobat_masuk.id AND smis_fr_stok_obat.label = v_dobat_masuk.label
						WHERE smis_fr_stok_obat.prop NOT LIKE 'del' AND v_dobat_masuk.id_obat = '" . $d['id_obat'] . "' AND smis_fr_stok_obat.satuan = '" . $d['satuan'] . "' AND smis_fr_stok_obat.konversi = '" . $d['konversi'] . "' AND smis_fr_stok_obat.satuan_konversi = '" . $d['satuan_konversi'] . "' AND smis_fr_stok_obat.sisa > 0
						ORDER BY FIELD(smis_fr_stok_obat.label, 'reguler', 'sito'), smis_fr_stok_obat.tanggal_exp ASC
					";
					$stok_rows = $stok_dbtable->get_result($stok_query);
					$jumlah = $d['jumlah'];
					foreach($stok_rows as $sr) {
						$sisa_stok = 0;
						$jumlah_stok_keluar = 0;
						if ($sr->sisa >= $jumlah) {
							$sisa_stok = $sr->sisa - $jumlah;
							$jumlah_stok_keluar = $jumlah;
							$jumlah = 0;
						} else {
							$sisa_stok = 0;
							$jumlah_stok_keluar = $sr->sisa;
							$jumlah = $jumlah - $sr->sisa;
						}
						//do update stok obat here:
						$stok_data = array();
						$stok_data['sisa'] = $sisa_stok;
						$stok_data['autonomous'] = "[".$this->getAutonomous()."]";
				        $stok_data['duplicate'] = 0;
				        $stok_data['time_updated'] = date("Y-m-d H:i:s");
				        $stok_data['origin_updated'] = $this->getAutonomous();
						$stok_id['id'] = $sr->id;
						$stok_dbtable->update($stok_data, $stok_id);
						//logging riwayat stok obat:
						$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_riwayat_stok_obat");
						$data_riwayat = array();
						$data_riwayat['tanggal'] = date("Y-m-d");
						$data_riwayat['id_stok_obat'] = $sr->id;
						$data_riwayat['jumlah_keluar'] = $jumlah_stok_keluar;
						$data_riwayat['sisa'] = $sisa_stok;
						$data_riwayat['keterangan'] = "Stok Keluar ke " . ArrayAdapter::format("unslug", $_POST['unit']);
						global $user;
						$data_riwayat['nama_user'] = $user->getName();
						$data_riwayat['autonomous'] = "[".$this->getAutonomous()."]";
				        $data_riwayat['duplicate'] = 0;
				        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
				        $data_riwayat['origin_updated'] = $this->getAutonomous();
				        $data_riwayat['origin'] = $this->getAutonomous();
						$riwayat_dbtable->insert($data_riwayat);
						$id_riwayat_stok = $riwayat_dbtable->get_inserted_id();

						$data_riwayat = array();
						$data_riwayat['origin_id'] = $id_riwayat_stok;
						$data_riwayat_id = array();
						$data_riwayat_id['id'] = $id_riwayat_stok;
						$riwayat_dbtable->update($data_riwayat, $data_riwayat_id);
						//do insert stok obat keluar here:
						$stok_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat_keluar");
						$stok_keluar_data = array();
						$stok_keluar_data['id_dobat_keluar'] = $id_detail;
						$stok_keluar_data['id_stok_obat'] = $sr->id;
						$stok_keluar_data['jumlah'] = $jumlah_stok_keluar;
						$stok_keluar_data['autonomous'] = "[".$this->getAutonomous()."]";
				        $stok_keluar_data['duplicate'] = 0;
				        $stok_keluar_data['time_updated'] = date("Y-m-d H:i:s");
				        $stok_keluar_data['origin_updated'] = $this->getAutonomous();
				        $stok_keluar_data['origin'] = $this->getAutonomous();
						$stok_keluar_dbtable->insert($stok_keluar_data);
						$id_stok_obat_keluar = $stok_keluar_dbtable->get_inserted_id();

						$stok_keluar_data = array();
						$stok_keluar_data['origin_id'] = $id_stok_obat_keluar;
						$stok_keluar_data_id = array();
						$stok_keluar_data_id['id'] = $id_stok_obat_keluar;
						$stok_keluar_dbtable->update($stok_keluar_data, $stok_keluar_data_id);
						if ($jumlah == 0) break;
					}
					if ($jumlah > 0) {
						$berhasil = false;
						$kode_obat_gagal = $d['kode_obat'];
						$nama_obat_gagal = $d['nama_obat'];
						$this->addMessage("<b>" . $nama_obat_gagal . "</b> tidak dapat disimpan. (Stok tidak mencukupi, kekurangan " . $jumlah . " " . $d['satuan'] . ")");
					}
				}
			}
		} else {
			//do update header here:
			$header_data = array();
			$header_data['tanggal'] = $_POST['tanggal'];
			$header_data['unit'] = $_POST['unit'];
			$header_data['status'] = $_POST['status'];
			$header_data['keterangan'] = $_POST['keterangan'];
			$header_data['autonomous'] = "[" . $this->getAutonomous() . "]";
	        $header_data['duplicate'] = 0;
	        $header_data['time_updated'] = date("Y-m-d H:i:s");
	        $header_data['origin_updated'] = $this->getAutonomous();
			$result = $this->dbtable->update($header_data, $id);
			$success['type'] = "update";
			if (isset($_POST['detail'])) {
				//do update detail here:
				$dobat_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_dobat_keluar");
				$ks_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_kartu_stok");
				$detail = $_POST['detail'];
				foreach($detail as $d) {
					if ($d['cmd'] == "insert") {
						$detail_data = array();
						$detail_data['id_obat_keluar'] = $id['id'];
						$detail_data['id_obat'] = $d['id_obat'];
						$detail_data['kode_obat'] = $d['kode_obat'];
						$detail_data['nama_obat'] = $d['nama_obat'];
						$detail_data['nama_jenis_obat'] = $d['nama_jenis_obat'];
						$detail_data['stok_entri'] = $d['stok_entri'];
						$detail_data['harga_ma'] = $d['harga_ma'];
						$detail_data['jumlah_diminta'] = $d['jumlah_diminta'];
						$detail_data['jumlah'] = $d['jumlah'];
						$detail_data['satuan'] = $d['satuan'];
						$detail_data['konversi'] = $d['konversi'];
						$detail_data['satuan_konversi'] = $d['satuan_konversi'];
						$detail_data['autonomous'] = "[".$this->getAutonomous()."]";
				        $detail_data['duplicate'] = 0;
				        $detail_data['time_updated'] = date("Y-m-d H:i:s");
				        $detail_data['origin_updated'] = $this->getAutonomous();
				        $detail_data['origin'] = $this->getAutonomous();
						$dobat_keluar_dbtable->insert($detail_data);
						$id_detail = $dobat_keluar_dbtable->get_inserted_id();

						$detail_data = array();
						$detail_data['origin_id'] = $id_detail;
						$detail_data_id = array();
						$detail_data_id['id'] = $id_detail;
						$dobat_keluar_dbtable->update($detail_data, $detail_data_id);

						//kartu gudang induk:
						$ks_data = array();
						$ks_data['f_id'] = $id['id'];
						$ks_data['unit'] = ArrayAdapter::format("unslug", $header_data['unit']);
						$ks_data['no_bon'] = $id['id'];
						$ks_data['id_obat'] = $d['id_obat'];
						$ks_data['kode_obat'] = $d['kode_obat'];
						$ks_data['nama_obat'] = $d['nama_obat'];
						$ks_data['nama_jenis_obat'] = $d['nama_jenis_obat'];
						$ks_data['tanggal'] = $header_data['tanggal'];
						$ks_data['masuk'] = 0;
						$ks_data['keluar'] = $d['jumlah'];
						$ks_row = $ks_dbtable->get_row("
							SELECT SUM(b.sisa) AS 'jumlah'
							FROM smis_fr_dobat_f_masuk a LEFT JOIN smis_fr_stok_obat b ON a.id = b.id_dobat_masuk
							WHERE a.prop NOT LIKE 'del' AND a.id_obat = '" . $d['id_obat'] . "'
						");
						if($ks_row->jumlah < $d['jumlah']) {
							$berhasil = false;
							$kode_obat_gagal = $d['kode_obat'];
							$nama_obat_gagal = $d['nama_obat'];
							$this->addMessage("<b>" . $nama_obat_gagal . "</b> tidak dapat disimpan. (Stok tidak mencukupi, kekurangan " . $jumlah . " " . $d['satuan'] . ")");
						}
						$ks_data['sisa'] = $ks_row->jumlah - $d['jumlah'];
						$ks_data['autonomous'] = "[".$this->getAutonomous()."]";
						$ks_data['duplicate'] = 0;
						$ks_data['time_updated'] = date("Y-m-d H:i:s");
						$ks_data['origin_updated'] = $this->getAutonomous();
						$ks_data['origin'] = $this->getAutonomous();
						$ks_dbtable->insert($ks_data);
						$id_kartu_stok = $ks_dbtable->get_inserted_id();

						$ks_data = array();
						$ks_data['origin_id'] = $id_kartu_stok;
						$ks_data_id = array();
						$ks_data_id['id'] = $id_kartu_stok;
						$ks_dbtable->update($ks_data, $ks_data_id);

						$stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
						$stok_query = "
							SELECT smis_fr_stok_obat.id, v_dobat_masuk.id_obat, smis_fr_stok_obat.nama_obat, smis_fr_stok_obat.nama_jenis_obat, smis_fr_stok_obat.sisa, smis_fr_stok_obat.satuan, smis_fr_stok_obat.konversi, smis_fr_stok_obat.satuan_konversi, smis_fr_stok_obat.label
							FROM smis_fr_stok_obat LEFT JOIN (
								SELECT label, id, id_obat
								FROM smis_fr_dobat_f_masuk
							) v_dobat_masuk ON smis_fr_stok_obat.id_dobat_masuk = v_dobat_masuk.id AND smis_fr_stok_obat.label = v_dobat_masuk.label
							WHERE smis_fr_stok_obat.prop NOT LIKE 'del' AND v_dobat_masuk.id_obat = '" . $d['id_obat'] . "' AND smis_fr_stok_obat.satuan = '" . $d['satuan'] . "' AND smis_fr_stok_obat.konversi = '" . $d['konversi'] . "' AND smis_fr_stok_obat.satuan_konversi = '" . $d['satuan_konversi'] . "' AND smis_fr_stok_obat.sisa > 0
							ORDER BY FIELD(smis_fr_stok_obat.label, 'reguler', 'sito'), smis_fr_stok_obat.tanggal_exp ASC
						";
						$stok_rows = $stok_dbtable->get_result($stok_query);
						$jumlah = $d['jumlah'];
						foreach($stok_rows as $sr) {
							$sisa_stok = 0;
							$jumlah_stok_keluar = 0;
							if ($sr->sisa >= $jumlah) {
								$sisa_stok = $sr->sisa - $jumlah;
								$jumlah_stok_keluar = $jumlah;
								$jumlah = 0;
							} else {
								$sisa_stok = 0;
								$jumlah_stok_keluar = $sr->sisa;
								$jumlah = $jumlah - $sr->sisa;
							}
							//do update stok obat here:
							$stok_data = array();
							$stok_data['sisa'] = $sisa_stok;
							$stok_data['autonomous'] = "[".$this->getAutonomous()."]";
					        $stok_data['duplicate'] = 0;
					        $stok_data['time_updated'] = date("Y-m-d H:i:s");
					        $stok_data['origin_updated'] = $this->getAutonomous();
							$stok_id['id'] = $sr->id;
							$stok_dbtable->update($stok_data, $stok_id);
							//logging riwayat stok obat:
							$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_riwayat_stok_obat");
							$data_riwayat = array();
							$data_riwayat['tanggal'] = date("Y-m-d");
							$data_riwayat['id_stok_obat'] = $sr->id;
							$data_riwayat['jumlah_keluar'] = $jumlah_stok_keluar;
							$data_riwayat['sisa'] = $sisa_stok;
							$data_riwayat['keterangan'] = "Perubahan Stok Keluar ke " . ArrayAdapter::format("unslug", $_POST['unit']);
							global $user;
							$data_riwayat['nama_user'] = $user->getName();
							$data_riwayat['autonomous'] = "[".$this->getAutonomous()."]";
					        $data_riwayat['duplicate'] = 0;
					        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
					        $data_riwayat['origin_updated'] = $this->getAutonomous();
					        $data_riwayat['origin'] = $this->getAutonomous();
							$riwayat_dbtable->insert($data_riwayat);
							$id_riwayat_stok = $riwayat_dbtable->get_inserted_id();

							$data_riwayat = array();
							$data_riwayat['origin_id'] = $id_riwayat_stok;
							$data_riwayat_id = array();
							$data_riwayat_id['id'] = $id_riwayat_stok;
							$riwayat_dbtable->update($data_riwayat, $data_riwayat_id);
							//do insert stok obat keluar here:
							$stok_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat_keluar");
							$stok_keluar_data = array();
							$stok_keluar_data['id_dobat_keluar'] = $id_detail;
							$stok_keluar_data['id_stok_obat'] = $sr->id;
							$stok_keluar_data['jumlah'] = $jumlah_stok_keluar;
							$stok_keluar_data['autonomous'] = "[".$this->getAutonomous()."]";
					        $stok_keluar_data['duplicate'] = 0;
					        $stok_keluar_data['time_updated'] = date("Y-m-d H:i:s");
					        $stok_keluar_data['origin_updated'] = $this->getAutonomous();
					        $stok_keluar_data['origin'] = $this->getAutonomous();
							$stok_keluar_dbtable->insert($stok_keluar_data);
							$id_stok_obat_keluar = $stok_keluar_dbtable->get_inserted_id();

							$stok_keluar_data = array();
							$stok_keluar_data['origin_id'] = $id_stok_obat_keluar;
							$stok_keluar_data_id = array();
							$stok_keluar_data_id['id'] = $id_stok_obat_keluar;
							$stok_keluar_dbtable->update($stok_keluar_data, $stok_keluar_data_id);
							if ($jumlah == 0) break;
						}
						if ($jumlah > 0) {
							$berhasil = false;
							$kode_obat_gagal = $d['kode_obat'];
							$nama_obat_gagal = $d['nama_obat'];
							$this->addMessage("<b>" . $nama_obat_gagal . "</b> tidak dapat disimpan. (Stok tidak mencukupi, kekurangan " . $jumlah . " " . $d['satuan'] . ")");
						}
					} else if ($d['cmd'] == "update") {
						$detail_data = array();
						$detail_data['jumlah'] = $d['jumlah'];
						$detail_data['jumlah_diminta'] = $d['jumlah_diminta'];
						$detail_data['autonomous'] = "[".$this->getAutonomous()."]";
				        $detail_data['duplicate'] = 0;
				        $detail_data['time_updated'] = date("Y-m-d H:i:s");
				        $detail_data['origin_updated'] = $this->getAutonomous();
						$detail_id['id'] = $d['id'];
						$dobat_keluar_dbtable->update($detail_data, $detail_id);

						if ($d['jumlah'] != $d['jumlah_lama']) {
							//kartu gudang induk:
							$ks_data = array();
							$ks_data['f_id'] = $id['id'];
							$ks_data['unit'] = ArrayAdapter::format("unslug", $header_data['unit']);
							$ks_data['no_bon'] = $id['id'];
							$ks_data['id_obat'] = $d['id_obat'];
							$ks_data['kode_obat'] = $d['kode_obat'];
							$ks_data['nama_obat'] = $d['nama_obat'];
							$ks_data['nama_jenis_obat'] = $d['nama_jenis_obat'];
							$ks_data['tanggal'] = $header_data['tanggal'];
							if ($d['jumlah'] > $d['jumlah_lama']) {
								$ks_data['masuk'] = 0;
								$ks_data['keluar'] = $d['jumlah'] - $d['jumlah_lama'];
							} else {
								$ks_data['masuk'] = $d['jumlah_lama'] - $d['jumlah'];
								$ks_data['keluar'] = 0;
							}

							$ks_row = $ks_dbtable->get_row("
								SELECT SUM(b.sisa) AS 'jumlah'
								FROM smis_fr_dobat_f_masuk a LEFT JOIN smis_fr_stok_obat b ON a.id = b.id_dobat_masuk
								WHERE a.prop NOT LIKE 'del' AND a.id_obat = '" . $d['id_obat'] . "'
							");
							$ks_data['sisa'] = $ks_row->jumlah - $d['jumlah'];
							$ks_data['autonomous'] = "[" . $this->getAutonomous() . "]";
							$ks_data['duplicate'] = 0;
							$ks_data['time_updated'] = date("Y-m-d H:i:s");
							$ks_data['origin_updated'] = $this->getAutonomous();
							$ks_data['origin'] = $this->getAutonomous();
							$ks_dbtable->insert($ks_data);
							$id_kartu_stok = $ks_dbtable->get_inserted_id();

							$ks_data = array();
							$ks_data['origin_id'] = $id_kartu_stok;
							$ks_data_id = array();
							$ks_data_id['id'] = $id_kartu_stok;
							$ks_dbtable->update($ks_data, $ks_data_id);
						}

						if ($d['jumlah'] > $d['jumlah_lama']) {
							//jumlah baru > jumlah lama:
							$stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
							$stok_query = "
								SELECT smis_fr_stok_obat.id, v_dobat_masuk.id_obat, smis_fr_stok_obat.nama_obat, smis_fr_stok_obat.nama_jenis_obat, smis_fr_stok_obat.sisa, smis_fr_stok_obat.satuan, smis_fr_stok_obat.konversi, smis_fr_stok_obat.satuan_konversi, smis_fr_stok_obat.label
								FROM smis_fr_stok_obat LEFT JOIN (
									SELECT label, id, id_obat
									FROM smis_fr_dobat_f_masuk
								) v_dobat_masuk ON smis_fr_stok_obat.id_dobat_masuk = v_dobat_masuk.id AND smis_fr_stok_obat.label = v_dobat_masuk.label
								WHERE smis_fr_stok_obat.prop NOT LIKE 'del' AND v_dobat_masuk.id_obat = '" . $d['id_obat'] . "' AND smis_fr_stok_obat.satuan = '" . $d['satuan'] . "' AND smis_fr_stok_obat.konversi = '" . $d['konversi'] . "' AND smis_fr_stok_obat.satuan_konversi = '" . $d['satuan_konversi'] . "' AND smis_fr_stok_obat.sisa > 0
								ORDER BY FIELD(smis_fr_stok_obat.label, 'reguler', 'sito'), smis_fr_stok_obat.tanggal_exp ASC
							";
							$stok_rows = $stok_dbtable->get_result($stok_query);
							$jumlah = $d['jumlah'] - $d['jumlah_lama'];
							foreach($stok_rows as $sr) {
								$sisa_stok = 0;
								$jumlah_stok_keluar = 0;
								if ($sr->sisa >= $jumlah) {
									$sisa_stok = $sr->sisa - $jumlah;
									$jumlah_stok_keluar = $jumlah;
									$jumlah = 0;
								} else {
									$sisa_stok = 0;
									$jumlah_stok_keluar = $sr->sisa;
									$jumlah = $jumlah - $sr->sisa;
								}
								//do update stok obat here:
								$stok_data = array();
								$stok_data['sisa'] = $sisa_stok;
								$stok_data['autonomous'] = "[".$this->getAutonomous()."]";
						        $stok_data['duplicate'] = 0;
						        $stok_data['time_updated'] = date("Y-m-d H:i:s");
								$stok_id['id'] = $sr->id;
								$stok_dbtable->update($stok_data, $stok_id);
								//logging riwayat stok obat:
								$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_riwayat_stok_obat");
								$data_riwayat = array();
								$data_riwayat['tanggal'] = date("Y-m-d");
								$data_riwayat['id_stok_obat'] = $sr->id;
								$data_riwayat['jumlah_keluar'] = $jumlah_stok_keluar;
								$data_riwayat['sisa'] = $sisa_stok;
								$data_riwayat['keterangan'] = "Perubahan Stok Keluar ke " . ArrayAdapter::format("unslug", $_POST['unit']);
								global $user;
								$data_riwayat['nama_user'] = $user->getName();
								$data_riwayat['autonomous'] = "[".$this->getAutonomous()."]";
						        $data_riwayat['duplicate'] = 0;
						        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
						        $data_riwayat['origin_updated'] = $this->getAutonomous();
						        $data_riwayat['origin'] = $this->getAutonomous();
								$riwayat_dbtable->insert($data_riwayat);
								$id_riwayat_stok = $riwayat_dbtable->get_inserted_id();

								$data_riwayat = array();
								$data_riwayat['origin_id'] = $id_riwayat_stok;
								$data_riwayat_id = array();
								$data_riwayat_id['id'] = $id_riwayat_stok;
								$riwayat_dbtable->update($data_riwayat, $data_riwayat_id);
								//do insert stok obat keluar here:
								$stok_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat_keluar");
								$stok_keluar_data = array();
								$stok_keluar_data['id_dobat_keluar'] = $d['id'];
								$stok_keluar_data['id_stok_obat'] = $sr->id;
								$stok_keluar_data['jumlah'] = $jumlah_stok_keluar;
								$stok_keluar_data['autonomous'] = "[".$this->getAutonomous()."]";
						        $stok_keluar_data['duplicate'] = 0;
						        $stok_keluar_data['time_updated'] = date("Y-m-d H:i:s");
						        $stok_keluar_data['origin_updated'] = $this->getAutonomous();
						        $stok_keluar_data['origin'] = $this->getAutonomous();
								$stok_keluar_dbtable->insert($stok_keluar_data);
								$id_stok_obat_keluar = $stok_keluar_dbtable->get_inserted_id();

								$stok_keluar_data = array();
								$stok_keluar_data['origin_id'] = $id_stok_obat_keluar;
								$stok_keluar_data_id = array();
								$stok_keluar_data_id['id'] = $id_stok_obat_keluar;
								$stok_keluar_dbtable->update($stok_keluar_data, $stok_keluar_data_id);
								if ($jumlah == 0) break;
							}
							if ($jumlah > 0) {
								$berhasil = false;
								$kode_obat_gagal = $d['kode_obat'];
								$nama_obat_gagal = $d['nama_obat'];
								$this->addMessage("<b>" . $nama_obat_gagal . "</b> tidak dapat disimpan. (Stok tidak mencukupi, kekurangan " . $jumlah . " " . $d['satuan'] . ")");
							}
						} else if ($d['jumlah'] < $d['jumlah_lama']) {
							//jumlah baru < jumlah lama:
							$stok_obat_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat_keluar");
							$stok_keluar_query = "
								SELECT *
								FROM smis_fr_stok_obat_keluar
								WHERE id_dobat_keluar = '" . $d['id'] . "'
								ORDER BY id DESC
							";
							$stok_keluar = $stok_obat_keluar_dbtable->get_result($stok_keluar_query);
							$jumlah = $d['jumlah_lama'] - $d['jumlah'];
							foreach($stok_keluar as $sk) {
								$simpan_stok_keluar = 0;
								$simpan_stok = 0;
								if ($jumlah >= $sk->jumlah) {
									$jumlah = $jumlah - $sk->jumlah;
									$simpan_stok = $sk->jumlah;
									$simpan_stok_keluar = 0;
								} else {
									$simpan_stok_keluar = $sk->jumlah - $jumlah;
									$simpan_stok = $jumlah;
									$jumlah = 0;
								}
								$stok_keluar_data = array();
								$stok_keluar_data['jumlah'] = $simpan_stok_keluar;
								if ($simpan_stok_keluar == 0)
									$stok_keluar_data['prop'] = "del";
								$stok_keluar_data['autonomous'] = "[".$this->getAutonomous()."]";
						        $stok_keluar_data['duplicate'] = 0;
						        $stok_keluar_data['time_updated'] = date("Y-m-d H:i:s");
								$stok_keluar_id['id'] = $sk->id;
								$stok_obat_keluar_dbtable->update($stok_keluar_data, $stok_keluar_id);
								$stok_obat_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
								$stok_query = "
									SELECT *
									FROM smis_fr_stok_obat
									WHERE id = '" . $sk->id_stok_obat . "'
								";
								$stok_obat_row = $stok_obat_dbtable->get_row($stok_query);
								$stok_data = array();
								$stok_data['sisa'] = $stok_obat_row->sisa + $simpan_stok;
								$stok_data['autonomous'] = "[".$this->getAutonomous()."]";
						        $stok_data['duplicate'] = 0;
						        $stok_data['time_updated'] = date("Y-m-d H:i:s");
						        $stok_data['origin_updated'] = $this->getAutonomous();								
						        $stok_id['id'] = $sk->id_stok_obat;
								$stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
								$stok_dbtable->update($stok_data, $stok_id);
								//logging riwayat stok obat:
								$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_riwayat_stok_obat");
								$data_riwayat = array();
								$data_riwayat['tanggal'] = date("Y-m-d");
								$data_riwayat['id_stok_obat'] = $sk->id_stok_obat;
								$data_riwayat['jumlah_masuk'] = $simpan_stok;
								$data_riwayat['sisa'] = $stok_obat_row->sisa + $simpan_stok;
								$data_riwayat['keterangan'] = "Perubahan Stok Keluar ke " . ArrayAdapter::format("unslug", $_POST['unit']);
								global $user;
								$data_riwayat['nama_user'] = $user->getName();
								$data_riwayat['autonomous'] = "[".$this->getAutonomous()."]";
						        $data_riwayat['duplicate'] = 0;
						        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
						        $data_riwayat['origin_updated'] = $this->getAutonomous();
								$riwayat_dbtable->insert($data_riwayat);
								$id_riwayat_stok = $riwayat_dbtable->get_inserted_id();

								$data_riwayat = array();
								$data_riwayat['origin_id'] = $id_riwayat_stok;
								$data_riwayat_id = array();
								$data_riwayat_id['id'] = $id_riwayat_stok;
								$riwayat_dbtable->update($data_riwayat, $data_riwayat_id);
								if ($jumlah == 0) break;
							}
							if ($jumlah > 0) {
								$berhasil = false;
								$kode_obat_gagal = $d['kode_obat'];
								$nama_obat_gagal = $d['nama_obat'];	
								$this->addMessage("<b>" . $nama_obat_gagal . "</b> tidak dapat disimpan. (Stok tidak mencukupi, kekurangan " . $jumlah . " " . $d['satuan'] . ")");
							}
						} //end of update
					} else if($d['cmd'] == "delete") {
						$detail_data = array();
						$detail_data['prop'] = "del";
						$detail_data['autonomous'] = "[".$this->getAutonomous()."]";
				        $detail_data['duplicate'] = 0;
				        $detail_data['time_updated'] = date("Y-m-d H:i:s");
				        $detail_data['origin_updated'] = $this->getAutonomous();
						$detail_id['id'] = $d['id'];
						$dobat_keluar_dbtable->update($detail_data, $detail_id);
						
						//kartu gudang induk:
						$ks_data = array();
						$ks_data['f_id'] = $id['id'];
						$ks_data['unit'] = ArrayAdapter::format("unslug", $header_data['unit']);
						$ks_data['no_bon'] = $id['id'];
						$ks_data['id_obat'] = $d['id_obat'];
						$ks_data['kode_obat'] = $d['kode_obat'];
						$ks_data['nama_obat'] = $d['nama_obat'];
						$ks_data['nama_jenis_obat'] = $d['nama_jenis_obat'];
						$ks_data['tanggal'] = $header_data['tanggal'];
						$ks_data['masuk'] = $d['jumlah'];
						$ks_data['keluar'] = 0;
						$ks_row = $ks_dbtable->get_row("
							SELECT SUM(b.sisa) AS 'jumlah'
							FROM smis_fr_dobat_f_masuk a LEFT JOIN smis_fr_stok_obat b ON a.id = b.id_dobat_masuk
							WHERE a.prop NOT LIKE 'del' AND a.id_obat = '" . $d['id_obat'] . "'
						");
						// if ($ks_row->jumlah < $d['jumlah']) {
						// 	$berhasil = false;
						// 	$kode_obat_gagal = $d['kode_obat'];
						// 	$nama_obat_gagal = $d['nama_obat'];
						// }
						$ks_data['sisa'] = $ks_row->jumlah - $d['jumlah'];
						$ks_data['autonomous'] = "[" . $this->getAutonomous() . "]";
						$ks_data['duplicate'] = 0;
						$ks_data['time_updated'] = date("Y-m-d H:i:s");
						$ks_data['origin_updated'] = $this->getAutonomous();
						$ks_data['origin'] = $this->getAutonomous();
						$ks_dbtable->insert($ks_data);
						$id_kartu_stok = $ks_dbtable->get_inserted_id();

						$ks_data = array();
						$ks_data['origin_id'] = $id_kartu_stok;
						$ks_data_id = array();
						$ks_data_id['id'] = $id_kartu_stok;
						$ks_dbtable->update($ks_data, $ks_data_id);

						$stok_obat_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat_keluar");
						$stok_keluar_query = "
							SELECT *
							FROM smis_fr_stok_obat_keluar
							WHERE id_dobat_keluar = '" . $d['id'] . "' AND smis_fr_stok_obat_keluar.prop NOT LIKE 'del'
							ORDER BY id DESC
						";
						$stok_keluar = $stok_obat_keluar_dbtable->get_result($stok_keluar_query);
						foreach($stok_keluar as $sk) {
							$stok_keluar_data = array();
							$stok_keluar_data['jumlah'] = 0;
							$stok_keluar_data['prop'] = "del";
							$stok_keluar_data['autonomous'] = "[".$this->getAutonomous()."]";
					        $stok_keluar_data['duplicate'] = 0;
					        $stok_keluar_data['time_updated'] = date("Y-m-d H:i:s");
					        $stok_keluar_data['origin_updated'] = $this->getAutonomous();
							$stok_keluar_id['id'] = $sk->id;
							$stok_obat_keluar_dbtable->update($stok_keluar_data, $stok_keluar_id);
							$stok_obat_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
							$stok_query = "
								SELECT *
								FROM smis_fr_stok_obat
								WHERE id = '" . $sk->id_stok_obat . "'
							";
							$stok_obat_row = $stok_obat_dbtable->get_row($stok_query);
							$stok_data = array();
							$stok_data['sisa'] = $stok_obat_row->sisa + $sk->jumlah;
							$stok_data['autonomous'] = "[".$this->getAutonomous()."]";
					        $stok_data['duplicate'] = 0;
					        $stok_data['time_updated'] = date("Y-m-d H:i:s");
					        $stok_data['origin_updated'] = $this->getAutonomous();
							$stok_id['id'] = $sk->id_stok_obat;
							$stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
							$stok_dbtable->update($stok_data, $stok_id);
							//logging riwayat stok obat:
							$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_riwayat_stok_obat");
							$data_riwayat = array();
							$data_riwayat['tanggal'] = date("Y-m-d");
							$data_riwayat['id_stok_obat'] = $sk->id_stok_obat;
							$data_riwayat['jumlah_masuk'] = $sk->jumlah;
							$data_riwayat['sisa'] = $stok_obat_row->sisa + $sk->jumlah;
							$data_riwayat['keterangan'] = "Perubahan Stok Keluar ke " . ArrayAdapter::format("unslug", $_POST['unit']);
							global $user;
							$data_riwayat['nama_user'] = $user->getName();
							$data_riwayat['autonomous'] = "[".$this->getAutonomous()."]";
					        $data_riwayat['duplicate'] = 0;
					        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
					        $data_riwayat['origin_updated'] = $this->getAutonomous();
					        $data_riwayat['origin'] = $this->getAutonomous();
							$riwayat_dbtable->insert($data_riwayat);
							$id_riwayat_stok = $riwayat_dbtable->get_inserted_id();

							$data_riwayat = array();
							$data_riwayat['origin_id'] = $id_riwayat_stok;
							$data_riwayat_id = array();
							$data_riwayat_id['id'] = $id_riwayat_stok;
							$riwayat_dbtable->update($data_riwayat, $data_riwayat_id);
						}
					}
				}
			}
		}
        if ($berhasil) {
            $this->dbtable->get_db()->commit();
        } else {
            $this->dbtable->get_db()->rollback();
            $result = false;
        }
		$this->dbtable->get_db()->set_autocommit(true);
		$success['id'] = $id['id'];
		$success['success'] = 1;
		$success['kode_obat'] = $kode_obat_gagal;
		$success['nama_obat'] = $nama_obat_gagal;
		$success['message'] = $this->getMessage();
		if ($result === false) $success['success'] = 0;
		return $success;
	}
	public function edit() {
		$id = $_POST['id'];
		$header_row = $this->dbtable->get_row("
			SELECT *
			FROM smis_fr_obat_keluar
			WHERE id = '" . $id . "'
		");
		$data['header'] = $header_row;
		$dobat_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_dobat_keluar");
		$data['detail'] = $dobat_keluar_dbtable->get_result("
			SELECT *
			FROM smis_fr_dobat_keluar
			WHERE id_obat_keluar = '" . $id . "' AND prop NOT LIKE 'del'
		");
		$data['subdetail'] = $dobat_keluar_dbtable->get_result("
			SELECT
				id, GROUP_CONCAT(CONCAT(CAST(tanggal_exp AS CHAR CHARACTER SET utf8), ';', CAST(no_batch AS CHAR CHARACTER SET utf8), ';', CAST(jumlah AS CHAR CHARACTER SET utf8))) detail_info
			FROM (
				SELECT 
					a.id, a.id_obat, CASE WHEN c.tanggal_exp = '0000-00-00' THEN 'N/A' ELSE c.tanggal_exp END tanggal_exp, c.no_batch, SUM(b.jumlah) jumlah
				FROM 
					(smis_fr_dobat_keluar a INNER JOIN smis_fr_stok_obat_keluar b ON a.id = b.id_dobat_keluar) INNER JOIN smis_fr_stok_obat c ON b.id_stok_obat = c.id
				WHERE 
					a.id_obat_keluar = '" . $id . "' AND a.prop NOT LIKE 'del'
				GROUP BY 
					a.id, a.id_obat, c.tanggal_exp, c.no_batch
			) v
			GROUP BY
				id
		");
		return $data;
	}
	public function delete() {
		$id['id'] = $_POST['id'];
		if ($this->dbtable->isRealDelete()) {
			$result = $this->dbtable->delete(null,$id);
		} else {
			$data['prop'] = "del";
			$data['autonomous'] = "[".$this->getAutonomous()."]";
	        $data['duplicate'] = 0;
	        $data['time_updated'] = date("Y-m-d H:i:s");
	        $data['origin_updated'] = $this->getAutonomous();
			$result = $this->dbtable->update($data, $id);
		}
		$stok_obat_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat_keluar");
		$stok_obat_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
		$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_riwayat_stok_obat");
		$stok_keluar_query = "
			SELECT smis_fr_stok_obat_keluar.*, smis_fr_obat_keluar.unit
			FROM (smis_fr_stok_obat_keluar LEFT JOIN smis_fr_dobat_keluar ON smis_fr_stok_obat_keluar.id_dobat_keluar = smis_fr_dobat_keluar.id) LEFT JOIN smis_fr_obat_keluar ON smis_fr_dobat_keluar.id_obat_keluar = smis_fr_obat_keluar.id
			WHERE smis_fr_obat_keluar.id = '" . $id['id'] . "' AND smis_fr_stok_obat_keluar.prop NOT LIKE 'del'
			ORDER BY smis_fr_stok_obat_keluar.id DESC
		";
		$stok_keluar = $this->dbtable->get_result($stok_keluar_query);
		foreach($stok_keluar as $sk) {
			$stok_keluar_data = array();
			$stok_keluar_data['prop'] = "del";
			$stok_keluar_id['id'] = $sk->id;
			$stok_obat_keluar_dbtable->update($stok_keluar_data, $stok_keluar_id);
			$stok_query = "
				SELECT *
				FROM smis_fr_stok_obat
				WHERE id = '" . $sk->id_stok_obat . "'
			";
			$stok_obat_row =  $this->dbtable->get_row($stok_query);
			$stok_data = array();
			$stok_data['sisa'] = $stok_obat_row->sisa + $sk->jumlah;
			$stok_data['autonomous'] = "[".$this->getAutonomous()."]";
	        $stok_data['duplicate'] = 0;
	        $stok_data['time_updated'] = date("Y-m-d H:i:s");
	        $stok_data['origin_updated'] = $this->getAutonomous();
			$stok_id['id'] = $sk->id_stok_obat;
			$stok_obat_dbtable->update($stok_data, $stok_id);
			//logging riwayat stok obat:
			$data_riwayat = array();
			$data_riwayat['tanggal'] = date("Y-m-d");
			$data_riwayat['id_stok_obat'] = $sk->id_stok_obat;
			$data_riwayat['jumlah_masuk'] = $sk->jumlah;
			$data_riwayat['sisa'] = $stok_obat_row->sisa + $sk->jumlah;
			$data_riwayat['keterangan'] = "Pembatalan Stok Keluar ke " . ArrayAdapter::format("unslug", $sk->unit);
			global $user;
			$data_riwayat['nama_user'] = $user->getName();
			$data_riwayat['autonomous'] = "[".$this->getAutonomous()."]";
	        $data_riwayat['duplicate'] = 0;
	        $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
	        $data_riwayat['origin_updated'] = $this->getAutonomous();
	        $data_riwayat['origin'] = $this->getAutonomous();
			$riwayat_dbtable->insert($data_riwayat);
			$id_riwayat_stok = $riwayat_dbtable->get_inserted_id();

			$data_riwayat = array();
			$data_riwayat['origin_id'] = $id_riwayat_stok;
			$data_riwayat_id = array();
			$data_riwayat_id['id'] = $id_riwayat_stok;
			$riwayat_dbtable->update($data_riwayat, $data_riwayat_id);
		}

		//kartu gudang induk:
		$dok_rows = $this->dbtable->get_result("
			SELECT *
			FROM smis_fr_dobat_keluar
			WHERE id_obat_keluar = '" . $id['id'] . "' AND prop NOT LIKE 'del'
		");
		if ($dok_rows != null) {
			$ks_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_kartu_stok");
			$header_row = $this->dbtable->get_row("
				SELECT *
				FROM smis_fr_obat_keluar
				WHERE id = '" . $id['id'] . "'
			");
			foreach ($dok_rows as $dr) {	
				$ks_data = array();
				$ks_data['f_id'] = $id['id'];
				$ks_data['unit'] = "Pembatalan Mutasi ke " . ArrayAdapter::format("unslug", $header_row->unit);
				$ks_data['no_bon'] = $id['id'];
				$ks_data['id_obat'] = $dr->id_obat;
				$ks_data['kode_obat'] = $dr->kode_obat;
				$ks_data['nama_obat'] = $dr->nama_obat;
				$ks_data['nama_jenis_obat'] = $dr->nama_jenis_obat;
				$ks_data['tanggal'] = date("Y-m-d");
				$ks_data['masuk'] = $dr->jumlah;
				$ks_data['keluar'] = 0;
				$ks_row = $ks_dbtable->get_row("
					SELECT SUM(b.sisa) AS 'jumlah'
					FROM smis_fr_dobat_f_masuk a LEFT JOIN smis_fr_stok_obat b ON a.id = b.id_dobat_masuk
					WHERE a.prop NOT LIKE 'del' AND a.id_obat = '" . $dr->id_obat . "'
				");
				$ks_data['sisa'] = $ks_row->jumlah + $dr->jumlah;
				$ks_data['autonomous'] = "[".$this->getAutonomous()."]";
		        $ks_data['duplicate'] = 0;
		        $ks_data['time_updated'] = date("Y-m-d H:i:s");
		        $ks_data['origin_updated'] = $this->getAutonomous();
		        $ks_data['origin'] = $this->getAutonomous();
				$ks_dbtable->insert($ks_data);
				$id_kartu_stok = $ks_dbtable->get_inserted_id();

				$ks_data = array();
				$ks_data['origin_id'] = $id_kartu_stok;
				$ks_data_id = array();
				$ks_data_id['id'] = $id_kartu_stok;
				$ks_dbtable->update($ks_data, $ks_data_id);
			}
		}

		$success['success'] = 1;
		$success['id'] = $_POST['id'];
		if ($result === 'false') $success['success'] = 0;
		return $success;
	}
}
?>