<?php
require_once("smis-base/smis-include-service-consumer.php");
require_once("smis-base/smis-include-duplicate.php");

class AccObatMasukDBResponder extends DuplicateResponder {
    public function command($command) {
        if ($command != "accept") {
            return parent::command($command);
        }
		$responsePackage = new ResponsePackage();
		if ($command == "accept") {
			$responsePackage->setStatus(ResponsePackage::$STATUS_OK);
			$content = $this->acceptTransaction();
			$responsePackage->setContent($content);
			if ($content['success'] == 1) {
				$responsePackage->setAlertVisible(true);
				$responsePackage->setAlertContent("Data Saved", "Your Data Had Been Saved", ResponsePackage::$TIPE_INFO);
			} else {
				$responsePackage->setAlertVisible(false);
			}
		}
		return $responsePackage->getPackage();
    }

	private function acceptTransaction() {
		$id['id'] = $_POST['id'];

		$header_data = $this->dbtable->select($id);
		$id_obat_keluar = $this->createObatKeluarData($header_data);

		if ($id_obat_keluar > 0) {
			$this->pushAutoConfirmObatMasukUnitData($id_obat_keluar);
			$data['status_acc'] = "1";
			$this->dbtable->update($data, $id);
		}
		
		return [
			'type' => "update",
			'id' => $id['id'],
			'success' => 1
		];
	}

	private function createObatKeluarData($header_data) {
		$slug_depo = $this->dbtable->get_var("
			SELECT
				depo
			FROM
				smis_fr_faskes_depo
			WHERE
				faskes LIKE '" . $header_data->nama_klinik . "'
					AND prop = ''
			ORDER BY
				id DESC
			LIMIT
				0, 1
		");

		// Obat Keluar Unit :
		global $user;
		$data_obat_keluar = array(
			'tanggal' => date("Y-m-d"),
			'unit' => $slug_depo,
			'status' => "sudah",
			'keterangan' => "",
			'user_acc' => $user->getNameOnly(),
			'status_acc' => 1,
			'tanggal_acc' => date("Y-m-d H:i:s")
		);
		$obat_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_obat_keluar");
		$obat_keluar_dbtable->insert($data_obat_keluar);
		$id_obat_keluar = $obat_keluar_dbtable->get_inserted_id();
		$obat_keluar_dbtable->update([
			'nomor' => $id_obat_keluar
		], [
			'id' => $id_obat_keluar
		]);

		// Detail Obat Keluar Unit :
		$detail_obat_keluar_rows = $this->dbtable->get_result("
			SELECT
				b.id_obat, c.*
			FROM
				smis_fr_obat_f_masuk a
					INNER JOIN smis_fr_dobat_f_masuk b ON a.id = b.id_obat_f_masuk
					INNER JOIN smis_fr_stok_obat c ON b.id = c.id_dobat_masuk
			WHERE
				a.id = '" . $header_data->id . "'
					AND b.prop = ''
					AND c.prop = ''
					AND c.sisa > 0
		");
		if ($detail_obat_keluar_rows != null) {
			$dobat_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_dobat_keluar");
			$ks_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_kartu_stok");
			$stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
			$riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_riwayat_stok_obat");
			$stok_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat_keluar");
			foreach ($detail_obat_keluar_rows as $detail_obat_keluar_row) {
				$detail_data = array();
				$detail_data['id_obat_keluar'] = $id_obat_keluar;
				$detail_data['id_obat'] = $detail_obat_keluar_row->id_obat;
				$detail_data['kode_obat'] = $detail_obat_keluar_row->kode_obat;
				$detail_data['nama_obat'] = $detail_obat_keluar_row->nama_obat;
				$detail_data['nama_jenis_obat'] = $detail_obat_keluar_row->nama_jenis_obat;
				$detail_data['stok_entri'] = 0;
				$detail_data['harga_ma'] = $detail_obat_keluar_row->hna;
				$detail_data['jumlah_diminta'] = 0;
				$detail_data['jumlah'] = $detail_obat_keluar_row->sisa;
				$detail_data['satuan'] = $detail_obat_keluar_row->satuan;
				$detail_data['konversi'] = $detail_obat_keluar_row->konversi;
				$detail_data['satuan_konversi'] = $detail_obat_keluar_row->satuan_konversi;
				$detail_data['autonomous'] = "[".$this->getAutonomous()."]";
				$detail_data['duplicate'] = 0;
				$detail_data['time_updated'] = date("Y-m-d H:i:s");
				$detail_data['origin_updated'] = $this->getAutonomous();
				$detail_data['origin'] = $this->getAutonomous();
				$dobat_keluar_dbtable->insert($detail_data);
				$id_dobat_keluar = $dobat_keluar_dbtable->get_inserted_id();

				$detail_data = array();
				$detail_data['origin_id'] = $id_dobat_keluar;
				$detail_data_id = array();
				$detail_data_id['id'] = $id_dobat_keluar;
				$dobat_keluar_dbtable->update($detail_data, $detail_data_id);
				
				// Kartu Stok :
				$ks_data = array();
				$ks_data['f_id'] = $id_dobat_keluar;
				$ks_data['unit'] = ArrayAdapter::format("unslug", $slug_depo);
				$ks_data['no_bon'] = $id_obat_keluar;
				$ks_data['id_obat'] = $detail_obat_keluar_row->id_obat;
				$ks_data['kode_obat'] = $detail_obat_keluar_row->kode_obat;
				$ks_data['nama_obat'] = $detail_obat_keluar_row->nama_obat;
				$ks_data['nama_jenis_obat'] = $detail_obat_keluar_row->nama_jenis_obat;
				$ks_data['tanggal'] = date("Y-m-d");
				$ks_data['masuk'] = 0;
				$ks_data['keluar'] = $detail_obat_keluar_row->sisa;
				$ks_row = $this->dbtable->get_row("
					SELECT SUM(b.sisa) AS 'jumlah'
					FROM smis_fr_dobat_f_masuk a LEFT JOIN smis_fr_stok_obat b ON a.id = b.id_dobat_masuk
					WHERE b.prop NOT LIKE 'del' AND a.id_obat = '" . $detail_obat_keluar_row->id_obat . "'
				");
				$ks_data['sisa'] = $ks_row->jumlah - $detail_obat_keluar_row->jumlah;
				$ks_data['autonomous'] = "[".$this->getAutonomous()."]";
				$ks_data['duplicate'] = 0;
				$ks_data['time_updated'] = date("Y-m-d H:i:s");
				$ks_data['origin_updated'] = $this->getAutonomous();
				$ks_data['origin'] = $this->getAutonomous();
				$ks_dbtable->insert($ks_data);
				$id_kartu_stok = $ks_dbtable->get_inserted_id();

				$ks_data = array();
				$ks_data['origin_id'] = $id_kartu_stok;
				$ks_data_id = array();
				$ks_data_id['id'] = $id_kartu_stok;
				$ks_dbtable->update($ks_data, $ks_data_id);
				
				// Stok Obat
				$stok_data = array();
				$stok_data['sisa'] = 0;
				$stok_data['autonomous'] = "[".$this->getAutonomous()."]";
				$stok_data['duplicate'] = 0;
				$stok_data['time_updated'] = date("Y-m-d H:i:s");
				$stok_data['origin_updated'] = $this->getAutonomous();
				$stok_id['id'] = $detail_obat_keluar_row->id;
				$stok_dbtable->update($stok_data, $stok_id);

				// Riwayat Stok Obat
				$data_riwayat = array();
				$data_riwayat['tanggal'] = date("Y-m-d");
				$data_riwayat['id_stok_obat'] = $detail_obat_keluar_row->id;
				$data_riwayat['jumlah_keluar'] = $detail_obat_keluar_row->sisa;
				$data_riwayat['sisa'] = 0;
				$data_riwayat['keterangan'] = "Stok Keluar ke " . ArrayAdapter::format("unslug", $slug_depo);
				$data_riwayat['nama_user'] = $user->getName();
				$data_riwayat['autonomous'] = "[".$this->getAutonomous()."]";
				$data_riwayat['duplicate'] = 0;
				$data_riwayat['time_updated'] = date("Y-m-d H:i:s");
				$data_riwayat['origin_updated'] = $this->getAutonomous();
				$data_riwayat['origin'] = $this->getAutonomous();
				$riwayat_dbtable->insert($data_riwayat);
				$id_riwayat_stok = $riwayat_dbtable->get_inserted_id();

				$data_riwayat = array();
				$data_riwayat['origin_id'] = $id_riwayat_stok;
				$data_riwayat_id = array();
				$data_riwayat_id['id'] = $id_riwayat_stok;
				$riwayat_dbtable->update($data_riwayat, $data_riwayat_id);

				// Stok Obat Keluar
				$stok_keluar_data = array();
				$stok_keluar_data['id_dobat_keluar'] = $id_dobat_keluar;
				$stok_keluar_data['id_stok_obat'] = $detail_obat_keluar_row->id;
				$stok_keluar_data['jumlah'] = $detail_obat_keluar_row->sisa;
				$stok_keluar_data['autonomous'] = "[".$this->getAutonomous()."]";
				$stok_keluar_data['duplicate'] = 0;
				$stok_keluar_data['time_updated'] = date("Y-m-d H:i:s");
				$stok_keluar_data['origin_updated'] = $this->getAutonomous();
				$stok_keluar_data['origin'] = $this->getAutonomous();
				$stok_keluar_dbtable->insert($stok_keluar_data);
				$id_stok_obat_keluar = $stok_keluar_dbtable->get_inserted_id();

				$stok_keluar_data = array();
				$stok_keluar_data['origin_id'] = $id_stok_obat_keluar;
				$stok_keluar_data_id = array();
				$stok_keluar_data_id['id'] = $id_stok_obat_keluar;
				$stok_keluar_dbtable->update($stok_keluar_data, $stok_keluar_data_id);
			}
		}

		return $id_obat_keluar;
	}

	private function pushAutoConfirmObatMasukUnitData($id_obat_keluar) {
		$obat_keluar_row = $this->dbtable->get_row("
			SELECT *
			FROM smis_fr_obat_keluar
			WHERE id = '" . $id_obat_keluar . "'
		");
		$detail = $this->dbtable->get_result("
			SELECT 
				a.id AS 'id_stok_obat_keluar', b.id_obat, b.kode_obat, b.nama_obat, b.nama_jenis_obat, c.formularium, c.berlogo, c.generik, c.label, c.id_vendor, c.nama_vendor, a.jumlah, b.satuan, b.konversi, b.satuan_konversi, c.hna, c.produsen, c.tanggal_exp, c.no_batch, a.prop
			FROM 
				smis_fr_stok_obat_keluar a 
					LEFT JOIN smis_fr_stok_obat c ON a.id_stok_obat = c.id 
					LEFT JOIN smis_fr_dobat_keluar b ON a.id_dobat_keluar = b.id
			WHERE 
				b.id_obat_keluar = '" . $id_obat_keluar . "'
		");
		$command = "push_save";
		require_once("gudang_farmasi/service_consumer/PushObatServiceConsumer.php");
		$push_obat_service_consumer = new PushObatServiceConsumer($this->dbtable->get_db(), $obat_keluar_row->id, $obat_keluar_row->tanggal, $obat_keluar_row->unit, $obat_keluar_row->status, $obat_keluar_row->keterangan, $detail, $command);
		$push_obat_service_consumer->execute();
	}
}
?>