<?php
	require_once("smis-base/smis-include-service-consumer.php");
	global $db;

	$table = new Table(
		array("No.", "ID Obat", "Kode Obat", "Nama Obat", "Jenis Obat", "Margin", "HPP Tertinggi", "Tanggal Update", "Fix HJA", "HJA"),
		"Gudang Farmasi : Pengaturan Margin Jual Per Obat",
		null,
		true
	);
    $table->setName("pengaturan_margin");
    $table->setAddButtonEnable(false);
    $table->setReloadButtonEnable(false);
    $table->setPrintButtonEnable(false);
	$table->setDelButtonEnable(false);
	$synch_button = new Button("", "", "Perbarui Data Sesuai Data Master");
	$synch_button->setClass("btn-inverse");
	$synch_button->setIcon("fa fa-link");
	$synch_button->setIsButton(Button::$ICONIC);
	$synch_button->setAction("pengaturan_margin.downloadMasterData()");
	$table->addHeaderButton($synch_button);
	$download_button = new Button("", "", "Download XLS");
	$download_button->setClass("btn-inverse");
	$download_button->setIcon("fa fa-download");
	$download_button->setIsButton(Button::$ICONIC);
	$download_button->setAction("pengaturan_margin.exportXLS()");
	$table->addHeaderButton($download_button);

	$obat_table = new Table(
		array("No.", "ID Obat", "Kode Obat", "Nama Obat", "Jenis Obat"),
		"",
		null,
		true
	);
	$obat_table->setName("obat");
	$obat_table->setModel(Table::$SELECT);
	$obat_adapter = new SimpleAdapter(true, "No.");
	$obat_adapter->add("ID Obat", "id", "digit6");
	$obat_adapter->add("Kode Obat", "kode");
	$obat_adapter->add("Nama Obat", "nama");
	$obat_adapter->add("Jenis Obat", "nama_jenis_barang");
	$obat_service_responder = new ServiceResponder(
		$db,
		$obat_table,
		$obat_adapter,
		"get_daftar_barang_m"
	);
	$super_command = new SuperCommand();
	$super_command->addResponder("obat", $obat_service_responder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "export_xls") {
			ini_set("memory_limit", "256M");
			set_time_limit(0);

			$rows = $db->get_result("
				SELECT d.*, v.tanggal_update, CASE WHEN v.hpp_tertinggi IS NULL THEN 0 ELSE v.hpp_tertinggi END hpp_tertinggi, CASE WHEN v.hpp_tertinggi IS NULL THEN 0 ELSE (1 + d.margin_jual / 100) * v.hpp_tertinggi END hja
				FROM
				smis_fr_margin_jual_per_obat d LEFT JOIN (
					SELECT b.id_obat, a.tanggal_datang tanggal_update, MAX(c.hna) hpp_tertinggi
					FROM (smis_fr_obat_f_masuk a INNER JOIN smis_fr_dobat_f_masuk b ON a.id = b.id_obat_f_masuk) INNER JOIN smis_fr_stok_obat c ON b.id = c.id_dobat_masuk
					WHERE a.prop = '' AND b.prop = '' AND c.prop = ''
					GROUP BY b.id_obat
				) v ON v.id_obat = d.id_obat
				WHERE d.prop = ''
				ORDER BY d.nama_obat ASC
			");

			require_once ("smis-libs-out/php-excel/PHPExcel.php");

			$objPHPExcel = new PHPExcel();
			$objWorksheet = $objPHPExcel->getActiveSheet();
			$objWorksheet->setTitle("Data Margin Obat");
			$i = 1;

			$objWorksheet->mergeCells("A" . $i . ":I" . $i)->setCellValue("A" . $i, getSettings($db, "smis_autonomous_name", "SIM RUMAH SAKIT"));
			$objWorksheet->getStyle("A" . $i . ":I" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objWorksheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 1;
			$objWorksheet->mergeCells("A" . $i . ":I" . $i)->setCellValue("A" . $i, "Unit : Gudang Farmasi");
			$objWorksheet->getStyle("A" . $i . ":I" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objWorksheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 1;
			$objWorksheet->mergeCells("A" . $i . ":I" . $i)->setCellValue("A" . $i, "Data Margin Jual");
			$objWorksheet->getStyle("A" . $i . ":I" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objWorksheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 2;

			$border_start = $i;
			$col = "A";
			$head = array("No.", "ID Obat", "Kode Obat", "Nama Obat", "Jenis Obat", "Margin", "HPP Tertinggi", "Tanggal Update", "HJA");
			foreach ($head as $h)
				$objWorksheet->setCellValue($col++ . $i, $h);
			$objWorksheet->getStyle("A" . $i . ":I" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objWorksheet->getStyle("A" . $i . ":I" . $i)->getFont()->setBold(true);
			$objWorksheet->getStyle("A" . $i . ":I" . $i)->applyFromArray(
			    array(
			        'fill' => array(
			            'type' => PHPExcel_Style_Fill::FILL_SOLID,
			            'color' => array('rgb' => '808080')
			        )
			    )
			);
			$i = $i + 1;

			$data = json_decode($_POST['d_data']);
			if ($rows != null) {
				$number = 1;
				foreach ($rows as $row) {
					$objWorksheet->setCellValue("A" . $i, $number++);
					$objWorksheet->setCellValue("B" . $i, $row->id_obat);
					$objWorksheet->setCellValue("C" . $i, $row->kode_obat);
					$objWorksheet->setCellValue("D" . $i, $row->nama_obat);
					$objWorksheet->setCellValue("E" . $i, $row->nama_jenis_obat);
					$objWorksheet->setCellValue("F" . $i, $row->margin_jual);
					$objWorksheet->setCellValue("G" . $i, $row->hpp_tertinggi);
					$objWorksheet->setCellValue("H" . $i, ArrayAdapter::format("date d-m-Y", $row->tanggal_update));
					$objWorksheet->setCellValue("I" . $i, $row->hja);
					$objWorksheet->getStyle("G" . $i)->getNumberFormat()->setFormatCode('#,##0.00');
					$objWorksheet->getStyle("I" . $i)->getNumberFormat()->setFormatCode('#,##0.00');
					$i = $i + 1;
				}
			}

			$thin = array();
			$thin['borders'] = array();
			$thin['borders']['allborders'] = array();
			$thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
			$objWorksheet->getStyle("A" . $border_start . ":I" . $i)->applyFromArray($thin);

			foreach (range('A', 'I') as $columnID)
		    	$objWorksheet->getColumnDimension($columnID)->setAutoSize(true);

			header("Content-type: application/vnd.ms-excel");	
			header("Content-Disposition: attachment; filename=DATA MARGIN JUAL OBAT - GUDANG FARMASI.xlsx");
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objWriter->save("php://output");
			return;
		}
		$dbtable = new DBTable($db, "smis_fr_margin_jual_per_obat");
		if ($_POST['command'] == "list") {
			$filter = "";
			$filter_v = "";
			if (isset($_POST['kriteria'])) {
				$filter_v = " AND (c.nama_obat LIKE '%" . $_POST['kriteria'] . "%') ";
				$filter = " AND (d.nama_obat LIKE '%" . $_POST['kriteria'] . "%') ";
			}
			$query_value = "
				SELECT d.*, v.tanggal_update, CASE WHEN v.hpp_tertinggi IS NULL THEN 0 ELSE v.hpp_tertinggi END hpp_tertinggi, 
					IF(fix_hja = 0, CASE WHEN v.hpp_tertinggi IS NULL THEN 0 ELSE (1 + d.margin_jual / 100) * v.hpp_tertinggi END, harga_jual) hja
				FROM
				smis_fr_margin_jual_per_obat d LEFT JOIN (
					SELECT b.id_obat, a.tanggal_datang tanggal_update, MAX(c.hna) hpp_tertinggi
					FROM (smis_fr_obat_f_masuk a INNER JOIN smis_fr_dobat_f_masuk b ON a.id = b.id_obat_f_masuk) INNER JOIN smis_fr_stok_obat c ON b.id = c.id_dobat_masuk
					WHERE a.prop = '' AND b.prop = '' AND c.prop = '' " . $filter_v . "
					GROUP BY b.id_obat
				) v ON v.id_obat = d.id_obat
				WHERE d.prop = '' " . $filter . "
				ORDER BY d.nama_obat ASC
			";
			$query_count = "
				SELECT COUNT(*)
				FROM (
					" . $query_value . "
				) v
			";
			$dbtable->setPreferredQuery(true, $query_value, $query_count);
		}
        if ($_POST['command'] == "download_data_master") {
            $rows = $dbtable->get_result("
                SELECT 
                    id id_obat, kode kode_obat, nama nama_obat, nama_jenis_barang nama_jenis_obat
                FROM 
                    smis_pr_barang
                WHERE 
                    prop = '' AND medis = '1' AND inventaris = '0' AND id NOT IN (
                        SELECT 
                            DISTINCT id_obat 
                        FROM 
                            smis_fr_margin_jual_per_obat 
                        WHERE prop = ''
                    )
			");
            if ($rows != null) {
                $default_margin = 100;
                $autonomous = "[" . getSettings($db, "smis_autonomous_id", "") . "]";
                $duplicate = 0;
                $time_updated = date("Y-m-d H:i:s");
				$origin_updated = getSettings($db, "smis_autonomous_id", "");
                foreach ($rows as $row) {
					$margin_data = array(
						'id_obat' 			=> $row->id_obat,
						'kode_obat'			=> $row->kode_obat, 
						'nama_obat'			=> $row->nama_obat, 
						'nama_jenis_obat'	=> $row->nama_jenis_obat, 
						'margin_jual'		=> $default_margin, 
						'autonomous'		=> $autonomous, 
						'duplicate'			=> $duplicate, 
						'time_updated'		=> $time_updated,
						'origin_updated'	=> $origin_updated
					);
					$dbtable->insert($margin_data);

					$params = array(
						'id_obat' 			=> $row->id_obat,
						'kode_obat'			=> $row->kode_obat,
						'nama_obat'			=> $row->nama_obat,
						'nama_jenis_obat'	=> $row->nama_jenis_obat,
						'margin_jual'		=> $default_margin
					);
					$service_consumer = new ServiceConsumer(
						$db,
						"push_margin_jual_per_obat",
						$params
					);
					$service_consumer->execute();
				}
				$data['success'] = 1;
				echo json_encode($data);
            }
            return;
		}
		if ($_POST['command'] == "get_max_hpp") {
			$id_obat = $_POST['id_obat'];
			$row = $dbtable->get_row("
				SELECT MAX(a.hna) hpp, c.tanggal_datang 
				FROM (smis_fr_stok_obat a INNER JOIN smis_fr_dobat_f_masuk b ON a.id_dobat_masuk = b.id) INNER JOIN smis_fr_obat_f_masuk c ON  b.id_obat_f_masuk = c.id 
				WHERE a.prop = '' AND b.prop = '' AND c.prop = '' AND b.id_obat = '" . $id_obat . "'
			");
			$hpp = "Rp. 0,00";
			$tanggal_update = "-";
			if ($row != null) {
				$hpp = $row->hpp == 0 ? "Rp. 0,00" : ArrayAdapter::format("only-money", $row->hpp);
				$tanggal_update = ArrayAdapter::format("date d-m-Y", $row->tanggal_datang);
			}
			echo json_encode(array(
				"hpp" 				=> $hpp,
				"tanggal_update"	=> $tanggal_update
			));
			return;
		}
		if ($_POST['command'] == "save") {
			$params = array(
				'id_obat' 			=> $_POST['id_obat'],
				'kode_obat'			=> $_POST['kode_obat'],
				'nama_obat'			=> $_POST['nama_obat'],
				'nama_jenis_obat'	=> $_POST['nama_jenis_obat'],
				'margin_jual'		=> $_POST['margin_jual']
			);
			$service_consumer = new ServiceConsumer(
				$db,
				"push_margin_jual_per_obat",
				$params
			);
			$service_consumer->execute();
		}
		$adapter = new SimpleAdapter(true, "No.");
		$adapter->add("ID Obat", "id_obat", "digit6");
		$adapter->add("Kode Obat", "kode_obat");
		$adapter->add("Nama Obat", "nama_obat");
		$adapter->add("Jenis Obat", "nama_jenis_obat");
		$adapter->add("Margin", "margin_jual", "money");
		$adapter->add("HPP Tertinggi", "hpp_tertinggi", "money");
		$adapter->add("Tanggal Update", "tanggal_update", "date d-m-Y");
		$adapter->add("Fix HJA", "fix_hja", "trivial_0_Tidak_Ya");
		$adapter->add("HJA", "hja", "money");
		$dbresponder = new DBResponder(
			$dbtable,
			$table,
			$adapter
		);
		$data = $dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}

	$modal = new Modal("pengaturan_margin_add_form", "smis_form_container", "pengaturan_margin");
	$modal->setTitle("Data Margin Jual Obat");
	$id_hidden = new Hidden("pengaturan_margin_id", "pengaturan_margin_id", "");
	$modal->addElement("", $id_hidden);
	$id_obat_text = new Text("pengaturan_margin_id_obat", "pengaturan_margin_id_obat", "");
	$id_obat_text->setAtribute("disabled='disabled'");
	$modal->addElement("ID Obat", $id_obat_text);
	$kode_obat_text = new Text("pengaturan_margin_kode_obat", "pengaturan_margin_kode_obat", "");
	$kode_obat_text->setAtribute("disabled='disabled'");
	$modal->addElement("Kode Obat", $kode_obat_text);
	$nama_obat_text = new Text("pengaturan_margin_nama_obat", "pengaturan_margin_nama_obat", "");
	$nama_obat_text->setAtribute("disabled='disabled'");
	$modal->addElement("Nama Obat", $nama_obat_text);
	$nama_jenis_obat_text = new Text("pengaturan_margin_nama_jenis_obat", "pengaturan_margin_nama_jenis_obat", "");
	$nama_jenis_obat_text->setAtribute("disabled='disabled'");
	$modal->addElement("Jenis Obat", $nama_jenis_obat_text);
	$tanggal_update_text = new Text("pengaturan_margin_tanggal_update", "pengaturan_margin_tanggal_update", "");
	$tanggal_update_text->setAtribute("disabled=disabled");
	$modal->addElement("Tanggal Update", $tanggal_update_text);
	$hpp_max_text = new Text("pengaturan_margin_hpp_max", "pengaturan_margin_hpp_max", "");
	$hpp_max_text->setAtribute("disabled='disabled'");
	$modal->addElement("Maks. HPP *", $hpp_max_text);
	$fix_hja_checkbox = new CheckBox("pengaturan_margin_fix_hja", "", "");
	$modal->addElement("Fix HJA", $fix_hja_checkbox);
	$harga_jual_text = new Text("pengaturan_margin_harga_jual", "pengaturan_margin_harga_jual", "");
	$harga_jual_text->setTypical("money");
	$harga_jual_text->setAtribute(" data-thousands=\".\" data-decimal=\",\"  data-precision=\"2\" disabled='disabled'" );
	$modal->addElement("HJA", $harga_jual_text);
	$margin_jual_text = new Text("pengaturan_margin_margin_jual", "pengaturan_margin_margin_jual", "");
	$modal->addElement("Margin Jual", $margin_jual_text);
	$save_button = new Button("", "", "Simpan");
	$save_button->setClass("btn-success");
	$save_button->setAction("pengaturan_margin.save()");
	$save_button->setIcon("fa fa-floppy-o");
	$save_button->setIsButton(Button::$ICONIC);
	$modal->addFooter($save_button);
	
	echo $modal->getHtml();
	echo $table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("gudang_farmasi/js/pengaturan_margin_obat_action.js", false);
	echo addJS("gudang_farmasi/js/pengaturan_margin.js", false);
?>