<?php
    global $db;

    $table = new Table(
        array("No.", "Depo Farmasi", "Faskes"),
        "Gudang Farmasi : Pengaturan Depo Farmasi - Faskes",
        null,
        true
    );
    $table->setName("pengaturan_depo_faskes");
    $table->setPrintButtonEnable(false);
    $table->setReloadButtonEnable(false);

    if (isset($_POST['command'])) {
        if ($_POST['command'] == "check_exist_data") {
            $depo = $_POST['depo'];
            $faskes = $_POST['faskes'];
            $result = $db->get_var("
                SELECT
                    COUNT(*) jumlah
                FROM
                    smis_fr_faskes_depo
                WHERE
                    prop = ''
                        AND (depo LIKE '" . $depo . "' OR faskes LIKE '" . $faskes . "')
            ");
            echo json_encode($result);
            return;
        }
        $adapter = new SimpleAdapter(true, "No.");
        $adapter->add("Depo Farmasi", "depo", "unslug");
        $adapter->add("Faskes", "faskes");
        $dbtable = new DBTable($db, "smis_fr_faskes_depo");
        $dbresponder = new DBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    $modal = new Modal("pengaturan_depo_faskes_add_form", "", "Data Depo Farmasi - Faskes");
    $id_hidden = new Hidden("pengaturan_depo_faskes_id", "pengaturan_depo_faskes_id", "");
    $modal->addElement("", $id_hidden);
    $faskes_rows = $db->get_result("
        SELECT
            nama
        FROM
            smis_rg_faskes
        WHERE
            prop = ''
        ORDER BY
            nama ASC
    ");
    $faskes_option = new OptionBuilder();
    $faskes_option->add("", "", 1);
    if ($faskes_rows != null) {
        foreach ($faskes_rows as $faskes_row) {
            $faskes_option->addSingle($faskes_row->nama);
        }
    }
    $faskes_select = new Select("pengaturan_depo_faskes_faskes", "pengaturan_depo_faskes_faskes", $faskes_option->getContent());
    $modal->addElement("Faskes", $faskes_select);
    $depo_option = new OptionBuilder();
    $depo_option->add("", "", 1);
    $depo_option->add("Depo Farmasi Batam Centre", "depo_farmasi_batam_centre");
    $depo_option->add("Depo Farmasi Batu Aji", "depo_farmasi_batu_aji");
    $depo_option->add("Depo Farmasi Bengkong", "depo_farmasi_bengkong");
    $depo_option->add("Depo Farmasi Jodoh", "depo_farmasi_jodoh");
    $depo_option->add("Depo Farmasi Panbil", "depo_farmasi_panbil");
    $depo_option->add("Depo Farmasi Piayu", "depo_farmasi_piayu");
    $depo_option->add("Depo Farmasi Sekupang", "depo_farmasi_sekupang");
    $depo_option->add("Depo Farmasi Tanjung Uncang", "depo_farmasi_tanjung_uncang");
    $depo_option->add("Depo Farmasi Utama", "depo_farmasi_utama");
    $depo_select = new Select("pengaturan_depo_faskes_depo", "pengaturan_depo_faskes_depo", $depo_option->getContent());
    $modal->addElement("Depo Farmasi", $depo_select);
    $button = new Button("", "", "Simpan");
    $button->setClass("btn btn-success");
    $button->setAction("pengaturan_depo_faskes.save()");
    $modal->addFooter($button);

    echo $modal->getHtml();
    echo $table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
    var pengaturan_depo_faskes;
    $(document).ready(function() {
        pengaturan_depo_faskes = new TableAction(
            "pengaturan_depo_faskes",
            "gudang_farmasi",
            "pengaturan_depo_faskes",
            new Array("id", "depo", "faskes")
        );
        pengaturan_depo_faskes.validate = function() {
            var valid = true;
            var invalid_msg = "";
            var faskes = $("#pengaturan_depo_faskes_faskes").val();
            var depo = $("#pengaturan_depo_faskes_depo").val();
            $(".error_field").removeClass("error_field");
            if (faskes == "") {
                valid = false;
                invalid_msg += "</br><strong>Faskes</strong> tidak boleh kosong";
                $("#pengaturan_depo_faskes_faskes").addClass("error_field");
            }
            if (depo == "") {
                valid = false;
                invalid_msg += "</br><strong>Depo Farmasi</strong> tidak boleh kosong";
                $("#pengaturan_depo_faskes_depo").addClass("error_field");
            }
            if (!valid) {
                $("#modal_alert_pengaturan_depo_faskes_add_form").html(
                    "<div class='alert alert-block alert-danger'>" +
                        "<h4>Peringatan</h4>" +
                        invalid_msg +
                    "</div>"
                );
            }
            return valid;
        };
        pengaturan_depo_faskes.save = function() {
            if (!this.validate()) {
                return;
            }
            var self = this;
            var faskes = $("#pengaturan_depo_faskes_faskes").val();
            var depo = $("#pengaturan_depo_faskes_depo").val();
            var data = this.getRegulerData();
            data['command'] = "check_exist_data";
            data['faskes'] = faskes;
            data['depo'] = depo;
            showLoading();
            $.post(
                "",
                data,
                function(check_response) {
                    var check_json = JSON.parse(check_response);
                    if (check_json == null) {
                        dismissLoading();
                        return;
                    }
                    if (check_json > 0) {
                        dismissLoading();
                        $("#modal_alert_pengaturan_depo_faskes_add_form").html(
                            "<div class='alert alert-block alert-danger'>" +
                                "<h4>Peringatan</h4>" +
                                "</br><strong>Faskes/Depo Farmasi</strong> sudah dikonfigurasi." +
                            "</div>"
                        );
                        return;
                    }
                    data = self.getSaveData();
                    $.post(
                        "",
                        data,
                        function(response) {
                            var json = getContent(response);
                            if (json == null) {
                                dismissLoading();
                                return;
                            }
                            dismissLoading();
                            self.clear();
                            $("#pengaturan_depo_faskes_add_form").smodal("hide");
                            self.view();
                        }
                    );
                }
            );
        };
        pengaturan_depo_faskes.view();
    });
</script>