<?php
	require_once("smis-base/smis-include-duplicate.php");
	global $db;

	$obat_table = new Table(
		array("No.", "Obat", "Jenis Obat"),
		"",
		null,
		true
	);
	$obat_table->setName("obat");
	$obat_table->setModel(Table::$SELECT);
	$obat_adapter = new SimpleAdapter(true, "No.");
	$obat_adapter->add("ID", "id");
	$obat_adapter->add("Obat", "nama");
	$obat_adapter->add("Jenis Obat", "nama_jenis_barang");
	$obat_dbtable = new DBTable($db, "smis_pr_barang");
	$obat_dbtable->addCustomKriteria(" medis ", " = '1' ");
	$obat_dbtable->addCustomKriteria(" inventaris ", " = '0' ");
	$obat_dbtable->setOrder(" id DESC ");
	$obat_dbresponder = new DBResponder(
		$obat_dbtable,
		$obat_table,
		$obat_adapter
	);
	$super_command = new SuperCommand();
	$super_command->addResponder("obat", $obat_dbresponder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}

	$table = new Table(
		array("No.", "Obat", "Jenis Obat", "Stok Minimum", "Stok Maksimum", "Satuan"),
		"Gudang Farmasi : Pengaturan Batas Stok",
		null,
		true
	);
	$table->setName("pengaturan_batas_stok_unit");

	if (isset($_POST['command'])) {
		$adapter = new SimpleAdapter(true, "No.");
		$adapter->add("Obat", "nama_obat");
		$adapter->add("Jenis Obat", "nama_jenis_obat");
		$adapter->add("Stok Minimum", "stok_minimum", "number");
		$adapter->add("Stok Maksimum", "stok_maksimum", "number");
		$adapter->add("Satuan", "satuan");
		$dbtable = new DBTable($db, "smis_fr_stok_obat_min_maks");
		$dbresponder = new DuplicateResponder(
			$dbtable,
			$table,
			$adapter
		);
		$data = $dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}

	$modal = new Modal("pengaturan_batas_stok_unit_add_form", "smis_form_container", "pengaturan_batas_stok_unit");
	$modal->setTitle("Data Pengaturan Batas Stok Obat");
	$id_hidden = new Hidden("pengaturan_batas_stok_unit_id", "pengaturan_batas_stok_unit_id", "");
	$modal->addElement("", $id_hidden);
	$id_obat_hidden = new Hidden("pengaturan_batas_stok_unit_id_obat", "pengaturan_batas_stok_unit_id_obat", "");
	$modal->addElement("", $id_obat_hidden);
	$nama_obat_text = new Text("pengaturan_batas_stok_unit_nama_obat", "pengaturan_batas_stok_unit_nama_obat", "");
	$nama_obat_text->setAtribute("disabled='disabled'");
	$nama_obat_text->setClass("smis-one-option-input");
	$nama_obat_button = new Button("", "", "Pilih");
	$nama_obat_button->setAtribute("id='obat_btn'");
	$nama_obat_button->setClass("btn-info");
	$nama_obat_button->setIsButton(Button::$ICONIC);
	$nama_obat_button->setIcon("icon-white ".Button::$icon_list_alt);
	$nama_obat_button->setAction("obat.chooser('obat', 'obat_button', 'obat', obat, 'Obat')");
	$nama_obat_input_group = new InputGroup("");
	$nama_obat_input_group->addComponent($nama_obat_text);
	$nama_obat_input_group->addComponent($nama_obat_button);
	$modal->addElement("Nama Obat", $nama_obat_input_group);
	$jenis_obat_text = new Text("pengaturan_batas_stok_unit_nama_jenis_obat", "pengaturan_batas_stok_unit_nama_jenis_obat", "");
	$jenis_obat_text->setAtribute("disabled='disabled'");
	$modal->addElement("Jenis Obat", $jenis_obat_text);
	$stok_minimum_text = new Text("pengaturan_batas_stok_unit_stok_minimum", "pengaturan_batas_stok_unit_stok_minimum", "");
	$modal->addElement("Batas Min.", $stok_minimum_text);
	$stok_maksimum_text = new Text("pengaturan_batas_stok_unit_stok_maksimum", "pengaturan_batas_stok_unit_stok_maksimum", "");
	$modal->addElement("Batas Maks.", $stok_maksimum_text);
	$satuan_text = new Text("pengaturan_batas_stok_unit_satuan", "pengaturan_batas_stok_unit_satuan", "");
	$satuan_text->setAtribute("disabled='disabled'");
	$modal->addElement("Satuan", $satuan_text);
	$save_button = new Button("", "", "Simpan");
	$save_button->setClass("btn-success");
	$save_button->setAction("pengaturan_batas_stok_unit.save()");
	$save_button->setIcon("fa fa-floppy-o");
	$save_button->setIsButton(Button::$ICONIC);
	$modal->addFooter($save_button);

	echo $modal->getHtml();
	echo $table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	function ObatAction(name, page, action, columns) {
		this.initialize(name, page, action, columns);
	}
	ObatAction.prototype.constructor = ObatAction;
	ObatAction.prototype = new TableAction();
	ObatAction.prototype.selected = function(json) {
		$("#pengaturan_batas_stok_unit_id_obat").val(json.id);
		$("#pengaturan_batas_stok_unit_nama_obat").val(json.nama);
		$("#pengaturan_batas_stok_unit_nama_jenis_obat").val(json.nama);
		$("#pengaturan_batas_stok_unit_satuan").val(json.satuan_konversi);
	};

	var pengaturan_batas_stok_unit;
	var obat;
	$(document).ready(function() {
		obat = new ObatAction(
			'obat',
			'gudang_farmasi',
			'pengaturan_batas_stok_unit',
			new Array()
		);
		obat.setSuperCommand('obat');

		var columns = new Array('id', 'id_obat', 'nama_obat', 'nama_jenis_obat', 'stok_minimum', 'stok_maksimum', 'satuan');
		pengaturan_batas_stok_unit = new TableAction(
			'pengaturan_batas_stok_unit',
			'gudang_farmasi',
			'pengaturan_batas_stok_unit',
			columns
		);
		pengaturan_batas_stok_unit.validate = function() {
			var valid = true;
			var invalid_msg = "";
			var id_obat = $("#pengaturan_batas_stok_unit_id_obat").val();
			var stok_minimum = $("#pengaturan_batas_stok_unit_stok_minimum").val();
			var stok_maksimum = $("#pengaturan_batas_stok_unit_stok_maksimum").val();
			$(".error_field").removeClass("error_field");
			if (id_obat == "") {
				valid = false;
				invalid_msg += "</br><strong>Obat</strong> tidak boleh kosong";
				$("#pengaturan_batas_stok_unit_nama_obat").addClass("error_field");
			}
			if (stok_minimum == "") {
				valid = false;
				invalid_msg += "</br><strong>Batas Min.</strong> tidak boleh kosong";
				$("#pengaturan_batas_stok_unit_stok_minimum").addClass("error_field");
			}
			if (stok_maksimum == "") {
				valid = false;
				invalid_msg += "</br><strong>Batas Max.</strong> tidak boleh kosong";
				$("#pengaturan_batas_stok_unit_stok_maksimum").addClass("error_field");
			}
			if (stok_minimum != "" && stok_maksimum != "") {
				if (!is_numeric(stok_minimum)) {
					valid = false;
					invalid_msg += "</br><strong>Batas Min.</strong> harus numerik (0 - 9)";
					$("#pengaturan_batas_stok_unit_stok_minimum").addClass("error_field");
				}
				if (!is_numeric(stok_maksimum)) {
					valid = false;
					invalid_msg += "</br><strong>Batas Maks.</strong> harus numerik (0 - 9)";
					$("#pengaturan_batas_stok_unit_stok_maksimum").addClass("error_field");
				}
				if (is_numeric(stok_minimum) && is_numeric(stok_maksimum)) {
					if (parseFloat(stok_maksimum) < parseFloat(stok_minimum)) {
						valid = false;
						invalid_msg += "</br><strong>Batas Maks.</strong> tidak diperkenankan lebih kecil daripada <strong>Batas Min.</strong>";
						$("#pengaturan_batas_stok_unit_stok_minimum").addClass("error_field");
						$("#pengaturan_batas_stok_unit_stok_maksimum").addClass("error_field");
					}
				}
			}
			if (!valid) {
				$("#modal_alert_pengaturan_batas_stok_unit_add_form").html(
					"<div class='alert alert-block alert-danger'>" +
						"<h4>Peringatan</h4>" +
						invalid_msg +
					"</div>"
				);
			}
			return valid;
		};
		pengaturan_batas_stok_unit.save = function() {
			if (!this.validate())
				return;
			TableAction.prototype.save.call(this);
		};
		pengaturan_batas_stok_unit.view();
	});
</script>
