<?php
	require_once 'smis-base/smis-include-service-consumer.php';
	global $db;

	//get_daftar_vendor_consumer:
	$vendor_table = new Table(
		array("Nama", "NPWP", "Alamat", "No. Telp."),
		"",
		null,
		true
	);
	$vendor_table->setName("lrrp_vendor");
	$vendor_table->setModel(Table::$SELECT);
	$vendor_adapter = new SimpleAdapter();
	$vendor_adapter->add("Nama", "nama");
	$vendor_adapter->add("NPWP", "npwp");
	$vendor_adapter->add("Alamat", "alamat");
	$vendor_adapter->add("No. Telp.", "telpon");
	$vendor_service_responder = new ServiceResponder(
		$db,
		$vendor_table,
		$vendor_adapter,
		"get_daftar_vendor"
	);

	$super_command = new SuperCommand();
	$super_command->addResponder("lrrp_vendor", $vendor_service_responder);
	$init = $super_command->initialize();
	if ($init != null) {
		echo $init;
		return;
	}

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "get_item_number") {
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$id_vendor = $_POST['id_vendor'];
			$dbtable = new DBTable($db, "smis_fr_retur_obat");
			$row = $dbtable->get_row("
				SELECT COUNT(*) AS 'jumlah'
				FROM smis_fr_retur_obat
				WHERE prop = '' AND tanggal >= '" . $tanggal_from . "' AND tanggal <= '" . $tanggal_to . "' AND id_vendor LIKE '" . $id_vendor . "'
			");
			$data = array();
			$data['jumlah'] = $row->jumlah;
			echo json_encode($data);
		} else if ($_POST['command'] == "get_item_info") {
			$num = $_POST['num'];
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$id_vendor = $_POST['id_vendor'];
			$dbtable = new DBTable($db, "smis_fr_retur_obat");
			$html = "";
			$header_row = $dbtable->get_row("
				SELECT a.id, a.tanggal AS 'tanggal_retur', a.tanggal_faktur, b.no_bbm, a.no_faktur, a.nama_vendor
				FROM smis_fr_retur_obat a LEFT JOIN smis_fr_obat_f_masuk b ON a.id_obat_f_masuk = b.id
				WHERE a.prop = '' AND a.tanggal >= '" . $tanggal_from . "' AND a.tanggal <= '" . $tanggal_to . "' AND a.id_vendor LIKE '" . $id_vendor . "'
				LIMIT " . $num . ", 1
			");
			$detail_rows = $dbtable->get_result("
				SELECT c.id_obat, b.kode_obat, b.nama_obat, b.nama_jenis_obat, a.jumlah, b.hna, b.produsen, b.tanggal_exp, a.keterangan
				FROM (smis_fr_dretur_obat a LEFT JOIN smis_fr_stok_obat b ON a.id_stok_obat = b.id) LEFT JOIN smis_fr_dobat_f_masuk c ON b.id_dobat_masuk = c.id
				WHERE a.id_retur_obat = '" . $header_row->id . "'
			");
			$total_subtotal = 0;
			$num_is_exist = false;
			foreach ($detail_rows as $detail_row) {
				$nomor = "";
				if (!$num_is_exist) {
					$nomor = $num + 1;
					$num_is_exist = true;
				}
				$html .= "
					<tr>
						<td id='lrrp_nomor'><small>" . $nomor . "</small></td>
						<td id='lrrp_tanggal_retur'><small>" . ArrayAdapter::format("date d-m-Y", $header_row->tanggal_retur) . "</small></td>
						<td id='lrrp_tanggal_faktur'><small>" . ArrayAdapter::format("date d-m-Y", $header_row->tanggal_faktur) . "</small></td>
						<td id='lrrp_no_bbm'><small>" . $header_row->no_bbm . "</small></td>
						<td id='lrrp_no_faktur'><small>" . $header_row->no_faktur . "</small></td>
						<td id='lrrp_nama_vendor'><small>" . $header_row->nama_vendor . "</small></td>
						<td id='lrrp_id_obat'><small>" . $detail_row->id_obat . "</small></td>
						<td id='lrrp_kode_obat'><small>" . $detail_row->kode_obat . "</small></td>
						<td id='lrrp_nama_obat'><small>" . $detail_row->nama_obat . "</small></td>
						<td id='lrrp_nama_jenis_obat'><small>" . $detail_row->nama_jenis_obat . "</small></td>
						<td id='lrrp_jumlah'><small>" . ArrayAdapter::format("number", $detail_row->jumlah) . "</small></td>
						<td id='lrrp_hpp'><small><div align='right'>" . ArrayAdapter::format("only-money", $detail_row->hna) . "</div></small></td>
						<td id='lrrp_total' style='display: none;'>" . round($detail_row->jumlah * $detail_row->hna) . "</td>
						<td id='lrrp_f_total'><small><div align='right'>" . ArrayAdapter::format("only-money", round($detail_row->jumlah * $detail_row->hna)) . "</div></small></td>
						<td id='lrrp_produsen'><small>" . $detail_row->produsen . "</small></td>
						<td id='lrrp_tanggal_exp'><small>" . ArrayAdapter::format("date d-m-Y", $detail_row->tanggal_exp) . "</small></td>
						<td id='lrrp_keterangan'><small>" . $detail_row->keterangan . "</small></td>
					</tr>
				";
				$total_subtotal += round($detail_row->jumlah * $detail_row->hna);
			}
			$html .= "
				<tr>
					<td colspan='12' style='vertical-align: middle !important;'><center><small><strong>SUBTOTAL</strong></small></center></td>
					<td id='lrrp_t_subtotal' style='display: none;'>" . $total_subtotal . "</td>
					<td id='lrrp_f_t_subtotal'><strong><small><div align='right'>" . ArrayAdapter::format("only-money", $total_subtotal) . "</div></small></strong></td>
					<td colspan='3'></td>
				</tr>
			";
			$data = array();
			$data['id'] = $header_row->id;
			$data['nama_vendor'] = $header_row->nama_vendor;
			$data['html'] = $html;
			echo json_encode($data);
		} else if ($_POST['command'] == "download") {
			$nama_entitas = getSettings($db, "smis_autonomous_title", "");
			$alamat_entitas = getSettings($db, "smis_autonomous_address", "");
			set_time_limit(0);
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			require_once("smis-libs-out/php-excel/PHPExcel.php");
			$objPHPExcel = PHPExcel_IOFactory::load("gudang_farmasi/templates/rincian_retur_pembelian_template.xlsx");
			$objPHPExcel->setActiveSheetIndexByName("Rincian Retur Pembelian");
			$objWorksheet = $objPHPExcel->getActiveSheet();
			$objWorksheet->setCellValue("A1", ArrayAdapter::format("unslug", $nama_entitas));
			$objWorksheet->setCellValue("A2", $alamat_entitas);
			$objWorksheet->setCellValue("A4", "Laporan Rincian Retur Pembelian Tanggal : " . ArrayAdapter::format("date d-m-Y", $tanggal_from) . " s/d " . ArrayAdapter::format("date d-m-Y", $tanggal_to));			
			$data = json_decode($_POST['d_data']);
			$start_row_num = 7;
			$end_row_num = 7;
			$row_num = $start_row_num;
			foreach ($data as $d) {
				if ($d->label == "detail") {
					$col_num = 0;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nomor);
					$col_num++;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, ArrayAdapter::format("date d-m-Y", $d->tanggal_retur));
					$col_num++;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, ArrayAdapter::format("date d-m-Y", $d->tanggal_faktur));
					$col_num++;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->no_bbm);
					$col_num++;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->no_faktur);
					$col_num++;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nama_vendor);
					$col_num++;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->id_obat);
					$col_num++;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->kode_obat);
					$col_num++;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nama_obat);
					$col_num++;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->nama_jenis_obat);
					$col_num++;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->jumlah);
					$objWorksheet->getStyle("K" . $row_num)->getNumberFormat()->setFormatCode("#,##0");
					$col_num++;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->hpp);
					$objWorksheet->getStyle("L" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
					$col_num++;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->subtotal);
					$objWorksheet->getStyle("M" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
					$col_num++;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->produsen);
					$col_num++;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->tanggal_exp);
					$col_num++;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->keterangan);
					$style = array(
						"font"		=> array(
							"bold"			=> false
						)
					);
					$objWorksheet->getStyle("A" . $row_num . ":P" . $row_num)->applyFromArray($style);
					$style = array(
						"alignment"	=> array(
							"horizontal"	=> PHPExcel_Style_Alignment::HORIZONTAL_LEFT
						)
					);
					$objWorksheet->getStyle("A" . $row_num . ":J" . $row_num)->applyFromArray($style);
					$objWorksheet->getStyle("P" . $row_num . ":P" . $row_num)->applyFromArray($style);
					$style = array(
						"alignment"	=> array(
							"horizontal"	=> PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
						)
					);
					$objWorksheet->getStyle("K" . $row_num . ":O" . $row_num)->applyFromArray($style);
				} else {
					$objWorksheet->mergeCells("A" . $row_num . ":L" . $row_num);
					$style = array(
						"alignment"	=> array(
							"horizontal"	=> PHPExcel_Style_Alignment::HORIZONTAL_CENTER
						),
						"font"		=> array(
							"bold"			=> true
						)
					);
					$objWorksheet->getStyle("A" . $row_num . ":P" . $row_num)->applyFromArray($style);
					$style = array(
						"alignment"	=> array(
							"horizontal"	=> PHPExcel_Style_Alignment::HORIZONTAL_RIGHT
						)
					);
					$objWorksheet->getStyle("K" . $row_num . ":O" . $row_num)->applyFromArray($style);
					$col_num = 0;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, "SUBTOTAL");
					$col_num += 12;
					$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d->t_subtotal);
					$objWorksheet->getStyle("M" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
					$objWorksheet->mergeCells("N" . $row_num . ":P" . $row_num);
				}
				$objWorksheet->insertNewRowBefore($row_num + 1, 1);
				$row_num++;
				$end_row_num++;
			}
			$objWorksheet->getRowDimension($row_num)->setVisible(false);
			$objWorksheet->getRowDimension($row_num + 1)->setVisible(false);
			
			header("Content-type: application/vnd.ms-excel");	
			header("Content-Disposition: attachment; filename=RINCIAN_RETUR_PEMBELIAN_" . $_POST['tanggal_from'] . "_" . $_POST['tanggal_to'] . "_" . date("Ymd_His") . ".xlsx");
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objWriter->save("php://output");
		}
		return;
	}

	$form = new Form("lrrp_form", "", "Gudang Farmasi : Laporan Rincian Retur Pembelian");
	$tanggal_from_text = new Text("lrrp_tanggal_from", "lrrp_tanggal_from", date("Y-m-") . "01");
	$tanggal_from_text->setClass("mydate");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lrrp_tanggal_to", "lrrp_tanggal_to", date("Y-m-d"));
	$tanggal_to_text->setClass("mydate");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$form->addElement("Waktu Akhir", $tanggal_to_text);
	$id_vendor_hidden = new Hidden("lrrp_id_vendor", "lrrp_id_vendor", "%%");
	$form->addElement("", $id_vendor_hidden);
	$nama_vendor_text = new Text("lrrp_nama_vendor", "lrrp_nama_vendor", "SEMUA");
	$nama_vendor_text->setAtribute("disabled='disabled'");
	$nama_vendor_text->setClass("smis-two-option-input");
	$browse_button = new Button("", "", "Pilih");
	$browse_button->setClass("btn-info");
	$browse_button->setAction("lrrp_vendor.chooser('lrrp_vendor', 'lrrp_vendor_button', 'lrrp_vendor', lrrp_vendor)");
	$browse_button->setIcon("icon-white icon-list-alt");
	$browse_button->setIsButton(Button::$ICONIC);
	$browse_button->setAtribute("id='lrrp_vendor_browse'");
	$clear_button = new Button("", "", "Hapus");
	$clear_button->setClass("btn-inverse");
	$clear_button->setAction("lrrp_vendor.clear()");
	$clear_button->setIcon("fa fa-times");
	$clear_button->setIsButton(Button::$ICONIC);
	$clear_button->setAtribute("id='lrrp_vendor_clear'");
	$vendor_input_group = new InputGroup("");
	$vendor_input_group->addComponent($nama_vendor_text);
	$vendor_input_group->addComponent($browse_button);
	$vendor_input_group->addComponent($clear_button);
	$form->addElement("Distributor", $vendor_input_group);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lrrp.view()");
	$print_button = new Button("", "", "Unduh");
	$print_button->setAtribute("id='lrrp_download'");
	$print_button->setClass("btn-inverse");
	$print_button->setIcon("fa fa-download");
	$print_button->setIsButton(Button::$ICONIC);
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($print_button);
	$form->addElement("", $btn_group);

	$table = new Table(
		array("No.", "Tanggal Retur", "Tanggal Faktur", "Kode Beli", "Faktur", "Supplier", "ID Obat", "Kode Obat", "Nama Obat", "Jenis Obat", "Jumlah", "HPP", "Total HPP", "Produsen", "Tanggal ED", "Keterangan"),
		"",
		null,
		true
	);
	$table->setName("lrrp");
	$table->setAction(false);
	$table->setFooterVisible(false);

	$loading_bar = new LoadingBar("lrrp_loading_bar", "");
	$button = new Button("", "", "Batal");
	$button->addClass("btn-primary");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$button->setIcon("fa fa-close");
	$button->setAction("lrrp.cancel()");
	$loading_modal = new Modal("lrrp_modal", "", "Proses..");
	$loading_modal->addHtml($loading_bar->getHtml(), "after");
	$loading_modal->addFooter($button);

	echo $loading_modal->getHtml();
	echo $form->getHtml();
	echo "<div id='table_content'>";
	echo $table->getHtml();
	echo "</div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("base-js/smis-base-loading.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
	function LRRPAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LRRPAction.prototype.constructor = LRRPAction;
	LRRPAction.prototype = new TableAction();
	LRRPAction.prototype.view = function() {
		var self = this;
		var data = this.getRegulerData();
		data['tanggal_from'] = $("#lrrp_tanggal_from").val();
		data['tanggal_to'] = $("#lrrp_tanggal_to").val();
		data['id_vendor'] = $("#lrrp_id_vendor").val();
		data['command'] = "get_item_number";
		$("#lrrp_download").removeAttr("onclick");
		FINISHED = false;
		$("#lrrp_list").empty();
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				$("#lrrp_loading_bar").sload("true", "Harap ditunggu...", 0);
				$("#lrrp_modal").smodal("show");
				self.fill_html(0, json.jumlah);
			}
		);
	};
	LRRPAction.prototype.fill_html = function(num, limit) {
		if (num >= limit || FINISHED) {
			this.finalize();
			return;
		}
		var self = this;
		var data = this.getRegulerData();
		data['num'] = num;
		data['tanggal_from'] = $("#lrrp_tanggal_from").val();
		data['tanggal_to'] = $("#lrrp_tanggal_to").val();
		data['id_vendor'] = $("#lrrp_id_vendor").val();
		data['command'] = "get_item_info";
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				$("#lrrp_list").append(json.html);
				$("#lrrp_loading_bar").sload("true", json.no_faktur + " - " + json.nama_vendor + " (" + (num + 1) + " / " + limit + ")", (num + 1) * 100 / limit - 1);
				self.fill_html(num + 1, limit);
			}
		);
	};
	LRRPAction.prototype.finalize = function() {
		$("#lrrp_loading_bar").sload("true", "Finalisasi..", 100);
		$("#lrrp_modal").smodal("hide");
		$("#lrrp_loading_bar").sload("true", "", 0);
		$("#lrrp_download").attr("onclick", "lrrp.download()");
	};
	LRRPAction.prototype.cancel = function() {
		FINISHED = true;
	};
	LRRPAction.prototype.download = function() {
		var nor = $("#lrrp_list").children("tr").length;
		var d_data = {};
		for (var i = 0; i < nor; i++) {
			var dd_data = {};
			var first_col_val = $("#lrrp_list tr:eq(" + i + ") td:eq(0)").text();
			if (first_col_val == "SUBTOTAL") {
				var t_subtotal = $("#lrrp_list tr:eq(" + i + ") td#lrrp_t_subtotal").text();
				dd_data['t_subtotal'] = t_subtotal;
				dd_data['label'] = "subtotal";
			} else {
				var nomor = $("#lrrp_list tr:eq(" + i + ") td#lrrp_nomor").text();
				var tanggal_retur = $("#lrrp_list tr:eq(" + i + ") td#lrrp_tanggal_retur").text();
				var tanggal_faktur = $("#lrrp_list tr:eq(" + i + ") td#lrrp_faktur").text();
				var no_bbm = $("#lrrp_list tr:eq(" + i + ") td#lrrp_no_bbm").text();
				var no_faktur = $("#lrrp_list tr:eq(" + i + ") td#lrrp_no_faktur").text();
				var nama_vendor = $("#lrrp_list tr:eq(" + i + ") td#lrrp_nama_vendor").text();
				var id_obat = $("#lrrp_list tr:eq(" + i + ") td#lrrp_id_obat").text();
				var kode_obat = $("#lrrp_list tr:eq(" + i + ") td#lrrp_kode_obat").text();
				var nama_obat = $("#lrrp_list tr:eq(" + i + ") td#lrrp_nama_obat").text();
				var nama_jenis_obat = $("#lrrp_list tr:eq(" + i + ") td#lrrp_nama_jenis_obat").text();
				var hpp = $("#lrrp_list tr:eq(" + i + ") td#lrrp_hpp").text().replace(/[^0-9-,]/g, '').replace(",", ".");
				var jumlah = $("#lrrp_list tr:eq(" + i + ") td#lrrp_jumlah").text().replace(/[^0-9-,]/g, '').replace(",", ".");
				var subtotal = $("#lrrp_list tr:eq(" + i + ") td#lrrp_total").text();
				var produsen = $("#lrrp_list tr:eq(" + i + ") td#lrrp_produsen").text();
				var tanggal_exp = $("#lrrp_list tr:eq(" + i + ") td#lrrp_tanggal_exp").text();
				var keterangan = $("#lrrp_list tr:eq(" + i + ") td#lrrp_keterangan").text();
				dd_data['nomor'] = nomor;
				dd_data['tanggal_retur'] = tanggal_retur;
				dd_data['tanggal_faktur'] = tanggal_faktur;
				dd_data['no_bbm'] = no_bbm;
				dd_data['no_faktur'] = no_faktur;
				dd_data['nama_vendor'] = nama_vendor;
				dd_data['id_obat'] = id_obat;
				dd_data['kode_obat'] = kode_obat;
				dd_data['nama_obat'] = nama_obat;
				dd_data['nama_jenis_obat'] = nama_jenis_obat;
				dd_data['hpp'] = hpp;
				dd_data['jumlah'] = jumlah;
				dd_data['subtotal'] = subtotal;
				dd_data['produsen'] = produsen;
				dd_data['tanggal_exp'] = tanggal_exp;
				dd_data['keterangan'] = keterangan;
				dd_data['label'] = "detail";
			}
			d_data[i] = dd_data;
		}
		var data = this.getRegulerData();
		data['command'] = "download";
		data['d_data'] = JSON.stringify(d_data);
		data['tanggal_from'] = $("#lrrp_tanggal_from").val();
		data['tanggal_to'] = $("#lrrp_tanggal_to").val();
		postForm(data);
	};

	function LRPVendorAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LRPVendorAction.prototype.constructor = LRPVendorAction;
	LRPVendorAction.prototype = new TableAction();
	LRPVendorAction.prototype.selected = function(json) {
		$("#lrrp_id_vendor").val(json.id);
		$("#lrrp_nama_vendor").val(json.nama);
	};
	LRPVendorAction.prototype.clear = function() {
		$("#lrrp_id_vendor").val("%%");
		$("#lrrp_nama_vendor").val("SEMUA");
	};

	var lrrp;
	var lrrp_vendor;
	var FINISHED;
	$(document).ready(function() {
		lrrp_vendor = new LRPVendorAction(
			"lrrp_vendor",
			"gudang_farmasi",
			"laporan_rincian_retur_pembelian",
			new Array()
		);
		lrrp_vendor.setSuperCommand("lrrp_vendor");
		lrrp = new LRRPAction(
			"lrrp",
			"gudang_farmasi",
			"laporan_rincian_retur_pembelian",
			new Array()
		);
		$("#lrrp_list").append("<tr><td colspan='18'><small><center><strong>DATA BELUM DITAMPILKAN</strong></center></small></td></tr>");
		$(document).keyup(function(e) {
			if (e.which == 27) {
				FINISHED = true;
			}
		})
	});
</script>