<?php 
	global $db;
	require_once("smis-base/smis-include-service-consumer.php");
		
	$lrrou_table = new Table(
		array("No. Retur", "Tanggal", "Unit", "Kode Obat", "Nama Obat", "Jumlah", "Satuan", "HPP", "Total HPP", "Tgl. Exp.", "Keterangan", "Status", "User Pengirim", "User Penerima"),
		"",
		null,
		true
	);
	$lrrou_table->setName("lrrou");
	$lrrou_table->setAction(false);
	
	if (isset($_POST['command'])) {
		if ($_POST['command'] == "export_pdf") {
			$nama_entitas = getSettings($db, "smis_autonomous_title", "");
			$alamat_entitas = getSettings($db, "smis_autonomous_address", "");
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$unit = $_POST['ruangan'];

			$margin_left = 5;
			$margin_top = 5;
			$total = 0;
			$data = $db->get_result("
				SELECT *
				FROM smis_fr_retur_obat_unit
				WHERE prop = '' AND tanggal >= '" . $tanggal_from . "' AND tanggal <= '" . $tanggal_to . "' AND unit LIKE '" . $unit . "'
			");
			$jumlah_item = count($data);
			$jumlah_item_per_halaman = 30;
			$jumlah_halaman = floor($jumlah_item / $jumlah_item_per_halaman) + 1;

			require_once("smis-libs-out/fpdf/fpdf.php");
			$fpdf = new FPDF("P", "mm", array(370, 500));
			$fpdf->SetFont("Arial", "B", 8);
			$fpdf->SetMargins($margin_left, $margin_top);

			$fpdf->SetFont("Arial", "", 8);
			if ($data != null) {
			 	for ($i = $i_halaman * $jumlah_item_per_halaman; $i < $jumlah_item; $i++) {
			 		if ($i % $jumlah_item_per_halaman == 0) {
			 			$fpdf->AddPage();
						$fpdf->SetY($last_y + 10);
						$fpdf->SetX(5);
						$fpdf->Ln(4);
						$fpdf->SetFont("Arial", "B", 9);
						$fpdf->Cell(360, 5, "LAPORAN REKAP RETUR OBAT UNIT", 0, 0, "C");
						$fpdf->Ln(5);
						$fpdf->SetFont("Arial", "B", 7);
						$fpdf->Cell(360, 5, ArrayAdapter::format("date d-m-Y", $_POST['tanggal_from']) . " s/d " . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_to']) . " | UNIT : " . ArrayAdapter::format("unslug", $unit), 0, 0, "C");
						$fpdf->Ln(7);
						$fpdf->SetFont("Arial", "B", 8);
						$fpdf->Cell(35, 5, "No. Retur", 1, 0, "C");
						$fpdf->Cell(20, 5, "Tanggal", 1, 0, "C");
						$fpdf->Cell(50, 5, "Unit", 1, 0, "C");
						$fpdf->Cell(25, 5, "Kode Obat", 1, 0, "C");
						$fpdf->Cell(35, 5, "Nama Obat", 1, 0, "C");
						$fpdf->Cell(15, 5, "Jumlah", 1, 0, "C");
						$fpdf->Cell(15, 5, "Satuan", 1, 0, "C");
						$fpdf->Cell(20, 5, "HPP", 1, 0, "C");
						$fpdf->Cell(20, 5, "Total HPP", 1, 0, "C");
						$fpdf->Cell(20, 5, "Tanggal Exp.", 1, 0, "C");
						$fpdf->Cell(20, 5, "Keterangan", 1, 0, "C");
						$fpdf->Cell(25, 5, "Status", 1, 0, "C");
						$fpdf->Cell(30, 5, "User Pengirim", 1, 0, "C");
						$fpdf->Cell(30, 5, "User Penerima", 1, 0, "C");
						$fpdf->Ln(5);
			 		}
			 		$nomor_retur = $data[$i]->id;
			 		$tanggal = ArrayAdapter::format("date d-m-Y", $data[$i]->tanggal);
			 		$unit = ArrayAdapter::format("unslug", $data[$i]->unit);
			 		$kode_obat = $data[$i]->kode_obat;
			 		$nama_obat = $data[$i]->nama_obat;
			 		$jumlah = $data[$i]->jumlah;
			 		$satuan = $data[$i]->satuan;
			 		$hpp = ArrayAdapter::format("only-money", $data[$i]->hna);
			 		$total_hpp = ArrayAdapter::format("only-money", $jumlah * $data[$i]->hna);
			 		$tanggal_exp = ArrayAdapter::format("date d-m-Y", $data[$i]->tanggal_exp);
			 		$keterangan = $data[$i]->keterangan;
			 		$status = ArrayAdapter::format("unslug", $data[$i]->status);
			 		$user_pengirim = $data[$i]->username_sender;
			 		$user_penerima = $data[$i]->username_receiver;

					$fpdf->SetFont("Arial", "", 8);
					$fpdf->SetX(5);
					$fpdf->Cell(35, 5, $nomor_retur, 1, 0);
					$fpdf->Cell(20, 5, $tanggal, 1, 0);
					$fpdf->Cell(50, 5, $unit, 1, 0);
					$fpdf->Cell(25, 5, substr($kode_obat, 0, 22), 1, 0);
					$fpdf->Cell(35, 5, substr($nama_obat, 0, 22), 1, 0);
					$fpdf->Cell(15, 5, $jumlah, 1, 0, "R");
					$fpdf->Cell(15, 5, $satuan, 1, 0);
					$fpdf->Cell(20, 5, $hpp, 1, 0, "R");
					$fpdf->Cell(20, 5, $total_hpp, 1, 0, "R");
					$fpdf->Cell(20, 5, $tanggal_exp, 1, 0);
					$fpdf->Cell(20, 5, substr($keterangan, 0, 15), 1, 0);
					$fpdf->Cell(25, 5, $status, 1, 0);
					$fpdf->Cell(30, 5, substr($user_pengirim, 0, 22), 1, 0);
					$fpdf->Cell(30, 5, substr($user_penerima, 0, 22), 1, 0);
					$fpdf->Ln(5);
			 		if ($i == ($i_halaman * $jumlah_item_per_halaman + $jumlah_item_per_halaman - 1) || $i == $jumlah_item - 1) {
		 				$fpdf->SetX(5);
						$fpdf->SetFont("Arial", "B", 8);
						$fpdf->Cell(360, 5, "Halaman " . ($i_halaman + 1) . " / " . $jumlah_halaman, 0, 0, "R");
						$fpdf->Ln(5);
						$i_halaman++;
			 		}
			 	}
		 	}
			global $user;
		    $md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "laporan_rekap_retur_obat_unit.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
			$pack = new ResponsePackage();
			$pack->setContent($pathfile);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
			echo json_encode($pack->getPackage());
			return;
		}
		class LRROUAdapter extends ArrayAdapter {
			public function adapt($row) {
				$array = array();
				$array['id'] = $row->id;
				$array['No. Retur'] = self::format("digit8", $row->id);
				$array['Tanggal'] = self::format("date d-m-Y", $row->tanggal);
				$array['Unit'] = self::format("unslug", $row->unit);
				$array['Kode Obat'] = $row->kode_obat;
				$array['Nama Obat'] = $row->nama_obat;
				$array['Jumlah'] = $row->jumlah;
				$array['Satuan'] = $row->satuan;
				$array['HPP'] = self::format("money", $row->hna);
				$array['Total HPP'] = self::format("money", $row->jumlah * $row->hna);
				$array['Tgl. Exp.'] = self::format("date d-m-Y", $row->tanggal_exp);
				$array['Keterangan'] = $row->keterangan;
				$array['Status'] = self::format("unslug", $row->status);
				$array['User Pengirim'] = $row->username_sender;
				$array['User Penerima'] = $row->username_receiver;
				return $array;
			}
		}
		$lrrou_adapter = new LRROUAdapter();		
		$lrrou_dbtable = new DBTable($db, "smis_fr_retur_obat_unit");
		if (isset($_POST['command']) == "list") {
			$filter = "tanggal >= '" . $_POST['tanggal_from'] . "' AND tanggal <= '" . $_POST['tanggal_to'] . "' AND unit = '" . $_POST['ruangan'] . "'";
			if (isset($_POST['kriteria'])) {
				$filter .= " AND (id LIKE '%" . $_POST['kriteria'] . "%' OR unit LIKE '%" . $_POST['kriteria'] . "%' OR kode_obat LIKE '%" . $_POST['kriteria'] . "%' OR nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR satuan LIKE '%" . $_POST['kriteria'] . "%') ";
			}
			$query_value = "
				SELECT *
				FROM (
					SELECT *
					FROM smis_fr_retur_obat_unit
					WHERE prop = ''
				) v_lrrou
				WHERE " . $filter . "
			";
			$query_count = "
				SELECT COUNT(*)
				FROM (
					" . $query_value . "
				) v
			";
			$lrrou_dbtable->setPreferredQuery(true, $query_value, $query_count);
		}
		$lrrou_dbresponder = new DBResponder(
			$lrrou_dbtable,
			$lrrou_table,
			$lrrou_adapter
		);
		$data = $lrrou_dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	$laporan_form = new Form("lrrou_form", "", "Gudang Farmasi : Laporan Rekap Retur Obat Unit");
	class ReturUnitServiceConsumer extends ServiceConsumer {
		public function __construct($db) {
			parent::__construct($db, "is_inventory");
		}		
		public function proceedResult() {
			$content = array();
			$result = json_decode($this->result, true);
			foreach($result as $autonomous) {
				foreach($autonomous as $entity=>$res) {
					if($res['value_obat']=="1"){
						$option = array();
						$option['value'] = $entity;
						$option['name'] = ArrayAdapter::format("unslug", $res['name']);
						$content[] = $option;
					}
				}
			}
			return $content;
		}
	}
	$unit_service_consumer = new ReturUnitServiceConsumer($db);
	$unit_service_consumer->execute();
	$unit_option = $unit_service_consumer->getContent();
	$unit_select = new Select("lrrou_unit", "lrrou_unit", $unit_option);
	$laporan_form->addElement("Ruangan", $unit_select);
	$tanggal_from_text = new Text("lrrou_tanggal_from", "lrrou_tanggal_from", "");
	$tanggal_from_text->setClass("mydate");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lrrou_tanggal_to", "lrrou_tanggal_to", "");
	$tanggal_to_text->setClass("mydate");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Akhir", $tanggal_to_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lrrou.view()");
	$pdf_button = new Button("", "", "Eksport");
	$pdf_button->setClass("btn-inverse");
	$pdf_button->setIcon("fa fa-download");
	$pdf_button->setIsButton(Button::$ICONIC);
	$pdf_button->setAction("lrrou.export_pdf()");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($pdf_button);
	$laporan_form->addElement("", $btn_group);

	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo $lrrou_table->getHtml();
	echo "</div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
	function LRROUAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LRROUAction.prototype.constructor = LRROUAction;
	LRROUAction.prototype = new TableAction();
	LRROUAction.prototype.view = function() {
		var self = this;
		var data = this.getViewData();
		data['tanggal_from'] = $("#lrrou_tanggal_from").val();
		data['tanggal_to'] = $("#lrrou_tanggal_to").val();
		data['ruangan'] = $("#lrrou_unit").val();
		showLoading();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) return;
				$("#" + self.prefix + "_list").html(json.list);
				$("#" + self.prefix + "_pagination").html(json.pagination);
				dismissLoading();
			}
		);
	};
	LRROUAction.prototype.export_pdf = function() {
		if ($("#lrrou_tanggal_from").val() == "" || $("#lrrou_tanggal_to").val() == "" || $("#lrrou_unit").val() == "")
			return;
		var data = this.getRegulerData();
		data['command'] = "export_pdf";
		data['tanggal_from'] = $("#lrrou_tanggal_from").val();
		data['tanggal_to'] = $("#lrrou_tanggal_to").val();
		data['ruangan'] = $("#lrrou_unit").val();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) {
					dismissLoading();
					return;
				}
				var getUrl = window.location['pathname'] + json;
	            window.open(getUrl, 'pdf');
	            dismissLoading();
			}
		);
	};
	
	var lrrou;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		$("#lrrou_max").val(50);
		lrrou = new LRROUAction(
			"lrrou",
			"gudang_farmasi",
			"laporan_rekap_retur_obat_unit",
			new Array()
		)
		$('.mydate').datepicker();
	});
</script>