<?php
	global $db;

	$table = new Table(
		array("No.", "Tanggal", "Nama Obat", "Satuan", "Jumlah Sistem", "Jumlah Fisik", "Selisih", "Keterangan"),
		"",
		null,
		true
	);
	$table->setName("laporan_penyesuaian_stok_obat");
	$table->setAction(false);
	$table->setFooterVisible(false);

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "export_pdf") {
			$nama_entitas = getSettings($db, "smis_autonomous_title", "");
			$alamat_entitas = getSettings($db, "smis_autonomous_address", "");
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];

			$margin_left = 5;
			$margin_top = 5;
			$total = 0;
			$data = $db->get_result("
				SELECT a.tanggal, b.nama_obat, b.satuan, a.jumlah_lama AS 'jumlah_sistem', a.jumlah_baru AS 'jumlah_fisik', jumlah_lama - jumlah_baru AS 'selisih', keterangan
				FROM smis_fr_penyesuaian_stok a LEFT JOIN smis_fr_stok_obat b ON a.id_stok_obat = b.id
				WHERE a.prop = '' AND a.tanggal >= '" . $_POST['tanggal_from'] . "' AND a.tanggal <= '" . $_POST['tanggal_to'] . "'
			");
			$jumlah_item = count($data);
			$jumlah_item_per_halaman = 48;
			$jumlah_halaman = floor($jumlah_item / $jumlah_item_per_halaman) + 1;

			require_once("smis-libs-out/fpdf/fpdf.php");
			$fpdf = new FPDF("P", "mm", "A4");
			$fpdf->SetFont("Arial", "B", 8);
			$fpdf->SetMargins($margin_left, $margin_top);

			$fpdf->SetFont("Arial", "", 8);
			if ($data != null) {
			 	for ($i = $i_halaman * $jumlah_item_per_halaman; $i < $jumlah_item; $i++) {
			 		if ($i % $jumlah_item_per_halaman == 0) {
			 			$fpdf->AddPage();
						$fpdf->SetY($last_y + 10);
						$fpdf->SetX(5);
						$fpdf->Ln(4);
						$fpdf->SetFont("Arial", "B", 9);
						$fpdf->Cell(200, 5, "LAPORAN PENYESUAIAN STOK OBAT", 0, 0, "C");
						$fpdf->Ln(5);
						$fpdf->SetFont("Arial", "B", 7);
						$fpdf->Cell(200, 5, ArrayAdapter::format("date d-m-Y", $_POST['tanggal_from']) . " s/d " . ArrayAdapter::format("date d-m-Y", $_POST['tanggal_to']) . " | UNIT : GUDANG FARMASI", 0, 0, "C");
						$fpdf->Ln(7);
						$fpdf->SetFont("Arial", "B", 8);
						$fpdf->Cell(15, 5, "No.", 1, 0, "C");
						$fpdf->Cell(20, 5, "Tanggal", 1, 0, "C");
						$fpdf->Cell(40, 5, "Nama Obat", 1, 0, "C");
						$fpdf->Cell(15, 5, "Satuan", 1, 0, "C");
						$fpdf->Cell(25, 5, "Jumlah Sistem", 1, 0, "C");
						$fpdf->Cell(20, 5, "Jumlah Fisik", 1, 0, "C");
						$fpdf->Cell(20, 5, "Selisih", 1, 0, "C");
						$fpdf->Cell(45, 5, "Keterangan", 1, 0, "C");
						$fpdf->Ln(5);
			 		}
			 		$nomor = $i + 1;
			 		$tanggal = ArrayAdapter::format("date d-m-Y", $data[$i]->tanggal);
			 		$nama_obat = $data[$i]->nama_obat;
			 		$satuan = $data[$i]->satuan;
			 		$jumlah_sistem = $data[$i]->jumlah_sistem;
			 		$jumlah_fisik = $data[$i]->jumlah_fisik;
			 		$selisih = $data[$i]->selisih;
			 		$keterangan = $data[$i]->keterangan;

					$fpdf->SetFont("Arial", "", 8);
					$fpdf->SetX(5);
					$fpdf->Cell(15, 5, $nomor, 1, 0);
					$fpdf->Cell(20, 5, $tanggal, 1, 0);
					$fpdf->Cell(40, 5, substr($nama_obat, 0, 22), 1, 0);
					$fpdf->Cell(15, 5, $satuan, 1, 0);
					$fpdf->Cell(25, 5, $jumlah_sistem, 1, 0, "R");
					$fpdf->Cell(20, 5, $jumlah_fisik, 1, 0, "R");
					$fpdf->Cell(20, 5, $selisih, 1, 0, "R");
					$fpdf->Cell(45, 5, substr($keterangan, 0, 22), 1, 0);
					$fpdf->Ln(5);
			 		if ($i == ($i_halaman * $jumlah_item_per_halaman + $jumlah_item_per_halaman - 1) || $i == $jumlah_item - 1) {
		 				$fpdf->SetX(5);
						$fpdf->SetFont("Arial", "B", 8);
						$fpdf->Cell(200, 5, "Halaman " . ($i_halaman + 1) . " / " . $jumlah_halaman, 0, 0, "R");
						$fpdf->Ln(5);
						$i_halaman++;
			 		}
			 	}
		 	}
			global $user;
		    $md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "laporan_penyesuaian_stok_obat.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
			$pack = new ResponsePackage();
			$pack->setContent($pathfile);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
			echo json_encode($pack->getPackage());
			return;
		}
		$adapter = new SimpleAdapter(true, "No.");
		$adapter->add("Tanggal", "tanggal", "date d-m-Y");
		$adapter->add("Nama Obat", "nama_obat");
		$adapter->add("Satuan", "satuan");
		$adapter->add("Jumlah Sistem", "jumlah_sistem", "number");
		$adapter->add("Jumlah Fisik", "jumlah_fisik", "number");
		$adapter->add("Selisih", "selisih", "number");
		$adapter->add("Keterangan", "keterangan");
		$dbtable = new DBTable($db, "smis_fr_penyesuaian_stok", $columns);
		$dbtable->setShowAll(true);
		$filter = "";
		if (isset($_POST['kriteria'])) {
			$filter .= " AND (b.nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR a.keterangan LIKE '%" . $_POST['kriteria'] . "%' ) ";
		}
		$query_value = "
			SELECT a.tanggal, b.nama_obat, b.satuan, a.jumlah_lama AS 'jumlah_sistem', a.jumlah_baru AS 'jumlah_fisik', jumlah_lama - jumlah_baru AS 'selisih', keterangan
			FROM smis_fr_penyesuaian_stok a LEFT JOIN smis_fr_stok_obat b ON a.id_stok_obat = b.id
			WHERE a.prop = '' AND a.tanggal >= '" . $_POST['tanggal_from'] . "' AND a.tanggal <= '" . $_POST['tanggal_to'] . "' " . $filter . "
		";
		$query_count = "
			SELECT COUNT(*)
			FROM (
				" . $query_value . "
			) v
		";
		$dbtable->setPreferredQuery(true, $query_value, $query_count);
		$dbresponder = new DBResponder(
			$dbtable,
			$table,
			$adapter
		);
		$data = $dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}

	$laporan_form = new Form("", "", "Gudang Farmasi : Laporan Penyesuaian Stok Obat");
	$tanggal_from_text = new Text("lpso_tanggal_from", "lpso_tanggal_from", date("Y-m-") . "01");
	$tanggal_from_text->setClass("mydate");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lpso_tanggal_to", "lpso_tanggal_to", date("Y-m-d"));
	$tanggal_to_text->setClass("mydate");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Akhir", $tanggal_to_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("laporan_penyesuaian_stok_obat.view()");
	$pdf_button = new Button("", "", "Unduh");
	$pdf_button->setClass("btn-inverse");
	$pdf_button->setIcon("fa fa-file-pdf-o");
	$pdf_button->setIsButton(Button::$ICONIC);
	$pdf_button->setAction("laporan_penyesuaian_stok_obat.export_pdf()");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($pdf_button);
	$laporan_form->addElement("", $btn_group);

	echo $laporan_form->getHtml();
	echo $table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
	var laporan_penyesuaian_stok_obat;
	$(document).ready(function() {
		laporan_penyesuaian_stok_obat = new TableAction(
			"laporan_penyesuaian_stok_obat",
			"gudang_farmasi",
			"laporan_penyesuaian_stok_obat",
			new Array()
		);
		$("#laporan_penyesuaian_stok_obat_list").append("<tr><td colspan='8'><strong><center><small>DATA BELUM DIPROSES</small></center></strong></td></tr>");
		laporan_penyesuaian_stok_obat.addViewData = function(data) {
			data['tanggal_from'] = $("#lpso_tanggal_from").val();
			data['tanggal_to'] = $("#lpso_tanggal_to").val();
			return data;
		};
		laporan_penyesuaian_stok_obat.export_pdf = function() {
			var data = this.getRegulerData();
			data['command'] = "export_pdf";
			data['tanggal_from'] = $("#lpso_tanggal_from").val();
			data['tanggal_to'] = $("#lpso_tanggal_to").val();
			$.post(
				"",
				data,
				function(response) {
					var json = getContent(response);
					if (json == null) {
						dismissLoading();
						return;
					}
					var getUrl = window.location['pathname'] + json;
		            window.open(getUrl, 'pdf');
		            dismissLoading();
				}
			);	
		};
	});
</script>