<?php
	global $db;

	function getMonthNumber($strMonth) {
		if ($strMonth == "Januari")
			return 1;
		else if ($strMonth == "Februari")
			return 2;
		else if ($strMonth == "Maret")
			return 3;
		else if ($strMonth == "April")
			return 4;
		else if ($strMonth == "Mei")
			return 5;
		else if ($strMonth == "Juni")
			return 6;
		else if ($strMonth == "Juli")
			return 7;
		else if ($strMonth == "Agustus")
			return 8;
		else if ($strMonth == "September")
			return 9;
		else if ($strMonth == "Oktober")
			return 10;
		else if ($strMonth == "November")
			return 11;
		else if ($strMonth == "Desember")
			return 12;
		return 0;
	}

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "get_jumlah_obat") {
			$unit = $_POST['unit'];

			$bulan_1_part = explode(" ", $_POST['bulan_1']);
			$bulan_1 = getMonthNumber($bulan_1_part[0]);
			$tahun_1 = $bulan_1_part[1];

			$bulan_2_part = explode(" ", $_POST['bulan_2']);
			$bulan_2 = getMonthNumber($bulan_2_part[0]);
			$tahun_2 = $bulan_2_part[1];

			$bulan_3_part = explode(" ", $_POST['bulan_3']);
			$bulan_3 = getMonthNumber($bulan_3_part[0]);
			$tahun_3 = $bulan_3_part[1];

			$jumlah = 0;
			$row = $db->get_row("
				SELECT COUNT(*) jumlah
				FROM (
					SELECT 
						DISTINCT a.id_obat, a.nama_obat
					FROM 
						smis_frm_" . $unit . "_penjualan_obat_jadi a INNER JOIN smis_frm_" . $unit ."_penjualan_resep b ON a.id_penjualan_resep = b.id
					WHERE
						a.prop = '' AND b.prop = '' AND b.dibatalkan = '0' AND 
						(
							(MONTH(b.tanggal) = '" . $bulan_1 . "' AND YEAR(b.tanggal) = '" . $tahun_1 . "') OR
							(MONTH(b.tanggal) = '" . $bulan_2 . "' AND YEAR(b.tanggal) = '" . $tahun_2 . "') OR
							(MONTH(b.tanggal) = '" . $bulan_3 . "' AND YEAR(b.tanggal) = '" . $tahun_3 . "')
						)
					UNION
					SELECT 
						DISTINCT a.id_obat, a.nama_obat
					FROM 
						(smis_frm_" . $unit . "_bahan_pakai_obat_racikan a INNER JOIN smis_frm_" . $unit ."_penjualan_obat_racikan b ON a.id_penjualan_obat_racikan = b.id) INNER JOIN smis_frm_" . $unit . "_penjualan_resep c ON b.id_penjualan_resep = c.id
					WHERE
						a.prop = '' AND b.prop = '' AND c.prop AND c.dibatalkan = '0' AND 
						(
							(MONTH(c.tanggal) = '" . $bulan_1 . "' AND YEAR(c.tanggal) = '" . $tahun_1 . "') OR
							(MONTH(c.tanggal) = '" . $bulan_2 . "' AND YEAR(c.tanggal) = '" . $tahun_2 . "') OR
							(MONTH(c.tanggal) = '" . $bulan_3 . "' AND YEAR(c.tanggal) = '" . $tahun_3 . "')
						)
				) v
			");
			if ($row != null)
				$jumlah = $row->jumlah;
			$data['jumlah'] = $jumlah;
			echo json_encode($data);
		} else if ($_POST['command'] == "get_info_obat") {
			$unit = $_POST['unit'];

			$bulan_1_part = explode(" ", $_POST['bulan_1']);
			$bulan_1 = getMonthNumber($bulan_1_part[0]);
			$tahun_1 = $bulan_1_part[1];

			$bulan_2_part = explode(" ", $_POST['bulan_2']);
			$bulan_2 = getMonthNumber($bulan_2_part[0]);
			$tahun_2 = $bulan_2_part[1];

			$bulan_3_part = explode(" ", $_POST['bulan_3']);
			$bulan_3 = getMonthNumber($bulan_3_part[0]);
			$tahun_3 = $bulan_3_part[1];

			$num = $_POST['num'];

			$row = $db->get_row("
				SELECT id_obat, nama_obat, nama_jenis_obat
				FROM (
					SELECT 
						DISTINCT a.id_obat, a.nama_obat, a.nama_jenis_obat
					FROM 
						smis_frm_" . $unit . "_penjualan_obat_jadi a INNER JOIN smis_frm_" . $unit ."_penjualan_resep b ON a.id_penjualan_resep = b.id
					WHERE
						a.prop = '' AND b.prop = '' AND b.dibatalkan = '0' AND 
						(
							(MONTH(b.tanggal) = '" . $bulan_1 . "' AND YEAR(b.tanggal) = '" . $tahun_1 . "') OR
							(MONTH(b.tanggal) = '" . $bulan_2 . "' AND YEAR(b.tanggal) = '" . $tahun_2 . "') OR
							(MONTH(b.tanggal) = '" . $bulan_3 . "' AND YEAR(b.tanggal) = '" . $tahun_3 . "')
						)
					UNION
					SELECT 
						DISTINCT a.id_obat, a.nama_obat, a.nama_jenis_obat
					FROM 
						(smis_frm_" . $unit . "_bahan_pakai_obat_racikan a INNER JOIN smis_frm_" . $unit ."_penjualan_obat_racikan b ON a.id_penjualan_obat_racikan = b.id) INNER JOIN smis_frm_" . $unit . "_penjualan_resep c ON b.id_penjualan_resep = c.id
					WHERE
						a.prop = '' AND b.prop = '' AND c.prop AND c.dibatalkan = '0' AND 
						(
							(MONTH(c.tanggal) = '" . $bulan_1 . "' AND YEAR(c.tanggal) = '" . $tahun_1 . "') OR
							(MONTH(c.tanggal) = '" . $bulan_2 . "' AND YEAR(c.tanggal) = '" . $tahun_2 . "') OR
							(MONTH(c.tanggal) = '" . $bulan_3 . "' AND YEAR(c.tanggal) = '" . $tahun_3 . "')
						)
				) v
				LIMIT " . $num . ", 1
			");

			$id_obat = "";
			$nama_jenis_obat = "";
			$nama_obat = "";
			$jumlah_penggunaan_bulan_1 = 0;
			$jumlah_penggunaan_bulan_2 = 0;
			$jumlah_penggunaan_bulan_3 = 0;
			$jumlah_penggunaan_total = 0;
			$amc = 0;
			$aqtpm = 0;
			$rerata = 0;
			if ($row != null) {
				$nama_jenis_obat = $row->nama_jenis_obat;
				$nama_obat = $row->nama_obat;
				$id_obat = $row->id_obat;

				$t_row = $db->get_row("
					SELECT SUM(jumlah) jumlah
					FROM (
						SELECT 
							a.id_obat, a.nama_obat, a.nama_jenis_obat, SUM(a.jumlah) jumlah
						FROM 
							smis_frm_" . $unit . "_penjualan_obat_jadi a INNER JOIN smis_frm_" . $unit ."_penjualan_resep b ON a.id_penjualan_resep = b.id
						WHERE
							a.prop = '' AND b.prop = '' AND b.dibatalkan = '0' AND MONTH(b.tanggal) = '" . $bulan_1 . "' AND YEAR(b.tanggal) = '" . $tahun_1 . "' AND a.id_obat = '" . $id_obat . "'
						UNION ALL
						SELECT 
							a.id_obat, a.nama_obat, a.nama_jenis_obat, SUM(a.jumlah) jumlah
						FROM 
							(smis_frm_" . $unit . "_bahan_pakai_obat_racikan a INNER JOIN smis_frm_" . $unit ."_penjualan_obat_racikan b ON a.id_penjualan_obat_racikan = b.id) INNER JOIN smis_frm_" . $unit . "_penjualan_resep c ON b.id_penjualan_resep = c.id
						WHERE
							a.prop = '' AND b.prop = '' AND c.prop AND c.dibatalkan = '0' AND MONTH(c.tanggal) = '" . $bulan_1 . "' AND YEAR(c.tanggal) = '" . $tahun_1 . "' AND a.id_obat = '" . $id_obat . "'
					) v
				");
				if ($t_row != null)
					$jumlah_penggunaan_bulan_1 = $t_row->jumlah == null ? 0 : $t_row->jumlah;

				$t_row = $db->get_row("
					SELECT SUM(jumlah) jumlah
					FROM (
						SELECT 
							a.id_obat, a.nama_obat, a.nama_jenis_obat, SUM(a.jumlah) jumlah
						FROM 
							smis_frm_" . $unit . "_penjualan_obat_jadi a INNER JOIN smis_frm_" . $unit ."_penjualan_resep b ON a.id_penjualan_resep = b.id
						WHERE
							a.prop = '' AND b.prop = '' AND b.dibatalkan = '0' AND MONTH(b.tanggal) = '" . $bulan_2 . "' AND YEAR(b.tanggal) = '" . $tahun_2 . "' AND a.id_obat = '" . $id_obat . "'
						UNION ALL
						SELECT 
							a.id_obat, a.nama_obat, a.nama_jenis_obat, SUM(a.jumlah) jumlah
						FROM 
							(smis_frm_" . $unit . "_bahan_pakai_obat_racikan a INNER JOIN smis_frm_" . $unit ."_penjualan_obat_racikan b ON a.id_penjualan_obat_racikan = b.id) INNER JOIN smis_frm_" . $unit . "_penjualan_resep c ON b.id_penjualan_resep = c.id
						WHERE
							a.prop = '' AND b.prop = '' AND c.prop AND c.dibatalkan = '0' AND MONTH(c.tanggal) = '" . $bulan_2 . "' AND YEAR(c.tanggal) = '" . $tahun_2 . "' AND a.id_obat = '" . $id_obat . "'
					) v
				");
				if ($t_row != null)
					$jumlah_penggunaan_bulan_2 = $t_row->jumlah == null ? 0 : $t_row->jumlah;

				$t_row = $db->get_row("
					SELECT SUM(jumlah) jumlah
					FROM (
						SELECT 
							a.id_obat, a.nama_obat, a.nama_jenis_obat, SUM(a.jumlah) jumlah
						FROM 
							smis_frm_" . $unit . "_penjualan_obat_jadi a INNER JOIN smis_frm_" . $unit ."_penjualan_resep b ON a.id_penjualan_resep = b.id
						WHERE
							a.prop = '' AND b.prop = '' AND b.dibatalkan = '0' AND MONTH(b.tanggal) = '" . $bulan_3 . "' AND YEAR(b.tanggal) = '" . $tahun_3 . "' AND a.id_obat = '" . $id_obat . "'
						UNION ALL
						SELECT 
							a.id_obat, a.nama_obat, a.nama_jenis_obat, SUM(a.jumlah) jumlah
						FROM 
							(smis_frm_" . $unit . "_bahan_pakai_obat_racikan a INNER JOIN smis_frm_" . $unit ."_penjualan_obat_racikan b ON a.id_penjualan_obat_racikan = b.id) INNER JOIN smis_frm_" . $unit . "_penjualan_resep c ON b.id_penjualan_resep = c.id
						WHERE
							a.prop = '' AND b.prop = '' AND c.prop AND c.dibatalkan = '0' AND MONTH(c.tanggal) = '" . $bulan_3 . "' AND YEAR(c.tanggal) = '" . $tahun_3 . "' AND a.id_obat = '" . $id_obat . "'
					) v
				");
				if ($t_row != null)
					$jumlah_penggunaan_bulan_3 = $t_row->jumlah == null ? 0 : $t_row->jumlah;

				$jumlah_penggunaan_total = $jumlah_penggunaan_bulan_1 + $jumlah_penggunaan_bulan_2 + $jumlah_penggunaan_bulan_3;
				$amc = round($jumlah_penggunaan_total / 3);
			}

			$data['html'] = 
				"<tr class='data_losfm'>" .
					"<td id='nomor'></td>" .
					"<td id='nama_jenis_obat'>" . $nama_jenis_obat . "</td>" .
					"<td id='nama_obat'>" . $nama_obat . "</td>" .
					"<td id='jml_bulan_1'><div align='right'>" . $jumlah_penggunaan_bulan_1 . "</div></td>" .
					"<td id='jml_bulan_2'><div align='right'>" . $jumlah_penggunaan_bulan_2 . "</div></td>" .
					"<td id='jml_bulan_3'><div align='right'>" . $jumlah_penggunaan_bulan_3 . "</div></td>" .
					"<td id='jml_total'><div align='right'>" . $jumlah_penggunaan_total . "</div></td>" .
					"<td id='amc'><div align='right'>" . $amc . "</div></td>" .
					"<td id='tamc'><div align='right'>" . $aqtpm . "</div></td>" .
					"<td id='rerata'><div align='right'>" . $rerata . "</div></td>" .
					"<td id='kelas'><div align='center'>-</div></td>" .
				"</tr>"
			;
			$data['nama_obat'] = $nama_obat;
			echo json_encode($data);
		} else if ($_POST['command'] == "export_xls") {
			ini_set("memory_limit", "256M");
			set_time_limit(0);
			$unit = $_POST['unit_label'];
			$bulan = $_POST['bulan_label'];
			$tahun = $_POST['tahun'];
			$bulan_1 = $_POST['bulan_1'];
			$bulan_2 = $_POST['bulan_2'];
			$bulan_3 = $_POST['bulan_3'];

			require_once ("smis-libs-out/php-excel/PHPExcel.php");

			$objPHPExcel = new PHPExcel();

			$objWorksheet = $objPHPExcel->getActiveSheet();
			$objWorksheet->setTitle("Laporan Obat Fast-Slow Moving");
			$i = 1;

			$objWorksheet->mergeCells("A" . $i . ":K" . $i)->setCellValue("A" . $i, "LAPORAN FAST - SLOW MOVING");
			$objWorksheet->getStyle("A" . $i . ":K" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objWorksheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 1;
			$objWorksheet->mergeCells("A" . $i . ":K" . $i)->setCellValue("A" . $i, "Unit : " . $unit);
			$objWorksheet->getStyle("A" . $i . ":K" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objWorksheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 1;
			$objWorksheet->mergeCells("A" . $i . ":K" . $i)->setCellValue("A" . $i, "Bulan : " . $bulan . " " . $tahun);
			$objWorksheet->getStyle("A" . $i . ":K" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objWorksheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 2;

			$border_start = $i;
			$col = "A";
			$head = array("No.", "Jenis", "Nama Obat", $bulan_1, $bulan_2, $bulan_3, "Total", "Average Monthly Consumption (AMC)", "Total Rerata Jumlah Per Bulan", "Rata-Rata", "Slow/Fast Moving");
			foreach ($head as $h)
				$objWorksheet->setCellValue($col++ . $i, $h);
			$objWorksheet->getStyle("A" . $i . ":K" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objWorksheet->getStyle("A" . $i . ":K" . $i)->getFont()->setBold(true);
			$i = $i + 1;

			$data = json_decode($_POST['d_data']);
			if (count($data) > 0) {
				foreach ($data as $d) {
					$objWorksheet->setCellValue("A" . $i, $d->nomor);
					$objWorksheet->setCellValue("B" . $i, $d->nama_jenis_obat);
					$objWorksheet->setCellValue("C" . $i, $d->nama_obat);
					$objWorksheet->setCellValue("D" . $i, $d->jml_bulan_1);
					$objWorksheet->setCellValue("E" . $i, $d->jml_bulan_2);
					$objWorksheet->setCellValue("F" . $i, $d->jml_bulan_3);
					$objWorksheet->setCellValue("G" . $i, $d->jml_total);
					$objWorksheet->setCellValue("H" . $i, $d->amc);
					$objWorksheet->setCellValue("I" . $i, $d->tamc);
					$objWorksheet->setCellValue("J" . $i, $d->rerata);
					$objWorksheet->setCellValue("K" . $i, $d->kelas);
					$objWorksheet->getStyle("D" . $i . ":J" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
					$objWorksheet->getStyle("K" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
					$i = $i + 1;
				}
			}

			$thin = array();
			$thin['borders'] = array();
			$thin['borders']['allborders'] = array();
			$thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
			$objWorksheet->getStyle("A" . $border_start . ":K" . $i)->applyFromArray($thin);

			foreach (range('A', 'K') as $columnID)
		    	$objWorksheet->getColumnDimension($columnID)->setAutoSize(true);

			header("Content-type: application/vnd.ms-excel");	
			header("Content-Disposition: attachment; filename=LAPORAN_OBAT_SLOW_FAST_MOVING_" . strtoupper($unit) . "_" . strtoupper($bulan) . " " . strtoupper($tahun) . ".xlsx");
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objWriter->save("php://output");
		}
		return;
	}

	$laporan_form = new Form("", "", "Gudang Farmasi : Laporan Obat Slow/Fast Moving");
	$bulan_option = new OptionBuilder();
	if (date("m") == 1)
		$bulan_option->add("Januari", "1", "1");
	else
		$bulan_option->add("Januari", "1");
	if (date("m") == 2)
		$bulan_option->add("Februari", "2", "1");
	else
		$bulan_option->add("Februari", "2");
	if (date("m") == 3)
		$bulan_option->add("Maret", "3", "1");
	else
		$bulan_option->add("Maret", "3");
	if (date("m") == 4)
		$bulan_option->add("April", "4", "1");
	else
		$bulan_option->add("April", "4");
	if (date("m") == 5)
		$bulan_option->add("Mei", "5", "1");
	else
		$bulan_option->add("Mei", "5");
	if (date("m") == 6)
		$bulan_option->add("Juni", "6", "1");
	else
		$bulan_option->add("Juni", "6");
	if (date("m") == 7)
		$bulan_option->add("Juli", "7", "1");
	else
		$bulan_option->add("Juli", "7");
	if (date("m") == 8)
		$bulan_option->add("Agustus", "8", "1");
	else
		$bulan_option->add("Agustus", "8");
	if (date("m") == 9)
		$bulan_option->add("September", "9", "1");
	else
		$bulan_option->add("September", "9");
	if (date("m") == 10)
		$bulan_option->add("Oktober", "10", "1");
	else
		$bulan_option->add("Oktober", "10");
	if (date("m") == 11)
		$bulan_option->add("November", "11", "1");
	else
		$bulan_option->add("November", "11");
	if (date("m") == 12)
		$bulan_option->add("Desember", "12", "1");
	else
		$bulan_option->add("Desember", "12");
	$bulan_select = new Select("losfm_bulan", "losfm_bulan", $bulan_option->getContent());
	$laporan_form->addElement("Bulan", $bulan_select);
	$tahun_option = new OptionBuilder();
	for ($i = date('Y'); $i >= date('Y') - 5; $i--) {
		if ($i != date('Y'))
			$tahun_option->add($i, $i);
		else
			$tahun_option->add($i, $i, "1");
	}
	$tahun_select = new Select("losfm_tahun", "losfm_tahun", $tahun_option->getContent());
	$laporan_form->addElement("Tahun", $tahun_select);
	$unit_option = new OptionBuilder();
	$unit_option->add("Depo Farmasi Batam Centre", "batam_centre", "1");
	$unit_option->add("Depo Farmasi Batu Aji", "batu_aji");
	$unit_option->add("Depo Farmasi Bengkong", "bengkong");
	$unit_option->add("Depo Farmasi Jodoh", "jodoh");
	$unit_option->add("Depo Farmasi Panbil", "panbil");
	$unit_option->add("Depo Farmasi Piayu", "piayu");
	$unit_option->add("Depo Farmasi Sekupang", "sekupang");
	$unit_option->add("Depo Farmasi Tanjung Uncang", "tanjung_uncang");
	$unit_option->add("Depo Farmasi Utama", "utama");
	$unit_select = new Select("losfm_unit", "losfm_unit", $unit_option->getContent());
	$laporan_form->addElement("Unit", $unit_select);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("losfm.view()");
	$excel_button = new Button("", "", "Unduh");
	$excel_button->setClass("btn-inverse");
	$excel_button->setIcon("fa fa-download");
	$excel_button->setIsButton(Button::$ICONIC);
	$excel_button->setAtribute("id='losfm_export_button'");
	$btn_group = new ButtonGroup("noexcel");
	$btn_group->addButton($show_button);
	$btn_group->addButton($excel_button);
	$laporan_form->addElement("", $btn_group);

	$table = new Table(
		array("No.", "Jenis Obat", "Nama Obat", "Bulan 1", "Bulan 2", "Bulan 3", "Total", "AMC", "AQTPM", "Rata-Rata", "Slow/Fast Moving"),
		"",
		null,
		true
	);
	$table->setName("losfm");
	$table->setAction(false);
	$table->setFooterVisible(false);
	$table->setHeaderVisible(false);

	$bulan_1 = "";
	$bulan_2 = "";
	$bulan_3 = "";
	if (date("m") == 1) {
		$bulan_1 = "Oktober " . (date("Y") - 1);
		$bulan_2 = "November " . (date("Y") - 1);
		$bulan_3 = "Desember " . (date("Y") - 1);
	} else if (date("m") == 2) {
		$bulan_1 = "November " . (date("Y") - 1);
		$bulan_2 = "Desember " . (date("Y") - 1);
		$bulan_3 = "Januari " . date("Y");
	} else if (date("m") == 3) {
		$bulan_1 = "Desember " . (date("Y") - 1);
		$bulan_2 = "Januari " . date("Y");
		$bulan_3 = "Februari " . date("Y");
	} else if (date("m") == 4) {
		$bulan_1 = "Januari " . date("Y");
		$bulan_2 = "Februari " . date("Y");
		$bulan_3 = "Maret " . date("Y");
	} else if (date("m") == 5) {
		$bulan_1 = "Februari " . date("Y");
		$bulan_2 = "Maret " . date("Y");
		$bulan_3 = "April " . date("Y");
	} else if (date("m") == 6) {
		$bulan_1 = "Maret " . date("Y");
		$bulan_2 = "April " . date("Y");
		$bulan_3 = "Mei " . date("Y");
	} else if (date("m") == 7) {
		$bulan_1 = "April " . date("Y");
		$bulan_2 = "Mei " . date("Y");
		$bulan_3 = "Juni " . date("Y");
	} else if (date("m") == 8) {
		$bulan_1 = "Mei " . date("Y");
		$bulan_2 = "Juni " . date("Y");
		$bulan_3 = "Juli " . date("Y");
	} else if (date("m") == 9) {
		$bulan_1 = "Juni " . date("Y");
		$bulan_2 = "Juli " . date("Y");
		$bulan_3 = "Agustus " . date("Y");
	} else if (date("m") == 10) {
		$bulan_1 = "Juli " . date("Y");
		$bulan_2 = "Agustus " . date("Y");
		$bulan_3 = "September " . date("Y");
	} else if (date("m") == 11) {
		$bulan_1 = "Agustus " . date("Y");
		$bulan_2 = "September " . date("Y");
		$bulan_3 = "Oktober " . date("Y");
	} else if (date("m") == 12) {
		$bulan_1 = "September " . date("Y");
		$bulan_2 = "Oktober " . date("Y");
		$bulan_3 = "November " . date("Y");
	}

	$table->addHeader("after", "
		<tr class='inverse'>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small>No.</small></center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small>Jenis Obat</small></center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small>Nama Obat</small></center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small><div id='losfm_bulan_1'>" . $bulan_1 . "</div></small></center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small><div id='losfm_bulan_2'>" . $bulan_2 . "</div></small></center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small><div id='losfm_bulan_3'>" . $bulan_3 . "</div></small></center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small>Total</small></center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small>Konsumsi Rerata Bulanan (AMC)</small></center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small>Total Rerata Jumlah Per Bulan</small></center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small>Rata-Rata</small></center>
			</th>
			<th rowspan='2' style='vertical-align: middle !important;'>
				<center><small>Slow/Fast Moving</small></center>
			</th>
		</tr>
	");

	$loading_bar = new LoadingBar("losfm_loading_bar", "");
	$button = new Button("", "", "Batal");
	$button->addClass("btn-primary");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$button->setIcon("fa fa-close");
	$button->setAction("losfm.cancel()");
	$loading_modal = new Modal("losfm_loading_modal", "", "Proses..");
	$loading_modal->addHtml($loading_bar->getHtml(), "after");
	$loading_modal->addFooter($button);
	
	echo $loading_modal->getHtml();
	echo $laporan_form->getHtml();
	echo $table->getHtml();
	echo "<div id='losfm_info'></div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("base-js/smis-base-loading.js");
?>
<script type="text/javascript">
	var losfm;
	var FINISHED;
	$(document).ready(function() {
		$("#losfm_list").html("<tr><td colspan='11'><center>DATA BELUM DITAMPILKAN</center></td></tr>");
		losfm = new TableAction(
			"losfm",
			"gudang_farmasi",
			"laporan_obat_slow_fast_moving",
			new Array()
		);
		losfm.view = function() {
			var self = this;
			$("#losfm_info").empty();
			$("#losfm_loading_bar").sload("true", "Harap ditunggu...", 0);
			$("#losfm_loading_modal").smodal("show");
			FINISHED = false;
			d_jenis_obat = {};
			var data = this.getRegulerData();
			data['command'] = "get_jumlah_obat";
			data['bulan'] = $("#losfm_bulan").val();
			data['tahun'] = $("#losfm_tahun").val();
			data['unit'] = $("#losfm_unit").val();
			data['bulan_1'] = $("#losfm_bulan_1").text();
			data['bulan_2'] = $("#losfm_bulan_2").text();
			data['bulan_3'] = $("#losfm_bulan_3").text();
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) return;
					$("#losfm_list").empty();
					self.getDataObat(0, json.jumlah);
				}
			);
		};
		losfm.getDataObat = function(num, limit) {
			if (FINISHED || num == limit) {
				if (FINISHED == false && num == limit) {
					this.finalize();
				} else {
					$("#losfm_loading_modal").smodal("hide");
					$("#losfm_info").html(
						"<div class='alert alert-block alert-inverse'>" +
							 "<center><strong>PROSES DIBATALKAN</strong></center>" +
						 "</div>"
					);
					$("#losfm_export_button").removeAttr("onclick");
				}
				return;
			}
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "get_info_obat";
			data['bulan'] = $("#losfm_bulan").val();
			data['tahun'] = $("#losfm_tahun").val();
			data['unit'] = $("#losfm_unit").val();
			data['bulan_1'] = $("#losfm_bulan_1").text();
			data['bulan_2'] = $("#losfm_bulan_2").text();
			data['bulan_3'] = $("#losfm_bulan_3").text();
			data['num'] = num;
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) return;
					$("#losfm_list").append(json.html);
					$("#losfm_loading_bar").sload("true", "NAMA OBAT : " + json.nama_obat + " (" + (num + 1) + " / " + limit + ")", (num + 1) * 100 / limit - 1);
					self.getDataObat(num + 1, limit);
				}
			);
		};
		losfm.finalize = function() {
			var num_rows = $("tbody#losfm_list tr").length;
			var arr_tamc = {};
			/// Inisiasi Total AMC Tiap Jenis Obat dan Pelabelan Nomor :
			for (var i = 0; i < num_rows; i++) {
				$("tbody#losfm_list tr:eq(" + i + ") td#nomor").html("<small>" + (i + 1) + "</small>");
				var nama_jenis_obat = $("tbody#losfm_list tr:eq(" + i + ") td#nama_jenis_obat").text();
				arr_tamc[nama_jenis_obat] = {
					'tamc' 			: 0,
					'jumlah_item' 	: 0
				};
			}
			/// Akumulasi Total AMC Tiap Jenis Obat :
			for (var i = 0; i < num_rows; i++) {
				var nama_jenis_obat = $("tbody#losfm_list tr:eq(" + i + ") td#nama_jenis_obat").text();
				var amc = $("tbody#losfm_list tr:eq(" + i + ") td#amc").text();
				arr_tamc[nama_jenis_obat]['tamc'] += parseFloat(amc);
				arr_tamc[nama_jenis_obat]['jumlah_item'] += 1;
			}
			/// Pelabelan Nilai Total AMC pada Tiap Obat :
			for (var i = 0; i < num_rows; i++) {
				var nama_jenis_obat = $("tbody#losfm_list tr:eq(" + i + ") td#nama_jenis_obat").text();
				var rerata_per_item = Math.round(parseFloat(arr_tamc[nama_jenis_obat]['tamc']) / parseFloat(arr_tamc[nama_jenis_obat]['jumlah_item']));
				var amc = parseFloat($("tbody#losfm_list tr:eq(" + i + ") td#amc").text());
				var kelas = "FAST";
				if (amc < rerata_per_item)
					kelas = "SLOW";
				$("tbody#losfm_list tr:eq(" + i + ") td#tamc").html("<div align='right'>" + arr_tamc[nama_jenis_obat]['tamc'] + "</div>");
				$("tbody#losfm_list tr:eq(" + i + ") td#rerata").html("<div align='right'>" + rerata_per_item + "</div>");
				$("tbody#losfm_list tr:eq(" + i + ") td#kelas").html("<div align='center'>" + kelas + "</div>");
			}
			$("#losfm_loading_modal").smodal("hide");
			$("#losfm_info").html(
				"<div class='alert alert-block alert-info'>" +
					 "<center><strong>PROSES SELESAI</strong></center>" +
				 "</div>"
			);
			$("#losfm_export_button").removeAttr("onclick");
			$("#losfm_export_button").attr("onclick", "losfm.export_xls()");
		};
		losfm.export_xls = function() {
			showLoading();
			var num_rows = $("#losfm_list").children("tr").length;
			var d_data = {};
			for (var i = 0; i < num_rows; i++) {
				var nomor = $("tbody#losfm_list tr:eq(" + i + ") td#nomor").text();
				var nama_jenis_obat = $("tbody#losfm_list tr:eq(" + i + ") td#nama_jenis_obat").text();
				var nama_obat = $("tbody#losfm_list tr:eq(" + i + ") td#nama_obat").text();
				var jml_bulan_1 = $("tbody#losfm_list tr:eq(" + i + ") td#jml_bulan_1").text();
				var jml_bulan_2 = $("tbody#losfm_list tr:eq(" + i + ") td#jml_bulan_2").text();
				var jml_bulan_3 = $("tbody#losfm_list tr:eq(" + i + ") td#jml_bulan_3").text();
				var jml_total = $("tbody#losfm_list tr:eq(" + i + ") td#jml_total").text();
				var amc = $("tbody#losfm_list tr:eq(" + i + ") td#amc").text();
				var tamc = $("tbody#losfm_list tr:eq(" + i + ") td#tamc").text();
				var rerata = $("tbody#losfm_list tr:eq(" + i + ") td#rerata").text();
				var kelas = $("tbody#losfm_list tr:eq(" + i + ") td#kelas").text();
				d_data[i] = {
					"nomor" 			: nomor,
					"nama_jenis_obat"	: nama_jenis_obat,
					"nama_obat"			: nama_obat,
					"jml_bulan_1"		: jml_bulan_1,
					"jml_bulan_2"		: jml_bulan_2,
					"jml_bulan_3"		: jml_bulan_3,
					"jml_total"			: jml_total,
					"amc"				: amc,
					"tamc"				: tamc,
					"rerata"			: rerata,
					"kelas"				: kelas
				};
			}
			var data = this.getRegulerData();
			data['command'] = "export_xls";
			data['bulan'] = $("#losfm_bulan").val();
			data['bulan_label'] = $("#losfm_bulan option:selected").text();
			data['tahun'] = $("#losfm_tahun").val();
			data['unit'] = $("#losfm_unit").val();
			data['unit_label'] = $("#losfm_unit option:selected").text();
			data['bulan_1'] = $("#losfm_bulan_1").text();
			data['bulan_2'] = $("#losfm_bulan_2").text();
			data['bulan_3'] = $("#losfm_bulan_3").text();
			data['d_data'] = JSON.stringify(d_data);
			data['num_rows'] = num_rows;
			postForm(data);
			dismissLoading();
		};
		$("#losfm_bulan").on("change", function() {
			var bulan = $("#losfm_bulan").val();
			var tahun = parseFloat($("#losfm_tahun").val());
			if (bulan == 1) {
				$("#losfm_bulan_1").html("Oktober " + (tahun - 1));
				$("#losfm_bulan_2").html("November" + (tahun - 1));
				$("#losfm_bulan_3").html("Desember " + (tahun - 1));
			} else if (bulan == 2) {
				$("#losfm_bulan_1").html("November " + (tahun - 1));
				$("#losfm_bulan_2").html("Desember " + (tahun - 1));
				$("#losfm_bulan_3").html("Januari " + tahun);
			} else if (bulan == 3) {
				$("#losfm_bulan_1").html("Desember " + (tahun - 1));
				$("#losfm_bulan_2").html("Januari " + tahun);
				$("#losfm_bulan_3").html("Februari " + tahun);
			} else if (bulan == 4) {
				$("#losfm_bulan_1").html("Januari " + tahun);
				$("#losfm_bulan_2").html("Februari " + tahun);
				$("#losfm_bulan_3").html("Maret " + tahun);
			} else if (bulan == 5) {
				$("#losfm_bulan_1").html("Februari " + tahun);
				$("#losfm_bulan_2").html("Maret " + tahun);
				$("#losfm_bulan_3").html("April " + tahun);
			} else if (bulan == 6) {
				$("#losfm_bulan_1").html("Maret " + tahun);
				$("#losfm_bulan_2").html("April " + tahun);
				$("#losfm_bulan_3").html("Mei " + tahun);
			} else if (bulan == 7) {
				$("#losfm_bulan_1").html("April " + tahun);
				$("#losfm_bulan_2").html("Mei " + tahun);
				$("#losfm_bulan_3").html("Juni " + tahun);
			} else if (bulan == 8) {
				$("#losfm_bulan_1").html("Mei " + tahun);
				$("#losfm_bulan_2").html("Juni " + tahun);
				$("#losfm_bulan_3").html("Juli " + tahun);
			} else if (bulan == 9) {
				$("#losfm_bulan_1").html("Juni " + tahun);
				$("#losfm_bulan_2").html("Juli " + tahun);
				$("#losfm_bulan_3").html("Agustus " + tahun);
			} else if (bulan == 10) {
				$("#losfm_bulan_1").html("Juli " + tahun);
				$("#losfm_bulan_2").html("Agustus " + tahun);
				$("#losfm_bulan_3").html("September " + tahun);
			} else if (bulan == 11) {
				$("#losfm_bulan_1").html("Agustus " + tahun);
				$("#losfm_bulan_2").html("September " + tahun);
				$("#losfm_bulan_3").html("Oktober " + tahun);
			} else if (bulan == 12) {
				$("#losfm_bulan_1").html("September " + tahun);
				$("#losfm_bulan_2").html("Oktober " + tahun);
				$("#losfm_bulan_3").html("November " + tahun);
			}
		});
		$("#losfm_tahun").on("change", function() {
			var bulan = $("#losfm_bulan").val();
			var tahun = parseFloat($("#losfm_tahun").val());
			if (bulan == 1) {
				$("#losfm_bulan_1").html("Oktober " + (tahun - 1));
				$("#losfm_bulan_2").html("November" + (tahun - 1));
				$("#losfm_bulan_3").html("Desember " + (tahun - 1));
			} else if (bulan == 2) {
				$("#losfm_bulan_1").html("November " + (tahun - 1));
				$("#losfm_bulan_2").html("Desember " + (tahun - 1));
				$("#losfm_bulan_3").html("Januari " + tahun);
			} else if (bulan == 3) {
				$("#losfm_bulan_1").html("Desember " + (tahun - 1));
				$("#losfm_bulan_2").html("Januari " + tahun);
				$("#losfm_bulan_3").html("Februari " + tahun);
			} else if (bulan == 4) {
				$("#losfm_bulan_1").html("Januari " + tahun);
				$("#losfm_bulan_2").html("Februari " + tahun);
				$("#losfm_bulan_3").html("Maret " + tahun);
			} else if (bulan == 5) {
				$("#losfm_bulan_1").html("Februari " + tahun);
				$("#losfm_bulan_2").html("Maret " + tahun);
				$("#losfm_bulan_3").html("April " + tahun);
			} else if (bulan == 6) {
				$("#losfm_bulan_1").html("Maret " + tahun);
				$("#losfm_bulan_2").html("April " + tahun);
				$("#losfm_bulan_3").html("Mei " + tahun);
			} else if (bulan == 7) {
				$("#losfm_bulan_1").html("April " + tahun);
				$("#losfm_bulan_2").html("Mei " + tahun);
				$("#losfm_bulan_3").html("Juni " + tahun);
			} else if (bulan == 8) {
				$("#losfm_bulan_1").html("Mei " + tahun);
				$("#losfm_bulan_2").html("Juni " + tahun);
				$("#losfm_bulan_3").html("Juli " + tahun);
			} else if (bulan == 9) {
				$("#losfm_bulan_1").html("Juni " + tahun);
				$("#losfm_bulan_2").html("Juli " + tahun);
				$("#losfm_bulan_3").html("Agustus " + tahun);
			} else if (bulan == 10) {
				$("#losfm_bulan_1").html("Juli " + tahun);
				$("#losfm_bulan_2").html("Agustus " + tahun);
				$("#losfm_bulan_3").html("September " + tahun);
			} else if (bulan == 11) {
				$("#losfm_bulan_1").html("Agustus " + tahun);
				$("#losfm_bulan_2").html("September " + tahun);
				$("#losfm_bulan_3").html("Oktober " + tahun);
			} else if (bulan == 12) {
				$("#losfm_bulan_1").html("September " + tahun);
				$("#losfm_bulan_2").html("Oktober " + tahun);
				$("#losfm_bulan_3").html("November " + tahun);
			}
		});
		$(document).keyup(function(e) {
			if (e.which == 27) {
				FINISHED = true;
			}
		});
	});
</script>