<?php 
	global $db;
	require_once("gudang_farmasi/kelas/GudangFarmasiInventory.php");
	require_once("smis-base/smis-include-service-consumer.php");
	
	$laporan_form = new Form("lokr_form", "", "Gudang Farmasi : Laporan Mutasi Obat Per Ruangan");
	class UnitServiceConsumer extends ServiceConsumer {
		public function __construct($db) {
			parent::__construct($db, "is_inventory");
		}		
		public function proceedResult() {
			$content = array();
			$result = json_decode($this->result, true);
			foreach($result as $autonomous) {
				foreach($autonomous as $entity=>$res) {
					if($res['value_obat']=="1"){
						$option = array();
						$option['value'] = $entity;
						$option['name'] = ArrayAdapter::format("unslug", $res['name']);
						$content[] = $option;
					}
				}
			}
			return $content;
		}
	}
	$unit_service_consumer = new UnitServiceConsumer($db);
	$unit_service_consumer->execute();
	$unit_option = $unit_service_consumer->getContent();
	$unit_select = new Select("lokr_unit", "lokr_unit", $unit_option);
	$laporan_form->addElement("Ruangan", $unit_select);
	$tanggal_from_text = new Text("lokr_tanggal_from", "lokr_tanggal_from", "");
	$tanggal_from_text->setClass("mydate");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lokr_tanggal_to", "lokr_tanggal_to", "");
	$tanggal_to_text->setClass("mydate");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Akhir", $tanggal_to_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lokr.view()");
	$print_button = new Button("", "", "Cetak");
	$print_button->setClass("btn-inverse");
	$print_button->setIcon("fa fa-download");
	$print_button->setIsButton(Button::$ICONIC);
	$print_button->setAtribute("id='lokr_export_button'");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($print_button);
	$laporan_form->addElement("", $btn_group);
	
	$lokr_table = new Table(
		array("No. Mutasi", "Kode Obat", "Nama Obat", "Jumlah", "Satuan", "HNA", "Total HNA", "Harga Pokok", "Tgl. Exp.", "Status", "User Pengirim", "User Penerima"),
		"",
		null,
		true
	);
	$lokr_table->setName("lokr");
	$lokr_table->setAction(false);
	$lokr_table->setFooterVisible(false);
	
	if (isset($_POST['command'])) {
		if ($_POST['command'] == "get_jumlah_data") {
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$ruangan = $_POST['ruangan'];

			$jumlah = 0;
			$row = $db->get_row("
				SELECT COUNT(*) jumlah
				FROM (
					SELECT a.id, a.tanggal, a.unit, a.status, a.user_pengirim, a.user_penerima, b.kode_obat, b.nama_obat, c.jumlah, b.satuan, (d.harga_ma / 1.1) AS 'hna', b.tanggal_exp
					FROM ((smis_fr_stok_obat_keluar c LEFT JOIN smis_fr_stok_obat b ON c.id_stok_obat = b.id) LEFT JOIN smis_fr_dobat_keluar d ON c.id_dobat_keluar = d.id) LEFT JOIN smis_fr_obat_keluar a ON d.id_obat_keluar = a.id
					WHERE a.status NOT LIKE 'dikembalikan' AND d.prop LIKE '' AND c.jumlah <> 0 AND a.tanggal >= '" . $tanggal_from . "' AND a.tanggal <= '" . $tanggal_to . "' AND a.unit LIKE '" . $ruangan . "'
				) v_lokr
			");
			if ($row != null)
				$jumlah = $row->jumlah;

			$data = array();
			$data['jumlah'] = $jumlah;
			echo json_encode($data);
		} else if ($_POST['command'] == "get_info_data") {
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$ruangan = $_POST['ruangan'];
			$num = $_POST['num'];

			$no_mutasi = "";
			$kode_obat = "";
			$nama_obat = "";
			$jumlah = 0;
			$f_jumlah = "";
			$satuan = "";
			$hna = 0;
			$f_hna = "";
			$total_hna = 0;
			$f_total_hna = "";
			$harga_pokok = 0;
			$f_harga_pokok = "";
			$tanggal_exp = "";
			$status = "";
			$user_pengirim = "";
			$user_penerima = "";

			$row = $db->get_row("
				SELECT *
				FROM (
					SELECT a.id, a.tanggal, a.unit, a.status, a.user_pengirim, a.user_penerima, d.id_obat, b.kode_obat, b.nama_obat, c.jumlah, b.satuan, (d.harga_ma / 1.1) AS 'hna', b.tanggal_exp
					FROM ((smis_fr_stok_obat_keluar c LEFT JOIN smis_fr_stok_obat b ON c.id_stok_obat = b.id) LEFT JOIN smis_fr_dobat_keluar d ON c.id_dobat_keluar = d.id) LEFT JOIN smis_fr_obat_keluar a ON d.id_obat_keluar = a.id
					WHERE a.status NOT LIKE 'dikembalikan' AND d.prop LIKE '' AND c.jumlah <> 0 AND a.tanggal >= '" . $tanggal_from . "' AND a.tanggal <= '" . $tanggal_to . "' AND a.unit LIKE '" . $ruangan . "'
				) v_lokr
				LIMIT " . $num . ", 1
			");

			if ($row != null) {
				$no_mutasi = ArrayAdapter::format("digit8", $row->id);
				$kode_obat = $row->kode_obat;
				$nama_obat = $row->nama_obat;
				$jumlah = $row->jumlah;
				$f_jumlah = ArrayAdapter::format("number", $jumlah);
				$satuan = $row->satuan;
				$hna = $row->hna;
				$f_hna = ArrayAdapter::format("money Rp. ", $hna);
				$total_hna = $row->jumlah * $row->hna;
				$f_total_hna = ArrayAdapter::format("money Rp. ", $total_hna);
				$harga_pokok = GudangFarmasiInventory::getStockValue($db, $row->id_obat, $tanggal_to);
				$f_harga_pokok = ArrayAdapter::format("money Rp. ", $harga_pokok);
				$tanggal_exp = ArrayAdapter::format("date d-m-Y", $row->tanggal_exp);
				$status = ArrayAdapter::format("unslug", $row->status);
				$user_pengirim = $row->user_pengirim;
				$user_penerima = $row->user_penerima;
			}

			$html = "
				<tr>
					<td id='no_mutasi'><small>" .  $no_mutasi . "</small></td>
					<td id='kode_obat'><small>" .  $kode_obat . "</small></td>
					<td id='nama_obat'><small>" .  $nama_obat . "</small></td>
					<td id='jumlah' style='display: none;'>" .  $jumlah . "</td>
					<td id='f_jumlah'><small>" .  $f_jumlah . "</small></td>
					<td id='satuan'><small>" .  $satuan . "</small></td>
					<td id='hna' style='display: none;'>" .  $hna . "</td>
					<td id='f_hna'><small>" .  $f_hna . "</small></td>
					<td id='total_hna' style='display: none;'>" .  $total_hna . "</td>
					<td id='f_total_hna'><small>" .  $f_total_hna . "</small></td>
					<td id='harga_pokok' style='display: none;'>" .  $harga_pokok . "</td>
					<td id='f_harga_pokok'><small>" .  $f_harga_pokok . "</small></td>
					<td id='tanggal_exp'><small>" .  $tanggal_exp . "</small></td>
					<td id='status'><small>" .  $status . "</small></td>
					<td id='user_pengirim'><small>" .  $user_pengirim . "</small></td>
					<td id='user_penerima'><small>" .  $user_penerima . "</small></td>
				</tr>
			";

			$data = array();
			$data['tanggal'] = ArrayAdapter::format("date d-m-Y", $row->tanggal);
			$data['unit'] = ArrayAdapter::format("unslug", $row->unit);
			$data['nama_obat'] = $nama_obat;
			$data['html'] = $html;
			echo json_encode($data);
		} else if ($_POST['command'] == "export_xls") {
			ini_set("memory_limit", "256M");
			set_time_limit(0);
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$unit = $_POST['unit_label'];

			require_once ("smis-libs-out/php-excel/PHPExcel.php");

			$objPHPExcel = new PHPExcel();
			$objWorksheet = $objPHPExcel->getActiveSheet();
			$objWorksheet->setTitle("Laporan Mutasi Obat Per Ruangan");
			$i = 1;

			$objWorksheet->mergeCells("A" . $i . ":L" . $i)->setCellValue("A" . $i, "Laporan Mutasi Obat Per Ruangan");
			$objWorksheet->getStyle("A" . $i . ":L" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objWorksheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 1;
			$objWorksheet->mergeCells("A" . $i . ":L" . $i)->setCellValue("A" . $i, "Periode : " . ArrayAdapter::format("date d-m-Y", $tanggal_from) . " s.d. " . ArrayAdapter::format("date d-m-Y", $tanggal_to) . " | Ruangan : " . $unit);
			$objWorksheet->getStyle("A" . $i . ":L" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objWorksheet->getStyle("A" . $i)->getFont()->setBold(true);
			$i = $i + 2;

			$border_start = $i;
			$col = "A";
			$head = array("No. Mutasi", "Kode Obat", "Nama Obat", "Jumlah", "Satuan", "HNA", "Total HNA", "Harga Pokok", "Tgl. Exp.", "Status", "User Pengirim", "User Penerima");
			foreach ($head as $h)
				$objWorksheet->setCellValue($col++ . $i, $h);
			$objWorksheet->getStyle("A" . $i . ":L" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
			$objWorksheet->getStyle("A" . $i . ":L" . $i)->getFont()->setBold(true);
			$i = $i + 1;

			$data = json_decode($_POST['d_data']);
			if (count($data) > 0) {
				foreach ($data as $d) {
					$objWorksheet->setCellValue("A" . $i, $d->no_mutasi);
					$objWorksheet->setCellValue("B" . $i, $d->kode_obat);
					$objWorksheet->setCellValue("C" . $i, $d->nama_obat);
					$objWorksheet->setCellValue("D" . $i, $d->jumlah);
					$objWorksheet->setCellValue("E" . $i, $d->satuan);
					$objWorksheet->setCellValue("F" . $i, $d->hna);
					$objWorksheet->setCellValue("G" . $i, $d->total_hna);
					$objWorksheet->setCellValue("H" . $i, $d->harga_pokok);
					$objWorksheet->setCellValue("I" . $i, $d->tanggal_exp);
					$objWorksheet->setCellValue("J" . $i, $d->status);
					$objWorksheet->setCellValue("K" . $i, $d->user_pengirim);
					$objWorksheet->setCellValue("L" . $i, $d->user_penerima);
					$objWorksheet->getStyle("D" . $i)->getNumberFormat()->setFormatCode("#,##0");
					$objWorksheet->getStyle("F" . $i)->getNumberFormat()->setFormatCode("#,##0.00");
					$objWorksheet->getStyle("G" . $i)->getNumberFormat()->setFormatCode("#,##0.00");
					$objWorksheet->getStyle("H" . $i)->getNumberFormat()->setFormatCode("#,##0.00");
					$i = $i + 1;
				}
			}

			$thin = array();
			$thin['borders'] = array();
			$thin['borders']['allborders'] = array();
			$thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
			$objWorksheet->getStyle("A" . $border_start . ":L" . $i)->applyFromArray($thin);

			foreach (range('A', 'L') as $columnID)
		    	$objWorksheet->getColumnDimension($columnID)->setAutoSize(true);

			header("Content-type: application/vnd.ms-excel");	
			header("Content-Disposition: attachment; filename=LAPORAN_MUTASI_OBAT_PER_RUANGAN_" . ArrayAdapter::format("date Ymd", $tanggal_from) . "_" . ArrayAdapter::format("date Ymd", $tanggal_to) . ".xlsx");
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objWriter->save("php://output");
		}
		return;
	}
	$loading_bar = new LoadingBar("lokr_loading_bar", "");
	$button = new Button("", "", "Batal");
	$button->addClass("btn-primary");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$button->setIcon("fa fa-close");
	$button->setAction("lokr.cancel()");
	$loading_modal = new Modal("lokr_loading_modal", "", "Proses..");
	$loading_modal->addHtml($loading_bar->getHtml(), "after");
	$loading_modal->addFooter($button);
	
	echo $loading_modal->getHtml();
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo $lokr_table->getHtml();
	echo "</div>";
	echo "<div id='lokr_info'></div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("base-js/smis-base-loading.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
	function LOKRAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	LOKRAction.prototype.constructor = LOKRAction;
	LOKRAction.prototype = new TableAction();
	LOKRAction.prototype.view = function() {
		$("#lokr_info").empty();
		$("#lokr_loading_bar").sload("true", "Harap ditunggu...", 0);
		$("#lokr_loading_modal").smodal("show");
		FINISHED = false;
		var self = this;
		var data = this.getRegulerData();
		data['command'] = "get_jumlah_data";
		data['tanggal_from'] = $("#lokr_tanggal_from").val();
		data['tanggal_to'] = $("#lokr_tanggal_to").val();
		data['ruangan'] = $("#lokr_unit").val();
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				$("#lokr_list").empty();
				self.fillHtml(0, json.jumlah);
			}
		);
	};
	LOKRAction.prototype.fillHtml = function(num, limit) {
		if (FINISHED || num == limit) {
			if (FINISHED == false && num == limit) {
				this.finalize();
			} else {
				$("#lokr_loading_modal").smodal("hide");
				$("#lokr_info").html(
					"<div class='alert alert-block alert-inverse'>" +
						 "<center><strong>PROSES DIBATALKAN</strong></center>" +
					 "</div>"
				);
				$("#lokr_export_button").removeAttr("onclick");
			}
			return;
		}
		var self = this;
		var data = this.getRegulerData();
		data['command'] = "get_info_data";
		data['num'] = num;
		data['tanggal_from'] = $("#lokr_tanggal_from").val();
		data['tanggal_to'] = $("#lokr_tanggal_to").val();
		data['ruangan'] = $("#lokr_unit").val();
		data['urutan'] = $("#lokr_urutan").val();
		$.post(
			"",
			data,
			function(response) {
				var json = JSON.parse(response);
				if (json == null) return;
				$("tbody#lokr_list").append(
					json.html
				);
				$("#lokr_loading_bar").sload("true", json.tanggal + " - " + json.unit + " - " + json.nama_obat + " (" + (num + 1) + " / " + limit + ")", (num + 1) * 100 / limit - 1);
				self.fillHtml(num + 1, limit);
			}
		);
	};
	LOKRAction.prototype.finalize = function() {
		var num_rows = $("tbody#lokr_list tr").length;
		$("#lokr_loading_modal").smodal("hide");
		$("#lokr_info").html(
			"<div class='alert alert-block alert-info'>" +
				 "<center><strong>PROSES SELESAI</strong></center>" +
			 "</div>"
		);
		$("#lokr_export_button").removeAttr("onclick");
		$("#lokr_export_button").attr("onclick", "lokr.export_xls()");
	};
	LOKRAction.prototype.export_xls = function() {
		showLoading();
		var num_rows = $("#lokr_list").children("tr").length;
		var d_data = {};
		for (var i = 0; i < num_rows; i++) {
			var no_mutasi = $("tbody#lokr_list tr:eq(" + i + ") td#no_mutasi").text();
			var kode_obat = $("tbody#lokr_list tr:eq(" + i + ") td#kode_obat").text();
			var nama_obat = $("tbody#lokr_list tr:eq(" + i + ") td#nama_obat").text();
			var jumlah = $("tbody#lokr_list tr:eq(" + i + ") td#jumlah").text();
			var satuan = $("tbody#lokr_list tr:eq(" + i + ") td#satuan").text();
			var hna = $("tbody#lokr_list tr:eq(" + i + ") td#hna").text();
			var total_hna = $("tbody#lokr_list tr:eq(" + i + ") td#total_hna").text();
			var harga_pokok = $("tbody#lokr_list tr:eq(" + i + ") td#harga_pokok").text();
			var tanggal_exp = $("tbody#lokr_list tr:eq(" + i + ") td#tanggal_exp").text();
			var status = $("tbody#lokr_list tr:eq(" + i + ") td#status").text();
			var user_pengirim = $("tbody#lokr_list tr:eq(" + i + ") td#user_pengirim").text();
			var user_penerima = $("tbody#lokr_list tr:eq(" + i + ") td#user_penerima").text();
			
			d_data[i] = {
				'no_mutasi' 	: no_mutasi,
				'kode_obat'		: kode_obat,
				'nama_obat'		: nama_obat,
				'jumlah'		: jumlah,
				'satuan'		: satuan,
				'hna'			: hna,
				'total_hna'		: total_hna,
				'harga_pokok'	: harga_pokok,
				'tanggal_exp'	: tanggal_exp,
				'status'		: status,
				'user_pengirim'	: user_pengirim,
				'user_penerima' : user_penerima
			};
		}
		var data = this.getRegulerData();
		data['command'] = "export_xls";
		data['tanggal_from'] = $("#lokr_tanggal_from").val();
		data['tanggal_to'] = $("#lokr_tanggal_to").val();
		data['unit'] = $("#lokr_unit").val();
		data['unit_label'] = $("#lokr_unit option:selected").text();
		data['d_data'] = JSON.stringify(d_data);
		data['num_rows'] = num_rows;
		postForm(data);
		dismissLoading();
	};
	
	var lokr;
	FINISHED;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		$("#lokr_max").val(50);
		lokr = new LOKRAction(
			"lokr",
			"gudang_farmasi",
			"laporan_obat_keluar_per_ruangan",
			new Array()
		)
		$('.mydate').datepicker();
		$("tbody#lokr_list").append(
			"<tr>" +
				"<td colspan='11'><strong><center><small>DATA BELUM DITAMPILKAN</small></center></strong></td>" +
			"</tr>"
		);
		$(document).keyup(function(e) {
			if (e.which == 27) {
				FINISHED = true;
			}
		})
	});
</script>