<?php
	require_once("gudang_farmasi/kelas/GudangFarmasiInventory.php");
	global $db;

	if (isset($_POST['command'])) {
		if ($_POST['command'] == "get_jumlah") {
			$jumlah = $db->get_var("
				SELECT
					COUNT(*) jumlah
				FROM
					smis_fr_obat_keluar
				WHERE
					prop LIKE ''
						AND status NOT LIKE 'dibatalkan'
						AND tanggal >= '" . $_POST['tanggal_from'] . "'
						AND tanggal <= '" . $_POST['tanggal_to'] . "'
			");
			$data = array();
			$data['jumlah'] = $jumlah;
			echo json_encode($data);
		} else if ($_POST['command'] == "get_info") {
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			$num = $_POST['num'];
			
			$data_header = $db->get_row("
				SELECT
					*
				FROM
					smis_fr_obat_keluar
				WHERE
					prop LIKE ''
						AND status NOT LIKE 'dibatalkan'
						AND tanggal >= '" . $_POST['tanggal_from'] . "'
						AND tanggal <= '" . $_POST['tanggal_to'] . "'
				LIMIT
					" . $num . ", 1
			");

			$nomor_mutasi = $data_header->nomor;
			$tanggal = ArrayAdapter::format("date d-m-Y", $data_header->tanggal);
			$ruangan = ArrayAdapter::format("unslug", $data_header->unit);
			$status = ArrayAdapter::format("unslug", $data_header->status);
			$user_pengirim = $data_header->user_pengirim;
			$user_penerima = $data_header->user_penerima;

			$details = $db->get_result("
				SELECT
					d.id_obat, b.kode_obat, b.nama_obat, a.jumlah, b.satuan, b.tanggal_exp
				FROM
					smis_fr_stok_obat_keluar a
						INNER JOIN smis_fr_stok_obat b ON a.id_stok_obat = b.id
						INNER JOIN smis_fr_dobat_keluar c ON a.id_dobat_keluar = c.id
						INNER JOIN smis_fr_dobat_f_masuk d ON b.id_dobat_masuk = d.id
				WHERE
					c.id_obat_keluar = '" . $data_header->id . "'
						AND a.jumlah > 0
						AND a.prop LIKE ''
						AND c.prop LIKE ''
			");

			$html = "";
			
			if ($details != null) {
				foreach ($details as $d) {
					$id_obat = $d->id_obat;
					$kode_obat = $d->kode_obat;
					$nama_obat = $d->nama_obat;
					$jumlah = $d->jumlah;
					$satuan = $d->satuan;
					$hpp = GudangFarmasiInventory::getStockValue($db, $id_obat, $data_header->tanggal);
					$f_hpp = $hpp == 0 ? "0,00" : ArrayAdapter::format("only-money", $hpp);
					$total_hpp = $jumlah * $hpp;
					$f_total = $total_hpp == 0 ? "0,00" : ArrayAdapter::format("only-money", $total_hpp);
					$tanggal_exp = ArrayAdapter::format("date d-m-Y", $d->tanggal_exp);

					$html .= "
						<tr>
							<td id='id_obat' style='display: none;'>" .  $id_obat . "</td>
							<td id='hpp' style='display: none;'>" .  $hpp . "</td>
							<td id='total' style='display: none;'>" .  $total_hpp . "</td>
							<td id='nomor_mutasi'><small>" . $nomor_mutasi . "</small></td>
							<td id='tanggal'><small>" . $tanggal . "</small></td>
							<td id='ruangan'><small>" . $ruangan . "</small></td>
							<td id='kode_obat'><small>" . $kode_obat . "</small></td>
							<td id='nama_obat'><small>" . $nama_obat . "</small></td>
							<td id='jumlah'><small>" . $jumlah . "</small></td>
							<td id='satuan'><small>" . $satuan . "</small></td>
							<td id='f_hpp'><small>" . $f_hpp . "</small></td>
							<td id='f_hpp'><small>" . $f_total . "</small></td>
							<td id='tanggal_exp'><small>" . $tanggal_exp . "</small></td>
							<td id='status'><small>" . $status . "</small></td>
							<td id='user_pengirim'><small>" . $user_pengirim . "</small></td>
							<td id='user_penerima'><small>" . $user_penerima . "</small></td>
						</tr>
					";
				}
			}

			$data = array();
			$data['id'] = $data_header->id;
			$data['tanggal'] = $data_header->tanggal;
			$data['nama_vendor'] = $data_header->nama_vendor;
			$data['html'] = $html;
			echo json_encode($data);
		} else if ($_POST['command'] == "export_xls") {
			$nama_entitas = getSettings($db, "smis_autonomous_title", "");
			$alamat_entitas = getSettings($db, "smis_autonomous_address", "");
			$tanggal_from = $_POST['tanggal_from'];
			$tanggal_to = $_POST['tanggal_to'];
			require_once("smis-libs-out/php-excel/PHPExcel.php");
			$objPHPExcel = PHPExcel_IOFactory::load("gudang_farmasi/templates/template_rekap_mutasi_obat.xlsx");
			$objPHPExcel->setActiveSheetIndexByName("REKAP MUTASI OBAT");
			$objWorksheet = $objPHPExcel->getActiveSheet();
			$objWorksheet->setCellValue("B2", "GUDANG FARMASI - " . ArrayAdapter::format("unslug", $nama_entitas));
			$objWorksheet->setCellValue("B3", "UNIT : SEMUA");
			$objWorksheet->setCellValue("B4", "PERIODE : " . ArrayAdapter::format("date d-m-Y", $tanggal_from) . " s/d " . ArrayAdapter::format("date d-m-Y", $tanggal_to));
			$data = json_decode($_POST['d_data'], true);
			if ($_POST['num_rows'] - 2 > 0)
				$objWorksheet->insertNewRowBefore(8, $_POST['num_rows'] - 2);
			$start_row_num = 8;
			$end_row_num = 8;
			$row_num = $start_row_num;
			$no = 1;
			foreach ($data as $d) {
				$col_num = 1;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $no);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['nomor_mutasi']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['tanggal']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['ruangan']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['kode_obat']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['nama_obat']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['jumlah']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['satuan']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['hpp']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['jumlah'] * $d['hpp']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['tanggal_exp']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['status']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['user_pengirim']);
				$col_num++;
				$objWorksheet->setCellValueByColumnAndRow($col_num, $row_num, $d['user_penerima']);
				$objWorksheet->getStyle("H" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$objWorksheet->getStyle("I" . $row_num)->getNumberFormat()->setFormatCode("#,##0.00");
				$row_num++;
				$end_row_num++;
				$no++;
			}
			header("Content-type: application/vnd.ms-excel");	
			header("Content-Disposition: attachment; filename=REKAP_MUTASI_OBAT_GUDANG_FARMASI_KE_SEMUA_UNIT_" . ArrayAdapter::format("date Ymd", $tanggal_from) . "_" . ArrayAdapter::format("date Ymd", $tanggal_to) . "_" . date("Ymd_His") . ".xlsx");
			$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
			$objWriter->save("php://output");
		}
		return;
	}
	
	$laporan_form = new Form("lok_form", "", "Gudang Farmasi : Rekap Mutasi Obat");
	$tanggal_from_text = new Text("lok_tanggal_from", "lok_tanggal_from", "");
	$tanggal_from_text->setClass("mydate");
	$tanggal_from_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Awal", $tanggal_from_text);
	$tanggal_to_text = new Text("lok_tanggal_to", "lok_tanggal_to", "");
	$tanggal_to_text->setClass("mydate");
	$tanggal_to_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$laporan_form->addElement("Waktu Akhir", $tanggal_to_text);
	$show_button = new Button("", "", "Tampilkan");
	$show_button->setClass("btn-primary");
	$show_button->setIcon("icon-white icon-repeat");
	$show_button->setIsButton(Button::$ICONIC);
	$show_button->setAction("lok.view()");
	$btn_group = new ButtonGroup("noprint");
	$export_button = new Button("", "", "Unduh");
	$export_button->setClass("btn-inverse");
	$export_button->setIcon("fa fa-download");
	$export_button->setIsButton(Button::$ICONIC);
	$export_button->setAtribute("id='lok_export_button'");
	$btn_group = new ButtonGroup("noprint");
	$btn_group->addButton($show_button);
	$btn_group->addButton($export_button);
	$laporan_form->addElement("", $btn_group);

	$lok_table = new Table(
		array("No. Mutasi", "Tanggal", "Ruangan", "Kode Obat", "Nama Obat", "Jumlah", "Satuan", "HPP", "Total HPP", "Tgl. Exp.", "Status", "User Pengirim", "User Penerima"),
		"",
		null,
		true
	);
	$lok_table->setName("lok");
	$lok_table->setFooterVisible(false);
	$lok_table->setAction(false);

	$loading_bar = new LoadingBar("lok_loading_bar", "");
	$button = new Button("", "", "Batal");
	$button->addClass("btn-primary");
	$button->setIsButton(Button::$ICONIC_TEXT);
	$button->setIcon("fa fa-close");
	$button->setAction("lok.cancel()");
	$loading_modal = new Modal("lok_loading_modal", "", "Proses..");
	$loading_modal->addHtml($loading_bar->getHtml(), "after");
	$loading_modal->addFooter($button);

	echo $loading_modal->getHtml();
	echo $laporan_form->getHtml();
	echo "<div id='table_content'>";
	echo $lok_table->getHtml();
	echo "</div>";
	echo "<div id='lok_info'></div>";
	echo addJS("framework/smis/js/table_action.js");
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addJS("base-js/smis-base-loading.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
	var lok;
	var FINISHED;
	$(document).ready(function() {
		lok = new TableAction(
			"lok",
			"gudang_farmasi",
			"laporan_obat_keluar_non_apotek",
			new Array()
		);
		lok.view = function() {
			if ($("#lok_tanggal_from").val() == "" || $("#lok_tanggal_to").val() == "")
				return;
			var self = this;
			$("#lok_info").empty();
			$("#lok_loading_bar").sload("true", "Harap ditunggu...", 0);
			$("#lok_loading_modal").smodal("show");
			FINISHED = false;
			var data = this.getRegulerData();
			data['command'] = "get_jumlah";
			data['tanggal_from'] = $("#lok_tanggal_from").val();
			data['tanggal_to'] = $("#lok_tanggal_to").val();
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) return;
					$("#lok_list").empty();
					self.fillHtml(0, json.jumlah);
				}
			);
		};
		lok.fillHtml = function(num, limit) {
			if (FINISHED || num == limit) {
				if (FINISHED == false && num == limit) {
					this.finalize();
				} else {
					$("#lok_loading_modal").smodal("hide");
					$("#lok_info").html(
						"<div class='alert alert-block alert-inverse'>" +
							 "<center><strong>PROSES DIBATALKAN</strong></center>" +
						 "</div>"
					);
					$("#lok_export_button").removeAttr("onclick");
				}
				return;
			}
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "get_info";
			data['num'] = num;
			data['tanggal_from'] = $("#lok_tanggal_from").val();
			data['tanggal_to'] = $("#lok_tanggal_to").val();
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) return;
					$("tbody#lok_list").append(
						json.html
					);
					$("#lok_loading_bar").sload("true", json.id + " - " + json.tanggal + " - " + json.unit + " (" + (num + 1) + " / " + limit + ")", (num + 1) * 100 / limit - 1);
					self.fillHtml(num + 1, limit);
				}
			);
		};
		lok.finalize = function() {
			var num_rows = $("tbody#lok_list tr").length;
			$("#lok_loading_modal").smodal("hide");
			$("#lok_info").html(
				"<div class='alert alert-block alert-info'>" +
					"<center><strong>PROSES SELESAI</strong></center>" +
				"</div>"
			);
			$("#lok_export_button").removeAttr("onclick");
			$("#lok_export_button").attr("onclick", "lok.export_xls()");
		};
		lok.cancel = function() {
			FINISHED = true;
		};
		lok.export_xls = function() {
			showLoading();
			var num_rows = $("#lok_list").children("tr").length;
			var d_data = {};
			for (var i = 0; i < num_rows; i++) {
				var nomor_mutasi = $("tbody#lok_list tr:eq(" + i + ") td#nomor_mutasi").text();
				var tanggal = $("tbody#lok_list tr:eq(" + i + ") td#tanggal").text();
				var ruangan = $("tbody#lok_list tr:eq(" + i + ") td#ruangan").text();
				var id_obat = $("tbody#lok_list tr:eq(" + i + ") td#id_obat").text();
				var kode_obat = $("tbody#lok_list tr:eq(" + i + ") td#kode_obat").text();
				var nama_obat = $("tbody#lok_list tr:eq(" + i + ") td#nama_obat").text();
				var jumlah = $("tbody#lok_list tr:eq(" + i + ") td#jumlah").text();
				var satuan = $("tbody#lok_list tr:eq(" + i + ") td#satuan").text();
				var hpp = $("tbody#lok_list tr:eq(" + i + ") td#hpp").text();
				var tanggal_exp = $("tbody#lok_list tr:eq(" + i + ") td#tanggal_exp").text();
				var status = $("tbody#lok_list tr:eq(" + i + ") td#status").text();
				var user_pengirim = $("tbody#lok_list tr:eq(" + i + ") td#user_pengirim").text();
				var user_penerima = $("tbody#lok_list tr:eq(" + i + ") td#user_penerima").text();
				d_data[i] = {
					'nomor_mutasi' : nomor_mutasi,
					'tanggal' : tanggal,
					'ruangan' : ruangan,
					'id_obat' : id_obat,
					'kode_obat' : kode_obat,
					'nama_obat' : nama_obat,
					'jumlah' : jumlah,
					'satuan' : satuan,
					'hpp' : hpp,
					'tanggal_exp' : tanggal_exp,
					'status' : status,
					'user_pengirim' : user_pengirim,
					'user_penerima' : user_penerima					
				};
			}
			var data = this.getRegulerData();
			data['command'] = "export_xls";
			data['tanggal_from'] = $("#lok_tanggal_from").val();
			data['tanggal_to'] = $("#lok_tanggal_to").val();
			data['d_data'] = JSON.stringify(d_data);
			data['num_rows'] = num_rows;
			console.log(data);
			postForm(data);
			dismissLoading();
		};
		$("#lok_loading_modal").on("show", function() {
			$("a.close").hide();
		});
		$("#lok_loading_modal").on("hide", function() {
			$("a.close").show();
		});
		$("tbody#lok_list").append(
			"<tr>" +
				"<td colspan='13'><strong><center><small>LAPORAN BELUM DIPROSES</small></center></strong></td>" +
			"</tr>"
		);
		$(document).keyup(function(e) {
			if (e.which == 27) {
				FINISHED = true;
			}
		})
	});
</script>