var pengaturan_margin;
var obat;
$(document).ready(function() {
	obat = new ObatAction(
		"obat",
		"gudang_farmasi",
		"pengaturan_margin",
		new Array()
	);
	obat.setSuperCommand("obat");
	pengaturan_margin = new TableAction(
		"pengaturan_margin",
		"gudang_farmasi",
		"pengaturan_margin",
		new Array("id", "id_obat", "kode_obat", "nama_obat", "nama_jenis_obat", "margin_jual", "harga_jual", "fix_hja")
	);
	pengaturan_margin.edit = function(id) {
		var self = this;
		showLoading();	
		var edit_data = this.getEditData(id);
		$.post(
			"",
			edit_data,
			function(res) {		
			var json = getContent(res);
			if (json == null) return;
			for (var i = 0; i < self.column.length; i++) {
				if ($.inArray(self.column[i],self.noclear) !=-1 && !self.edit_clear_for_no_clear) {
					continue;
				}
				var name = self.column[i];
				var the_id = "#"+self.prefix+"_" + name;
				smis_edit( the_id, json["" + name]);
			}

			var data = self.getRegulerData();
			data['command'] = "get_max_hpp";
			data['super_command'] = "";
			data['id_obat'] = $("#pengaturan_margin_id_obat").val();
			$.post(
				"",
				data,
				function(response) {
					var jsn = JSON.parse(response);
					if (jsn == null) {
						dismissLoading();
						return;
					}
					$("#pengaturan_margin_hpp_max").val(jsn.hpp);
					$("#pengaturan_margin_tanggal_update").val(jsn.tanggal_update);

					var v_hpp = jsn.hpp.replace(/[^0-9-,]/g, '').replace(",", ".");
					var v_margin = $("#pengaturan_margin_margin_jual").val();
					var v_hja = parseFloat(v_hpp) + parseFloat(v_margin * v_hpp / 100);
					$("#pengaturan_margin_harga_jual").val(parseFloat(v_hja).formatMoney("2", ".", ","));

					dismissLoading();
					self.disabledOnEdit(self.column_disabled_on_edit);
					self.show_form();
				}
			);
		});
	};
	pengaturan_margin.downloadMasterData = function() {
		showLoading();
		var self = this;
		var data = this.getRegulerData();
		data['command'] = "download_data_master";
		$.post(
			"",
			data,
			function() {
				self.view();
				dismissLoading();
			}
		);
	};
	pengaturan_margin.exportXLS = function() {
		showLoading();
		var data = this.getRegulerData();
		data['command'] = "export_xls";
		postForm(data);
		dismissLoading();
	};
	pengaturan_margin.view();
	$("#pengaturan_margin_harga_jual").on("keyup", function(e) {
		var v_hpp = $("#pengaturan_margin_hpp_max").val().replace(/[^0-9-,]/g, '').replace(",", ".");
		var v_hja = $("#pengaturan_margin_harga_jual").val().replace(/[^0-9-,]/g, '').replace(",", ".");
		var v_margin = 0;
		if (v_hpp > 0)
			v_margin = (v_hja - v_hpp) / v_hpp * 100;
		$("#pengaturan_margin_margin_jual").val(v_margin);
	});

	$("#pengaturan_margin_margin_jual").on("keyup", function(e) {
		var v_hpp = $("#pengaturan_margin_hpp_max").val().replace(/[^0-9-,]/g, '').replace(",", ".");
		var v_margin = $("#pengaturan_margin_margin_jual").val();
		var v_hja = parseFloat(v_hpp) + parseFloat(v_margin * v_hpp / 100);
		$("#pengaturan_margin_harga_jual").val(parseFloat(v_hja).formatMoney("2", ".", ","));
	});

	$("#pengaturan_margin_fix_hja").on("change", function() {
		var fix_hja = $(this).is(":checked");
		if (fix_hja === true) {
			$("#pengaturan_margin_harga_jual").removeAttr("disabled");
			$("#pengaturan_margin_margin_jual").removeAttr("disabled");
			$("#pengaturan_margin_margin_jual").attr("disabled", "disabled");
		} else {
			$("#pengaturan_margin_harga_jual").removeAttr("disabled");
			$("#pengaturan_margin_harga_jual").attr("disabled", "disabled");
			$("#pengaturan_margin_margin_jual").removeAttr("disabled");
		}
	});
});