<?php 
	global $db;

	$stok_obat_table = new Table(
		array("Nomor", "Kode Obat", "Nama Obat", "Jenis Obat", "Produsen", "Vendor", "Jenis Stok", "Sisa", "Harga Satuan", "Ket. Jumlah", "Tgl. Exp.", "No. Batch"),
		"",
		null,
		true
	);
	$stok_obat_table->setName("stok_obat_t");
	$stok_obat_table->setReloadButtonEnable(false);
	$stok_obat_table->setPrintButtonEnable(false);
	$stok_obat_table->setAddButtonEnable(false);
	$stok_obat_table->setDelButtonEnable(false);

	$option = new OptionBuilder();
	$option->add("Semua","%%", "1");
	$tahun_rows = $db->get_result("
		SELECT 
			DISTINCT YEAR(tanggal_exp) tahun
		FROM 
			smis_fr_stok_obat
		WHERE 
			prop = '' AND sisa > 0 AND YEAR(tanggal_exp) > 0
		ORDER BY
			YEAR(tanggal_exp) ASC
	");
	if ($tahun_rows != null) {
		foreach ($tahun_rows as $tr)
			$option->addSingle($tr->tahun);
	}
	$select = new Select("stok_obat_t_tahun", "Tahun", $option->getContent());
	$tr = "<tr><td colspan='13'>" . $select->getHtml() . "</td></tr>";
	$stok_obat_table->addHeader("before", $tr);

	$export_pdf_button = new Button("", "", "");
	$export_pdf_button->setIsButton(Button::$ICONIC);
	$export_pdf_button->setIcon("fa fa-download");
	$export_pdf_button->setClass("btn-inverse");
	$export_pdf_button->setAction("stok_obat_t.export_pdf()");
	$stok_obat_table->addHeaderButton($export_pdf_button);
	
	if (isset($_POST['command'])) {
		if ($_POST['command'] == "export_pdf") {
			require_once("smis-libs-out/fpdf/fpdf.php");
			$fpdf = new FPDF("L", "mm", "A4");
			$fpdf->SetMargins(10, 10);

			$fpdf->AddPage();
			$fpdf->SetFont("Arial", "B", 10);
			$fpdf->Cell(275, 5, "LAPORAN DETAIL STOK OBAT (" . date("d-m-Y") . ")", 0, 0, "C");
			$fpdf->Ln(5);
			$fpdf->Cell(275, 5, "", 0, 0, "C");
			$fpdf->Ln(5);
			$fpdf->SetFont("Arial", "B", 8);
			$fpdf->Cell(10, 5, "No.", 1, 0, "C");
			$fpdf->Cell(20, 5, "Kode Obat", 1, 0, "C");
			$fpdf->Cell(35, 5, "Nama Obat", 1, 0, "C");
			$fpdf->Cell(30, 5, "Jenis Obat", 1, 0, "C");
			$fpdf->Cell(20, 5, "Produsen", 1, 0, "C");
			$fpdf->Cell(30, 5, "Vendor", 1, 0, "C");
			$fpdf->Cell(20, 5, "Jenis Stok", 1, 0, "C");
			$fpdf->Cell(20, 5, "Sisa", 1, 0, "C");
			$fpdf->Cell(25, 5, "Harga Satuan", 1, 0, "C");
			$fpdf->Cell(25, 5, "Ket. Jumlah", 1, 0, "C");
			$fpdf->Cell(20, 5, "Tgl. Exp.", 1, 0, "C");
			$fpdf->Cell(20, 5, "No. Batch", 1, 0, "C");
			
			$data = $db->get_result("
				SELECT *
				FROM smis_fr_stok_obat
				WHERE prop = '' AND sisa > 0
			");
			if ($data != null) {
				$nomor = 1;
				foreach ($data as $d) {
					$fpdf->Ln(5);
					$fpdf->SetFont("Arial", "", 8);
					$fpdf->Cell(10, 5, $nomor++, 1, 0, "C");
					$fpdf->Cell(20, 5, substr($d->kode_obat, 0, 10), 1, 0);
					$fpdf->Cell(35, 5, substr($d->nama_obat, 0, 15), 1, 0);
					$fpdf->Cell(30, 5, substr($d->nama_jenis_obat, 0, 12), 1, 0);
					$fpdf->Cell(20, 5, substr($d->produsen, 0, 10), 1, 0);
					$fpdf->Cell(30, 5, substr($d->nama_vendor, 0, 12), 1, 0);
					$fpdf->Cell(20, 5, ArrayAdapter::format("unslug", $d->label), 1);
					$fpdf->Cell(20, 5, $d->sisa, 1, 0, "R");
					$fpdf->Cell(25, 5, ArrayAdapter::format("only-money", $d->hna), 1, 0, "R");
					if ($d->konversi > 1)
						$fpdf->Cell(25, 5, substr("1 " . $d->satuan . " = " . $d->konversi . " " . $d->satuan_konversi, 0, 12), 1, 0);
					else
						$fpdf->Cell(25, 5, "-", 1, 0, "C");
					if ($d->tanggal_exp == "0000-00-00")
						$fpdf->Cell(20, 5, "-", 1, 0, "C");
					else
						$fpdf->Cell(20, 5, ArrayAdapter::format("date d-m-Y", $d->tanggal_exp), 1, 0);;
					if ($d->no_batch == null)
						$fpdf->Cell(20, 5, "-", 1, 0, "C");
					else
						$fpdf->Cell(20, 5, substr($d->no_batch, 0, 10), 1, 0);
				}
			}

			global $user;
		    $md5 = md5(date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "detail_stok_obat.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
			echo json_encode($pathfile);
			return;
		}
		class StokObatAdapter extends ArrayAdapter {
			public function adapt($row) {
				$array = array();
				$array['id'] = $row->id;
				$array['Nomor'] = self::format("digit8", $row->id);
				$array['Kode Obat'] = $row->kode_obat;
				$array['Nama Obat'] = $row->nama_obat;
				$array['Jenis Obat'] = $row->nama_jenis_obat;
				$array['Produsen'] = $row->produsen;
				$array['Vendor'] = $row->nama_vendor;
				$array['Jenis Stok'] = self::format("unslug", $row->label);
				$array['Sisa'] = $row->sisa . " " . $row->satuan;
				$array['Harga Satuan'] = self::format("money Rp.", $row->hna);
				if ($row->konversi > 1)
					$array['Ket. Jumlah'] = "1 " . $row->satuan . " = " . $row->konversi . " " . $row->satuan_konversi;
				else
					$array['Ket. Jumlah'] = "-";
				if ($row->tanggal_exp == "0000-00-00")
					$array['Tgl. Exp.'] = "-";
				else
					$array['Tgl. Exp.'] = self::format("date d M Y", $row->tanggal_exp);
				if ($row->no_batch == null)
					$array['No. Batch'] = "-";
				else
					$array['No. Batch'] = $row->no_batch;
				return $array;
			}
		}
		$stok_obat_adapter = new StokObatAdapter();
		$columns = array("id", "tanggal_exp");
		$stok_obat_dbtable = new DBTable(
			$db,
			"smis_fr_stok_obat",
			$columns
		);
		$filter = "";
		if (isset($_POST['filter']))
			$filter .= " AND YEAR(tanggal_exp) LIKE '" . $_POST['filter'] . "' ";
		if (isset($_POST['kriteria']))
			$filter .= " AND (nama_obat LIKE '%" . $_POST['kriteria'] . "%') ";
		
		$v_stok="
			SELECT 
				*
			FROM 
				smis_fr_stok_obat
			WHERE 
				prop = '' AND sisa > 0 " . $filter . "
		";
		$query_value = "
			SELECT *
			FROM (
				" . $v_stok . "
			) v
		";
		$query_count = "
			SELECT COUNT(*)
			FROM (
				" . $v_stok . "
			) v
		";			
		$stok_obat_dbtable->setPreferredQuery(true, $query_value, $query_count);
		$stok_obat_dbresponder = new DBResponder(
			$stok_obat_dbtable,
			$stok_obat_table,
			$stok_obat_adapter
		);
		$data = $stok_obat_dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	$stok_obat_t_modal = new Modal("stok_obat_t_add_form", "smis_form_container", "stok_obat_t");
	$stok_obat_t_modal->setTitle("Perubahan ED Obat");
	$id_hidden = new Hidden("stok_obat_t_id", "stok_obat_t_id", "");
	$stok_obat_t_modal->addElement("", $id_hidden);
	$kode_obat_text = new Text("stok_obat_t_kode_obat", "stok_obat_t_kode_obat", "");
	$kode_obat_text->setAtribute("disabled='disabled'");
	$stok_obat_t_modal->addElement("Kode Obat", $kode_obat_text);
	$nama_obat_text = new Text("stok_obat_t_nama_obat", "stok_obat_t_nama_obat", "");
	$nama_obat_text->setAtribute("disabled='disabled'");
	$stok_obat_t_modal->addElement("Nama Obat", $nama_obat_text);
	$nama_jenis_obat_text = new Text("stok_obat_t_nama_jenis_obat", "stok_obat_t_nama_jenis_obat", "");
	$nama_jenis_obat_text->setAtribute("disabled='disabled'");
	$stok_obat_t_modal->addElement("Jenis Obat", $nama_jenis_obat_text);
	$sisa_text = new Text("stok_obat_t_sisa", "stok_obat_t_sisa", "");
	$sisa_text->setAtribute("disabled='disabled'");
	$stok_obat_t_modal->addElement("Sisa", $sisa_text);
	$tanggal_exp_text = new Text("stok_obat_t_tanggal_exp", "stok_obat_t_tanggal_exp", "");
	$tanggal_exp_text->setClass("mydate");
	$tanggal_exp_text->setAtribute("data-date-format='yyyy-mm-dd'");
	$stok_obat_t_modal->addElement("Tgl. Exp.", $tanggal_exp_text);
	$no_batch_text = new Text("stok_obat_t_no_batch", "stok_obat_t_no_batch", "");
	$no_batch_text->setAtribute("disabled='disabled'");
	$stok_obat_t_modal->addElement("No. Batch", $no_batch_text);
	$save_button = new Button("", "", "Simpan");
	$save_button->setClass("btn-success");
	$save_button->setAction("stok_obat_t.save()");
	$save_button->setIcon("fa fa-floppy-o");
	$save_button->setIsButton(Button::$ICONIC);
	$stok_obat_t_modal->addFooter($save_button);
	
	echo $stok_obat_t_modal->getHtml();	
	echo $stok_obat_table->getHtml();
	echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">	
	var stok_obat_t;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		$(".mydate").datepicker();
		var stok_obat_t_columns = new Array("id", "kode_obat", "nama_obat", "nama_jenis_obat", "sisa", "tanggal_exp", "no_batch");
		stok_obat_t = new TableAction(
			"stok_obat_t",
			"gudang_farmasi",
			"daftar_stok_obat_tersimpan",
			stok_obat_t_columns
		);
		stok_obat_t.addViewData = function(view_data) {
			view_data['filter'] = $("#stok_obat_t_tahun").val();
			return view_data;
		};
		stok_obat_t.export_pdf = function() {
			var self = this;
			var data = this.getRegulerData();
			data['command'] = "export_pdf";
			showLoading();
			$.post(
				"",
				data,
				function(response) {
					var json = JSON.parse(response);
					if (json == null) {
						dismissLoading();
						return;
					}
					var getUrl = window.location['pathname'] + json;
		            window.open(getUrl, 'pdf');
		            dismissLoading();
				}
			);
		};
		stok_obat_t.view();
		$("#stok_obat_t_tahun").on("change", function() {
			stok_obat_t.view();
		});
	});
</script>