<?php 
	$daftar_obat_table = new Table(
		array("Nomor", "Kode Obat", "Nama Obat", "Jenis Obat", "Stok"),
		"Gudang Farmasi : Daftar Obat",
		null,
		true
	);
	$daftar_obat_table->setName("daftar_obat");
	$daftar_obat_table->setAddButtonEnable(false);
	$daftar_obat_table->setPrintButtonEnable(false);
	$daftar_obat_table->setReloadButtonEnable(false);
	$daftar_obat_table->setEditButtonEnable(false);
	$daftar_obat_table->setDelButtonEnable(false);
	$export_button = new Button("", "", "Eksport PDF");
	$export_button->setClass("btn-inverse");
	$export_button->setAction("daftar_obat.export_pdf()");
	$export_button->setIcon("fa fa-download");
	$export_button->setIsButton(Button::$ICONIC);
	$daftar_obat_table->addHeaderButton($export_button);
	
	if (isset($_POST['command'])) {
		if ($_POST['command'] == "export_pdf") {
			$nama_instansi = "KLINIK CASA MEDICAL PANBIL";
			$alamat_instansi_1 = "Komp. Panbil Komersil Area Blok A";
			$alamat_instansi_2 = "No. 3A Kelurahan Muka Kuning";
			$no_izin_instansi = getSettings($db, "instansi_no_ijin", "");

			$margin_left = 10;
			$margin_top = 10;
			$total = 0;
			$jumlah_item = 0;
			$jumlah_item_per_halaman = 44;

			$row = $db->get_row("
				SELECT COUNT(*) AS 'jumlah'
				FROM (
					SELECT id_obat, kode_obat, nama_obat, nama_jenis_obat, GROUP_CONCAT(CONCAT(sisa, ' ', satuan, ' ', label) ORDER BY satuan, sisa, label ASC SEPARATOR ', ') AS 'stok'
					FROM (
						SELECT v_dobat_masuk.id_obat, smis_fr_stok_obat.kode_obat, smis_fr_stok_obat.nama_obat, smis_fr_stok_obat.nama_jenis_obat, SUM(smis_fr_stok_obat.sisa) AS 'sisa', smis_fr_stok_obat.satuan, smis_fr_stok_obat.konversi, smis_fr_stok_obat.satuan_konversi, CASE smis_fr_stok_obat.label WHEN 'reguler' THEN '(R)' WHEN 'sito' THEN '(S)' ELSE '(K)' END AS 'label'
						FROM smis_fr_stok_obat LEFT JOIN (
							SELECT label, id, id_obat
							FROM smis_fr_dobat_f_masuk
						) v_dobat_masuk ON smis_fr_stok_obat.id_dobat_masuk = v_dobat_masuk.id AND smis_fr_stok_obat.label = v_dobat_masuk.label
						WHERE smis_fr_stok_obat.prop NOT LIKE 'del'
						GROUP BY v_dobat_masuk.id_obat, smis_fr_stok_obat.satuan, smis_fr_stok_obat.konversi, smis_fr_stok_obat.satuan_konversi, smis_fr_stok_obat.label
					) v_obat
					WHERE sisa > 0
					GROUP BY id_obat
				) v_stok
			");
			if ($row != null)
				$jumlah_item = $row->jumlah;
			$jumlah_halaman = floor($jumlah_item / $jumlah_item_per_halaman) + 1;

			require_once("smis-libs-out/fpdf/fpdf.php");
			$fpdf = new FPDF("P", "mm", "A4");
			$fpdf->SetFont("Arial", "B", 8);
			$fpdf->SetMargins($margin_left, $margin_top);

			for ($i_halaman = 0; $i_halaman < $jumlah_halaman; $i_halaman++) {
				$fpdf->AddPage();
				$fpdf->SetY($last_y + 10);
				$fpdf->SetX(10);
				$fpdf->Ln(4);
				$fpdf->SetFont("Arial", "B", 9);
				$fpdf->Cell(180, 5, "DAFTAR OBAT GUDANG FARMASI", 0, 0, "C");
				$fpdf->Ln(5);
				$fpdf->SetFont("Arial", "B", 8);
				$fpdf->Cell(180, 5, ArrayAdapter::format("date d-m-Y, H:i:s", date("Y-m-d H:i:s")), 0, 0, "C");
				$fpdf->Ln(10);
				$fpdf->SetFont("Arial", "B", 9);
				$fpdf->Cell(22.6, 5, "Nomor", 1, 0, "C");
				$fpdf->Cell(27.6, 5, "Kode Obat", 1, 0, "C");
				$fpdf->Cell(42.6, 5, "Nama Obat", 1, 0, "C");
				$fpdf->Cell(47.6, 5, "Jenis Obat", 1, 0, "C");
				$fpdf->Cell(47.6, 5, "Stok", 1, 0, "C");
				$fpdf->Ln(5);
				$rows = $db->get_result("
					SELECT *
					FROM (
						SELECT id_obat, kode_obat, nama_obat, nama_jenis_obat, GROUP_CONCAT(CONCAT(sisa, ' ', satuan, ' ', label) ORDER BY satuan, sisa, label ASC SEPARATOR ', ') AS 'stok'
						FROM (
							SELECT v_dobat_masuk.id_obat, smis_fr_stok_obat.kode_obat, smis_fr_stok_obat.nama_obat, smis_fr_stok_obat.nama_jenis_obat, SUM(smis_fr_stok_obat.sisa) AS 'sisa', smis_fr_stok_obat.satuan, smis_fr_stok_obat.konversi, smis_fr_stok_obat.satuan_konversi, CASE smis_fr_stok_obat.label WHEN 'reguler' THEN '(R)' WHEN 'sito' THEN '(S)' ELSE '(K)' END AS 'label'
							FROM smis_fr_stok_obat LEFT JOIN (
								SELECT label, id, id_obat
								FROM smis_fr_dobat_f_masuk
							) v_dobat_masuk ON smis_fr_stok_obat.id_dobat_masuk = v_dobat_masuk.id AND smis_fr_stok_obat.label = v_dobat_masuk.label
							WHERE smis_fr_stok_obat.prop NOT LIKE 'del'
							GROUP BY v_dobat_masuk.id_obat, smis_fr_stok_obat.satuan, smis_fr_stok_obat.konversi, smis_fr_stok_obat.satuan_konversi, smis_fr_stok_obat.label
						) v_obat
						WHERE sisa > 0
						GROUP BY id_obat
					) v
					LIMIT " . $i_halaman * $jumlah_item_per_halaman . ", " . $jumlah_item_per_halaman . "
				");

				$fpdf->SetFont("Arial", "", 9);
				if ($rows != null) {
					foreach ($rows as $row) {
						$fpdf->SetX(10);
						$fpdf->Cell(22.6, 5, ArrayAdapter::format("only-digit8", $row->id_obat), 1, 0);
						$fpdf->Cell(27.6, 5, substr($row->kode_obat, 0, 25), 1, 0);
						$fpdf->Cell(42.6, 5, substr($row->nama_obat, 0, 25), 1, 0);
						$fpdf->Cell(47.6, 5, substr($row->nama_jenis_obat, 0, 20), 1, 0);
						$fpdf->Cell(47.6, 5, substr($row->stok, 0, 25), 1, 0);
						$fpdf->Ln(5);
					}
				}
				for ($i = count($rows); $i <= $jumlah_item_per_halaman; $i++) {
					$fpdf->SetX(10);
					$fpdf->Cell(22.6, 5, "", 1, 0);
					$fpdf->Cell(27.6, 5, "", 1, 0);
					$fpdf->Cell(42.6, 5, "", 1, 0);
					$fpdf->Cell(47.6, 5, "", 1, 0);
					$fpdf->Cell(47.6, 5, "", 1, 0);
					$fpdf->Ln(5);
				}
				$fpdf->SetX(10);
				$fpdf->SetFont("Arial", "B", 8);
				$fpdf->Cell(180, 5, "Halaman " . ($i_halaman + 1) . " / " . $jumlah_halaman, 0, 0, "R");
				$fpdf->Ln(5);
			}

			global $user;
		    $md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "daftar_obat.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
			$pack = new ResponsePackage();
			$pack->setContent($pathfile);
			$pack->setStatus(ResponsePackage::$STATUS_OK);
			echo json_encode($pack->getPackage());
			return;
		}
		class DaftarObatAdapter extends ArrayAdapter {
			public function adapt($row) {
				$array = array();
				$array['id'] = $row->id_obat;
				$array['Nomor'] = self::format("digit8", $row->id_obat);
				$array['Kode Obat'] = $row->kode_obat;
				$array['Nama Obat'] = $row->nama_obat;
				$array['Jenis Obat'] = $row->nama_jenis_obat;
				$array['Stok'] = $row->stok;
				return $array;
			}
		}
		$daftar_obat_adapter = new DaftarObatAdapter();
		$columns = array("id_obat", "nama_obat", "nama_jenis_obat", "sisa");
		$daftar_obat_dbtable = new DBTable(
			$db,
			"smis_fr_stok_obat",
			$columns
		);
		$filter = "";
		if (isset($_POST['kriteria'])) {
			$filter = " AND (smis_fr_stok_obat.kode_obat LIKE '%" . $_POST['kriteria'] . "%' OR smis_fr_stok_obat.nama_obat LIKE '%" . $_POST['kriteria'] . "%' OR smis_fr_stok_obat.nama_jenis_obat LIKE '%" . $_POST['kriteria'] . "%')";
		}
		$query_value = "
			SELECT *
			FROM (
				SELECT id_obat, kode_obat, nama_obat, nama_jenis_obat, GROUP_CONCAT(CONCAT(sisa, ' ', satuan, ' ', label) ORDER BY satuan, sisa, label ASC SEPARATOR ', ') AS 'stok'
				FROM (
					SELECT v_dobat_masuk.id_obat, smis_fr_stok_obat.kode_obat, smis_fr_stok_obat.nama_obat, smis_fr_stok_obat.nama_jenis_obat, SUM(smis_fr_stok_obat.sisa) AS 'sisa', smis_fr_stok_obat.satuan, smis_fr_stok_obat.konversi, smis_fr_stok_obat.satuan_konversi, CASE smis_fr_stok_obat.label WHEN 'reguler' THEN '(R)' WHEN 'sito' THEN '(S)' ELSE '(K)' END AS 'label'
					FROM smis_fr_stok_obat LEFT JOIN (
						SELECT label, id, id_obat
						FROM smis_fr_dobat_f_masuk
					) v_dobat_masuk ON smis_fr_stok_obat.id_dobat_masuk = v_dobat_masuk.id AND smis_fr_stok_obat.label = v_dobat_masuk.label
					WHERE smis_fr_stok_obat.prop NOT LIKE 'del' " . $filter . "
					GROUP BY v_dobat_masuk.id_obat, smis_fr_stok_obat.satuan, smis_fr_stok_obat.konversi, smis_fr_stok_obat.satuan_konversi, smis_fr_stok_obat.label
				) v_obat
				WHERE sisa > 0
				GROUP BY id_obat
			) v_stok
		";
		$query_count = "
			SELECT COUNT(*)
			FROM (
				SELECT id_obat, kode_obat, nama_obat, nama_jenis_obat, GROUP_CONCAT(CONCAT(sisa, ' ', satuan, ' ', label) ORDER BY satuan, sisa, label ASC SEPARATOR ', ') AS 'stok'
				FROM (
					SELECT v_dobat_masuk.id_obat, smis_fr_stok_obat.kode_obat, smis_fr_stok_obat.nama_obat, smis_fr_stok_obat.nama_jenis_obat, SUM(smis_fr_stok_obat.sisa) AS 'sisa', smis_fr_stok_obat.satuan, smis_fr_stok_obat.konversi, smis_fr_stok_obat.satuan_konversi, CASE smis_fr_stok_obat.label WHEN 'reguler' THEN '(R)' WHEN 'sito' THEN '(S)' ELSE '(K)' END AS 'label'
					FROM smis_fr_stok_obat LEFT JOIN (
						SELECT label, id, id_obat
						FROM smis_fr_dobat_f_masuk
					) v_dobat_masuk ON smis_fr_stok_obat.id_dobat_masuk = v_dobat_masuk.id AND smis_fr_stok_obat.label = v_dobat_masuk.label
					WHERE smis_fr_stok_obat.prop NOT LIKE 'del' " . $filter . "
					GROUP BY v_dobat_masuk.id_obat, smis_fr_stok_obat.satuan, smis_fr_stok_obat.konversi, smis_fr_stok_obat.satuan_konversi, smis_fr_stok_obat.label
				) v_obat
				WHERE sisa > 0
				GROUP BY id_obat
			) v_stok
		";
		$daftar_obat_dbtable->setPreferredQuery(true, $query_value, $query_count);
		$daftar_obat_dbresponder = new DBResponder(
			$daftar_obat_dbtable,
			$daftar_obat_table,
			$daftar_obat_adapter
		);
		$data = $daftar_obat_dbresponder->command($_POST['command']);
		echo json_encode($data);
		return;
	}
	
	echo $daftar_obat_table->getHtml();
	echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
	function DaftarObatAction(name, page, action, column) {
		this.initialize(name, page, action, column);
	}
	DaftarObatAction.prototype.constructor = DaftarObatAction;
	DaftarObatAction.prototype = new TableAction();
	DaftarObatAction.prototype.export_pdf = function() {
		var self = this;
		var data = this.getRegulerData();
		data['command'] = "export_pdf";
		showLoading();
		$.post(
			"",
			data,
			function(response) {
				var json = getContent(response);
				if (json == null) {
					dismissLoading();
					return;
				}
				var getUrl = window.location['pathname'] + json;
	            window.open(getUrl, 'pdf');
	            dismissLoading();
			}
		);
	};
	
	var daftar_obat;
	$(document).ready(function() {
		$('[data-toggle="popover"]').popover({
			trigger: 'hover',
			'placement': 'top'
		});
		$("#daftar_obat_max").val(50);
		var daftar_obat_columns = new Array("id_obat", "nama_obat", "nama_jenis_obat", "sisa");
		daftar_obat = new DaftarObatAction(
			"daftar_obat",
			"gudang_farmasi",
			"daftar_obat",
			daftar_obat_columns
		);
		daftar_obat.view();
	});
</script>