<?php
	class PengecekanStokUnitAdapter extends ArrayAdapter {
		public function adapt($row) {
			$arr = array();
			$arr['No.'] = ++$this->number;
			$arr['Obat'] = $row->nama_obat;
			$arr['Jenis Obat'] = $row->nama_jenis_obat;
			$arr['Stok Minimum'] = self::format("number", $row->stok_minimum);
			$arr['Stok Maksimum'] = self::format("number", $row->stok_maksimum);
			$is_red = false;
			if (
				$row->stok > $row->stok_maksimum ||
				$row->stok < $row->stok_minimum ||
				0.8 * $row->stok <= $row->stok_minimum
			)
				$is_red = true;
			if ($is_red == false)
				$arr['Stok Aktual'] = self::format("number", $row->stok);
			else
				$arr['Stok Aktual'] = "<strong><font color='red'>" . self::format("number", $row->stok) . "</font></storng>";
			$arr['Satuan'] = $row->satuan;
			return $arr;
		}
	}
?>