<?php
class ObatKeluarAdapter extends ArrayAdapter {
	public function adapt($row) {
		$array = array();
		$array['id'] = $row->id;
		$array['nomor'] = $row->nomor;
		$array['status'] = $row->status;
		$array['status_acc'] = $row->status_acc;
		$array['restock'] = $row->restock;
		$array['Nomor'] = ArrayAdapter::format("digit8", $row->id);
		$array['Kode'] = $row->nomor;
		$array['Tanggal Keluar'] = self::format("date d M Y", $row->tanggal);
		$array['Unit'] = self::format("unslug", $row->unit);
		if ($row->status == "sudah")
			$array['Status'] = "Sudah Diterima";
		else if ($row->status == "dikembalikan")
			$array['Status'] = "Dikembalikan";
		else if ($row->status_acc == 0)
			$array['Status'] = "Menunggu Acc. Mutasi";
		else
			$array['Status'] = "Belum Diterima";
		return $array;
	}
}
?>