<?php
require_once("smis-base/smis-include-service-consumer.php");
require_once("smis-base/smis-include-duplicate.php");
global $db;

$table = new Table(
    array("No.", "No. BBM", "No. OPL", "No. Faktur", "Tgl. Faktur", "Rekanan", "Klinik", "Tgl. Diterima", "Jatuh Tempo", "Status Acc."),
    "Gudang Farmasi : Acc. Penerimaan Obat (BBM - OPL)",
    null,
    true
);
$table->setName("acc_penerimaan_obat");
$table->setPrintButtonEnable(false);
$table->setReloadButtonEnable(false);
$table->setAddButtonEnable(false);
$table->setEditButtonEnable(false);
$table->setDelButtonEnable(false);
$button = new Button("", "", "Lihat");
$button->setClass("btn btn-inverse");
$table->addContentButton("detail", $button);

if (isset($_POST['command'])) {
    if ($_POST['command'] == "get_html_detail_faktur") {
        $html = "";
        $id_bbm = $_POST['id'];

        $table_header = "smis_fr_obat_f_masuk";
        $table_detail = "smis_fr_dobat_f_masuk";
        $table_stok = "smis_fr_stok_obat";
        $id_header = "id_obat_f_masuk";
        $id_detail = "id_dobat_masuk";

        $header_row = $db->get_row("
                SELECT 
                    *
                FROM 
                    " . $table_header . "
                WHERE 
                    id = '" . $id_bbm . "'
            ");
        $detail_rows = $db->get_result("
                SELECT 
                    a.*, CASE WHEN b.tanggal_exp IS NULL THEN '-' ELSE b.tanggal_exp END AS 'tanggal_exp', CASE WHEN b.no_batch IS NULL THEN '-' ELSE b.no_batch END AS 'no_batch'
                FROM 
                    " . $table_detail . " a 
                        LEFT JOIN " . $table_stok . " b ON a.id = b." . $id_detail . "
                WHERE 
                    a." . $id_header . " = '" . $id_bbm . "' 
                        AND a.prop LIKE ''
            ");

        $html .= "<div id='detail_bbm_id' style='display: none;'>" . $id_bbm . "</div>";
        $html .= "<table border='1' width='100%'>";
        $html .= "<caption><center>FAKTUR " . strtoupper($header_row->nama_klinik) . " (" . strtoupper($header_row->nama_vendor) . ")</center></caption>";
        if ($detail_rows != null) {
            $nomor = 1;
            $total = 0;
            $html .=    "<thead>
                        <tr>
                            <th>No.</th>
                            <th>Kode</th>
                            <th>Nama</th>
                            <th>Jenis</th>
                            <th>Stok Entri</th>
                            <th>Jml. Tercatat</th>
                            <th>Jml. Diterima</th>
                            <th>Satuan</th>
                            <th>Konversi</th>
                            <th>Stn. Konversi</th>
                            <th>Harga</th>
                            <th>Diskon</th>
                            <th>Subtotal</th>
                        </tr>
                    </thead>
                    <tbody>";
            foreach ($detail_rows as $detail_row) {
                $subtotal = $detail_row->hna * $detail_row->jumlah;
                $hpp = $detail_row->hna;
                if ($header_row->use_ppn == 1) {
                    $subtotal = $detail_row->hna / 1.1 * $detail_row->jumlah;
                    $hpp = $detail_row->hna / 1.1;
                }
                $f_diskon = $detail_row->diskon . " %";
                if ($detail_row->t_diskon == "nominal") {
                    $f_diskon = ArrayAdapter::format("only-money", $detail_row->diskon);
                    $subtotal = $subtotal - $detail_row->diskon;
                } else {
                    $subtotal = $subtotal - ($detail_row->diskon * $subtotal / 100);
                }
                $subtotal = round($subtotal);
                $total += $subtotal;
                $f_subtotal = ArrayAdapter::format("money", $subtotal);
                $html .=    "<tr>
                                    <td id='nomor'>" . $nomor++ . "</td>
                                    <td id='kode_obat'>" . $detail_row->kode_obat . "</td>
                                    <td id='nama_obat'>" . $detail_row->nama_obat . "</td>
                                    <td id='nama_jenis_obat'>" . $detail_row->nama_jenis_obat . "</td>
                                    <td id='f_stok_entri'>" . ArrayAdapter::format("number", $detail_row->stok_entri) . "</td>
                                    <td id='f_jumlah_tercatat'>" . ArrayAdapter::format("number", $detail_row->jumlah_tercatat) . "</td>
                                    <td id='f_jumlah'>" . ArrayAdapter::format("number", $detail_row->jumlah) . "</td>
                                    <td id='satuan'>" . $detail_row->satuan . "</td>
                                    <td id='konversi'>" . $detail_row->konversi . "</td>
                                    <td id='satuan_konversi'>" . $detail_row->satuan_konversi . "</td>
                                    <td id='f_hna'>" . ArrayAdapter::format("money", $hpp) . "</td>
                                    <td id='f_diskon'><div align='right'>" . $f_diskon . "</div></td>
                                    <td id='f_subtotal'>" . $f_subtotal . "</td>
                                </tr>";
            }
        }
        $global_diskon = $header_row->diskon;
        $global_t_diskon = $header_row->t_diskon;
        if ($global_t_diskon == "persen") {
            $global_diskon = $global_diskon * $total / 100;
        }
        $global_diskon = floor($global_diskon);
        $total_1 = $total - $global_diskon;
        $use_ppn = $header_row->use_ppn;
        $ppn = floor($total_1 * 0.1);
        if ($use_ppn == 0) {
            $ppn = 0;
        }
        $total_2 = $total_1 + $ppn;
        $tambahan_biaya = $header_row->materai;
        $tagihan = $total_2 + $tambahan_biaya;
        $html .=    "</tbody>
                    <tfoot>
                        <tr>
                            <td colspan='12'><div align='right'><strong>Total I</strong></div></td>
                            <td id='total'><div align='right'>" . ArrayAdapter::format("only-money", $total) . "</div></td>
                        </tr>
                        <tr>
                            <td colspan='12'><div align='right'><strong>Diskon</strong></div></td>
                            <td id='diskon_global'><div align='right'>" . ArrayAdapter::format("only-money", $global_diskon) . "</div></td>
                        </tr>
                        <tr>
                            <td colspan='12'><div align='right'><strong>Total II</strong></div></td>
                            <td id='total_2'><div align='right'>" . ArrayAdapter::format("only-money", $total_1) . "</div></td>
                        </tr>
                        <tr>
                            <td colspan='12'><div align='right'><strong>PPn</strong></div></td>
                            <td id='ppn'><div align='right'>" . ArrayAdapter::format("only-money", $ppn) . "</div></td>
                        </tr>
                        <tr>
                            <td colspan='12'><div align='right'><strong>Tambahan Biaya</strong></div></td>
                            <td id='tambahan_biaya'><div align='right'>" . ArrayAdapter::format("only-money", $tambahan_biaya) . "</div></td>
                        </tr>
                        <tr>
                            <td colspan='12'><div align='right'><strong>Jumlah Tagihan</strong></div></td>
                            <td id='tagihan'><div align='right'>" . ArrayAdapter::format("only-money", $tagihan) . "</div></td>
                        </tr>
                    </tfoot>";
        $html .= "</table>";

        echo json_encode([
            'html' => $html
        ]);
        return;
    }
    $adapter = new SimpleAdapter(true, "No.");
    $adapter->add("No. BBM", "no_bbm");
    $adapter->add("No. OPL", "no_opl");
    $adapter->add("No. Faktur", "no_faktur");
    $adapter->add("Tgl. Faktur", "tanggal", "date d-m-Y");
    $adapter->add("Rekanan", "nama_vendor");
    $adapter->add("Klinik", "nama_klinik");
    $adapter->add("Tgl. Diterima", "tanggal_datang", "date d-m-Y");
    $adapter->add("Jatuh Tempo", "tanggal_tempo", "date d-m-Y");
    $adapter->add("Status Acc.", "status_acc", "trivial_0_Belum Disetujui_Sudah Disetujui");
    $dbtable = new DBTable($db, "smis_fr_obat_f_masuk");
    $dbtable->addCustomKriteria(" id ", " <> 0 ");
    $dbtable->addCustomKriteria(" status_acc ", " = 0 ");
    $dbtable->setOrder(" id DESC ");

    class AccObatMasukDBResponder extends DuplicateResponder
    {
        public function command($command)
        {
            if ($command != "accept") {
                return parent::command($command);
            }
            $responsePackage = new ResponsePackage();
            if ($command == "accept") {
                $responsePackage->setStatus(ResponsePackage::$STATUS_OK);
                $content = $this->acceptTransaction();
                $responsePackage->setContent($content);
                if ($content['success'] == 1) {
                    $responsePackage->setAlertVisible(true);
                    $responsePackage->setAlertContent("Data Saved", "Your Data Had Been Saved", ResponsePackage::$TIPE_INFO);
                } else {
                    $responsePackage->setAlertVisible(false);
                }
            }
            return $responsePackage->getPackage();
        }

        private function acceptTransaction()
        {
            $id['id'] = $_POST['id'];

            $header_data = $this->dbtable->select($id);
            $id_obat_keluar = $this->createObatKeluarData($header_data);

            if ($id_obat_keluar > 0) {
                $this->pushAutoConfirmObatMasukUnitData($id_obat_keluar);
                $data['status_acc'] = "1";
                $this->dbtable->update($data, $id);
            }

            return [
                'type' => "update",
                'id' => $id['id'],
                'success' => 1
            ];
        }

        private function createObatKeluarData($header_data)
        {
            $slug_depo = $this->dbtable->get_var("
                SELECT
                    depo
                FROM
                    smis_fr_faskes_depo
                WHERE
                    faskes LIKE '" . $header_data->nama_klinik . "'
                        AND prop = ''
                ORDER BY
                    id DESC
                LIMIT
                    0, 1
            ");

            // Obat Keluar Unit :
            global $user;
            $data_obat_keluar = array(
                'tanggal' => date("Y-m-d"),
                'unit' => $slug_depo,
                'status' => "sudah",
                'keterangan' => "",
                'user_acc' => $user->getNameOnly(),
                'status_acc' => 1,
                'tanggal_acc' => date("Y-m-d H:i:s")
            );
            $obat_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_obat_keluar");
            $obat_keluar_dbtable->insert($data_obat_keluar);
            $id_obat_keluar = $obat_keluar_dbtable->get_inserted_id();
            $obat_keluar_dbtable->update([
                'nomor' => $id_obat_keluar
            ], [
                'id' => $id_obat_keluar
            ]);

            // Detail Obat Keluar Unit :
            $detail_obat_keluar_rows = $this->dbtable->get_result("
                SELECT
                    b.id_obat, c.*
                FROM
                    smis_fr_obat_f_masuk a
                        INNER JOIN smis_fr_dobat_f_masuk b ON a.id = b.id_obat_f_masuk
                        INNER JOIN smis_fr_stok_obat c ON b.id = c.id_dobat_masuk
                WHERE
                    a.id = '" . $header_data->id . "'
                        AND b.prop = ''
                        AND c.prop = ''
                        AND c.sisa > 0
            ");
            if ($detail_obat_keluar_rows != null) {
                $dobat_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_dobat_keluar");
                $ks_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_kartu_stok");
                $stok_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat");
                $riwayat_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_riwayat_stok_obat");
                $stok_keluar_dbtable = new DBTable($this->dbtable->get_db(), "smis_fr_stok_obat_keluar");
                foreach ($detail_obat_keluar_rows as $detail_obat_keluar_row) {
                    $detail_data = array();
                    $detail_data['id_obat_keluar'] = $id_obat_keluar;
                    $detail_data['id_obat'] = $detail_obat_keluar_row->id_obat;
                    $detail_data['kode_obat'] = $detail_obat_keluar_row->kode_obat;
                    $detail_data['nama_obat'] = $detail_obat_keluar_row->nama_obat;
                    $detail_data['nama_jenis_obat'] = $detail_obat_keluar_row->nama_jenis_obat;
                    $detail_data['stok_entri'] = 0;
                    $detail_data['harga_ma'] = $detail_obat_keluar_row->hna;
                    $detail_data['jumlah_diminta'] = 0;
                    $detail_data['jumlah'] = $detail_obat_keluar_row->sisa;
                    $detail_data['satuan'] = $detail_obat_keluar_row->satuan;
                    $detail_data['konversi'] = $detail_obat_keluar_row->konversi;
                    $detail_data['satuan_konversi'] = $detail_obat_keluar_row->satuan_konversi;
                    $detail_data['autonomous'] = "[" . $this->getAutonomous() . "]";
                    $detail_data['duplicate'] = 0;
                    $detail_data['time_updated'] = date("Y-m-d H:i:s");
                    $detail_data['origin_updated'] = $this->getAutonomous();
                    $detail_data['origin'] = $this->getAutonomous();
                    $dobat_keluar_dbtable->insert($detail_data);
                    $id_dobat_keluar = $dobat_keluar_dbtable->get_inserted_id();

                    $detail_data = array();
                    $detail_data['origin_id'] = $id_dobat_keluar;
                    $detail_data_id = array();
                    $detail_data_id['id'] = $id_dobat_keluar;
                    $dobat_keluar_dbtable->update($detail_data, $detail_data_id);

                    // Kartu Stok :
                    $ks_data = array();
                    $ks_data['f_id'] = $id_dobat_keluar;
                    $ks_data['unit'] = ArrayAdapter::format("unslug", $slug_depo);
                    $ks_data['no_bon'] = $id_obat_keluar;
                    $ks_data['id_obat'] = $detail_obat_keluar_row->id_obat;
                    $ks_data['kode_obat'] = $detail_obat_keluar_row->kode_obat;
                    $ks_data['nama_obat'] = $detail_obat_keluar_row->nama_obat;
                    $ks_data['nama_jenis_obat'] = $detail_obat_keluar_row->nama_jenis_obat;
                    $ks_data['tanggal'] = date("Y-m-d");
                    $ks_data['masuk'] = 0;
                    $ks_data['keluar'] = $detail_obat_keluar_row->sisa;
                    $ks_row = $this->dbtable->get_row("
                        SELECT SUM(b.sisa) AS 'jumlah'
                        FROM smis_fr_dobat_f_masuk a LEFT JOIN smis_fr_stok_obat b ON a.id = b.id_dobat_masuk
                        WHERE b.prop NOT LIKE 'del' AND a.id_obat = '" . $detail_obat_keluar_row->id_obat . "'
                    ");
                    $ks_data['sisa'] = $ks_row->jumlah - $detail_obat_keluar_row->jumlah;
                    $ks_data['autonomous'] = "[" . $this->getAutonomous() . "]";
                    $ks_data['duplicate'] = 0;
                    $ks_data['time_updated'] = date("Y-m-d H:i:s");
                    $ks_data['origin_updated'] = $this->getAutonomous();
                    $ks_data['origin'] = $this->getAutonomous();
                    $ks_dbtable->insert($ks_data);
                    $id_kartu_stok = $ks_dbtable->get_inserted_id();

                    $ks_data = array();
                    $ks_data['origin_id'] = $id_kartu_stok;
                    $ks_data_id = array();
                    $ks_data_id['id'] = $id_kartu_stok;
                    $ks_dbtable->update($ks_data, $ks_data_id);

                    // Stok Obat
                    $stok_data = array();
                    $stok_data['sisa'] = 0;
                    $stok_data['autonomous'] = "[" . $this->getAutonomous() . "]";
                    $stok_data['duplicate'] = 0;
                    $stok_data['time_updated'] = date("Y-m-d H:i:s");
                    $stok_data['origin_updated'] = $this->getAutonomous();
                    $stok_id['id'] = $detail_obat_keluar_row->id;
                    $stok_dbtable->update($stok_data, $stok_id);

                    // Riwayat Stok Obat
                    $data_riwayat = array();
                    $data_riwayat['tanggal'] = date("Y-m-d");
                    $data_riwayat['id_stok_obat'] = $detail_obat_keluar_row->id;
                    $data_riwayat['jumlah_keluar'] = $detail_obat_keluar_row->sisa;
                    $data_riwayat['sisa'] = 0;
                    $data_riwayat['keterangan'] = "Stok Keluar ke " . ArrayAdapter::format("unslug", $slug_depo);
                    $data_riwayat['nama_user'] = $user->getName();
                    $data_riwayat['autonomous'] = "[" . $this->getAutonomous() . "]";
                    $data_riwayat['duplicate'] = 0;
                    $data_riwayat['time_updated'] = date("Y-m-d H:i:s");
                    $data_riwayat['origin_updated'] = $this->getAutonomous();
                    $data_riwayat['origin'] = $this->getAutonomous();
                    $riwayat_dbtable->insert($data_riwayat);
                    $id_riwayat_stok = $riwayat_dbtable->get_inserted_id();

                    $data_riwayat = array();
                    $data_riwayat['origin_id'] = $id_riwayat_stok;
                    $data_riwayat_id = array();
                    $data_riwayat_id['id'] = $id_riwayat_stok;
                    $riwayat_dbtable->update($data_riwayat, $data_riwayat_id);

                    // Stok Obat Keluar
                    $stok_keluar_data = array();
                    $stok_keluar_data['id_dobat_keluar'] = $id_dobat_keluar;
                    $stok_keluar_data['id_stok_obat'] = $detail_obat_keluar_row->id;
                    $stok_keluar_data['jumlah'] = $detail_obat_keluar_row->sisa;
                    $stok_keluar_data['autonomous'] = "[" . $this->getAutonomous() . "]";
                    $stok_keluar_data['duplicate'] = 0;
                    $stok_keluar_data['time_updated'] = date("Y-m-d H:i:s");
                    $stok_keluar_data['origin_updated'] = $this->getAutonomous();
                    $stok_keluar_data['origin'] = $this->getAutonomous();
                    $stok_keluar_dbtable->insert($stok_keluar_data);
                    $id_stok_obat_keluar = $stok_keluar_dbtable->get_inserted_id();

                    $stok_keluar_data = array();
                    $stok_keluar_data['origin_id'] = $id_stok_obat_keluar;
                    $stok_keluar_data_id = array();
                    $stok_keluar_data_id['id'] = $id_stok_obat_keluar;
                    $stok_keluar_dbtable->update($stok_keluar_data, $stok_keluar_data_id);
                }
            }

            return $id_obat_keluar;
        }

        private function pushAutoConfirmObatMasukUnitData($id_obat_keluar)
        {
            $obat_keluar_row = $this->dbtable->get_row("
                SELECT *
                FROM smis_fr_obat_keluar
                WHERE id = '" . $id_obat_keluar . "'
            ");
            $detail = $this->dbtable->get_result("
                SELECT 
                    a.id AS 'id_stok_obat_keluar', b.id_obat, b.kode_obat, b.nama_obat, b.nama_jenis_obat, c.formularium, c.berlogo, c.generik, c.label, c.id_vendor, c.nama_vendor, a.jumlah, b.satuan, b.konversi, b.satuan_konversi, c.hna, c.produsen, c.tanggal_exp, c.no_batch, a.prop
                FROM 
                    smis_fr_stok_obat_keluar a 
                        LEFT JOIN smis_fr_stok_obat c ON a.id_stok_obat = c.id 
                        LEFT JOIN smis_fr_dobat_keluar b ON a.id_dobat_keluar = b.id
                WHERE 
                    b.id_obat_keluar = '" . $id_obat_keluar . "'
            ");
            $command = "push_save";
            require_once("gudang_farmasi/service_consumer/PushObatServiceConsumer.php");
            $push_obat_service_consumer = new PushObatServiceConsumer($this->dbtable->get_db(), $obat_keluar_row->id, $obat_keluar_row->tanggal, $obat_keluar_row->unit, $obat_keluar_row->status, $obat_keluar_row->keterangan, $detail, $command);
            $push_obat_service_consumer->execute();
        }
    }

    $dbresponder = new AccObatMasukDBResponder(
        $dbtable,
        $table,
        $adapter
    );
    $data = $dbresponder->command($_POST['command']);
    echo json_encode($data);
    return;
}

$detail_bbm_modal = new Modal("detail_bbm_form", "", "Detail Faktur");
$detail_bbm_modal->setClass(Modal::$HALF_MODEL);
$acc_button = new Button("", "", "Setuju");
$acc_button->setClass("btn-success");
$acc_button->setAction("acc_penerimaan_obat.accept()");
$detail_bbm_modal->addFooter($acc_button);

echo $detail_bbm_modal->getHtml();
echo $table->getHtml();
echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
    var acc_penerimaan_obat;
    $(document).ready(function() {
        acc_penerimaan_obat = new TableAction(
            "acc_penerimaan_obat",
            "gudang_farmasi",
            "acc_penerimaan_obat",
            new Array()
        );
        acc_penerimaan_obat.detail = function(id) {
            var data = this.getRegulerData();
            data['command'] = "get_html_detail_faktur";
            data['id'] = id;
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dimissLoading();
                        return;
                    }
                    $("#detail_bbm_form_form").html(json.html);
                    $("#detail_bbm_form").smodal("show");
                    dismissLoading();
                }
            );
        };
        acc_penerimaan_obat.accept = function() {
            var self = this;
            var id = $("#detail_bbm_id").text();
            var data = this.getRegulerData();
            data['command'] = "accept";
            data['id'] = id;
            $("#detail_bbm_form").smodal("hide");
            bootbox.confirm({
                'title': "Konfirmasi",
                'message': "Yakin menyetujui BBM ini?",
                buttons: {
                    confirm: {
                        label: 'Ya',
                        className: 'btn-success'
                    },
                    cancel: {
                        label: 'Tidak',
                        className: 'btn-danger'
                    }
                },
                callback: function(result) {
                    if (result) {
                        showLoading();
                        $.post(
                            "",
                            data,
                            function(response) {
                                var json = getContent(response);
                                if (json == null) {
                                    dismissLoading();
                                    $("#detail_bbm_form").smodal("show");
                                    return;
                                }
                                dismissLoading();
                                self.view();
                            }
                        );
                    } else {
                        $("#detail_bbm_form").smodal("show");
                    }
                }
            });
        };
        acc_penerimaan_obat.view();
    });
</script>