<?php
    require_once("smis-base/smis-include-service-consumer.php");
    global $db;

    $table = new Table(
        array("Nomor", "Tanggal Keluar", "Unit", "Status Acc."),
        "Gudang Farmasi : Acc. Obat Keluar - Unit",
        null,
        true
    );
    $table->setName("acc_obat_keluar");
    $table->setAddButtonEnable(false);
    $table->setReloadButtonEnable(false);
    $table->setPrintButtonEnable(false);
    $table->setEditButtonEnable(false);
    $table->setDelButtonEnable(false);

    $detail_button = new Button("", "", "Review");
    $detail_button->setIsButton(Button::$ICONIC_TEXT);
    $detail_button->setIcon("icon-eye-open icon-white");
    $detail_button->setClass("btn btn-inverse");
    $table->addContentButton("review", $detail_button);

    if (isset($_POST['command'])) {
        $dbtable = new DBTable($db, "smis_fr_obat_keluar");
        $dbtable->addCustomKriteria("status_acc", " = 0 ");
        $dbtable->addCustomKriteria("status", " LIKE 'belum' ");
        $dbtable->setOrder(" id DESC ");

        if ($_POST['command'] == "confirm") {
            $id['id'] = $_POST['id'];
            global $user;
            $data = [
                'user_acc' => $user->getNameOnly(),
                'status_acc' => 1,
                'tanggal_acc' => date("Y-m-d H:i:s")
            ];
            $dbtable->update($data, $id);

            $obat_keluar_row = $db->get_row("
                SELECT *
                FROM smis_fr_obat_keluar
                WHERE id = '" . $id['id'] . "'
            ");
            $detail = $db->get_result("
                SELECT 
                    a.id AS 'id_stok_obat_keluar', b.id_obat, b.kode_obat, b.nama_obat, b.nama_jenis_obat, c.formularium, c.berlogo, c.generik, c.label, c.id_vendor, c.nama_vendor, a.jumlah, b.satuan, b.konversi, b.satuan_konversi, c.hna, c.produsen, c.tanggal_exp, c.no_batch, a.prop
                FROM 
                    smis_fr_stok_obat_keluar a 
                        LEFT JOIN smis_fr_stok_obat c ON a.id_stok_obat = c.id 
                        LEFT JOIN smis_fr_dobat_keluar b ON a.id_dobat_keluar = b.id
                WHERE 
                    b.id_obat_keluar = '" . $id['id'] . "'
            ");
            $command = "push_save";
            require_once("gudang_farmasi/service_consumer/PushObatServiceConsumer.php");
            $push_obat_service_consumer = new PushObatServiceConsumer($db, $obat_keluar_row->id, $obat_keluar_row->tanggal, $obat_keluar_row->unit, $obat_keluar_row->status, $obat_keluar_row->keterangan, $detail, $command);
            $push_obat_service_consumer->execute();

            echo json_encode([
                'status' => 1
            ]);
            return;
        }

        $adapter = new SimpleAdapter();
        $adapter->add("Nomor", "id", "digit8");
        $adapter->add("Tanggal Keluar", "tanggal", "date d M Y");
        $adapter->add("Unit", "unit", "unslug");
        $adapter->add("Status Acc.", "status_acc", "trivial_0_Belum Acc._Sudah Acc.");

        require_once("gudang_farmasi/responder/ObatKeluarDBResponder.php");
        $dbresponder = new ObatKeluarDBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    $modal = new Modal("acc_obat_keluar_add_form", "smis_form_container", "acc_obat_keluar");
    $modal->setTitle("Acc. Obat Keluar");
    $modal->setClass(Modal::$FULL_MODEL);
    $id_text = new Text("acc_obat_keluar_id", "acc_obat_keluar_id", "");
    $id_text->setAtribute("disabled='disabled'");
    $modal->addElement("Nomor", $id_text);
    $nomor_hidden = new Hidden("acc_obat_keluar_nomor", "acc_obat_keluar_nomor", "");
    $modal->addElement("", $nomor_text);
    $tanggal_text = new Text("acc_obat_keluar_tanggal", "acc_obat_keluar_tanggal", "");
    $tanggal_text->setClass("mydate");
    $tanggal_text->setAtribute("data-date-format='yyyy-m-d'");
    $modal->addElement("Tanggal", $tanggal_text);
    require_once("gudang_farmasi/service_consumer/UnitServiceConsumer.php");
    $unit_service_consumer = new UnitServiceConsumer($db);
    $unit_service_consumer->execute();
    $unit_option = $unit_service_consumer->getContent();
    $unit_select = new Select("acc_obat_keluar_unit", "acc_obat_keluar_unit", $unit_option);
    $modal->addElement("Unit", $unit_select);
    $dacc_obat_keluar_table = new Table(
        array("No.", "Nama Obat", "Jenis Obat", "Diminta", "Diberikan", "Keterangan", ""),
        "",
        null,
        true
    );
    $dacc_obat_keluar_table->setName("dacc_obat_keluar");
    $dacc_obat_keluar_table->setAction(false);
    $dacc_obat_keluar_table->setFooterVisible(false);
    $modal->addBody("dacc_obat_keluar_table", $dacc_obat_keluar_table);
    $confirm_button = new Button("", "", "Simpan");
    $confirm_button->setClass("btn-success");
    $confirm_button->setAction("acc_obat_keluar.confirm()");
    $confirm_button->setIcon("fa fa-check");
    $confirm_button->setIsButton(Button::$ICONIC);
    $modal->addFooter($confirm_button);

    echo $modal->getHtml();
    echo $table->getHtml();
?>
<script type="text/javascript">
    var acc_obat_keluar;
    $(document).ready(function() {
        acc_obat_keluar = new TableAction(
            'acc_obat_keluar',
            'gudang_farmasi',
            'acc_obat_keluar',
            new Array()
        );
        acc_obat_keluar.review = function(id) {
            var data = this.getRegulerData();
            data['command'] = "edit";
            data['id'] = id;
            showLoading();
            $.post(
                '',
                data,
                function(response) {
                    var json = getContent(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    $("#acc_obat_keluar_id").val(id);
                    $("#acc_obat_keluar_nomor").val(json.header.nomor);
                    $("#acc_obat_keluar_tanggal").val(json.header.tanggal);
                    $("#acc_obat_keluar_tanggal").removeAttr("disabled");
                    $("#acc_obat_keluar_tanggal").attr("disabled", "disabled");
                    $("#acc_obat_keluar_unit").val(json.header.unit);
                    $("#acc_obat_keluar_unit").removeAttr("disabled");
                    $("#acc_obat_keluar_unit").attr("disabled", "disabled");
                    $("#dacc_obat_keluar_add").hide();
                    row_id = 0;
                    $("#dacc_obat_keluar_list").children("tr").remove();
                    for (var i = 0; i < json.detail.length; i++) {
                        var dobat_keluar_id = json.detail[i].id;
                        var dobat_keluar_id_obat_keluar = json.detail[i].id_obat_keluar;
                        var dobat_keluar_id_obat = json.detail[i].id_obat;
                        var dobat_keluar_kode_obat = json.detail[i].kode_obat;
                        var dobat_keluar_nama_obat = json.detail[i].nama_obat;
                        var dobat_keluar_nama_jenis_obat = json.detail[i].nama_jenis_obat;
                        var dobat_keluar_harga_ma = json.detail[i].harga_ma;
                        var dobat_keluar_stok_entri = json.detail[i].stok_entri;
                        var dobat_keluar_jumlah_diminta = json.detail[i].jumlah_diminta;
                        var dobat_keluar_jumlah = json.detail[i].jumlah;
                        var dobat_keluar_satuan = json.detail[i].satuan;
                        var dobat_keluar_konversi = json.detail[i].konversi;
                        var dobat_keluar_satuan_konversi = json.detail[i].satuan_konversi;
                        $("tbody#dacc_obat_keluar_list").append(
                            "<tr id='data_" + row_id + "'>" +
                                "<td style='display: none;' id='data_" + row_id + "_id'>" + dobat_keluar_id + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_kode_obat'>" + dobat_keluar_kode_obat + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_id_obat'>" + dobat_keluar_id_obat + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_harga_ma'>" + dobat_keluar_harga_ma + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_stok_entri'>" + dobat_keluar_stok_entri + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_jumlah_diminta'>" + dobat_keluar_jumlah_diminta + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_jumlah_lama'>" + dobat_keluar_jumlah + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_jumlah'>" + dobat_keluar_jumlah + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_satuan'>" + dobat_keluar_satuan + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_konversi'>" + dobat_keluar_konversi + "</td>" +
                                "<td style='display: none;' id='data_" + row_id + "_satuan_konversi'>" + dobat_keluar_satuan_konversi + "</td>" +
                                "<td id='data_" + row_id + "_nomor'>" + (i + 1) + "</td>" +
                                "<td id='data_" + row_id + "_nama_obat'>" + dobat_keluar_nama_obat + "</td>" +
                                "<td id='data_" + row_id + "_nama_jenis_obat'>" + dobat_keluar_nama_jenis_obat + "</td>" +
                                "<td id='data_" + row_id + "_f_jumlah_diminta'>" + dobat_keluar_jumlah_diminta + " " + dobat_keluar_satuan + "</td>" +
                                "<td id='data_" + row_id + "_f_jumlah'>" + dobat_keluar_jumlah + " " + dobat_keluar_satuan + "</td>" +
                                "<td id='data_" + row_id + "_keterangan'>1 " + dobat_keluar_satuan + " = " + dobat_keluar_konversi + " " + dobat_keluar_satuan_konversi + "</td>" +
                                "<td></td>" +
                            "</tr>"
                        );
                        for (var k = 0; k < json.subdetail.length; k++) {
                            if (json.subdetail[k].id == dobat_keluar_id) {
                                var dobat_keluar_detail_info_arr = json.subdetail[k].detail_info.split(',');
                                for (var j = 0; j < dobat_keluar_detail_info_arr.length; j++) {
                                    var dobat_keluar_detail_info_parts = dobat_keluar_detail_info_arr[j].split(';', 3);
                                    var dobat_keluar_detail_info_tanggal_exp = dobat_keluar_detail_info_parts[0];
                                    var dobat_keluar_detail_info_no_batch = dobat_keluar_detail_info_parts[1];
                                    var dobat_keluar_detail_info_jumlah = dobat_keluar_detail_info_parts[2];
                                    $("tbody#dacc_obat_keluar_list").append(
                                        "<tr id='info_" + row_id + "'>" +
                                            "<td></td>" +
                                            "<td></td>" +
                                            "<td>" +
                                                "<small>No. Batch : " + dobat_keluar_detail_info_no_batch + "</small>" +
                                            "</td>" +
                                            "<td colspan='1'>" +
                                                "<small>Tanggal Exp. : " + dobat_keluar_detail_info_tanggal_exp + "</small>" +
                                            "</td>" +
                                            "<td>" +
                                                "<small>Jumlah : " + dobat_keluar_detail_info_jumlah + "</small>" +
                                            "</td>" +
                                            "<td></td>" +
                                            "<td></td>" +
                                        "</tr>"
                                    );
                                }
                            }
                        }
                        row_id++;
                    }
                    $("#acc_obat_keluar_add_form").smodal("show");
                    dismissLoading();
                }
            );
        };
        acc_obat_keluar.confirm = function() {
            var self = this;
            var data = this.getRegulerData();
            data['command'] = "confirm";
            data['id'] = $("#acc_obat_keluar_id").val();
            
            $("#acc_obat_keluar_add_form").smodal("hide");

            bootbox.confirm({
                title     : "Konfirmasi",
                message   : "Yakin melakukan persetujuan Mutasi Obat ini?<br/><br/><b>PERINGATAN</b> : Persetujuan Mutasi Obat ini akan mengirimkan data ke submenu Penerimaan Obat unit terkait dan dapat diterima oleh unit tersebut.",
                buttons   : {
                    confirm : {
                        label       : "Lanjutkan",
                        className   : "btn-success"
                    },
                    cancel : {
                        label       : "Batal",
                        className   : "btn-inverse"
                    }
                },
                callback : function(result) {
                    if (result) {
                        showLoading();
                        $.post(
                            '',
                            data,
                            function(response) {
                                self.view();
                                dismissLoading();
                            }
                        );
                    } else {
                        $("#acc_obat_keluar_add_form").smodal("show");
                    }
                }
            });
        };
        acc_obat_keluar.view();
    });
</script>