<?php 

/**
 * this class used to communicate with 
 * the server how to synchronize the whole data
 * 
 * */

class AsuhanSynchronousResponder extends DBSynchronousResponder{
    public function synchronousData($original,$adapted,$id,$prop=""){
        $data=array();
        $data['grup_name']      = "gizi";
        $data['nama_pasien']    = $original->nama_pasien;
        $data['noreg_pasien']   = $original->noreg_pasien;
        $data['nrm_pasien']     = $original->nrm_pasien;
        $data['entity']         = "gizi";
        $data['list']           = $adapted;
        $serv = new ServiceConsumer($this->getDBTable()->get_db(),"proceed_receivable",$data,"kasir");
        $serv->execute();
        $hasil=$serv->getContent();
        return $hasil;
    }
    
    public function delete()
    {
        $result = parent::delete();
        if(getSettings($db,"gizi-accounting-auto-notif","0")=="1"){
            $this-> synchronizeToAccounting($this->dbtable->get_db(), $_POST['id'] ,"del");
        }
        return $result;
    }
    
    public function save(){
		$data=$this->postToArray();
		$id['id']=$this->getPost("id", 0);
		if($id['id']==0 || $id['id']=="" || !$this->dbtable->is_exist($id,$this->is_exist_include_del)){
			$result=$this->dbtable->insert($data,$this->is_use_prop,$this->upsave_condition);
			$id['id']=$this->dbtable->get_inserted_id();
			$success['type']='insert';
		}else {
			$result=$this->dbtable->update($data,$id,$this->upsave_condition);
			$success['type']='update';
		}
		$success['id']=$id['id'];
		$success['success']=1;
		if($result===false) 
            $success['success']=0;
        if(getSettings($db,"gizi-accounting-auto-notif","0")=="1"){
            $this-> synchronizeToAccounting($this->dbtable->get_db(),$success ['id'] ,"");
        }
		return $success;
	}
    
    public function synchronizeToAccounting($db,$id,$is_del=""){
        $x=$this->dbtable->selectEventDel($id);
        
        $data=array();
        $data['jenis_akun'] = "transaction";
        $data['jenis_data'] = "penjualan";
        $data['id_data']    = $id;
        $data['entity']     = "gizi";
        $data['service']    = "get_detail_accounting";
        $data['data']       = $id;
        $data['code']       = "gz-".$id;
        $data['operation']  = $is_del;
        $data['tanggal']    = $x->tanggal;
        $data['uraian']     = "Asuhan Gizi Pasien ".$x->nama_pasien." Pada Noreg ".$x->id;
        $data['nilai']      = $x->biaya;
        
        $serv=new ServiceConsumer($db,"push_notify_accounting",$data,"accounting");
        $serv->execute();
    }
}

?>