<?php
    require_once("smis-base/smis-include-service-consumer.php");
    global $user;
    global $db;

    $karyawan_table = new Table(
		array("NIP", "Nama", "Jabatan"),
		"",
		null,
		true
	);
	$karyawan_table->setName("karyawan");
	$karyawan_table->setModel(Table::$SELECT);
	$karyawan_adapter = new SimpleAdapter();
	$karyawan_adapter->add("NIP", "nip");
	$karyawan_adapter->add("Nama", "nama");
	$karyawan_adapter->add("Jabatan", "nama_jabatan");
	$karyawan_service_responder = new ServiceResponder(
		$db,
		$karyawan_table,
		$karyawan_adapter,
		"employee"
	);

    $opl_table = new Table(
        array("No.", "No. OPL", "Tanggal", "Vendor"),
        "",
        null,
        true
    );
    $opl_table->setName("opl");
    $opl_table->setModel(Table::$SELECT);
    $opl_adapter = new SimpleAdapter(true, "No.");
    $opl_adapter->add("No. OPL", "nomor");
    $opl_adapter->add("Tanggal", "tanggal", "date d-m-Y");
    $opl_adapter->add("Vendor", "nama_vendor");
    $service_name = "get_daftar_opl_farmasi";
    if (isset($_POST['unit']) && $_POST['unit'] == "gudang_umum") {
        $service_name = "get_daftar_opl_non_farmasi";
    }
    $opl_service_responder = new ServiceResponder(
        $db,
        $opl_table,
        $opl_adapter,
        $service_name
    );
    $super_command = new SuperCommand();
    $super_command->addResponder("opl", $opl_service_responder);
    $super_command->addResponder("karyawan", $karyawan_service_responder);
    $init = $super_command->initialize();
    if ($init != null) {
        echo $init;
        return;
    }

    if (isset($_POST['command'])) {
        $table = new Table(array(), "", null, true);
        $adapter = new SimpleAdapter();
        $dbtable = new DBTable($db, "smis_ac_transaksi");
        require_once("finance/class/responder/KBUangMukaDBResponder.php");
        $dbresponder = new KBUangMukaDBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    require_once("accounting/function/new_transaksi_harian.php");

    $id = isset($_POST['header']['id']) ? $_POST['header']['id'] : "";
    $id_transaksi = isset($_POST['id_transaksi']) ? $_POST['id_transaksi'] : "";
    $id_detail = isset($_POST['header']['id_detail']) ? $_POST['header']['id_detail'] : "";
    $operator = isset($_POST['header']['operator']) ? $_POST['header']['operator'] : $user->getNameOnly();
    $tanggal_input = isset($_POST['header']['tanggal_input']) ? $_POST['header']['tanggal_input'] : date("d-m-Y H:i");
    $tanggal_jurnal = isset($_POST['header']['tanggal_jurnal']) ? $_POST['header']['tanggal_jurnal'] : date("d-m-Y H:i");
    $nomor = isset($_POST['header']['nomor']) ? $_POST['header']['nomor'] : new_transaksi_harian_automatic($db, date("Y-m-d"), "JUM");
    $id_transaksi = isset($_POST['header']['id_transaksi']) ? $_POST['header']['id_transaksi'] : "";
    $unit = isset($_POST['header']['unit']) ? $_POST['header']['unit'] : "gudang_farmasi";
    $id_opl = isset($_POST['header']['id_opl']) ? $_POST['header']['id_opl'] : "";
    $nomor_opl = isset($_POST['header']['nomor_opl']) ? $_POST['header']['nomor_opl'] : "";
    $pic = isset($_POST['header']['pic']) ? $_POST['header']['pic'] : "";
    $status = isset($_POST['header']['status']) ? $_POST['header']['status'] : "";
    $no_akun = isset($_POST['header']['no_akun']) ? $_POST['header']['no_akun'] : "";
    $nama_akun = isset($_POST['header']['nama_akun']) ? $_POST['header']['nama_akun'] : "";
    $uraian = isset($_POST['header']['uraian']) ? $_POST['header']['uraian'] : "";
    $kredit = isset($_POST['header']['nilai']) ? $_POST['header']['nilai'] : "0,00";

    $form = new Form("", "", "Jurnal Uang Muka");
    $id_hidden = new Hidden("kb_uang_muka_id", "kb_uang_muka_id", $id);
    $form->addElement("", $id_hidden);
    $id_transaksi_hidden = new Hidden("kb_uang_muka_id_transaksi", "kb_uang_muka_id_transaksi", $id_transaksi);
    $form->addElement("", $id_transaksi_hidden);
    $id_detail_hidden = new Hidden("kb_uang_muka_id_detail", "kb_uang_muka_id_detail", $id_detail);
    $form->addElement("", $id_detail_hidden);
    $operator_text = new Text("kb_uang_muka_operator", "kb_uang_muka_operator", $operator);
    $operator_text->setAtribute("disabled='disabled'");
    $form->addElement("Petugas Entri", $operator_text);
    $tanggal_input_text = new Text("kb_uang_muka_tanggal_input", "kb_uang_muka_tanggal_input", $tanggal_input);
    $tanggal_input_text->setAtribute("disabled='disabled'");
    $form->addElement("Tanggal Entri", $tanggal_input_text);
    $tanggal_text = new Text("kb_uang_muka_tanggal", "kb_uang_muka_tanggal", $tanggal_jurnal);
    $tanggal_text->setAtribute("data-date-format='dd-mm-yyyy hh:ii'");
    $tanggal_text->setClass("mydatetime");
    $form->addElement("Tanggal Jurnal", $tanggal_text);
    $nomor_text = new Text("kb_uang_muka_nomor", "kb_uang_muka_nomor", $nomor);
    $form->addElement("Nomor Jurnal", $nomor_text);
    $unit_option = new OptionBuilder();
    if ($unit == "gudang_farmasi") {
        $unit_option->add("Gudang Farmasi", "gudang_farmasi", "1");
    } else {
        $unit_option->add("Gudang Farmasi", "gudang_farmasi");
    }
    if ($unit == "gudang_umum") {
        $unit_option->add("Gudang Umum", "gudang_umum", "1");
    } else {
        $unit_option->add("Gudang Umum", "gudang_umum");
    }
    $unit_select = new Select("kb_uang_muka_unit", "kb_uang_muka_unit", $unit_option->getContent());
    $form->addElement("Unit Pembelian", $unit_select);
    $id_opl_hidden = new Hidden("kb_uang_muka_id_opl", "kb_uang_muka_id_opl", $id_opl);
    $form->addElement("", $id_opl_hidden);
    $opl_button = new Button("", "", "Pilih");
    $opl_button->setClass("btn-info");
    $opl_button->setIsButton(Button::$ICONIC);
    $opl_button->setIcon("icon-white " . Button::$icon_list_alt);
    $opl_button->setAction("opl.chooser('opl', 'opl_button', 'opl', opl)");
    $opl_button->setAtribute("id='opl_browse'");
    $nomor_opl_text = new Text("kb_uang_muka_nomor_opl", "kb_uang_muka_nomor_opl", $nomor_opl);
    $nomor_opl_text->setClass("smis-one-option-input");
    $nomor_opl_text->setAtribute("disabled='disabled'");
    $opl_input_group = new InputGroup("");
    $opl_input_group->addComponent($nomor_opl_text);
    $opl_input_group->addComponent($opl_button);
    $form->addElement("No. OPL", $opl_input_group);
    $pic_button = new Button("", "", "Pilih");
    $pic_button->setClass("btn-info");
    $pic_button->setIsButton(Button::$ICONIC);
    $pic_button->setIcon("icon-white " . Button::$icon_list_alt);
    $pic_button->setAction("karyawan.chooser('karyawan', 'karyawan_button', 'karyawan', karyawan)");
    $pic_button->setAtribute("id='pic_browse'");
    $pic_text = new Text("kb_uang_muka_pic", "kb_uang_muka_pic", $pic);
    $pic_text->setAtribute("disabled='disabled'");
    $pic_text->setClass("smis-one-option-input");
    $pic_input_group = new InputGroup("");
    $pic_input_group->addComponent($pic_text);
    $pic_input_group->addComponent($pic_button);
    $form->addElement("PIC", $pic_input_group);
    $status_text = new Text("kb_uang_muka_status", "kb_uang_muka_status", $status);
    $status_text->setAtribute("disabled='disabled'");
    $form->addElement("Status", $status_text);
    $keterangan_textarea = new TextArea("kb_uang_muka_keterangan", "kb_uang_muka_keterangan", $uraian);
    $keterangan_textarea->setLine(3);
    $form->addElement("Keterangan", $keterangan_textarea);
    $akun_rows = $db->get_result("
        SELECT 
            *
        FROM
            smis_ac_account
        WHERE
            prop = '' 
                AND id_parent <> 0
                AND have_child = 0
                AND nama_tipe LIKE 'Kas & Setara Kas'
        ORDER BY
            nomor ASC
    ");
    $akun_option = new OptionBuilder();
    $akun_option->add("", "", "1");
    if ($akun_rows != null)
        foreach ($akun_rows as $akun_row)
            $akun_option->add($akun_row->nomor . " - " . $akun_row->nama);
    $akun_select = new Select("kb_uang_muka_akun", "kb_uang_muka_akun", $akun_option->getContent());
    $form->addElement("Akun Kas Bank", $akun_select);
    $kredit_text = new Text("kb_uang_muka_kredit", "kb_uang_muka_kredit", $kredit);
    $kredit_text->setTypical("money");
    $kredit_text->setAtribute("data-thousands='.' data-decimal=',' data-precision='2'");
    $form->addElement("Kredit", $kredit_text);

    $table = new Table(
        array("No.", "No. - Nama Akun", "Uraian", "Debit"),
        "",
        null,
        true
    );
    $table->setName("kb_uang_muka_detail");
    $table->setFooterVisible(false);
    $table->setDelButtonEnable(false);
    $table->setPrintButtonEnable(false);
    $table->setReloadButtonEnable(false);
    $table->setAddButtonEnable(false);
    $add_button = new Button("", "", "Tambah");
    $add_button->setClass("btn btn-inverse");
    $add_button->setAction("kb_uang_muka.appendDetail()");
    $add_button->setIcon("fa fa-plus");
    $add_button->setIsButton(Button::$ICONIC);
    $table->addHeaderButton($add_button);

    $back_button = new Button("", "", "Kembali ke Daftar");
    $back_button->setClass("btn btn-inverse");
    $back_button->setAction("kb_uang_muka.back()");

    $save_button = new Button("", "", "Simpan Jurnal");
    $save_button->setClass("btn btn-success");
    $save_button->setAction("kb_uang_muka.save()");

    echo $form->getHtml();
    echo $table->getHtml();
    echo "<div class='container-fluid'>";
    echo "<div class='row-fluid'>";
    if ($id == "") {
        echo "<div class='span6' align='left'>" . $back_button->getHtml() . "</div>";
        echo "<div class='span6' align='right'>" . $save_button->getHtml() . "</div>";
    } else {
        echo "<div class='span12' align='right'>" . $back_button->getHtml() . "</div>";
    }
    echo "</div>";
    echo "</div>";
    echo addJS("framework/smis/js/table_action.js");
    echo addJS("framework/bootstrap/js/bootstrap-select.js");
    echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");
    echo addCSS("framework/bootstrap/css/bootstrap-select.css");
    echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
?>
<script type="text/javascript">
    var karyawan;
    var opl;
    var kb_uang_muka;
    var row_num;
    $(document).ready(function() {
        row_num = 0;
        $(".mydatetime").datetimepicker({
            minuteStep: 1
        });
        $("#table_kb_uang_muka_detail").append("<tfoot>" +
            "<tr>" +
            "<td colspan='3'><div align='right'><strong>Total</strong></div></td>" +
            "<td id='total' style='display: none;'>0</td>" +
            "<td><strong><div id='f_total' align='right'>0,00</div></strong></td>" +
            "<td></td>" +
            "</tr>" +
            "</tfoot>");
        karyawan = new TableAction(
            "karyawan",
            "finance",
            "kb_uang_muka_form",
            new Array()
        );
        karyawan.selected = function(json) {
            $("#kb_uang_muka_pic").val(json.nama);
        };
        karyawan.setSuperCommand("karyawan");
        opl = new TableAction(
            "opl",
            "finance",
            "kb_uang_muka_form",
            new Array()
        );
        opl.addViewData = function(data) {
            data['unit'] = $("#kb_uang_muka_unit").val();
            return data;
        };
        opl.selected = function(json) {
            $("#kb_uang_muka_id_opl").val(json.id);
            $("#kb_uang_muka_nomor_opl").val(json.nomor);
            if (json.selesai == 1)
                $("#kb_uang_muka_status").val("Selesai");
            else
                $("#kb_uang_muka_status").val("Belum Selesai");
            $("#kb_uang_muka_pic").focus();
        };
        opl.setSuperCommand("opl");
        kb_uang_muka = new TableAction(
            "kb_uang_muka",
            "finance",
            "kb_uang_muka_form",
            new Array("kredit")
        );
        kb_uang_muka.refreshNumber = function() {
            var nor = $("#kb_uang_muka_detail_list tr").length;
            var nomor = 1;
            for (var i = 0; i < nor; i++) {
                if ($("#kb_uang_muka_detail_list tr:eq(" + i + ")").hasClass("deleted") === false) {
                    $("#kb_uang_muka_detail_list tr:eq(" + i + ") td#detail_nomor").html(nomor);
                    nomor++;
                }
            }
        };
        kb_uang_muka.refreshTotal = function() {
            var total = 0;
            var nor = $("#kb_uang_muka_detail_list tr").length;
            for (var i = 0; i < nor; i++) {
                if ($("#kb_uang_muka_detail_list tr:eq(" + i + ")").hasClass("deleted") === false) {
                    var debet = $("#kb_uang_muka_detail_list tr:eq(" + i + ") td#detail_debet input#kb_uang_muka_detail_debet").val();
                    debet = parseFloat(debet.replace(/[^0-9-,]/g, '').replace(",", "."));
                    total += debet;
                }
            }
            $("#total").html(total);
            $("#f_total").html(total.formatMoney("2", ".", ","));
        };
        kb_uang_muka.appendDetail = function() {
            var self = this;
            var data = this.getRegulerData();
            data['command'] = "new_row";
            data['row_num'] = row_num;
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    row_num++;
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    $("#kb_uang_muka_detail_list").append(json.html);
                    $("#kb_uang_muka_detail_list tr:last td#detail_akun select").select2();
                    $("#kb_uang_muka_detail_list tr:last td#detail_debet input#kb_uang_muka_detail_debet").on("keyup", function() {
                        self.refreshTotal();
                    });
                    $("#kb_uang_muka_detail_list tr:last td#detail_debet input#kb_uang_muka_detail_debet").maskMoney();
                    $("#kb_uang_muka_detail_list tr:last td#detail_debet input#kb_uang_muka_detail_debet").maskMoney('mask', 0);
                    self.refreshNumber();
                    dismissLoading();
                }
            );
        };
        kb_uang_muka.addDetail = function(id_detail, akun, uraian, nilai) {
            var self = this;
            var data = this.getRegulerData();
            data['command'] = "new_row";
            data['row_num'] = row_num++;
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    $("#kb_uang_muka_detail_list").append(json.html);
                    $("#kb_uang_muka_detail_list tr:last td#detail_akun select").select2();
                    $("#kb_uang_muka_detail_list tr:last td#detail_debet input#kb_uang_muka_detail_debet").on("keyup", function() {
                        self.refreshTotal();
                    });
                    $("#kb_uang_muka_detail_list tr:last td#detail_debet input#kb_uang_muka_detail_debet").maskMoney();
                    $("#kb_uang_muka_detail_list tr:last td#detail_debet input#kb_uang_muka_detail_debet").maskMoney('mask', 0);
                    self.refreshNumber();
                    $("#kb_uang_muka_detail_list tr:last td#detail_id").html(id_detail);
                    $("#kb_uang_muka_detail_list tr:last td#detail_akun #kb_uang_muka_detail_akun").select2('data', {
                        id: akun,
                        text: akun
                    });
                    $("#kb_uang_muka_detail_list tr:last td#detail_uraian #kb_uang_muka_detail_keterangan").val(uraian);
                    $("#kb_uang_muka_detail_list tr:last td#detail_debet #kb_uang_muka_detail_debet").val(nilai);
                    self.refreshTotal();
                    dismissLoading();
                }
            );
        };
        kb_uang_muka.deleteDetail = function(id_row) {
            var self = this;
            bootbox.confirm({
                title: "Konfirmasi",
                message: "Menghapus detail data?",
                buttons: {
                    confirm: {
                        label: "Ya",
                        className: "btn-success"
                    },
                    cancel: {
                        label: "Tidak",
                        className: "btn-danger"
                    }
                },
                callback: function(result) {
                    if (result) {
                        showLoading();
                        var id = $("tr#" + id_row + " td#detail_id").text();
                        if (id == "")
                            $("tr#" + id_row).remove();
                        else {
                            $("tr#" + id_row).addClass("deleted");
                            $("tr#" + id_row).hide();
                        }
                        self.refreshNumber();
                        self.refreshTotal();
                        dismissLoading();
                    }
                }
            });
        };
        kb_uang_muka.back = function() {
            var data = this.getRegulerData();
            data['action'] = "kb_uang_muka";
            data['super_command'] = "";
            LoadSmisPage(data);
        };
        kb_uang_muka.validate = function() {
            var valid = true;
            var tanggal = $("#kb_uang_muka_tanggal").val();
            var nomor = $("#kb_uang_muka_nomor").val();
            var keterangan = $("#kb_uang_muka_keterangan").val();
            var id_opl = $("#kb_uang_muka_id_opl").val();
            var pic = $("#kb_pic").val();
            var akun = $("#kb_uang_muka_akun").val();
            var kredit = parseFloat($("#kb_uang_muka_kredit").val().replace(/[^0-9-,]/g, '').replace(",", "."));;
            var total_debet = parseFloat($("#total").text());
            var nor = $("#kb_uang_muka_detail_list tr").not(".deleted").length;
            var invalid_msg = "";
            if (tanggal == "") {
                valid = false;
                invalid_msg += "<li>Tanggal Jurnal tidak diperkenankan kosong.</li>";
            }
            if (nomor == "") {
                valid = false;
                invalid_msg += "<li>Nomor Jurnal tidak diperkenankan kosong.</li>";
            }
            if (keterangan == "") {
                valid = false;
                invalid_msg += "<li>Keterangan tidak diperkenankan kosong.</li>";
            }
            if (id_opl == "") {
                valid = false;
                invalid_msg += "<li>No. OPL tidak diperkenankan kosong.</li>";
            }
            if (pic == "") {
                valid = false;
                invalid_msg += "<li>PIC tidak diperkenankan kosong.</li>";
            }
            if (akun == "") {
                valid = false;
                invalid_msg += "<li>Akun Kas Bank tidak diperkenankan kosong.</li>"
            }
            if (kredit == "") {
                valid = false;
                invalid_msg += "<li>Kredit tidak diperkenankan kosong.</li>";
            } else if (kredit == 0) {
                valid = false;
                invalid_msg += "<li>Kredit tidak diperkenankan bernilai nol.</li>";
            } else if (kredit != total_debet) {
                valid = false;
                invalid_msg += "<li>Kredit dan Total Debit tidak diperkenankan bernilai berbeda.</li>";
            }
            if (nor == 0) {
                valid = false;
                invalid_msg += "<li>Jumlah Detail Debit tidak diperkenankan kosong.</li>";
            }
            nor = $("#kb_uang_muka_detail_list tr").length;
            for (var i = 0; i < nor; i++) {
                if ($("#kb_uang_muka_detail_list tr:eq(" + i + ")").hasClass("deleted") === false) {
                    var no = $("#kb_uang_muka_detail_list tr:eq(" + i + ") td#detail_nomor").text();
                    var akun = $("#kb_uang_muka_detail_list tr:eq(" + i + ") td#detail_akun select#kb_uang_muka_detail_akun").val();
                    var keterangan = $("#kb_uang_muka_detail_list tr:eq(" + i + ") td#detail_uraian textarea#kb_uang_muka_detail_keterangan").val();
                    var debet = $("#kb_uang_muka_detail_list tr:eq(" + i + ") td#detail_debet input#kb_uang_muka_detail_debet").val();
                    if (debet.length > 0)
                        debet = parseFloat(debet.replace(/[^0-9-,]/g, '').replace(",", "."));
                    if (akun == "") {
                        valid = false;
                        invalid_msg = "<li>Akun tidak diperkenankan kosong. (Baris ke-" + no + ")</li>";
                    }
                    if (keterangan == "") {
                        valid = false;
                        invalid_msg = "<li>Uraian tidak diperkenankan kosong. (Baris ke-" + no + ")</li>";
                    }
                    if (debet == "") {
                        valid = false;
                        invalid_msg = "<li>Debit tidak diperkenankan kosong. (Baris ke-" + no + ")</li>";
                    } else if (debet == 0) {
                        valid = false;
                        invalid_msg = "<li>Debit tidak diperkenankan bernilai nol. (Baris ke-" + no + ")</li>";
                    }
                }
            }
            if (valid == false) {
                bootbox.alert({
                    title: "Kesalahan",
                    message: "<ul>" + invalid_msg + "</ul>"
                });
            }
            return valid;
        };
        kb_uang_muka.getSaveData = function() {
            var data = this.getRegulerData();
            data['command'] = "save";
            data['id'] = $("#kb_uang_muka_id").val();
            data['id_transaksi'] = $("#kb_uang_muka_id_transaksi").val();
            data['id_detail'] = $("#kb_uang_muka_id_detail").val();
            data['operator'] = $("#kb_uang_muka_operator").val();
            data['tanggal_input'] = $("#kb_uang_muka_tanggal_input").val();
            data['tanggal'] = $("#kb_uang_muka_tanggal").val();
            data['nomor'] = $("#kb_uang_muka_nomor").val();
            data['unit'] = $("#kb_uang_muka_unit").val();
            data['id_opl'] = $("#kb_uang_muka_id_opl").val();
            data['nomor_opl'] = $("#kb_uang_muka_nomor_opl").val();
            data['pic'] = $("#kb_uang_muka_pic").val();
            data['status'] = $("#kb_uang_muka_status").val();
            data['keterangan'] = $("#kb_uang_muka_keterangan").val();
            data['akun'] = $("#kb_uang_muka_akun").val();
            var kredit = $("#kb_uang_muka_kredit").val();
            data['kredit'] = parseFloat(kredit.replace(/[^0-9-,]/g, '').replace(",", "."));
            var nor = $("#kb_uang_muka_detail_list tr").length;
            var d_detail = {};
            for (var i = 0; i < nor; i++) {
                var id = $("#kb_uang_muka_detail_list tr:eq(" + i + ") td#detail_id").text();
                var akun = $("#kb_uang_muka_detail_list tr:eq(" + i + ") td#detail_akun select#kb_uang_muka_detail_akun").val();
                var keterangan = $("#kb_uang_muka_detail_list tr:eq(" + i + ") td#detail_uraian textarea#kb_uang_muka_detail_keterangan").val();
                var debet = $("#kb_uang_muka_detail_list tr:eq(" + i + ") td#detail_debet input#kb_uang_muka_detail_debet").val();
                var deleted = $("#kb_uang_muka_detail_list tr:eq(" + i + ")").hasClass("deleted") ? 1 : 0;
                debet = parseFloat(debet.replace(/[^0-9-,]/g, '').replace(",", "."));
                d_detail[i] = {
                    'deleted': deleted,
                    'id': id,
                    'akun': akun,
                    'keterangan': keterangan,
                    'debet': debet
                };
            }
            data['detail'] = JSON.stringify(d_detail);
            return data;
        };
        kb_uang_muka.save = function() {
            if (!this.validate())
                return;
            var self = this;
            var data = this.getSaveData();
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    dismissLoading();
                    data['command'] = "print_jurnal";
                    data['id'] = json.id;
                    showLoading();
                    $.post(
                        "",
                        data,
                        function(response) {
                            var json = JSON.parse(response);
                            if (json == null) {
                                dismissLoading();
                                return;
                            }
                            var getUrl = window.location['pathname'] + json;
                            window.open(getUrl, 'pdf');
                            dismissLoading();
                            self.back();
                        }
                    );
                }
            );
        };

        <?php
        if (!isset($_POST['header'])) {
        ?>
            kb_uang_muka.appendDetail();
        <?php
        } else {
        ?>
            $("#kb_uang_muka_akun").val("<?php echo $_POST['header']['no_akun'] . " - " . $_POST['header']['nama_akun']; ?>");
            showLoading();
            <?php
            $nod = count($_POST['detail']);
            for ($i_detail = 0; $i_detail < $nod; $i_detail++) {
            ?>
                var id = <?php echo $_POST['detail'][$i_detail]['id']; ?>;
                var akun = "<?php echo $_POST['detail'][$i_detail]['nomor_account']; ?> - <?php echo $_POST['detail'][$i_detail]['nama_account']; ?>";
                var uraian = "<?php echo $_POST['detail'][$i_detail]['keterangan']; ?>";
                var nilai = <?php echo $_POST['detail'][$i_detail]['debet']; ?>;
                nilai = nilai.formatMoney("2", ".", ",");
                kb_uang_muka.addDetail(id, akun, uraian, nilai);
            <?php
            }
            ?>
            dismissLoading();
        <?php } ?>

        $("#kb_uang_muka_akun").select2().on("select2-close", function() {
            var value = $(this).select2('data').text;
            var nama_idx = value.indexOf(" - ") + 3;
            var kode_akun = value.split(" - ")[0].trim();
            var nama_akun = value.substr(nama_idx);
            $("#kb_uang_muka_nama_akun").val(nama_akun);
            $("#kb_uang_muka_no_akun").val(kode_akun);
        });
    });
</script>
<style type="text/css">
    textarea.detail_textarea {
        width: 100% !important;
    }

    textarea#kb_uang_muka_keterangan {
        resize: none;
    }

    .detail_select2.select2-container {
        width: 100% !important;
    }

    .detail_select2.select2-search--dropdown .detail_select2.select2-search__field {
        width: 98%;
    }

    .detail_money {
        width: 100% !important;
    }
</style>