<?php
    require_once("finance/class/table/UangMukaTable.php");
    global $db;

    $table = new UangMukaTable(
        array("No.", "No. Jurnal", "Tgl. Jurnal", "No. OPL", "Unit", "Uraian", "PIC", "Nilai Keluar", "Status"),
        "",
        null,
        true
    );
    $table->setName("kb_uang_muka");
    $table->setReloadButtonEnable(false);
    $table->setPrintButtonEnable(false);
    $table->setAddButtonEnable(false);
    $table->setEditButtonEnable(false);
    $add_button = new Button("", "", "Jurnal");
    $add_button->setClass("btn btn-primary");
    $add_button->setAction("kb_uang_muka.show_add_form()");
    $add_button->setIcon("fa fa-plus");
    $add_button->setIsButton(Button::$ICONIC_TEXT);
    $table->addHeaderButton($add_button);
    $table->setFooterVisible(false);

    if (isset($_POST['command'])) {
        $adapter = new SummaryAdapter(true, "No.");
        $adapter->addFixValue("Uraian", "<div align='right'><b>Total</b></div>");
        $adapter->addSummary("Nilai Keluar", "nilai", "money");
        $adapter->add("id", "id");
        $adapter->add("diakui", "diakui");
        $adapter->add("No. Jurnal", "nomor_jurnal");
        $adapter->add("Tgl. Jurnal", "tanggal_jurnal", "date d-m-Y");
        $adapter->add("No. OPL", "nomor_opl");
        $adapter->add("Unit", "unit", "unslug");
        $adapter->add("Uraian", "uraian");
        $adapter->add("PIC", "pic");
        $adapter->add("Nilai Keluar", "nilai", "money");
        $adapter->add("Status", "status");
        $dbtable = new DBTable($db, "smis_fnc_uang_muka");

        if ($_POST['command'] == "list") {
            $tanggal_dari = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_dari'])->format("Y-m-d");
            $tanggal_sampai = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_sampai'])->format("Y-m-d");

            $dbtable->addCustomKriteria("tanggal_jurnal", " >= '" . $tanggal_dari . "'");
            $dbtable->addCustomKriteria("tanggal_jurnal", " <= '" . $tanggal_sampai . "'");
            $dbtable->setShowAll(true);
        }
        require_once("finance/class/responder/KBUangMukaDBResponder.php");
        $dbresponder = new KBUangMukaDBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    $form = new Form("", "", "Uang Muka");
    $tanggal_dari_text = new Text("kb_pt_tanggal_dari", "kb_pt_tanggal_dari", "01" . date("-m-Y"));
    $tanggal_dari_text->setAtribute("data-date-format='dd-mm-yyyy'");
    $tanggal_dari_text->setClass("mydate");
    $form->addElement("Dari Tgl.", $tanggal_dari_text);
    $tanggal_sampai_text = new Text("kb_pt_tanggal_sampai", "kb_pt_tanggal_sampai", date("d-m-Y"));
    $tanggal_sampai_text->setAtribute("data-date-format='dd-mm-yyyy'");
    $tanggal_sampai_text->setClass("mydate");
    $form->addElement("Sampai Tgl.", $tanggal_sampai_text);
    $kode_akun_hidden = new Hidden("kb_pt_kode_akun", "kb_pt_kode_akun", "");
    $form->addElement("", $kode_akun_hidden);
    $nama_akun_hidden = new Hidden("kb_pt_nama_akun", "kb_pt_nama_akun", "");
    $form->addElement("", $nama_akun_hidden);
    $proses_button = new Button("", "", "Proses");
    $proses_button->setClass("btn btn-primary");
    $proses_button->setAction("kb_uang_muka.view()");
    $proses_button->setIcon("icon-white icon-repeat");
    $proses_button->setIsButton(Button::$ICONIC);
    $download_excel_button = new Button("", "", "Download XLS");
    $download_excel_button->setClass("btn btn-success");
    $download_excel_button->setAction("kb_uang_muka.export_xls()");
    $download_excel_button->setIcon("fa fa-file-excel-o");
    $download_excel_button->setIsButton(Button::$ICONIC);
    $download_pdf_button = new Button("", "", "Download PDF");
    $download_pdf_button->setClass("btn btn-danger");
    $download_pdf_button->setAction("kb_uang_muka.export_pdf()");
    $download_pdf_button->setIcon("fa fa-file-pdf-o");
    $download_pdf_button->setIsButton(Button::$ICONIC);
    $button_group = new ButtonGroup();
    $button_group->addButton($proses_button);
    $button_group->addButton($download_excel_button);
    $button_group->addButton($download_pdf_button);
    $form->addElement("", $button_group);

    echo $form->getHtml();
    echo $table->getHtml();
    echo addJS("framework/smis/js/table_action.js");
    echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
    echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
    var kb_uang_muka;
    $(document).ready(function() {
        $(".mydate").datepicker();
        kb_uang_muka = new TableAction(
            "kb_uang_muka",
            "finance",
            "kb_uang_muka",
            new Array()
        );
        kb_uang_muka.addRegulerData = function(data) {
            data['tanggal_dari'] = $("#kb_pt_tanggal_dari").val();
            data['tanggal_sampai'] = $("#kb_pt_tanggal_sampai").val();
            return data;
        };
        kb_uang_muka.export_xls = function() {
            showLoading();
            var data = this.getRegulerData();
            data['command'] = "export_xls";
            postForm(data);
            dismissLoading();
        };
        kb_uang_muka.export_pdf = function() {
            showLoading();
            var data = this.getRegulerData();
            data['command'] = "export_pdf";
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    var getUrl = window.location['pathname'] + json;
                    window.open(getUrl, 'pdf');
                    dismissLoading();
                }
            );
        };
        kb_uang_muka.printelement = function(id) {
            var data = this.getRegulerData();
            data['command'] = "print_jurnal";
            data['id'] = id;
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    var getUrl = window.location['pathname'] + json;
                    window.open(getUrl, 'pdf');
                    dismissLoading();
                }
            );
        };
        kb_uang_muka.show_add_form = function() {
            var data = this.getRegulerData();
            data['action'] = "kb_uang_muka_form";
            data['super_command'] = "";
            LoadSmisPage(data);
        };
        kb_uang_muka.detail = function(id) {
            var self = this;
            var data = this.getRegulerData();
            data['command'] = "edit";
            data['id'] = id;
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = getContent(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    dismissLoading();
                    data = self.getRegulerData();
                    data['action'] = "kb_uang_muka_form";
                    data['super_command'] = "";
                    data['header'] = json.header;
                    data['detail'] = json.detail;
                    LoadSmisPage(data);
                }
            );
        };
        kb_uang_muka.view();
    });
</script>