<?php
    global $db;

    $faktur_table = new Table(array("No.", "Asal Faktur", "No. Faktur", "No. BBM", "Tgl. Faktur", "Jatuh Tempo", "Rekanan", "Total Tagihan", "Sisa Tagihan"));
    $faktur_table->setName("faktur");
    $faktur_table->setModel(Table::$SELECT);
    $gudang_option = new OptionBuilder();
    $gudang_option->add("Gudang Farmasi", "gudang_farmasi", "1");
    $gudang_option->add("Gudang Umum", "gudang_umum");
    $gudang_s_select = new Select("filter_gudang", "filter_gudang", $gudang_option->getContent());
    $faktur_table = new Table(array("No.", "Asal Faktur", "No. Faktur", "No. BBM", "Tgl. Faktur", "Jatuh Tempo", "Rekanan", "Total Tagihan", "Sisa Tagihan"));
    $faktur_table->setName("faktur");
    $faktur_table->setModel(Table::$SELECT);
    $header =   "<tr class = 'header_faktur'>" .
                    "<td></td>" .
                    "<td>" . $gudang_s_select->getHtml() . "</td>" .
                    "<td></td>" .
                    "<td></td>" .
                    "<td></td>" .
                    "<td></td>" .
                    "<td></td>" .
                    "<td></td>" .
                    "<td></td>" .
                    "<td>" .
                        "<div class='btn-group noprint'>" .
                            "<a href='#' onclick='faktur.view()' data-content='Cari' data-toggle='popover' id='faktur_search' class='input btn btn-inverse'>" .
                                "<i class='icon-white icon-search'></i>" .
                            "</a>" .
                        "</div>" .
                    "</td>" .
                "</tr>";
    $faktur_table->addHeader("after", $header);
    $faktur_adapter = new SimpleAdapter(true, "No.");
    $faktur_adapter->add("Asal Faktur", "asal_faktur", "unslug");
    $faktur_adapter->add("No. Faktur", "nomor_faktur");
    $faktur_adapter->add("No. BBM", "no_bbm");
    $faktur_adapter->add("Tgl. Faktur", "tanggal_faktur", "date d-m-Y");
    $faktur_adapter->add("Jatuh Tempo", "jatuh_tempo", "date d-m-Y");
    $faktur_adapter->add("Rekanan", "rekanan");
    $faktur_adapter->add("Total Tagihan", "total_tagihan", "money");
    $faktur_adapter->add("Sisa Tagihan", "sisa_tagihan", "money");
    $faktur_dbtable = new DBTable($db, "smis_fnc_bayar");
    $faktur_dbtable->setViewForSelect(true);
    $filter = "";
    if (isset($_POST['kriteria'])) {
        $filter .= " AND no_faktur LIKE '%" . $_POST['kriteria'] . "%' ";
    }
    if (isset($_POST['id_vendor'])) {
        $filter .= " AND id_vendor = '" . $_POST['id_vendor'] . "' ";
    }
    $query_value = "
        SELECT
            CONCAT('gudang_farmasi', '|', id) id,
            'gudang_farmasi' asal_faktur, 
            no_faktur nomor_faktur,
            no_bbm,
            tanggal tanggal_faktur,
            tanggal_tempo jatuh_tempo,
            nama_vendor rekanan,
            total_tagihan,
            (total_tagihan - total_dibayar) sisa_tagihan
        FROM
            smis_fr_obat_masuk
        WHERE
                prop = ''
                    AND id > 0
                    AND id_po > 0
                    AND has_journal = 1
                    AND sudah_direkap = 0
                    " . $filter . "
            ORDER BY
                (total_tagihan - total_dibayar) DESC
    ";
    if (isset($_POST['asal_faktur']) && $_POST['asal_faktur'] == "gudang_umum") {
        $query_value = "
            SELECT
                CONCAT('gudang_umum', '|', id) id,
                'gudang_umum' asal_faktur, 
                no_faktur nomor_faktur,
                no_bbm,
                tanggal tanggal_faktur,
                tanggal_tempo jatuh_tempo,
                nama_vendor rekanan,
                total_tagihan,
                (total_tagihan - total_dibayar) sisa_tagihan
            FROM
                smis_gu_barang_masuk
            WHERE
                prop = ''
                    AND id > 0
                    AND id_po > 0
                    AND has_journal = 1
                    AND sudah_direkap = 0
                    " . $filter . "
            ORDER BY
                (total_tagihan - total_dibayar) DESC
        ";
    }
    $query_count = "
		SELECT COUNT(*)
		FROM (
			" . $query_value . "
		) v_faktur
	";
    $faktur_dbtable->setPreferredQuery(true, $query_value, $query_count);
    require_once("finance/class/responder/KBPFFakturDBResponder.php");
    $faktur_dbresponder = new KBPFFakturDBResponder(
        $faktur_dbtable,
        $faktur_table,
        $faktur_adapter
    );

    $super_command = new SuperCommand();
    $super_command->addResponder("faktur", $faktur_dbresponder);
    $init = $super_command->initialize();
    if ($init != null) {
        echo $init;
        return;
    }

    if (isset($_POST['command'])) {
        if ($_POST['command'] == "get_html_detail_faktur") {
            $html = "";
            $unit = $_POST['unit'];
            $id_bbm = $_POST['id_bbm'];

            $table_header = "smis_fr_obat_masuk";
            $table_detail = "smis_fr_dobat_masuk";
            $table_stok = "smis_fr_stok_obat";
            $id_header = "id_obat_masuk";
            $id_detail = "id_dobat_masuk";
            if ($unit == "GUDANG UMUM") {
                $table_header = "smis_gu_barang_masuk";
                $table_detail = "smis_gu_dbarang_masuk";
                $table_stok = "smis_gu_stok_barang";
                $id_header = "id_barang_masuk";
                $id_detail = "id_dbarang_masuk";
            }

            $header_row = $db->get_row("
                SELECT 
                    *
                FROM 
                    " . $table_header . "
                WHERE 
                    id = '" . $id_bbm . "'
            ");
            $detail_rows = $db->get_result("
                SELECT 
                    a.*, CASE WHEN b.tanggal_exp IS NULL THEN '-' ELSE b.tanggal_exp END AS 'tanggal_exp', CASE WHEN b.no_batch IS NULL THEN '-' ELSE b.no_batch END AS 'no_batch'
                FROM 
                    " . $table_detail . " a 
                        LEFT JOIN " . $table_stok . " b ON a.id = b." . $id_detail . "
                WHERE 
                    a." . $id_header . " = '" . $id_bbm . "' 
                        AND a.prop LIKE ''
            ");

            $html = "<table border='1' width='100%'>";
            $html .= "<caption><center>FAKTUR " . $unit . " (" . strtoupper($header_row->nama_vendor) . ")</center></caption>";
            if ($detail_rows != null) {
                $nomor = 1;
                $total = 0;
                $html .=    "<thead>
                                <tr>
                                    <th>No.</th>
                                    <th>Kode</th>
                                    <th>Nama</th>
                                    <th>Jenis</th>
                                    <th>Stok Entri</th>
                                    <th>Jml. Tercatat</th>
                                    <th>Jml. Diterima</th>
                                    <th>Satuan</th>
                                    <th>Harga</th>
                                    <th>Diskon</th>
                                    <th>Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>";
                foreach ($detail_rows as $detail_row) {
                    $subtotal = $detail_row->hna * $detail_row->jumlah;
                    $hpp = $detail_row->hna;
                    if ($header_row->use_ppn == 1) {
                        $subtotal = $detail_row->hna / 1.1 * $detail_row->jumlah;
                        $hpp = $detail_row->hna / 1.1;
                    }
                    $f_diskon = $detail_row->diskon . " %";
                    if ($detail_row->t_diskon == "nominal") {
                        $f_diskon = ArrayAdapter::format("only-money", $detail_row->diskon);
                        $subtotal = $subtotal - $detail_row->diskon;
                    } else {
                        $subtotal = $subtotal - ($detail_row->diskon * $subtotal / 100);
                    }
                    $subtotal = round($subtotal);
                    $total += $subtotal;
                    $f_subtotal = ArrayAdapter::format("money", $subtotal);
                    if ($unit == "GUDANG FARMASI") {
                        $html .=    "<tr>
                                        <td id='nomor'>" . $nomor++ . "</td>
                                        <td id='kode_obat'>" . $detail_row->kode_obat . "</td>
                                        <td id='nama_obat'>" . $detail_row->nama_obat . "</td>
                                        <td id='nama_jenis_obat'>" . $detail_row->nama_jenis_obat . "</td>
                                        <td id='f_stok_entri'>" . ArrayAdapter::format("number", $detail_row->stok_entri) . "</td>
                                        <td id='f_jumlah_tercatat'>" . ArrayAdapter::format("number", $detail_row->jumlah_tercatat) . "</td>
                                        <td id='f_jumlah'>" . ArrayAdapter::format("number", $detail_row->jumlah) . "</td>
                                        <td id='satuan'>" . $detail_row->satuan . "</td>
                                        <td id='f_hna'>" . ArrayAdapter::format("money", $hpp) . "</td>
                                        <td id='f_diskon'><div align='right'>" . $f_diskon . "</div></td>
                                        <td id='f_subtotal'>" . $f_subtotal . "</td>
                                    </tr>";
                    } else {
                        $html .=    "<tr>
                                        <td id='nomor'>" . $nomor++ . "</td>
                                        <td id='kode_barang'>" . $detail_row->kode_barang . "</td>
                                        <td id='nama_barang'>" . $detail_row->nama_barang . "</td>
                                        <td id='nama_jenis_barang'>" . $detail_row->nama_jenis_barang . "</td>
                                        <td id='f_stok_entri'>" . ArrayAdapter::format("number", $detail_row->stok_entri) . "</td>
                                        <td id='f_jumlah_tercatat'>" . ArrayAdapter::format("number", $detail_row->jumlah_tercatat) . "</td>
                                        <td id='f_jumlah'>" . ArrayAdapter::format("number", $detail_row->jumlah) . "</td>
                                        <td id='satuan'>" . $detail_row->satuan . "</td>
                                        <td id='f_hna'>" . ArrayAdapter::format("money", $hpp) . "</td>
                                        <td id='f_diskon'><div align='right'>" . $f_diskon . "</div></td>
                                        <td id='f_subtotal'>" . $f_subtotal . "</td>
                                    </tr>";
                }
            }
            $global_diskon = $header_row->diskon;
            $global_t_diskon = $header_row->t_diskon;
            if ($global_t_diskon == "persen")
                $global_diskon = $global_diskon * $total / 100;
            $global_diskon = floor($global_diskon);
            $total_1 = $total - $global_diskon;
            $use_ppn = $header_row->use_ppn;
            $ppn = floor($total_1 * 0.1);
            if ($use_ppn == 0)
                $ppn = 0;
            $total_2 = $total_1 + $ppn;
            $tambahan_biaya = $header_row->materai;
            $tagihan = $total_2 + $tambahan_biaya;
            $html .=    "</tbody>
                            <tfoot>
                                <tr>
                                    <td colspan='10'><div align='right'><strong>Total I</strong></div></td>
                                    <td id='total'><div align='right'>" . ArrayAdapter::format("only-money", $total_1) . "</div></td>
                                </tr>
                                <tr>
                                    <td colspan='10'><div align='right'><strong>Diskon</strong></div></td>
                                    <td id='diskon_global'><div align='right'>" . ArrayAdapter::format("only-money", $global_diskon) . "</div></td>
                                </tr>
                                <tr>
                                    <td colspan='10'><div align='right'><strong>Total II</strong></div></td>
                                    <td id='total_2'><div align='right'>" . ArrayAdapter::format("only-money", $total_2) . "</div></td>
                                </tr>
                                <tr>
                                    <td colspan='10'><div align='right'><strong>PPn</strong></div></td>
                                    <td id='ppn'><div align='right'>" . ArrayAdapter::format("only-money", $ppn) . "</div></td>
                                </tr>
                                <tr>
                                    <td colspan='10'><div align='right'><strong>Tambahan Biaya</strong></div></td>
                                    <td id='tambahan_biaya'><div align='right'>" . ArrayAdapter::format("only-money", $tambahan_biaya) . "</div></td>
                                </tr>
                                <tr>
                                    <td colspan='10'><div align='right'><strong>Jumlah Tagihan</strong></div></td>
                                    <td id='tagihan'><div align='right'>" . ArrayAdapter::format("only-money", $tagihan) . "</div></td>
                                </tr>
                            </tfoot>";
            }
            $html .= "</table>";

            echo json_encode([
                'html' => $html
            ]);
            return;
        }
        return;
    }

    $table = new Table(
        array("No.", "Asal Faktur", "No. Faktur", "No. BBM", "Tgl. Faktur", "Tgl. Jatuh Tempo", "Total Tagihan"),
        "",
        null,
        true
    );
    $table->setName("info_rekap_faktur");
    $table->setAddButtonEnable(false);
    $table->setReloadButtonEnable(false);
    $table->setPrintButtonEnable(false);
    $table->setEditButtonEnable(false);
    $table->setDelButtonEnable(false);
    $table->setFooterVisible(false);
    $add_button = new Button("button_add_faktur", "", "Faktur");
    $add_button->setClass("btn btn-primary");
    $add_button->setAction("info_rekap_faktur.show_add_form()");
    $add_button->setIcon("fa fa-plus");
    $add_button->setIsButton(Button::$ICONIC_TEXT);
    $table->addHeaderButton($add_button);

    $faktur_modal = new Modal("info_rekap_faktur_add_form", "", "Faktur");
    $id_hidden = new Hidden("info_rekap_faktur_id", "info_rekap_faktur_id", "");
    $faktur_modal->addElement("", $id_hidden);
    $id_bbm_hidden = new Hidden("info_rekap_faktur_id_bbm", "info_rekap_faktur_id_bbm", "");
    $faktur_modal->addElement("", $id_bbm_hidden);
    $nomor_faktur_text = new Text("info_rekap_faktur_nomor_faktur", "info_rekap_faktur_nomor_faktur", "");
    $nomor_faktur_text->setAtribute("disabled='disabled'");
    $nomor_faktur_text->setClass("smis-one-option-input");
    $faktur_browse_button = new Button("", "", "Pilih");
    $faktur_browse_button->setClass("btn-info");
    $faktur_browse_button->setIsButton(Button::$ICONIC);
    $faktur_browse_button->setIcon("icon-white " . Button::$icon_list_alt);
    $faktur_browse_button->setAction("faktur.chooser('faktur', 'faktur', 'faktur', faktur)");
    $faktur_browse_button->setAtribute("id='faktur_browse'");
    $faktur_input_group = new InputGroup("");
    $faktur_input_group->addComponent($nomor_faktur_text);
    $faktur_input_group->addComponent($faktur_browse_button);
    $faktur_modal->addElement("No. Faktur", $faktur_input_group);
    $nomor_bbm_text = new Text("info_rekap_faktur_nomor_bbm", "info_rekap_faktur_nomor_bbm", "");
    $nomor_bbm_text->setAtribute("disabled='disabled'");
    $faktur_modal->addElement("No. BBM", $nomor_bbm_text);
    $tanggal_faktur_text = new Text("info_rekap_faktur_tanggal_faktur", "info_rekap_faktur_tanggal_faktur", "");
    $tanggal_faktur_text->setAtribute("disabled='disabled'");
    $faktur_modal->addElement("Tgl. Faktur", $tanggal_faktur_text);
    $tanggal_jatuh_tempo_text = new Text("info_rekap_faktur_tanggal_jatuh_tempo", "info_rekap_faktur_tanggal_jatuh_tempo", "");
    $tanggal_jatuh_tempo_text->setAtribute("disabled='disabled'");
    $faktur_modal->addElement("Tgl. Jatuh Tempo", $tanggal_jatuh_tempo_text);
    $total_tagihan_text = new Text("info_rekap_faktur_total_tagihan", "info_rekap_faktur_total_tagihan", "");
    $total_tagihan_text->setAtribute("disabled='disabled'");
    $faktur_modal->addElement("Total Tagihan", $total_tagihan_text);
    $unit_text = new Text("info_rekap_faktur_unit", "info_rekap_faktur_unit", "");
    $unit_text->setAtribute("disabled='disabled'");
    $faktur_modal->addElement("Asal Faktur", $unit_text);
    $save_button = new Button("button_save_faktur", "", "Simpan");
    $save_button->setClass("btn btn-primary");
    $save_button->setAction("info_rekap_faktur.save()");
    $save_button->setIcon("fa fa-save");
    $save_button->setIsButton(Button::$ICONIC);
    $faktur_modal->addFooter($save_button);

    $detail_faktur_modal = new Modal("detail_faktur_form", "", "Detail Faktur");
    $detail_faktur_modal->setClass(Modal::$HALF_MODEL);
    $ok_button = new Button("", "", "OK");
    $ok_button->setClass("btn-inverse");
    $ok_button->setAction("$($(this).data('target')).smodal('hide')");
    $detail_faktur_modal->addFooter($ok_button);

    echo $detail_faktur_modal->getHtml();
    echo $faktur_modal->getHtml();
    echo $table->getHtml();
?>
<script type="text/javascript">
    var info_rekap_faktur;
    var faktur;
    var N_ROWS;
    $(document).ready(function() {
        N_ROWS = <?php echo isset($_POST['r_num_detail_rekap_faktur']) ? $_POST['r_num_detail_rekap_faktur'] : 0; ?>;
        <?php 
            if (isset($_POST['html_detail_rekap_faktur'])) { ?>
                $("#info_rekap_faktur_list").html("<?php echo $_POST['html_detail_rekap_faktur']; ?>");
            <?php
            } else { ?>
                $("#info_rekap_faktur_list").html("<tr id='info_rekap_faktur_temp'><td colspan='8'><center>Tidak terdapat daftar info faktur.</center></td></tr>");
            <?php
            }
        ?>

        $("#smis-chooser-modal").on("show", function() {
            if ($("#smis-chooser-modal .modal-header h3").text() == "FAKTUR") {
                $("#smis-chooser-modal").removeClass("half_model");
                $("#smis-chooser-modal").removeClass("full_model");
                $("#smis-chooser-modal").addClass("full_model");
            } else {
                $("#smis-chooser-modal").removeClass("half_model");
                $("#smis-chooser-modal").removeClass("full_model");
            }
        });

        info_rekap_faktur = new TableAction(
            "info_rekap_faktur",
            "finance",
            "kb_prf_informasi_rekap_faktur",
            new Array("row_num", "id", "id_bbm", "nomor_faktur", "nomor_bbm", "tanggal_faktur", "tanggal_jatuh_tempo", "total_tagihan", "unit")
        );
        info_rekap_faktur.show_add_form = function() {
            var id_vendor = $("#rekap_faktur_id_vendor").val();
            if (id_vendor == "" || id_vendor == 0) {
                bootbox.alert({
                    title: "Peringatan",
                    message: "Vendor tidak diperkenankan kosong."
                });
                return;
            }
            TableAction.prototype.show_add_form.call(this);
        };
        info_rekap_faktur.validate = function() {
            var valid = true;
            var message = "<ul>";
            var id_bbm = $("#info_rekap_faktur_id_bbm").val();
            var unit = $("#info_rekap_faktur_unit").val();
            var nomor_faktur = $("#info_rekap_faktur_nomor_faktur").val();
            if (id_bbm == "" || id_bbm == 0) {
                valid = false;
                message += "<li>Silakan memilih Faktur terlebih dahulu.</li>";
            } else if (this.isExistFaktur(id_bbm, unit)) {
                valid = false;
                message += "<li>Faktur " + nomor_faktur + " / Asal " + unit + " sudah ada dalam daftar.</li>";
            }
            message += "</ul>";
            if (!valid) {
                $("#info_rekap_faktur_add_form").smodal("hide");
                bootbox.alert({
                    closeButton: false,
                    title: "Peringatan",
                    message: message,
                    callback: function() {
                        $("#info_rekap_faktur_add_form").smodal("show");
                    }
                });
            }
            return valid;
        };
        info_rekap_faktur.isExistFaktur = function(id_bbm, unit) {
            var result = false;
            var total_tr = $("#info_rekap_faktur_list tr.data_faktur").length;
            for (var i = 0; i < total_tr; i++) {
                var cur_prop = $("#info_rekap_faktur_list tr.data_faktur:eq(" + i + ") td#faktur_prop").text();
                var cur_id_bbm = $("#info_rekap_faktur_list tr.data_faktur:eq(" + i + ") td#faktur_id_bbm").text();
                if (cur_prop == "" && cur_id_bbm == id_bbm) {
                    result = true;
                    break;
                }
            }
            return result;
        };
        info_rekap_faktur.save = function() {
            if (!this.validate()) {
                return;
            }
            var id = $("#info_rekap_faktur_id").val();
            var id_bbm = $("#info_rekap_faktur_id_bbm").val();
            var nomor_faktur = $("#info_rekap_faktur_nomor_faktur").val();
            var nomor_bbm = $("#info_rekap_faktur_nomor_bbm").val();
            var tanggal_faktur = $("#info_rekap_faktur_tanggal_faktur").val();
            var tanggal_jatuh_tempo = $("#info_rekap_faktur_tanggal_jatuh_tempo").val();
            var total_tagihan = $("#info_rekap_faktur_total_tagihan").val();
            var unit = $("#info_rekap_faktur_unit").val();
            $("#info_rekap_faktur_list").append(
                "<tr id='faktur_" + N_ROWS + "' class='data_faktur'>" +
                "<td id='faktur_id' style='display: none;'>" + id + "</td>" +
                "<td id='faktur_id_rekap_faktur' style='display: none;'></td>" +
                "<td id='faktur_id_bbm' style='display: none;'>" + id_bbm + "</td>" +
                "<td id='faktur_prop' style='display: none;'></td>" +
                "<td id='faktur_nomor'></td>" +
                "<td id='faktur_unit'>" + unit + "</td>" +
                "<td id='faktur_nomor_faktur'>" + nomor_faktur + "</td>" +
                "<td id='faktur_nomor_bbm'>" + nomor_bbm + "</td>" +
                "<td id='faktur_tanggal_faktur'>" + tanggal_faktur + "</td>" +
                "<td id='faktur_tanggal_jatuh_tempo'>" + tanggal_jatuh_tempo + "</td>" +
                "<td id='faktur_total_tagihan'><div align='right'>" + total_tagihan + "</div></td>" +
                "<td>" +
                "<div class='btn-group noprint'>" +
                "<a href='#' onclick='info_rekap_faktur.detail(" + N_ROWS + ")' data-content='Lihat' data-toggle='popover' class='input btn btn-success'>" +
                "<i class='icon-eye-open icon-white'></i>" +
                "</a>" +
                "<a href='#' onclick='info_rekap_faktur.delete(" + N_ROWS + ")' data-content='Batal' data-toggle='popover' class='input btn btn-danger'>" +
                "<i class='fa fa-times'></i>" +
                "</a>" +
                "</div>" +
                "</td>" +
                "</tr>"
            );
            N_ROWS++;
            this.clear();
            this.refreshNumberAndFooterInfo();
            $("#info_rekap_faktur_add_form").smodal("hide");
        };
        info_rekap_faktur.refreshNumberAndFooterInfo = function() {
            if ($("#info_rekap_faktur_temp").length > 0) {
                $("#info_rekap_faktur_temp").remove();
            }
            if ($("#footer_info_rekap_faktur").length > 0) {
                $("#footer_info_rekap_faktur").remove();
            }
            var total_tr = $("#info_rekap_faktur_list tr.data_faktur").length;
            var visible_tr = 0;
            var nomor = 1;
            var total_tagihan = 0;
            for (var i = 0; i < total_tr; i++) {
                var prop = $("#info_rekap_faktur_list tr.data_faktur:eq(" + i + ") td#faktur_prop").text();
                var tagihan = parseFloat($("#info_rekap_faktur_list tr.data_faktur:eq(" + i + ") td#faktur_total_tagihan").text().replace(/[^0-9-,]/g, '').replace(",", "."));
                if (prop == "") {
                    $("#info_rekap_faktur_list tr.data_faktur:eq(" + i + ") td#faktur_nomor").html(nomor);
                    total_tagihan += tagihan;
                    nomor++;
                    visible_tr++;
                } else {
                    $("#info_rekap_faktur_list tr.data_faktur:eq(" + i + ") td#faktur_nomor").html("");
                }
            }
            var total_dibayar = parseFloat($("#rekap_faktur_total_dibayar").val().replace(/[^0-9-,]/g, '').replace(",", "."));
            sisa_tagihan = total_tagihan - total_dibayar;
            sisa_tagihan = sisa_tagihan.formatMoney("2", ".", ",");
            total_tagihan = total_tagihan.formatMoney("2", ".", ",");
            $("#rekap_faktur_total_tagihan").val(total_tagihan);
            $("#rekap_faktur_sisa_tagihan").val(sisa_tagihan);
            if (visible_tr > 0) {
                $("#info_rekap_faktur_list").append(
                    "<tr id='footer_info_rekap_faktur'>" +
                    "<td colspan='6'><div align='right'><b>Total</b></div></td>" +
                    "<td id='faktur_total_tagihan'><div align='right'><b>" + total_tagihan + "</div></div></td>" +
                    "<td></td>" +
                    "</tr>"
                );
            } else {
                $("#info_rekap_faktur_list").html("<tr id='info_rekap_faktur_temp'><td colspan='8'><center>Tidak terdapat daftar info faktur.</center></td></tr>");
            }
        };
        info_rekap_faktur.detail = function(r_num) {
            var data = this.getRegulerData();
            data['command'] = "get_html_detail_faktur";
            data['id_bbm'] = $("#faktur_" + r_num + " td#faktur_id_bbm").text();
            data['unit'] = $("#faktur_" + r_num + " td#faktur_unit").text();
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dimissLoading();
                        return;
                    }
                    $("#detail_faktur_form_form").html(json.html);
                    $("#detail_faktur_form").smodal("show");
                    dismissLoading();
                }
            );
        };
        info_rekap_faktur.delete = function(r_num) {
            var id = $("#faktur_" + r_num).text();
            if (id == "" || id == 0) {
                $("#faktur_" + r_num).remove();
            } else {
                $("#faktur_" + r_num + " td#faktur_prop").html("del");
                $("#faktur_" + r_num).hide();
            }
            this.refreshNumberAndFooterInfo();
        };

        faktur = new TableAction(
            "faktur",
            "finance",
            "kb_prf_informasi_rekap_faktur",
            new Array()
        );
        faktur.addViewData = function(data) {
            data['asal_faktur'] = $("#filter_gudang").val();
            data['id_vendor'] = $("#rekap_faktur_id_vendor").val();
            return data;
        };
        faktur.selected = function(json) {
            $("#info_rekap_faktur_id_bbm").val(json.header.id);
            $("#info_rekap_faktur_nomor_faktur").val(json.header.nomor_faktur);
            $("#info_rekap_faktur_nomor_bbm").val(json.header.no_bbm);
            $("#info_rekap_faktur_tanggal_faktur").val(json.header.tanggal_faktur);
            $("#info_rekap_faktur_tanggal_jatuh_tempo").val(json.header.jatuh_tempo);
            $("#info_rekap_faktur_total_tagihan").val(json.header.total_tagihan);
            $("#info_rekap_faktur_unit").val(json.header.asal_faktur.toUpperCase().replace("_", " "));
        };
        faktur.setSuperCommand("faktur");
    });
</script>