<?php
    global $db;

    $uang_muka_table = new Table(array("No.", "No. Jurnal", "Tgl. Jurnal", "No. OPL", "Unit", "Uraian", "PIC", "Nilai Keluar", "Status"));
    $uang_muka_table->setName("uang_muka");
    $uang_muka_table->setModel(Table::$SELECT);
    $uang_muka_adapter = new SimpleAdapter(true, "No.");
    $uang_muka_adapter->add("No. Jurnal", "nomor_jurnal");
    $uang_muka_adapter->add("Tgl. Jurnal", "tanggal_jurnal", "date d-m-Y");
    $uang_muka_adapter->add("No. OPL", "nomor_opl");
    $uang_muka_adapter->add("Unit", "unit", "unslug");
    $uang_muka_adapter->add("Uraian", "uraian");
    $uang_muka_adapter->add("PIC", "pic");
    $uang_muka_adapter->add("Nilai Keluar", "nilai", "money");
    $uang_muka_adapter->add("Status", "status");
    $uang_muka_dbtable = new DBTable($db, "smis_fnc_uang_muka");
    $uang_muka_dbtable->addCustomKriteria(" diakui ", " = 0 ");
    if (isset($_POST['id_opl'])) {
        $uang_muka_dbtable->addCustomKriteria(" id_opl ", " = '"  . $_POST['id_opl'] . "' ");
    }
    $uang_muka_dbresponder = new DBResponder($uang_muka_dbtable, $uang_muka_table, $uang_muka_adapter);

    $super_command = new SuperCommand();
    $super_command->addResponder("uang_muka", $uang_muka_dbresponder);
    $init = $super_command->initialize();
    if ($init != null) {
        echo $init;
        return;
    }

    $table = new Table(
        array("No.", "No. ID", "No. Jurnal UM", "Tgl. Jurnal UM", "PIC", "Nilai"),
        "",
        null,
        true
    );
    $table->setName("uang_muka_faktur");
    $table->setFooterVisible(false);
    $table->setReloadButtonEnable(false);
    $table->setPrintButtonEnable(false);
    $table->setAddButtonEnable(false);
    $add_button = new Button("", "", "Match Uang Muka");
    $add_button->setClass("btn-info");
    $add_button->setIsButton(Button::$ICONIC_TEXT);
    $add_button->setIcon("fa fa-plus");
    $add_button->setAction("uang_muka_faktur.show_add_form()");
    $add_button->setAtribute("id='add_uang_muka_faktur_button'");
    $table->addHeaderButton($add_button);

    if (isset($_POST['command'])) {
        $adapter = new SummaryAdapter(true, "No.");
        $adapter->addFixValue("PIC", "<div align='right'><b>Total</b></div>");
        $adapter->addSummary("Nilai", "nilai", "money");
        $adapter->add("No. ID", "id");
        $adapter->add("No. Jurnal UM", "nomor_jurnal");
        $adapter->add("Tgl. Jurnal UM", "tanggal_jurnal", "date d-m-Y");
        $adapter->add("PIC", "pic");
        $adapter->add("Nilai", "nilai", "money");
        $dbtable = new DBTable($db, "smis_fnc_uang_muka_faktur");

        if ($_POST['command'] == "list") {
            $id_faktur = $_POST['id_faktur'];
            $asal_faktur = $_POST['asal_faktur'];

            $query_value = "
                SELECT
                    *
                FROM
                    smis_fnc_uang_muka_faktur
                WHERE
                    prop = ''
                        AND id_faktur = '" . $id_faktur . "'
                        AND asal_faktur LIKE '" . $asal_faktur . "'
                ORDER BY
                    tanggal_jurnal ASC,
                        nomor_jurnal ASC,
                        id ASC
            ";
            $query_count = "
                SELECT
                    COUNT(*)
                FROM 
                    (" . $query_value . ") v
            ";
            $dbtable->setPreferredQuery(true, $query_value, $query_count);
            $dbtable->setShowAll(true);
        }
        require_once("finance/class/responder/KBUangMukaFakturDBResponder.php");
        $dbresponder = new KBUangMukaFakturDBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    $modal = new Modal("uang_muka_faktur_add_form", "", "Match Uang Muka");
    $id_hidden = new Hidden("uang_muka_faktur_id", "uang_muka_faktur_id", "");
    $modal->addElement("", $id_hidden);
    $id_uang_muka_hidden = new Hidden("uang_muka_faktur_id_uang_muka", "uang_muka_faktur_id_uang_muka", "");
    $modal->addELement("", $id_uang_muka_hidden);
    $id_opl_hidden = new Hidden("uang_muka_faktur_id_opl", "uang_muka_faktur_id_opl", "");
    $modal->addElement("", $id_opl_hidden);
    $unit_hidden = new Hidden("uang_muka_faktur_unit", "uang_muka_faktur_unit", "");
    $modal->addElement("", $unit_hidden);
    $nomor_opl_hidden = new Hidden("uang_muka_faktur_nomor_opl", "uang_muka_faktur_nomor_opl", "");
    $modal->addElement("", $nomor_opl_hidden);
    $uraian_hidden = new Hidden("uang_muka_faktur_uraian", "uang_muka_faktur_uraian", "");
    $modal->addElement("", $uraian_hidden);
    $uang_muka_button = new Button("", "", "Pilih");
    $uang_muka_button->setClass("btn-info");
    $uang_muka_button->setIsButton(Button::$ICONIC);
    $uang_muka_button->setIcon("icon-white " . Button::$icon_list_alt);
    $uang_muka_button->setAction("uang_muka.chooser('uang_muka', 'uang_muka_button', 'uang_muka', uang_muka, 'Uang Muka')");
    $uang_muka_button->setAtribute("id='uang_muka_browse'");
    $nomor_jurnal_text = new Text("uang_muka_faktur_nomor_jurnal", "uang_muka_faktur_nomor_jurnal", "");
    $nomor_jurnal_text->setAtribute("disabled='disabled'");
    $nomor_jurnal_text->setClass("smis-one-option-input");
    $uang_muka_input_group = new InputGroup("");
    $uang_muka_input_group->addComponent($nomor_jurnal_text);
    $uang_muka_input_group->addComponent($uang_muka_button);
    $modal->addElement("No. Jurnal", $uang_muka_input_group);
    $tanggal_jurnal_text = new Text("uang_muka_faktur_tanggal_jurnal", "uang_muka_faktur_tanggal_jurnal", "");
    $tanggal_jurnal_text->setAtribute("disabled='disabled'");
    $modal->addElement("Tgl. UM", $tanggal_jurnal_text);
    $pic_text = new Text("uang_muka_faktur_pic", "uang_muka_faktur_pic", "");
    $pic_text->setAtribute("disabled='disabled'");
    $modal->addElement("PIC", $pic_text);
    $nilai_text = new Text("uang_muka_faktur_nilai", "uang_muka_faktur_nilai", "");
    $nilai_text->setAtribute("disabled='disabled'");
    $modal->addElement("Nilai", $nilai_text);
    $save_button = new Button("", "", "Simpan");
    $save_button->setClass("btn-success");
    $save_button->setAction("uang_muka_faktur.save()");
    $modal->addFooter($save_button);

    echo $modal->getHtml();
    echo $table->getHtml();
?>
<script type="text/javascript">
    var uang_muka;
    var uang_muka_faktur;
    $(document).ready(function() {
        uang_muka = new TableAction(
            "uang_muka",
            "finance",
            "kb_pf_faktur_uang_muka",
            new Array()
        );
        uang_muka.addViewData = function(data) {
            data['id_opl'] = $("#faktur_id_opl").val();
            return data;
        };
        uang_muka.selected = function(json) {
            $("#uang_muka_faktur_id_uang_muka").val(json.id);
            $("#uang_muka_faktur_id_opl").val(json.id_opl);
            $("#uang_muka_faktur_unit").val(json.unit);
            $("#uang_muka_faktur_nomor_opl").val(json.nomor_opl);
            $("#uang_muka_faktur_uraian").val(json.uraian);
            $("#uang_muka_faktur_nomor_jurnal").val(json.nomor_jurnal);
            $("#uang_muka_faktur_tanggal_jurnal").val(json.tanggal_jurnal);
            $("#uang_muka_faktur_pic").val(json.pic);
            $("#uang_muka_faktur_nilai").val(json.nilai);
        };
        uang_muka.setSuperCommand("uang_muka");

        uang_muka_faktur = new TableAction(
            "uang_muka_faktur",
            "finance",
            "kb_pf_faktur_uang_muka",
            new Array("id", "id_uang_muka", "id_opl", "unit", "nomor_opl", "uraian", "nomor_jurnal", "tanggal_jurnal", "pic", "nilai")
        );
        uang_muka_faktur.addRegulerData = function(data) {
            data['id_faktur'] = $("#faktur_id_faktur").val();
            data['asal_faktur'] = $("#faktur_asal_faktur").val();
            return data;
        };
        uang_muka_faktur.validate = function() {
            var valid = true;
            var invalid_msg = "";
            var id_uang_muka = $("#uang_muka_faktur_id_uang_muka").val();

            $(".error_field").removeClass("error_field");

            if (id_uang_muka == "") {
                valid = false;
                invalid_msg += "</br><strong>Uang Muka</strong> tidak boleh kosong";
                $("#uang_muka_faktur_nomor_jurnal").addClass("error_field");
            }

            if (!valid) {
                $("#modal_alert_uang_muka_faktur_add_form").html(
                    "<div class='alert alert-block alert-danger'>" +
                    "<h4>Peringatan</h4>" +
                    invalid_msg +
                    "</div>"
                );
            }
            return valid;
        };
        uang_muka_faktur.save = function() {
            if (!this.validate())
                return;
            var self = this;
            var data = this.getSaveData();
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = getContent(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    dismissLoading();
                    $("#faktur_sisa_tagihan").val(json.sisa_tagihan);
                    $("#uang_muka_faktur_add_form").smodal("hide");
                    // self.printelement(json.id);
                    self.view();
                }
            );
        };
        uang_muka_faktur.del = function(id) {
            var self = this;
            var html_message =  "<strong>Peringatan</strong> : ";
                html_message += "Pembatalan transaksi akan berdampak pada jurnal terkait di Buku Besar Akuntansi.<br/><br/>";
                html_message += "Yakin membatalkan transaksi ini?";
            bootbox.confirm({
                message: html_message,
                buttons: {
                    confirm : {
                        label : "Ya",
                        className : "btn-success"
                    },
                    cancel : {
                        label : "Tidak",
                        className : "btn-danger"
                    }
                },
                callback: function(result) {
                    if (result) {
                        var data = self.getRegulerData();
                        data['command'] = "del";
                        data['id'] = id;
                        showLoading();
                        $.post(
                            "",
                            data,
                            function(response) {
                                var json = getContent(response);
                                if (json == null) {
                                    dismissLoading();
                                    return;
                                }
                                $("#faktur_sisa_tagihan").val(json.sisa_tagihan);
                                dismissLoading();
                                self.view();
                            }
                        );
                    }
                }
            });
        };
    });
</script>
<style type="text/css">
    #uang_muka_faktur_add_form_form label {
        width: 150px !important;
    }
</style>