<?php
    global $db;

    $table = new Table(
        array("No.", "No. ID", "No. Ref.", "Tgl. Bayar", "Jenis Bayar", "Nilai", "Keterangan", "Akun"),
        "",
        null,
        true
    );
    $table->setName("pembayaran_faktur");
    $table->setFooterVisible(false);
    $table->setReloadButtonEnable(false);
    $table->setPrintButtonEnable(false);
    $table->setAddButtonEnable(false);
    $table->setPrintElementButtonEnable(true);
    $add_button = new Button("", "", "Pembayaran");
	$add_button->setClass("btn-info");
	$add_button->setIsButton(Button::$ICONIC_TEXT);
	$add_button->setIcon("fa fa-plus");
	$add_button->setAction("pembayaran_faktur.show_add_form()");
    $add_button->setAtribute("id='add_pembayaran_faktur_button'");
    $table->addHeaderButton($add_button);
    
    if (isset($_POST['command'])) {
        $adapter = new SummaryAdapter(true, "No.");
        $adapter->addFixValue("Jenis Bayar", "<div align='right'><b>Total</b></div>");
        $adapter->addSummary("Nilai", "kredit", "money");
        $adapter->add("No. ID", "id");
        $adapter->add("No. Ref.", "noref");
        $adapter->add("Tgl. Bayar", "waktu", "date d-m-Y");
        $adapter->add("Jenis Bayar", "jenis");
        $adapter->add("Nilai", "kredit", "money");
        $adapter->add("Keterangan", "keterangan");
        $adapter->add("Akun", "akun");
        $dbtable = new DBTable($db, "smis_fnc_bayar");

        if ($_POST['command'] == "list") {
            $id_faktur = $_POST['id_faktur'];
            $asal_faktur = $_POST['asal_faktur'];

            $query_value = "
                SELECT
                    id, noref, waktu, jenis, kredit, keterangan, CONCAT(no_akun, ' - ', nama_dompet) akun
                FROM
                    smis_fnc_bayar
                WHERE
                    prop = ''
                        AND id_faktur = '" . $id_faktur . "'
                        AND asal_faktur LIKE '" . $asal_faktur . "'
                ORDER BY
                    waktu ASC,
                        id ASC
            ";
            $query_count = "
                SELECT
                    COUNT(*)
                FROM 
                    (" . $query_value . ") v
            ";
            $dbtable->setPreferredQuery(true, $query_value, $query_count);
            $dbtable->setShowAll(true);
        }
        require_once("finance/class/responder/KBPembayaranFakturDBResponder.php");
        $dbresponder = new KBPembayaranFakturDBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    $modal = new Modal("pembayaran_faktur_add_form", "", "Pembayaran Faktur");
    $id_hidden = new Hidden("pembayaran_faktur_id", "pembayaran_faktur_id", "");
    $modal->addElement("", $id_hidden);
    $nomor_text = new Text("pembayaran_faktur_nomor", "pembayaran_faktur_nomor", "");
    $nomor_text->setAtribute("disabled='disabled'");
    $modal->addElement("No. Jurnal", $nomor_text);
    $noref_text = new Text("pembayaran_faktur_noref", "pembayaran_faktur_noref", "");
    $noref_text->addAtribute("autofocus");
    $modal->addElement("No. Ref.", $noref_text);
    $waktu_text = new Text("pembayaran_faktur_waktu", "pembayaran_faktur_waktu", date("d-m-Y"));
    $waktu_text->setAtribute("data-date-format='dd-mm-yyyy'");
    $waktu_text->setClass("mydate");
    $modal->addElement("Tgl. Bayar", $waktu_text);
    $jenis_option = new OptionBuilder();
    $jenis_option->addSingle("Tunai");
    $jenis_option->addSingle("Giro");
    $jenis_option->addSingle("Cek");
    $jenis_option->addSingle("Transfer Bank");
    $jenis_select = new Select("pembayaran_faktur_jenis", "pembayaran_faktur_jenis", $jenis_option->getContent());
    $modal->addElement("Jenis Bayar", $jenis_select);
    $kredit_text = new Text("pembayaran_faktur_kredit", "pembayaran_faktur_kredit", "");
    $kredit_text->setTypical("money");
    $kredit_text->setAtribute("data-thousands='.' data-decimal=',' data-precision='2'");
    $modal->addElement("Nilai", $kredit_text);
    $keterangan_textarea = new TextArea("pembayaran_faktur_keterangan", "pembayaran_faktur_keterangan", "");
    $keterangan_textarea->setLine(2);
    $modal->addElement("Keterangan", $keterangan_textarea);
    $no_akun_hidden = new Hidden("pembayaran_faktur_no_akun", "pembayaran_faktur_no_akun", "");
    $modal->addElement("", $no_akun_hidden);
    $nama_dompet_hidden = new Hidden("pembayaran_faktur_nama_dompet", "pembayaran_faktur_nama_dompet", "");
    $modal->addElement("", $nama_dompet_hidden);
    $akun_rows = $db->get_result("
        SELECT 
            *
        FROM
            smis_ac_account
        WHERE
            prop = '' 
                AND id_parent <> 0
                AND have_child = 0
                AND nama_tipe LIKE 'Kas & Setara Kas'
        ORDER BY
            nomor ASC
    ");
    $akun_option = new OptionBuilder();
    $akun_option->add("", "", "1");
    if ($akun_rows != null)
        foreach ($akun_rows as $akun_row)
            $akun_option->add($akun_row->nomor . " - " . $akun_row->nama);
    $akun_select = new Select("pembayaran_faktur_akun", "pembayaran_faktur_akun", $akun_option->getContent());
    $modal->addElement("Akun Kas Bank", $akun_select);
    $close_button = new Button("", "", "Kembali");
    $close_button->setClass("btn-inverse");
    $close_button->setAction("$('#pembayaran_faktur_add_form').smodal('hide')");
    $modal->addFooter($close_button);
    $save_button = new Button("", "", "Simpan Pembayaran");
	$save_button->setClass("btn-success");
    $save_button->setAction("pembayaran_faktur.save()");
    $modal->addFooter($save_button);
    $modal->addHTML("
		<div class='alert alert-block alert-info'>
			<h4>Informasi</h4><br/>
            Data transaksi pembayaran faktur berkaitan dengan jurnal pembayaran di Buku Besar Akuntansi.
		</div>
	", "before");

    echo $modal->getHtml();
    echo $table->getHtml();
    echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
    echo addJS("framework/bootstrap/js/bootstrap-select.js");
    echo addCSS("framework/bootstrap/css/datepicker.css");
    echo addCSS("framework/bootstrap/css/bootstrap-select.css");
?>
<script type="text/javascript">
    $(document).ready(function() {
        $(".mydate").datepicker();
        $("#pembayaran_faktur_add_form > div.modal-header > a").remove();
        $("#pembayaran_faktur_akun").select2().on("select2-close", function() {
            var value = $(this).select2('data').text;
            var nama_idx = value.indexOf(" - ") + 3;
            var kode_akun = value.split(" - ")[0].trim();
            var nama_akun = value.substr(nama_idx);
            $("#pembayaran_faktur_nama_dompet").val(nama_akun);
            $("#pembayaran_faktur_no_akun").val(kode_akun);
        });
    });
</script>
<style type="text/css">
    #pembayaran_faktur_add_form_form label {
        width: 150px !important;
    }
</style>