<?php
    global $user;
    global $db;

    if (isset($_POST['command'])) {
        $table = new Table(array(), "", null, true);
        $adapter = new SimpleAdapter();
        $dbtable = new DBTable($db, "smis_fnc_setoran_tunai_kasir");
        require_once("finance/class/responder/PenerimaanSetoranTunaiDBResponder.php");
        $dbresponder = new PenerimaanSetoranTunaiDBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    $readonly = true;
    $id = $_POST['data']['id'];
    $operator = $_POST['data']['operator'];
    $tanggal_entri = $_POST['data']['tanggal_entri'];
    $tanggal = $_POST['data']['tanggal'];
    $nomor = $_POST['data']['nomor'];
    $asal_nomor_akun = $_POST['data']['asal_nomor_akun'];
    $asal_nama_akun = $_POST['data']['asal_nama_akun'];
    $f_asal_akun = $asal_nomor_akun . " - " . $asal_nama_akun;
    $tujuan_nomor_akun = $_POST['data']['tujuan_nomor_akun'];
    $tujuan_nama_akun = $_POST['data']['tujuan_nama_akun'];
    $f_tujuan_akun = $tujuan_nomor_akun . " - " . $tujuan_nama_akun;
    $keterangan = $_POST['data']['keterangan'];
    $kredit = $_POST['data']['nilai'];

    $form = new Form("", "", "Penerimaan Setoran Tunai");
    $id_hidden = new Hidden("kb_penerimaan_setoran_tunai_id", "kb_penerimaan_setoran_tunai_id", $id);
    $form->addElement("", $id_hidden);
    $operator_text = new Text("kb_penerimaan_setoran_tunai_operator", "kb_penerimaan_setoran_tunai_operator", $operator);
    $operator_text->setAtribute("disabled='disabled'");
    $form->addElement("Petugas Entri", $operator_text);
    $tanggal_entri_text = new Text("kb_penerimaan_setoran_tunai_tanggal_entri", "kb_penerimaan_setoran_tunai_tanggal_entri", $tanggal_entri);
    $tanggal_entri_text->setAtribute("disabled='disabled'");
    $form->addElement("Tanggal Entri", $tanggal_entri_text);
    $tanggal_text = new Text("kb_penerimaan_setoran_tunai_tanggal", "kb_penerimaan_setoran_tunai_tanggal", $tanggal);
    if ($readonly)
        $tanggal_text->setAtribute("data-date-format='dd-mm-yyyy hh:ii' disabled='disabled'");
    else
        $tanggal_text->setAtribute("data-date-format='dd-mm-yyyy hh:ii'");
    $tanggal_text->setClass("mydatetime");
    $form->addElement("Tanggal Jurnal", $tanggal_text);
    $nomor_text = new Text("kb_penerimaan_setoran_tunai_nomor", "kb_penerimaan_setoran_tunai_nomor", $nomor);
    if ($readonly)
        $nomor_text->setAtribute("disabled='disabled'");
    $form->addElement("Nomor Jurnal", $nomor_text);
    $keterangan_textarea = new TextArea("kb_penerimaan_setoran_tunai_keterangan", "kb_penerimaan_setoran_tunai_keterangan", $keterangan);
    $keterangan_textarea->setLine(3);
    if ($readonly)
        $keterangan_textarea->setAtribute("disabled='disabled'");
    $form->addElement("Keterangan", $keterangan_textarea);
    $asal_akun_text = new Text("kb_penerimaan_setoran_tunai_asal_akun", "kb_penerimaan_setoran_tunai_asal_akun", $f_asal_akun);
    $asal_akun_text->setAtribute("disabled='disabled'");
    $form->addElement("Dari Akun", $asal_akun_text);
    if ($readonly) {
        $tujuan_akun_text = new Text("kb_penerimaan_setoran_tunai_tujuan_akun", "kb_penerimaan_setoran_tunai_tujuan_akun", $f_tujuan_akun);
        $tujuan_akun_text->setAtribute("disabled='disabled'");
        $form->addElement("Akun Penerima", $tujuan_akun_text);
    } else {
        $akun_rows = $db->get_result("
            SELECT 
                *
            FROM
                smis_ac_account
            WHERE
                prop = '' 
                    AND id_parent <> 0
                    AND have_child = 0
                    AND nama_tipe LIKE 'Kas & Setara Kas'
                    AND nomor NOT LIKE '" . $asal_nomor_akun . "'
            ORDER BY
                nomor ASC
        ");
        $akun_option = new OptionBuilder();
        $akun_option->add("", "", "1");
        if ($akun_rows != null)
            foreach ($akun_rows as $akun_row)
                $akun_option->add($akun_row->nomor . " - " . $akun_row->nama);
        $tujuan_akun_select = new Select("kb_penerimaan_setoran_tunai_tujuan_akun", "kb_penerimaan_setoran_tunai_tujuan_akun", $akun_option->getContent());
        $form->addElement("Akun Penerima", $tujuan_akun_select);
    }
    $kredit_text = new Text("kb_penerimaan_setoran_tunai_kredit", "kb_penerimaan_setoran_tunai_kredit", $kredit);
    if ($readonly) {
        $kredit_text->setTypical("money");
        $kredit_text->setAtribute("data-thousands='.' data-decimal=',' data-precision='2' disabled='disabled'");
    } else {
        $kredit_text->setTypical("money");
        $kredit_text->setAtribute("data-thousands='.' data-decimal=',' data-precision='2'");
    }
    $form->addElement("Kredit", $kredit_text);

    $back_button = new Button("", "", "Kembali ke Daftar");
    $back_button->setClass("btn btn-inverse");
    $back_button->setAction("kb_penerimaan_setoran_tunai.back()");

    $accept_button = new Button("", "", "Terima");
    $accept_button->setClass("btn btn-success");
    $accept_button->setAction("kb_penerimaan_setoran_tunai.accept()");

    $pending_button = new Button("", "", "Kembalikan");
    $pending_button->setClass("btn btn-danger");
    $pending_button->setAction("kb_penerimaan_setoran_tunai.pending()");

    $button_group = new ButtonGroup();
    $button_group->addButton($pending_button);
    $button_group->addButton($accept_button);

    echo $form->getHtml();
    echo "<div class='clear'>";
    echo "<div class='container-fluid'>";
    echo "<div class='row-fluid'>";
    echo "<div class='span6' align='left'>" . $back_button->getHtml() . "</div>";
    echo "<div class='span6' align='right'>" . $button_group->getHtml() . "</div>";
    echo "</div>";
    echo "</div>";
    echo addJS("framework/smis/js/table_action.js");
    echo addJS("framework/bootstrap/js/bootstrap-select.js");
    echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");
    echo addCSS("framework/bootstrap/css/bootstrap-select.css");
    echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
?>
<script type="text/javascript">
    var kb_penerimaan_setoran_tunai;
    var row_num;
    $(document).ready(function() {
        row_num = 0;
        $(".mydatetime").datetimepicker({
            minuteStep: 1
        });
        kb_penerimaan_setoran_tunai = new TableAction(
            "kb_penerimaan_setoran_tunai",
            "finance",
            "kb_penerimaan_setoran_tunai_form",
            new Array("kredit")
        );
        kb_penerimaan_setoran_tunai.back = function() {
            var data = this.getRegulerData();
            data['action'] = "kb_penerimaan_setoran_tunai";
            data['super_command'] = "";
            LoadSmisPage(data);
        };
        kb_penerimaan_setoran_tunai.accept = function() {
            var self = this;
            var id = $("#kb_penerimaan_setoran_tunai_id").val();
            bootbox.confirm({
                title: "Konfirmasi",
                message: "Yakin menerima data ini?",
                buttons: {
                    confirm: {
                        label: 'Ya',
                        className: 'btn-success'
                    },
                    cancel: {
                        label: 'Tidak',
                        className: 'btn-danger'
                    }
                },
                callback: function (result) {
                    if (result) {
                        var data = self.getRegulerData();
                        data['command'] = "accept";
                        data['id'] = id;
                        showLoading();
                        $.post(
                            "",
                            data,
                            function(response) {
                                var json = JSON.parse(response);
                                if (json == null) {
                                    dismissLoading();
                                    return;
                                }
                                dismissLoading();
                                self.back();
                            }
                        );
                    }
                }    
            });
        };
        kb_penerimaan_setoran_tunai.pending = function() {
            var self = this;
            var id = $("#kb_penerimaan_setoran_tunai_id").val();
            bootbox.confirm({
                title: "Konfirmasi",
                message: "Yakin mengembalikan data ini?",
                buttons: {
                    confirm: {
                        label: 'Ya',
                        className: 'btn-success'
                    },
                    cancel: {
                        label: 'Tidak',
                        className: 'btn-danger'
                    }
                },
                callback: function (result) {
                    if (result) {
                        var data = self.getRegulerData();
                        data['command'] = "pending";
                        data['id'] = id;
                        showLoading();
                        $.post(
                            "",
                            data,
                            function(response) {
                                var json = JSON.parse(response);
                                if (json == null) {
                                    dismissLoading();
                                    return;
                                }
                                dismissLoading();
                                self.back();
                            }
                        );
                    }
                }    
            });
        };

        <?php
        if (isset($_POST['data'])) {
        ?>
            $("#kb_penerimaan_setoran_tunai_tujuan_akun").val("<?php echo $_POST['data']['tujuan_nomor_akun'] . " - " . $_POST['data']['tujuan_nama_akun']; ?>");
        <?php } ?>

        <?php
        if (!$readonly) {
        ?>
            $("#kb_penerimaan_setoran_tunai_tujuan_akun").select2();
        <?php } ?>
    });
</script>
<style type="text/css">
    textarea.detail_textarea {
        width: 100% !important;
    }

    textarea#setoran_tunai_keterangan {
        resize: none;
    }
</style>