<?php
    global $db;

    require_once("finance/class/table/PenerimaanSetoranTunaiTable.php");
    $table = new PenerimaanSetoranTunaiTable(
        array("No.", "No. Setoran Tunai", "No. Jurnal", "Tgl. Jurnal", "Uraian", "Nilai", "Status"),
        "",
        null,
        true
    );
    $table->setName("kb_penerimaan_setoran_tunai");
    $table->setAddButtonEnable(false);
    $table->setReloadButtonEnable(false);
    $table->setPrintButtonEnable(false);
    $table->setFooterVisible(false);

    if (isset($_POST['command'])) {
        $adapter = new SummaryAdapter(true, "No.");
        $adapter->addFixValue("Uraian", "<div align='right'><b>Total</b></div>");
        $adapter->addSummary("Nilai", "nilai_aktual", "money");
        $adapter->add("status", "status");
        $adapter->add("No. Setoran Tunai", "nomor_transaksi");
        $adapter->add("No. Jurnal", "nomor");
        $adapter->add("Tgl. Jurnal", "tanggal", "date d-m-Y");
        $adapter->add("No. - Nama Akun", "akun");
        $adapter->add("Uraian", "keterangan");
        $adapter->add("Nilai", "nilai_aktual", "money");
        $adapter->add("Status", "status_label");
        $dbtable = new DBTable($db, "smis_fnc_setoran_tunai_kasir");
        if ($_POST['command'] == "list") {
            $tanggal_dari = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_dari'])->format("Y-m-d");
            $tanggal_sampai = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_sampai'])->format("Y-m-d");
            $query_value = "
                SELECT
                    *,
                    CASE
                        WHEN status = 4 THEN 0
                        ELSE nilai
                    END nilai_aktual, 
                    CASE 
                        WHEN status = 0 THEN 'Belum Dikirim'
                        WHEN status = 1 THEN 'Menunggu Verifikasi'
                        WHEN status = 2 THEN 'Sudah Diterima'
                        WHEN status = 3 THEN 'Pending'
                        WHEN status = 4 THEN 'Pending'
                        ELSE '-'
                    END status_label
                FROM 
                    smis_fnc_setoran_tunai_kasir
                WHERE
                    prop = ''
                        AND DATE(tanggal) >= '" . $tanggal_dari . "'
                        AND DATE(tanggal) <= '" . $tanggal_sampai . "'
                        AND (status = 1 OR status = 2)
                ORDER BY
                    tanggal ASC, id ASC
            ";
            $query_count = "
                SELECT
                    COUNT(*)
                FROM
                    (" . $query_value . ") v
            ";
            $dbtable->setPreferredQuery(true, $query_value, $query_count);
            $dbtable->setShowAll(true);
        }
        require_once("finance/class/responder/PenerimaanSetoranTunaiDBResponder.php");
        $dbresponder = new PenerimaanSetoranTunaiDBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    $form = new Form("", "", "Daftar Setoran Tunai");
    $tanggal_dari_text = new Text("kb_penerimaan_setoran_tunai_tanggal_dari", "kb_penerimaan_setoran_tunai_tanggal_dari", "01" . date("-m-Y"));
    $tanggal_dari_text->setAtribute("data-date-format='dd-mm-yyyy'");
    $tanggal_dari_text->setClass("mydate");
    $form->addElement("Dari Tgl.", $tanggal_dari_text);
    $tanggal_sampai_text = new Text("kb_penerimaan_setoran_tunai_tanggal_sampai", "kb_penerimaan_setoran_tunai_tanggal_sampai", date("d-m-Y"));
    $tanggal_sampai_text->setAtribute("data-date-format='dd-mm-yyyy'");
    $tanggal_sampai_text->setClass("mydate");
    $form->addElement("Sampai Tgl.", $tanggal_sampai_text);
    $proses_button = new Button("", "", "Proses");
    $proses_button->setClass("btn btn-primary");
    $proses_button->setAction("kb_penerimaan_setoran_tunai.view()");
    $proses_button->setIcon("icon-white icon-repeat");
    $proses_button->setIsButton(Button::$ICONIC);
    $download_excel_button = new Button("", "", "Download XLS");
    $download_excel_button->setClass("btn btn-success");
    $download_excel_button->setAction("kb_penerimaan_setoran_tunai.export_xls()");
    $download_excel_button->setIcon("fa fa-file-excel-o");
    $download_excel_button->setIsButton(Button::$ICONIC);
    $download_pdf_button = new Button("", "", "Download PDF");
    $download_pdf_button->setClass("btn btn-danger");
    $download_pdf_button->setAction("kb_penerimaan_setoran_tunai.export_pdf()");
    $download_pdf_button->setIcon("fa fa-file-pdf-o");
    $download_pdf_button->setIsButton(Button::$ICONIC);
    $button_group = new ButtonGroup();
    $button_group->addButton($proses_button);
    $button_group->addButton($download_excel_button);
    $button_group->addButton($download_pdf_button);
    $form->addElement("", $button_group);

    echo $form->getHtml();
    echo $table->getHtml();
    echo addJS("framework/smis/js/table_action.js");
    echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
    echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
    var kb_penerimaan_setoran_tunai;
    $(document).ready(function() {
        $(".mydate").datepicker();
        $('[data-toggle="popover"]').popover({
            trigger: 'hover',
            'placement': 'top'
        });
        kb_penerimaan_setoran_tunai = new TableAction(
            "kb_penerimaan_setoran_tunai",
            "finance",
            "kb_penerimaan_setoran_tunai",
            new Array()
        );
        kb_penerimaan_setoran_tunai.addRegulerData = function(data) {
            data['tanggal_dari'] = $("#kb_penerimaan_setoran_tunai_tanggal_dari").val();
            data['tanggal_sampai'] = $("#kb_penerimaan_setoran_tunai_tanggal_sampai").val();
            return data;
        };
        kb_penerimaan_setoran_tunai.export_xls = function() {
            showLoading();
            var data = this.getRegulerData();
            data['command'] = "export_xls";
            postForm(data);
            dismissLoading();
        };
        kb_penerimaan_setoran_tunai.export_pdf = function() {
            showLoading();
            var data = this.getRegulerData();
            data['command'] = "export_pdf";
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    var getUrl = window.location['pathname'] + json;
                    window.open(getUrl, 'pdf');
                    dismissLoading();
                }
            );
        };
        kb_penerimaan_setoran_tunai.printelement = function(id) {
            var data = this.getRegulerData();
            data['command'] = "print_jurnal";
            data['id'] = id;
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    var getUrl = window.location['pathname'] + json;
                    window.open(getUrl, 'pdf');
                    dismissLoading();
                }
            );
        };
        kb_penerimaan_setoran_tunai.edit = function(id) {
            var self = this;
            var data = this.getRegulerData();
            data['command'] = "edit";
            data['id'] = id;
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = getContent(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    dismissLoading();
                    data = self.getRegulerData();
                    data['action'] = "kb_penerimaan_setoran_tunai_form";
                    data['super_command'] = "";
                    data['data'] = json;
                    LoadSmisPage(data);
                }
            );
        };
        kb_penerimaan_setoran_tunai.view();
    });
</script>