<?php
    global $user;
    global $db;

    if (isset($_POST['command'])) {
        $table = new Table(array(), "", null, true);
        $adapter = new SimpleAdapter();
        $dbtable = new DBTable($db, "smis_ac_transaksi");
        require_once("finance/class/responder/KBPenerimaanDBResponder.php");
        $dbresponder = new KBPenerimaanDBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    $id = isset($_POST['header']['id']) ? $_POST['header']['id'] : "";
    $id_detail = isset($_POST['header']['id_detail']) ? $_POST['header']['id_detail'] : "";
    $operator = isset($_POST['header']['operator']) ? $_POST['header']['operator'] : $user->getNameOnly();
    $tanggal_input = isset($_POST['header']['tanggal_input']) ? $_POST['header']['tanggal_input'] : date("d-m-Y H:i");
    $tanggal = isset($_POST['header']['tanggal']) ? $_POST['header']['tanggal'] : date("d-m-Y H:i");
    $nomor = isset($_POST['header']['nomor']) ? $_POST['header']['nomor'] : "";
    $no_akun = isset($_POST['header']['no_akun']) ? $_POST['header']['no_akun'] : "";
    $nama_akun = isset($_POST['header']['nama_akun']) ? $_POST['header']['nama_akun'] : "";
    $keterangan = isset($_POST['header']['keterangan']) ? $_POST['header']['keterangan'] : "";
    $debet = isset($_POST['header']['nilai']) ? $_POST['header']['nilai'] : "0,00";

    $form = new Form("", "", "Jurnal Penerimaan");
    $id_hidden = new Hidden("kb_penerimaan_id", "kb_penerimaan_id", $id);
    $form->addElement("", $id_hidden);
    $id_detail_hidden = new Hidden("kb_penerimaan_id_detail", "kb_penerimaan_id_detail", $id_detail);
    $form->addElement("", $id_detail_hidden);
    $operator_text = new Text("kb_penerimaan_operator", "kb_penerimaan_operator", $operator);
    $operator_text->setAtribute("disabled='disabled'");
    $form->addElement("Petugas Entri", $operator_text);
    $tanggal_input_text = new Text("kb_penerimaan_tanggal_input", "kb_penerimaan_tanggal_input", $tanggal_input);
    $tanggal_input_text->setAtribute("disabled='disabled'");
    $form->addElement("Tanggal Entri", $tanggal_input_text);
    $tanggal_text = new Text("kb_penerimaan_tanggal", "kb_penerimaan_tanggal", $tanggal);
    $tanggal_text->setAtribute("data-date-format='dd-mm-yyyy hh:ii'");
    $tanggal_text->setClass("mydatetime");
    $form->addElement("Tanggal Jurnal", $tanggal_text);
    $nomor_text = new Text("kb_penerimaan_nomor", "kb_penerimaan_nomor", $nomor);
    $nomor_text->setAtribute("disabled='disabled'");
    $form->addElement("Nomor Jurnal", $nomor_text);
    $keterangan_textarea = new TextArea("kb_penerimaan_keterangan", "kb_penerimaan_keterangan", $keterangan);
    $keterangan_textarea->setLine(3);
    $form->addElement("Keterangan", $keterangan_textarea);
    $akun_rows = $db->get_result("
        SELECT 
            *
        FROM
            smis_ac_account
        WHERE
            prop = '' 
                AND id_parent <> 0
                AND have_child = 0
                AND nama_tipe LIKE 'Kas & Setara Kas'
        ORDER BY
            nomor ASC
    ");
    $akun_option = new OptionBuilder();
    $akun_option->add("", "", "1");
    if ($akun_rows != null)
        foreach ($akun_rows as $akun_row)
            $akun_option->add($akun_row->nomor . " - " . $akun_row->nama);
    $nomor_akun_bank_clearing = getSettings($db, "accounting-akun-khusus-bank-clearing", "");
    if ($nomor_akun_bank_clearing != "") {
        $akun_bank_clearing = $db->get_row("
            SELECT
                nomor, nama
            FROM
                smis_ac_account
            WHERE
                prop LIKE ''
                    AND nomor LIKE '" . $nomor_akun_bank_clearing . "'
        ");
        if ($akun_bank_clearing != null) {
            $akun_option->add($akun_bank_clearing->nomor . " - " . $akun_bank_clearing->nama);
        }
    }
    $akun_select = new Select("kb_penerimaan_akun", "kb_penerimaan_akun", $akun_option->getContent());
    $form->addElement("Akun Kas Bank", $akun_select);
    $debet_text = new Text("kb_penerimaan_debet", "kb_penerimaan_debet", $debet);
    $debet_text->setTypical("money");
    $debet_text->setAtribute("data-thousands='.' data-decimal=',' data-precision='2'");
    $form->addElement("Debit", $debet_text);

    $table = new Table(
        array("No.", "No. - Nama Akun", "Uraian", "Kredit"),
        "",
        null,
        true
    );
    $table->setName("kb_penerimaan_detail");
    $table->setFooterVisible(false);
    $table->setDelButtonEnable(false);
    $table->setPrintButtonEnable(false);
    $table->setReloadButtonEnable(false);
    $table->setAddButtonEnable(false);
    $add_button = new Button("", "", "Tambah");
    $add_button->setClass("btn btn-inverse");
    $add_button->setAction("kb_penerimaan.appendDetail()");
    $add_button->setIcon("fa fa-plus");
    $add_button->setIsButton(Button::$ICONIC);
    $table->addHeaderButton($add_button);

    $back_button = new Button("", "", "Kembali ke Daftar");
    $back_button->setClass("btn btn-inverse");
    $back_button->setAction("kb_penerimaan.back()");

    $save_button = new Button("", "", "Simpan Jurnal");
    $save_button->setClass("btn btn-success");
    $save_button->setAction("kb_penerimaan.save()");

    echo $form->getHtml();
    echo $table->getHtml();
    echo "<div class='container-fluid'>";
        echo "<div class='row-fluid'>";
            echo "<div class='span6' align='left'>" . $back_button->getHtml() . "</div>";
            echo "<div class='span6' align='right'>" . $save_button->getHtml() . "</div>";
        echo "</div>";    
    echo "</div>";
    echo addJS("framework/smis/js/table_action.js");
    echo addJS("framework/bootstrap/js/bootstrap-select.js");
    echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");
    echo addCSS("framework/bootstrap/css/bootstrap-select.css");
    echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
?>
<script type="text/javascript">
    var kb_penerimaan;
    var row_num;
    $(document).ready(function() {
        row_num = 0;
        $(".mydatetime").datetimepicker({
            minuteStep: 1
        });
        $("#table_kb_penerimaan_detail").append("<tfoot>" +
                                                    "<tr>" +
                                                        "<td colspan='3'><div align='right'><strong>Total</strong></div></td>" +
                                                        "<td id='total' style='display: none;'>0</td>" +
                                                        "<td><strong><div id='f_total' align='right'>0,00</div></strong></td>" +
                                                        "<td></td>" +
                                                    "</tr>" +
                                                "</tfoot>");
        kb_penerimaan = new TableAction(
            "kb_penerimaan",
            "finance",
            "kb_penerimaan_form",
            new Array("debet")
        );
        kb_penerimaan.refreshNumber = function() {
            var nor = $("#kb_penerimaan_detail_list tr").length;
            var nomor = 1;
            for (var i = 0; i < nor; i++) {
                if ($("#kb_penerimaan_detail_list tr:eq(" + i + ")").hasClass("deleted") === false) {
                    $("#kb_penerimaan_detail_list tr:eq(" + i + ") td#detail_nomor").html(nomor);
                    nomor++;
                }
            }
        };
        kb_penerimaan.refreshTotal = function() {
            var total = 0;
            var nor = $("#kb_penerimaan_detail_list tr").length;
            for (var i = 0; i < nor; i++) {
                if ($("#kb_penerimaan_detail_list tr:eq(" + i + ")").hasClass("deleted") === false) {
                    var kredit = $("#kb_penerimaan_detail_list tr:eq(" + i + ") td#detail_kredit input#kb_penerimaan_detail_kredit").val();
                    kredit = parseFloat(kredit.replace(/[^0-9-,]/g, '').replace(",", "."));
                    total += kredit;
                }
            }
            $("#total").html(total);
            $("#f_total").html(total.formatMoney("2", ".", ","));
        };
        kb_penerimaan.appendDetail = function() {
            var self = this;
            var data = this.getRegulerData();
            data['command'] = "new_row";
            data['row_num'] = row_num;
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    row_num++;
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    $("#kb_penerimaan_detail_list").append(json.html);
                    $("#kb_penerimaan_detail_list tr:last td#detail_akun select").select2();
                    $("#kb_penerimaan_detail_list tr:last td#detail_kredit input#kb_penerimaan_detail_kredit").on("keyup", function() {
                        self.refreshTotal();
                    });
                    $("#kb_penerimaan_detail_list tr:last td#detail_kredit input#kb_penerimaan_detail_kredit").maskMoney();
                    $("#kb_penerimaan_detail_list tr:last td#detail_kredit input#kb_penerimaan_detail_kredit").maskMoney('mask', 0);
                    self.refreshNumber();
                    dismissLoading();
                }
            );
        };
        kb_penerimaan.addDetail = function(id_detail, akun, uraian, nilai) {
            var self = this;
            var data = this.getRegulerData();
            data['command'] = "new_row";
            data['row_num'] = row_num++;
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    $("#kb_penerimaan_detail_list").append(json.html);
                    $("#kb_penerimaan_detail_list tr:last td#detail_akun select").select2();
                    $("#kb_penerimaan_detail_list tr:last td#detail_kredit input#kb_penerimaan_detail_kredit").on("keyup", function() {
                        self.refreshTotal();
                    });
                    $("#kb_penerimaan_detail_list tr:last td#detail_kredit input#kb_penerimaan_detail_kredit").maskMoney();
                    $("#kb_penerimaan_detail_list tr:last td#detail_kredit input#kb_penerimaan_detail_kredit").maskMoney('mask', 0);
                    self.refreshNumber();
                    $("#kb_penerimaan_detail_list tr:last td#detail_id").html(id_detail);
                    $("#kb_penerimaan_detail_list tr:last td#detail_akun #kb_penerimaan_detail_akun").select2('data', {id : akun, text: akun});
                    $("#kb_penerimaan_detail_list tr:last td#detail_uraian #kb_penerimaan_detail_keterangan").val(uraian);
                    $("#kb_penerimaan_detail_list tr:last td#detail_kredit #kb_penerimaan_detail_kredit").val(nilai);
                    self.refreshTotal();
                    dismissLoading();
                }
            );
        };
        kb_penerimaan.deleteDetail = function(id_row) {
            var self = this;
            bootbox.confirm({
                title: "Konfirmasi",
                message: "Menghapus detail data?",
                buttons: {
                    confirm: {
                        label: "Ya",
                        className: "btn-success"
                    },
                    cancel: {
                        label: "Tidak",
                        className: "btn-danger"
                    }
                },
                callback: function(result) {
                    if (result) {
                        showLoading();
                        var id = $("tr#" + id_row + " td#detail_id").text();
                        if (id == "")
                            $("tr#" + id_row).remove();
                        else {
                            $("tr#" + id_row).addClass("deleted");
                            $("tr#" + id_row).hide();
                        }
                        self.refreshNumber();
                        self.refreshTotal();
                        dismissLoading();
                    }
                }
            });
        };
        kb_penerimaan.back = function() {
            var data = this.getRegulerData();
            data['action'] = "kb_penerimaan";
            data['super_command'] = "";
            LoadSmisPage(data);
        };
        kb_penerimaan.validate = function() {
            var valid = true;
            var tanggal = $("#kb_penerimaan_tanggal").val();
            var keterangan = $("#kb_penerimaan_keterangan").val();
            var akun = $("#kb_penerimaan_akun").val();
            var debet = parseFloat($("#kb_penerimaan_debet").val().replace(/[^0-9-,]/g, '').replace(",", "."));;
            var total_kredit = parseFloat($("#total").text());
            var nor = $("#kb_penerimaan_detail_list tr").not(".deleted").length;
            var invalid_msg = "";
            if (tanggal == "") {
                valid = false;
                invalid_msg += "<li>Tanggal Jurnal tidak diperkenankan kosong.</li>";
            }
            if (keterangan == "") {
                valid = false;
                invalid_msg += "<li>Keterangan tidak diperkenankan kosong.</li>";
            }
            if (akun == "") {
                valid = false;
                invalid_msg += "<li>Akun Kas Bank tidak diperkenankan kosong.</li>"
            }
            if (debet == "") {
                valid = false;
                invalid_msg += "<li>Debit tidak diperkenankan kosong.</li>";
            } else if (debet == 0) {
                valid = false;
                invalid_msg += "<li>Debit tidak diperkenankan bernilai nol.</li>";
            } else if (debet != total_kredit) {
                valid = false;
                invalid_msg += "<li>Debit dan Total Kredit tidak diperkenankan bernilai berbeda.</li>";
            }
            if (nor == 0) {
                valid = false;
                invalid_msg += "<li>Jumlah Detail Kredit tidak diperkenankan kosong.</li>";
            }
            nor = $("#kb_penerimaan_detail_list tr").length;
            for (var i = 0; i < nor; i++) {
                if ($("#kb_penerimaan_detail_list tr:eq(" + i + ")").hasClass("deleted") === false) {
                    var no = $("#kb_penerimaan_detail_list tr:eq(" + i + ") td#detail_nomor").text();
                    var akun = $("#kb_penerimaan_detail_list tr:eq(" + i + ") td#detail_akun select#kb_penerimaan_detail_akun").val();
                    var keterangan = $("#kb_penerimaan_detail_list tr:eq(" + i + ") td#detail_uraian textarea#kb_penerimaan_detail_keterangan").val();
                    var kredit = $("#kb_penerimaan_detail_list tr:eq(" + i + ") td#detail_kredit input#kb_penerimaan_detail_kredit").val();
                    if (kredit.length > 0)
                        kredit = parseFloat(kredit.replace(/[^0-9-,]/g, '').replace(",", "."));
                    if (akun == "") {
                        valid = false;
                        invalid_msg = "<li>Akun tidak diperkenankan kosong. (Baris ke-" + no + ")</li>";
                    }
                    if (keterangan == "") {
                        valid = false;
                        invalid_msg = "<li>Uraian tidak diperkenankan kosong. (Baris ke-" + no + ")</li>";
                    }
                    if (kredit == "") {
                        valid = false;
                        invalid_msg = "<li>Kredit tidak diperkenankan kosong. (Baris ke-" + no + ")</li>";
                    } else if (kredit == 0) {
                        valid = false;
                        invalid_msg = "<li>Kredit tidak diperkenankan bernilai nol. (Baris ke-" + no + ")</li>";
                    }
                }
            }
            if (valid == false) {
                bootbox.alert({
                    title: "Kesalahan",
                    message: "<ul>" + invalid_msg + "</ul>"
                });
            }
            return valid;
        };
        kb_penerimaan.getSaveData = function() {
            var data = this.getRegulerData();
            data['command'] = "save";
            data['id'] = $("#kb_penerimaan_id").val();
            data['id_detail'] = $("#kb_penerimaan_id_detail").val();
            data['operator'] = $("#kb_penerimaan_operator").val();
            data['tanggal_input'] = $("#kb_penerimaan_tanggal_input").val();
            data['tanggal'] = $("#kb_penerimaan_tanggal").val();
            data['nomor'] = $("#kb_penerimaan_nomor").val();
            data['keterangan'] = $("#kb_penerimaan_keterangan").val();
            data['akun'] = $("#kb_penerimaan_akun").val();
            var debet = $("#kb_penerimaan_debet").val();
            data['debet'] = parseFloat(debet.replace(/[^0-9-,]/g, '').replace(",", "."));
            var nor = $("#kb_penerimaan_detail_list tr").length;
            var d_detail = {};
            for (var i = 0; i < nor; i++) {
                var id = $("#kb_penerimaan_detail_list tr:eq(" + i + ") td#detail_id").text();
                var akun = $("#kb_penerimaan_detail_list tr:eq(" + i + ") td#detail_akun select#kb_penerimaan_detail_akun").val();
                var keterangan = $("#kb_penerimaan_detail_list tr:eq(" + i + ") td#detail_uraian textarea#kb_penerimaan_detail_keterangan").val();
                var kredit = $("#kb_penerimaan_detail_list tr:eq(" + i + ") td#detail_kredit input#kb_penerimaan_detail_kredit").val();
                var deleted = $("#kb_penerimaan_detail_list tr:eq(" + i + ")").hasClass("deleted") ? 1 : 0;
                kredit = parseFloat(kredit.replace(/[^0-9-,]/g, '').replace(",", "."));
                d_detail[i] = {
                    'deleted' : deleted,
                    'id': id,
                    'akun': akun,
                    'keterangan': keterangan,
                    'kredit': kredit
                };
            }
            data['detail'] = JSON.stringify(d_detail);
            console.log(data);
            return data;
        };
        kb_penerimaan.save = function() {
            if (!this.validate())
                return;
            var self = this;
            var data = this.getSaveData();
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    dismissLoading();
                    self.back();
                }
            );
        };
        
        <?php 
            if (!isset($_POST['header'])) { 
        ?>
            kb_penerimaan.appendDetail();
        <?php 
            } else { 
        ?>
            $("#kb_penerimaan_akun").val("<?php echo $_POST['header']['no_akun'] . " - " . $_POST['header']['nama_akun']; ?>");
            showLoading();
            <?php
                $nod = count($_POST['detail']);
                for ($i_detail = 0; $i_detail < $nod; $i_detail++) {
            ?>
                    var id = <?php echo $_POST['detail'][$i_detail]['id']; ?>;
                    var akun = "<?php echo $_POST['detail'][$i_detail]['nomor_account']; ?> - <?php echo $_POST['detail'][$i_detail]['nama_account']; ?>";
                    var uraian = "<?php echo $_POST['detail'][$i_detail]['keterangan']; ?>";
                    var nilai = <?php echo $_POST['detail'][$i_detail]['kredit']; ?>;
                    nilai = nilai.formatMoney("2", ".", ",");
                    kb_penerimaan.addDetail(id, akun, uraian, nilai);
            <?php 
                }
            ?>
            dismissLoading();
        <?php } ?>

        $("#kb_penerimaan_akun").select2().on("select2-close", function() {
            var value = $(this).select2('data').text;
            var nama_idx = value.indexOf(" - ") + 3;
            var kode_akun = value.split(" - ")[0].trim();
            var nama_akun = value.substr(nama_idx);
            $("#kb_penerimaan_nama_akun").val(nama_akun);
            $("#kb_penerimaan_no_akun").val(kode_akun);
        });
    });
</script>
<style type="text/css">
    textarea.detail_textarea {
        width: 100% !important;
    }

    textarea#kb_penerimaan_keterangan {
        resize: none;
    }

    .detail_select2.select2-container {
        width: 100% !important;
    }

    .detail_select2.select2-search--dropdown .detail_select2.select2-search__field {
        width: 98%;
    }

    .detail_money {
        width: 100% !important;
    }
</style>