<?php
    global $db;

    $vendor_table = new Table(array("No.", "Nama", "Kota", "Medis/Non-Medis"));
	$vendor_table->setName("vendor");
    $vendor_table->setModel(Table::$SELECT);
    $vendor_adapter = new SimpleAdapter(true, "No.");
    $vendor_adapter->add("Nama", "nama");
    $vendor_adapter->add("Kota", "kota");
    $vendor_adapter->add("Medis/Non-Medis", "trivial_1_Medis_Non-Medis");
	$vendor_dbtable = new DBTable($db, "smis_pb_vendor");
    $vendor_dbtable->setViewForSelect(true);
	$vendor_dbresponder = new DBResponder(
		$vendor_dbtable,
		$vendor_table,
		$vendor_adapter
    );
    
    $super_command = new SuperCommand();
    $super_command->addResponder("vendor", $vendor_dbresponder);
    $init = $super_command->initialize();
    if ($init != null) {
        echo $init;
        return;
    }
    
    if (isset($_POST['command'])) {
        $table = new Table(array(), "", true, null);   
        $adapter = new SimpleAdapter();
        $dbtable = new DBTable($db, "smis_fnc_rekap_faktur");
        require_once("finance/class/responder/KBPembayaranRekapFakturDBResponder.php");
        $dbresponder = new KBPembayaranRekapFakturDBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    $id = isset($_POST['id']) ? $_POST['id'] : "";
    $id_vendor = isset($_POST['id_vendor']) ? $_POST['id_vendor'] : "";
    $medis = isset($_POST['medis']) ? $_POST['medis'] : "";
    $nama_vendor = isset($_POST['nama_vendor']) ? $_POST['nama_vendor'] : "";
    $tanggal = isset($_POST['tanggal']) && $_POST['tanggal'] != "" ? ArrayAdapter::format("date d-m-Y", $_POST['tanggal']) : date("d-m-Y");
    $nomor = isset($_POST['nomor']) ? $_POST['nomor'] : "";
    $total_tagihan = isset($_POST['total_tagihan']) && $_POST['total_tagihan'] > 0? ArrayAdapter::format("only-money", $_POST['total_tagihan']) : "0,00";
    $total_dibayar = isset($_POST['total_dibayar']) && $_POST['total_dibayar'] > 0 ? ArrayAdapter::format("only-money", $_POST['total_dibayar']) : "0,00";
    $sisa_tagihan = isset($_POST['sisa_tagihan']) && $_POST['sisa_tagihan'] > 0 ? ArrayAdapter::format("only-money", $_POST['sisa_tagihan']) : "0,00";

    $form = new Form("", "", "Pembayaran Rekap Faktur");
    $id_hidden = new Hidden("rekap_faktur_id", "rekap_faktur_id", $id);
    $form->addElement("", $id_hidden);
    $id_vendor_hidden = new Hidden("rekap_faktur_id_vendor", "rekap_faktur_id_vendor", $id_vendor);
    $form->addElement("", $id_vendor_hidden);
    $medis_hidden = new Hidden("rekap_faktur_medis", "rekap_faktur_medis", $medis);
    $form->addElement("", $medis_hidden);
    $vendor_button = new Button("", "", "Pilih");
    if ($id_vendor == "") {
        $vendor_button->setClass("btn-info");
        $vendor_button->setAction("vendor.chooser('vendor', 'vendor_button', 'vendor', vendor)");
    } else {
        $vendor_button->setClass("btn-inverse");
    }
	$vendor_button->setIsButton(Button::$ICONIC);
	$vendor_button->setIcon("icon-white ".Button::$icon_list_alt);
	$vendor_button->setAtribute("id='vendor_browse'");
	$nama_vendor_text = new Text("rekap_faktur_nama_vendor", "rekap_faktur_nama_vendor", $nama_vendor);
	$nama_vendor_text->setAtribute("disabled='disabled'");
	$nama_vendor_text->setClass("smis-one-option-input");
	$vendor_input_group = new InputGroup("");
	$vendor_input_group->addComponent($nama_vendor_text);
	$vendor_input_group->addComponent($vendor_button);
    $form->addElement("Nama Vendor", $vendor_input_group);
    $tanggal_text = new Text("rekap_faktur_tanggal", "rekap_faktur_tanggal", $tanggal);
    $tanggal_text->setAtribute("data-date-format='dd-mm-yyyy'");
    $tanggal_text->setClass("mydate");
    $form->addElement("Tgl. Rekap Faktur", $tanggal_text);
    $nomor_text = new Text("rekap_faktur_nomor", "rekap_faktur_nomor", $nomor);
    $nomor_text->setAtribute("disabled='disabled'");
    $form->addElement("No. Rekap Faktur", $nomor_text);
    $total_tagihan_text = new Text("rekap_faktur_total_tagihan", "rekap_faktur_total_tagihan", $total_tagihan);
    $total_tagihan_text->setAtribute("disabled='disabled'");
    $form->addElement("Total Tagihan", $total_tagihan_text);
    $total_dibayar_text = new Text("rekap_faktur_total_dibayar", "rekap_faktur_total_dibayar", $total_dibayar);
    $total_dibayar_text->setAtribute("disabled='disabled'");
    $form->addElement("Total Dibayar", $total_dibayar_text);
    $sisa_tagihan_text = new Text("rekap_faktur_sisa_tagihan", "rekap_faktur_sisa_tagihan", $sisa_tagihan);
    $sisa_tagihan_text->setAtribute("disabled='disabled'");
    $form->addElement("Sisa Tagihan", $sisa_tagihan_text);

    $rekap_faktur_tabulator = new Tabulator("rekap_faktur_tabulator", "", Tabulator::$POTRAIT);
    $rekap_faktur_tabulator->setBookDimension(1000, 250);
    $rekap_faktur_tabulator->add("rekap_faktur_informasi_tab", "Informasi Faktur", "finance/resource/php/kas_bank/kb_prf_informasi_rekap_faktur.php", Tabulator::$TYPE_INCLUDE, "fa fa-navicon");
    
    $button_group = new ButtonGroup("");
	$back_button = new Button("", "", "Kembali");
	$back_button->setClass("btn-inverse");
	$back_button->setIsButton(Button::$ICONIC_TEXT);
	$back_button->setIcon("fa fa-chevron-left");
	$back_button->setAction("pembayaran_rekap_faktur.back()");
	$back_button->setAtribute("id='penerimaan_obat_back'");
	$button_group->addButton($back_button);
    $save_button = new Button("", "", "Simpan");
    $save_button->setClass("btn-success");
    $save_button->setIsButton(Button::$ICONIC_TEXT);
    $save_button->setIcon("fa fa-floppy-o");
    $save_button->setAction("pembayaran_rekap_faktur.save()");
    $save_button->setAtribute("id='penerimaan_obat_save'");
    $button_group->addButton($save_button);

    echo $form->getHtml();
    echo "<div class='clear'></div>";
    echo $rekap_faktur_tabulator->getHtml();
    echo "<div class='clear'></div>";
    echo "<div align='right'>" . $button_group->getHtml() . "</div>";
    echo addJS("framework/smis/js/table_action.js");
    echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
	echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
    var vendor;
    var pembayaran_rekap_faktur;
    $(document).ready(function() {
        $('.modal').on('shown.bs.modal', function() {
			$(this).find('[autofocus]').focus();
		});
        $(".mydate").datepicker();

        vendor = new TableAction(
            "vendor",
            "finance",
            "kb_pembayaran_rekap_faktur_form",
            new Array()
        );
        vendor.selected = function(json) {
            $("#rekap_faktur_id_vendor").val(json.id);
            $("#rekap_faktur_nama_vendor").val(json.nama);
            $("#rekap_faktur_medis").val(json.medis);
            $("#vendor_browse").removeClass("btn-info");
            $("#vendor_browse").addClass("btn-inverse");
            $("#vendor_browse").removeAttr("onclick");
        };
        vendor.setSuperCommand("vendor");

        pembayaran_rekap_faktur = new TableAction(
            "pembayaran_rekap_faktur",
            "finance",
            "kb_pembayaran_rekap_faktur_form",
            new Array()
        );
        pembayaran_rekap_faktur.back = function() {
            var data = this.getRegulerData();
            data['action'] = "kb_pembayaran_rekap_faktur";
            data['super_command'] = "";
            data['kriteria'] = "";
            data['max'] = 5;
            data['number'] = 0;
            LoadSmisPage(data);
        };
        pembayaran_rekap_faktur.getDetailFakturSaveData = function() {
            var total_tr = $("#info_rekap_faktur_list tr.data_faktur").length;
            var data = {};
            for (var i = 0; i < total_tr; i++) {
                var id = $("#info_rekap_faktur_list tr.data_faktur:eq(" + i + ") td#faktur_id").text();
                var id_rekap_faktur = $("#info_rekap_faktur_list tr.data_faktur:eq(" + i + ") td#faktur_id_rekap_faktur").text();
                var id_bbm = $("#info_rekap_faktur_list tr.data_faktur:eq(" + i + ") td#faktur_id_bbm").text();
                var unit = $("#info_rekap_faktur_list tr.data_faktur:eq(" + i + ") td#faktur_unit").text();
                var nomor_faktur = $("#info_rekap_faktur_list tr.data_faktur:eq(" + i + ") td#faktur_nomor_faktur").text();
                var nomor_bbm = $("#info_rekap_faktur_list tr.data_faktur:eq(" + i + ") td#faktur_nomor_bbm").text();
                var tanggal_faktur = $("#info_rekap_faktur_list tr.data_faktur:eq(" + i + ") td#faktur_tanggal_faktur").text();
                var tanggal_jatuh_tempo = $("#info_rekap_faktur_list tr.data_faktur:eq(" + i + ") td#faktur_tanggal_jatuh_tempo").text();
                var total_tagihan = parseFloat($("#info_rekap_faktur_list tr.data_faktur:eq(" + i + ") td#faktur_total_tagihan").text().replace(/[^0-9-,]/g, '').replace(",", "."));
                var prop = $("#info_rekap_faktur_list tr.data_faktur:eq(" + i + ") td#faktur_prop").text();
                data[i] = {
                    'id' : id,
                    'id_rekap_faktur' : id_rekap_faktur,
                    'id_bbm' : id_bbm,
                    'unit' : unit,
                    'nomor_faktur' : nomor_faktur,
                    'nomor_bbm' : nomor_bbm,
                    'tanggal_faktur' : tanggal_faktur,
                    'tanggal_jatuh_tempo' : tanggal_jatuh_tempo,
                    'total_tagihan' : total_tagihan,
                    'prop' : prop
                };
            }
            return JSON.stringify(data);
        };
        pembayaran_rekap_faktur.getSaveData = function() {
            var data = this.getRegulerData();
            data['command'] = "save";
            data['id'] = $("#rekap_faktur_id").val();
            data['id_vendor'] = $("#rekap_faktur_id_vendor").val();
            data['nama_vendor'] = $("#rekap_faktur_nama_vendor").val();
            data['medis'] = $("#rekap_faktur_medis").val();
            data['tanggal'] = $("#rekap_faktur_tanggal").val();
            data['nomor'] = $("#rekap_faktur_nomor").val();
            data['total_tagihan'] = $("#rekap_faktur_total_tagihan").val().replace(/[^0-9-,]/g, '').replace(",", ".");
            data['total_dibayar'] = $("#rekap_faktur_total_dibayar").val().replace(/[^0-9-,]/g, '').replace(",", ".");
            data['sisa_tagihan'] = $("#rekap_faktur_sisa_tagihan").val().replace(/[^0-9-,]/g, '').replace(",", ".");
            data['detail_rekap_faktur'] = this.getDetailFakturSaveData();
            return data;
        };
        pembayaran_rekap_faktur.save = function() {
            var self = this;
            var data = this.getSaveData();
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = getContent(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    dismissLoading();
                    self.back();
                }
            );
        };
    });
</script>
<style>
    label {
        width: 150px !important;
    }
</style>