<?php 
    global $db;

    $table = new Table(
        array("No.", "Nama Vendor", "Tgl. Rekap Faktur", "No. Rekap Faktur", "Total Tagihan", "Sisa Tagihan", "Operator"),
        "",
        null,
        true
    );
    $table->setName("pembayaran_rekap_faktur");
    $table->setPrintButtonEnable(false);
    $table->setReloadButtonEnable(false);
    $table->setEditButtonEnable(false);
    $table->setDelButtonEnable(false);
    $button = new Button("", "", "Lihat");
    $button->setClass("btn-info");
    $table->addContentButton("detail", $button);

    if (isset($_POST['command'])) {
        $adapter = new SimpleAdapter(true, "No.");
        $adapter->add("Nama Vendor", "nama_vendor");
        $adapter->add("Tgl. Rekap Faktur", "tanggal", "date d-m-Y");
        $adapter->add("No. Rekap Faktur", "nomor");
        $adapter->add("Total Tagihan", "total_tagihan", "money");
        $adapter->add("Sisa Tagihan", "sisa_tagihan", "money");
        $adapter->add("Operator", "operator");
        $dbtable = new DBTable($db, "smis_fnc_rekap_faktur");
        $tanggal = date("Y-m-d");
        if (isset($_POST['tanggal'])) {
            $tanggal = DateTime::createFromFormat("d-m-Y", $_POST['tanggal'])->format("Y-m-d");
        }
        $dbtable->addCustomKriteria("tanggal", " = '" . $tanggal . "' ");
        require_once("finance/class/responder/KBPembayaranRekapFakturDBResponder.php");
        $dbresponder = new KBPembayaranRekapFakturDBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    $form = new Form("", "", "");
    $tanggal_text = new Text("pembayaran_rekap_faktur_tanggal", "pembayaran_rekap_faktur_tanggal", date("d-m-Y"));
    $tanggal_text->setAtribute("data-date-format='dd-mm-yyyy'");
    $tanggal_text->setClass("mydate");
    $form->addElement("Tgl. Rekap Faktur", $tanggal_text);

    echo $form->getHtml();
    echo "<div class='clear'></div>";
    echo $table->getHtml();
    echo addJS("framework/smis/js/table_action.js");
    echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
    echo addCSS("framework/bootstrap/css/datepicker.css");
?>
<script type="text/javascript">
    var pembayaran_rekap_faktur;
    $(document).ready(function() {
        $(".mydate").datepicker();
        pembayaran_rekap_faktur = new TableAction(
            "pembayaran_rekap_faktur",
            "finance",
            "kb_pembayaran_rekap_faktur",
            new Array()
        );
        pembayaran_rekap_faktur.addViewData = function(data) {
            data['tanggal'] = $("#pembayaran_rekap_faktur_tanggal").val();
            return data;
        };
        pembayaran_rekap_faktur.show_add_form = function() {
            var data = this.getRegulerData();
            data['action'] = "kb_pembayaran_rekap_faktur_form";
            data['super_command'] = "";
            data['id'] = "";
            data['id_vendor'] = "";
            data['medis'] = "";
            data['nama_vendor'] = "";
            data['tanggal'] = "";
            data['nomor'] = "";
            data['total_tagihan'] = 0;
            data['total_dibayar'] = 0;
            data['sisa_tagihan'] = 0;
            LoadSmisPage(data);
        };
        pembayaran_rekap_faktur.detail = function(id) {
            var self = this;
            var data = this.getRegulerData();
            data['command'] = "edit";
            data['id'] = id;
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = getContent(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    dismissLoading();
                    var rekap_faktur_data = self.getRegulerData();
                    rekap_faktur_data['action'] = "kb_pembayaran_rekap_faktur_form";
                    rekap_faktur_data['super_command'] = "";
                    rekap_faktur_data['id'] = json.header.id;
                    rekap_faktur_data['id_vendor'] = json.header.id_vendor;
                    rekap_faktur_data['medis'] = json.header.medis;
                    rekap_faktur_data['nama_vendor'] = json.header.nama_vendor;
                    rekap_faktur_data['tanggal'] = json.header.tanggal;
                    rekap_faktur_data['nomor'] = json.header.nomor;
                    rekap_faktur_data['total_tagihan'] = json.header.total_tagihan;
                    rekap_faktur_data['total_dibayar'] = json.header.total_dibayar;
                    rekap_faktur_data['sisa_tagihan'] = json.header.sisa_tagihan;
                    rekap_faktur_data['html_detail_rekap_faktur'] = json.detail.rekap_faktur.html;
                    rekap_faktur_data['r_num_detail_rekap_faktur'] = json.detail.rekap_faktur.r_num;
                    LoadSmisPage(rekap_faktur_data);
                }
            );
        };
        pembayaran_rekap_faktur.view();
    });
</script>
<style>
    label {
        width: 150px !important;
    }
</style>