<?php
    global $db;

    $gudang_option = new OptionBuilder();
    $gudang_option->add("Gudang Farmasi", "gudang_farmasi", "1");
    $gudang_option->add("Gudang Umum", "gudang_umum");
    $gudang_s_select = new Select("filter_gudang", "filter_gudang", $gudang_option->getContent());
    $faktur_table = new Table(array("No.", "Asal Faktur", "No. Faktur", "No. BBM", "Tgl. Faktur", "Jatuh Tempo", "Rekanan", "Total Tagihan", "Sisa Tagihan"));
	$faktur_table->setName("faktur");
    $faktur_table->setModel(Table::$SELECT);
    $header =   "<tr class = 'header_faktur'>" .
					"<td></td>" .
					"<td>" . $gudang_s_select->getHtml() . "</td>" .
					"<td></td>" .
                    "<td></td>" .
					"<td></td>" .
					"<td></td>" .
					"<td></td>" .
					"<td></td>" .
                    "<td></td>" .
                    "<td>" . 
                        "<div class='btn-group noprint'>" .
                            "<a href='#' onclick='faktur.view()' data-content='Cari' data-toggle='popover' id='faktur_search' class='input btn btn-inverse'>" . 
                                "<i class='icon-white icon-search'></i>" .
                            "</a>" .
                        "</div>" .
                    "</td>" .
			    "</tr>";
	$faktur_table->addHeader("after", $header);
    $faktur_adapter = new SimpleAdapter(true, "No.");
    $faktur_adapter->add("Asal Faktur", "asal_faktur", "unslug");
    $faktur_adapter->add("No. Faktur", "nomor_faktur");
    $faktur_adapter->add("No. BBM", "no_bbm");
    $faktur_adapter->add("Tgl. Faktur", "tanggal_faktur", "date d-m-Y");
    $faktur_adapter->add("Jatuh Tempo", "jatuh_tempo", "date d-m-Y");
    $faktur_adapter->add("Rekanan", "rekanan");
    $faktur_adapter->add("Total Tagihan", "total_tagihan", "money");
    $faktur_adapter->add("Sisa Tagihan", "sisa_tagihan", "money");
	$faktur_dbtable = new DBTable($db, "smis_fnc_bayar");
    $faktur_dbtable->setViewForSelect(true);
    $filter = "";
	if (isset($_POST['kriteria'])) {
		$filter .= " AND (no_faktur LIKE '%" . $_POST['kriteria'] . "%' OR nama_vendor LIKE '%" . $_POST['kriteria'] . "%')";
    }
    $query_value = "
        SELECT
            CONCAT('gudang_farmasi', '|', id) id,
            'gudang_farmasi' asal_faktur, 
            no_faktur nomor_faktur,
            no_bbm,
            tanggal tanggal_faktur,
            tanggal_tempo jatuh_tempo,
            nama_vendor rekanan,
            total_tagihan,
            (total_tagihan - total_dibayar) sisa_tagihan
        FROM
            smis_fr_obat_masuk
        WHERE
                prop = ''
                    AND id > 0
                    AND id_po > 0
                    AND has_journal = 1
                    " . $filter . "
            ORDER BY
                (total_tagihan - total_dibayar) DESC
    ";
    if (isset($_POST['gudang']) && $_POST['gudang'] == "gudang_umum") {
        $query_value = "
            SELECT
                CONCAT('gudang_umum', '|', id) id,
                'gudang_umum' asal_faktur, 
                no_faktur nomor_faktur,
                no_bbm,
                tanggal tanggal_faktur,
                tanggal_tempo jatuh_tempo,
                nama_vendor rekanan,
                total_tagihan,
                (total_tagihan - total_dibayar) sisa_tagihan
            FROM
                smis_gu_barang_masuk
            WHERE
                prop = ''
                    AND id > 0
                    AND id_po > 0
                    AND has_journal = 1
                    " . $filter . "
            ORDER BY
                (total_tagihan - total_dibayar) DESC
        ";
    }
	$query_count = "
		SELECT COUNT(*)
		FROM (
			" . $query_value . "
		) v_faktur
	";
    $faktur_dbtable->setPreferredQuery(true, $query_value, $query_count);
    require_once("finance/class/responder/KBPFFakturDBResponder.php");
	$faktur_dbresponder = new KBPFFakturDBResponder(
		$faktur_dbtable,
		$faktur_table,
		$faktur_adapter
    );
    
    $super_command = new SuperCommand();
    $super_command->addResponder("faktur", $faktur_dbresponder);
    $init = $super_command->initialize();
    if ($init != null) {
        echo $init;
        return;
    }
    
    if (isset($_POST['command'])) {
         $table = new Table(
            array("No.", "No. ID", "No. Ref.", "Tgl. Bayar", "Jenis Bayar", "Nilai", "Keterangan", "Akun"),
            "",
            null,
            true
        );
        $table->setName("pembayaran_faktur");
        $table->setFooterVisible(false);
        $table->setReloadButtonEnable(false);
        $table->setPrintButtonEnable(false);
        $table->setAddButtonEnable(false);
        $table->setPrintElementButtonEnable(true);

        $adapter = new SummaryAdapter(true, "No.");
        $adapter->addFixValue("Jenis Bayar", "<div align='right'><b>Total</b></div>");
        $adapter->addSummary("Nilai", "kredit", "money");
        $adapter->add("No. ID", "id");
        $adapter->add("No. Ref.", "noref");
        $adapter->add("Tgl. Bayar", "waktu", "date d-m-Y");
        $adapter->add("Jenis Bayar", "jenis");
        $adapter->add("Nilai", "kredit", "money");
        $adapter->add("Keterangan", "keterangan");
        $adapter->add("Akun", "akun");
        $dbtable = new DBTable($db, "smis_fnc_bayar");

        if ($_POST['command'] == "list") {
            $id_faktur = $_POST['id_faktur'];
            $asal_faktur = $_POST['asal_faktur'];

            $query_value = "
                SELECT
                    id, noref, waktu, jenis, kredit, keterangan, CONCAT(no_akun, ' - ', nama_dompet) akun
                FROM
                    smis_fnc_bayar
                WHERE
                    prop = ''
                        AND id_faktur = '" . $id_faktur . "'
                        AND asal_faktur LIKE '" . $asal_faktur . "'
                ORDER BY
                    waktu ASC,
                        id ASC
            ";
            $query_count = "
                SELECT
                    COUNT(*)
                FROM 
                    (" . $query_value . ") v
            ";
            $dbtable->setPreferredQuery(true, $query_value, $query_count);
            $dbtable->setShowAll(true);
        }
        require_once("finance/class/responder/KBPembayaranFakturDBResponder.php");
        $dbresponder = new KBPembayaranFakturDBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    $form = new Form("", "", "Pembayaran Faktur");
    $id_faktur_hidden = new Hidden("faktur_id_faktur", "faktur_id_faktur", "");
    $form->addElement("", $id_faktur_hidden);
    $id_opl_hidden = new Hidden("faktur_id_opl", "faktur_id_opl", "");
    $form->addElement("", $id_opl_hidden);
    $asal_faktur_hidden = new Hidden("faktur_asal_faktur", "faktur_asal_faktur", "");
    $form->addElement("", $asal_faktur_hidden);
    $faktur_button = new Button("", "", "Pilih");
	$faktur_button->setClass("btn-info");
	$faktur_button->setIsButton(Button::$ICONIC);
	$faktur_button->setIcon("icon-white ".Button::$icon_list_alt);
	$faktur_button->setAction("faktur.chooser('faktur', 'faktur_button', 'faktur', faktur)");
	$faktur_button->setAtribute("id='faktur_browse'");
	$nomor_faktur_text = new Text("faktur_nomor_faktur", "faktur_nomor_faktur", "");
	$nomor_faktur_text->setAtribute("disabled='disabled'");
	$nomor_faktur_text->setClass("smis-one-option-input");
	$faktur_input_group = new InputGroup("");
	$faktur_input_group->addComponent($nomor_faktur_text);
	$faktur_input_group->addComponent($faktur_button);
    $form->addElement("No. Faktur", $faktur_input_group);
    $no_bbm_text = new Text("faktur_no_bbm", "faktur_no_bbm", "");
    $no_bbm_text->setAtribute("disabled='disabled'");
    $form->addElement("No. BBM", $no_bbm_text);
    $id_rekanan_hidden = new Hidden("faktur_id_rekanan", "faktur_id_rekanan", "");
    $form->addElement("", $id_rekanan_hidden);
    $nama_rekanan_text = new Text("faktur_nama_rekanan", "faktur_nama_rekanan", "");
    $nama_rekanan_text->setAtribute("disabled='disabled'");
    $form->addElement("Rekanan", $nama_rekanan_text);
    $tanggal_faktur_text = new Text("faktur_tanggal_faktur", "faktur_tanggal_faktur", "");
    $tanggal_faktur_text->setAtribute("disabled='disabled'");
    $form->addElement("Tgl. Faktur", $tanggal_faktur_text);
    $jatuh_tempo_text = new Text("faktur_jatuh_tempo", "faktur_jatuh_tempo", "");
    $jatuh_tempo_text->setAtribute("disabled='disabled'");
    $form->addElement("Jatuh Tempo", $jatuh_tempo_text);
    $total_tagihan_text = new Text("faktur_total_tagihan", "faktur_total_tagihan", "");
    $total_tagihan_text->setAtribute("disabled='disabled'");
    $form->addElement("Tot. Tagihan", $total_tagihan_text);
    $sisa_tagihan_text = new Text("faktur_sisa_tagihan", "faktur_sisa_tagihan", "");
    $sisa_tagihan_text->setAtribute("disabled='disabled'");
    $form->addElement("Sisa Tagihan", $sisa_tagihan_text);

    $faktur_tabulator = new Tabulator("faktur_tabulator", "", Tabulator::$POTRAIT);
    $faktur_tabulator->add("faktur_informasi_tab", "Informasi Faktur", "finance/resource/php/kas_bank/kb_pf_faktur_informasi.php", Tabulator::$TYPE_INCLUDE, "fa fa-navicon");
    $faktur_tabulator->add("faktur_uang_muka_tab", "Uang Muka", "finance/resource/php/kas_bank/kb_pf_faktur_uang_muka.php", Tabulator::$TYPE_INCLUDE, "fa fa-navicon");
    $faktur_tabulator->add("faktur_pembayaran_tab", "Pembayaran", "finance/resource/php/kas_bank/kb_pf_faktur_pembayaran.php", Tabulator::$TYPE_INCLUDE, "fa fa-navicon");

    echo $form->getHtml();
    echo "<div class='clear'></div>";
    echo $faktur_tabulator->getHtml();
    echo addJS("framework/smis/js/table_action.js");
?>
<script type="text/javascript">
    var faktur;
    var pembayaran_faktur;
    $(document).ready(function() {
        $('.modal').on('shown.bs.modal', function() {
			$(this).find('[autofocus]').focus();
		});
        $("#pembayaran_faktur_list").html("<tr><td colspan='9'><center>Faktur belum dipilih.</center></td></tr>");
        $("#uang_muka_faktur_list").html("<tr><td colspan='7'><center>Faktur belum dipilih.</center></td></tr>");
        $("#add_pembayaran_faktur_button").hide();
        $("#add_uang_muka_faktur_button").hide();
        $("#smis-chooser-modal").on("show", function() {
			if ($("#smis-chooser-modal .modal-header h3").text() == "FAKTUR") {
				$("#smis-chooser-modal").removeClass("half_model");
				$("#smis-chooser-modal").removeClass("full_model");
				$("#smis-chooser-modal").addClass("full_model");
			} else {
				$("#smis-chooser-modal").removeClass("half_model");
				$("#smis-chooser-modal").removeClass("full_model");
				$("#smis-chooser-modal").addClass("half_model");
			}
        });

        pembayaran_faktur = new TableAction(
            "pembayaran_faktur",
            "finance",
            "kb_pembayaran_faktur",
            new Array('id', 'noref', 'kredit', 'keterangan', 'no_akun', 'nama_dompet')
        );
        pembayaran_faktur.addViewData = function(data) {
            data['id_faktur'] = $("#faktur_id_faktur").val();
            data['asal_faktur'] = $("#faktur_asal_faktur").val();
            return data;
        };
        pembayaran_faktur.view = function() {
            if ($("#faktur_id_faktur").val() == "" || $("#faktur_asal_faktur").val() == "")
                return;
            TableAction.prototype.view.call(this);
            $("#add_pembayaran_faktur_button").show();
        };
        pembayaran_faktur.show_add_form = function() {
            TableAction.prototype.show_add_form.call(this);
            var sisa_tagihan = $("#faktur_sisa_tagihan").val();
            $("#pembayaran_faktur_kredit").val(sisa_tagihan);
            $("#pembayaran_faktur_noref").focus();
        };
        pembayaran_faktur.clear = function() {
            TableAction.prototype.clear.call(this);
            $("#pembayaran_faktur_akun").select2('data', {id : "", text: ""});
            $(".error_field").removeClass("error_field");
        };
        pembayaran_faktur.validate = function() {
            var valid = true;
            var invalid_msg = "";
            var noref = $("#pembayaran_faktur_noref").val();
            var waktu = $("#pembayaran_faktur_waktu").val();
            var jenis = $("#pembayaran_faktur_jenis").val();
            var keterangan = $("#pembayaran_faktur_keterangan").val();
            var akun = $("#pembayaran_faktur_akun").val();
            var kredit = parseFloat($("#pembayaran_faktur_kredit").val().replace(/[^0-9-,]/g, '').replace(",", "."))

            $(".error_field").removeClass("error_field");

            if (noref == "") {
                valid = false;
                invalid_msg += "</br><strong>No. Ref.</strong> tidak boleh kosong";
                $("#pembayaran_faktur_noref").addClass("error_field");
            }
            if (waktu == "") {
                valid = false;
                invalid_msg += "</br><strong>Tgl. Bayar</strong> tidak boleh kosong";
                $("#pembayaran_faktur_waktu").addClass("error_field");
            }
            if (jenis == "") {
                valid = false;
                invalid_msg += "</br><strong>Jenis Bayar</strong> tidak boleh kosong";
                $("#pembayaran_faktur_jenis").addClass("error_field");
            }
            if (keterangan == "") {
                valid = false;
                invalid_msg += "</br><strong>Keterangan</strong> tidak boleh kosong";
                $("#pembayaran_faktur_keterangan").addClass("error_field");
            }
            if (akun == "") {
                valid = false;
                invalid_msg += "</br><strong>Akun Kas Bank</strong> tidak boleh kosong";
                $("#pembayaran_faktur_akun").addClass("error_field");
            }
            if (kredit == 0) {
                valid = false;
                invalid_msg += "</br><strong>Nilai</strong> tidak boleh nol";
                $("#pembayaran_faktur_kredit").addClass("error_field");
            }
            
            if (!valid) {
                $("#modal_alert_pembayaran_faktur_add_form").html(
                    "<div class='alert alert-block alert-danger'>" +
                        "<h4>Peringatan</h4>" +
                        invalid_msg +
                    "</div>"
                );
            }
            return valid;
        };
        pembayaran_faktur.getSaveData = function() {
            var data = this.getRegulerData();
            data['command'] = "save";
            data['id'] = $("#pembayaran_faktur_id").val();
            data['id_faktur'] = $("#faktur_id_faktur").val();
            data['id_opl'] = $("#faktur_id_opl").val();
            data['asal_faktur'] = $("#faktur_asal_faktur").val();
            data['noref'] = $("#pembayaran_faktur_noref").val();
            data['id_vendor'] = $("#faktur_id_rekanan").val();
            data['nama_vendor'] = $("#faktur_nama_rekanan").val();
            data['penerima'] = $("#faktur_nama_rekanan").val();
            data['waktu'] = $("#pembayaran_faktur_waktu").val();
            data['jenis'] = $("#pembayaran_faktur_jenis").val();
            data['kredit'] = parseFloat($("#pembayaran_faktur_kredit").val().replace(/[^0-9-,]/g, '').replace(",", "."));
            data['keterangan'] = $("#pembayaran_faktur_keterangan").val();
            data['no_akun'] = $("#pembayaran_faktur_no_akun").val();
            data['nama_dompet'] = $("#pembayaran_faktur_nama_dompet").val();
            return data;
        };
        pembayaran_faktur.save = function() {
            if (!this.validate())
                return;
            var self = this;
            var data = this.getSaveData();
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = getContent(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    dismissLoading();
                    $("#faktur_sisa_tagihan").val(json.sisa_tagihan);
                    $("#pembayaran_faktur_add_form").smodal("hide");
                    self.printelement(json.id);
                    self.view();
                }
            );
        };
        pembayaran_faktur.edit = function(id) {
            this.clear();
            var data = this.getRegulerData();
            data['command'] = "edit";
            data['id'] = id;
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = getContent(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    $("#pembayaran_faktur_id").val(id);
                    $("#pembayaran_faktur_nomor").val(json.nomor);
                    $("#pembayaran_faktur_noref").val(json.noref);
                    $("#pembayaran_faktur_waktu").val(json.waktu);
                    $("#pembayaran_faktur_jenis").val(json.jenis);
                    $("#pembayaran_faktur_kredit").val(json.kredit);
                    $("#pembayaran_faktur_keterangan").val(json.keterangan);
                    $("#pembayaran_faktur_no_akun").val(json.no_akun);
                    $("#pembayaran_faktur_nama_dompet").val(json.nama_dompet);
                    var akun = json.no_akun + " - " + json.nama_dompet;
                    $("#pembayaran_faktur_akun").select2('data', {id : akun, text: akun});
                    $("#pembayaran_faktur_add_form").smodal("show");
                    dismissLoading();
                }
            );
        };
        pembayaran_faktur.del = function(id) {
            var self = this;
            var html_message =  "<strong>Peringatan</strong> : ";
                html_message += "Pembatalan transaksi akan berdampak pada jurnal terkait di Buku Besar Akuntansi.<br/><br/>";
                html_message += "Yakin membatalkan transaksi ini?";
            bootbox.confirm({
                message: html_message,
                buttons: {
                    confirm : {
                        label : "Ya",
                        className : "btn-success"
                    },
                    cancel : {
                        label : "Tidak",
                        className : "btn-danger"
                    }
                },
                callback: function(result) {
                    if (result) {
                        var data = self.getRegulerData();
                        data['command'] = "del";
                        data['id'] = id;
                        showLoading();
                        $.post(
                            "",
                            data,
                            function(response) {
                                var json = getContent(response);
                                if (json == null) {
                                    dismissLoading();
                                    return;
                                }
                                $("#faktur_sisa_tagihan").val(json.sisa_tagihan);
                                dismissLoading();
                                self.view();
                            }
                        );
                    }
                }
            });
        };
        pembayaran_faktur.printelement = function(id) {
            var data = this.getRegulerData();
            data['command'] = "print_invoice";
            data['id'] = id;
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    var getUrl = window.location['pathname'] + json;
                    window.open(getUrl, 'pdf');
                    dismissLoading();
                }
            );
        };

        faktur = new TableAction(
            "faktur",
            "finance",
            "kb_pembayaran_faktur",
            new Array()
        );
        faktur.addViewData = function(data) {
            data['gudang'] = $("#filter_gudang").val();
            return data;
        };
        faktur.selected = function(json) {
            $("#faktur_id_faktur").val(json.header.id);
            $("#faktur_id_opl").val(json.header.id_opl);
            $("#faktur_asal_faktur").val(json.header.asal_faktur);
            $("#faktur_nomor_faktur").val(json.header.nomor_faktur);
            $("#faktur_no_bbm").val(json.header.no_bbm);
            $("#faktur_tanggal_faktur").val(json.header.tanggal_faktur);
            $("#faktur_jatuh_tempo").val(json.header.jatuh_tempo);
            $("#faktur_id_rekanan").val(json.header.id_rekanan);
            $("#faktur_nama_rekanan").val(json.header.nama_rekanan);
            $("#faktur_total_tagihan").val(json.header.total_tagihan);
            $("#faktur_sisa_tagihan").val(json.header.sisa_tagihan);
            $("#total").html(json.footer.total_1);
            $("#global_diskon").html(json.footer.diskon);
            $("#total_2").html(json.footer.total_2);
            $("#ppn").html(json.footer.ppn);
            $("#materai").html(json.footer.materai);
            $("#tagihan").html(json.footer.tagihan);
            $("#informasi_faktur_list").html(json.detail);

            pembayaran_faktur.view();
            uang_muka_faktur.view()
            $("#add_uang_muka_faktur_button").show();
            $("#add_pembayaran_faktur_button").show();
        };
        faktur.setSuperCommand("faktur");
    });
</script>