<?php
    global $user;
    global $db;

    if (isset($_POST['command'])) {
        $table = new Table(array(), "", null, true);
        $adapter = new SimpleAdapter();
        $dbtable = new DBTable($db, "smis_fnc_mutasi_antar_kas_bank");
        require_once("finance/class/responder/KBMutasiAntarKasBankDBResponder.php");
        $dbresponder = new KBMutasiAntarKasBankDBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    $readonly = isset($_POST['readonly']) ? $_POST['readonly'] == 1 : false;
    $id = isset($_POST['id']) ? $_POST['id'] : "";
    $id_draft_jurnal = isset($_POST['id_draft_jurnal']) ? $_POST['id_draft_jurnal'] : "";
    $operator = isset($_POST['operator']) ? $_POST['operator'] : $user->getNameOnly();
    $tanggal_input = isset($_POST['tanggal_input']) ? ArrayAdapter::format("date d-m-Y H:i", $_POST['tanggal_input']) : "";
    $tanggal = isset($_POST['tanggal']) ? ArrayAdapter::format("date d-m-Y H:i", $_POST['tanggal']) : date("d-m-Y H:i");
    $nomor = isset($_POST['nomor']) ? $_POST['nomor'] : "";
    $asal_nomor_akun = isset($_POST['asal_nomor_akun']) ? $_POST['asal_nomor_akun'] : "";
    $asal_nama_akun = isset($_POST['asal_nama_akun']) ? $_POST['asal_nama_akun'] : "";
    $f_asal_akun = $asal_nomor_akun . " - " . $asal_nama_akun;
    if ($asal_nomor_akun == "")
        $f_asal_akun = "";
    $tujuan_nomor_akun = isset($_POST['tujuan_nomor_akun']) ? $_POST['tujuan_nomor_akun'] : "";
    $tujuan_nama_akun = isset($_POST['tujuan_nama_akun']) ? $_POST['tujuan_nama_akun'] : "";
    $f_tujuan_akun = $tujuan_nomor_akun . " - " . $tujuan_nama_akun;
    if ($tujuan_nomor_akun == "")
        $f_tujuan_akun = "";
    $keterangan = isset($_POST['keterangan']) ? $_POST['keterangan'] : "";
    $kredit = isset($_POST['nilai']) && $_POST['nilai'] > 0 ? $_POST['nilai'] : "0,00";

    $form = new Form("", "", "Mutasi Antar Kas Bank");
    $id_hidden = new Hidden("mutasi_antar_kas_bank_id", "mutasi_antar_kas_bank_id", $id);
    $form->addElement("", $id_hidden);
    $id_draft_jurnal_hidden = new Hidden("mutasi_antar_kas_bank_id_draft_jurnal", "mutasi_antar_kas_bank_id_draft_jurnal", $id_draft_jurnal);
    $form->addElement("", $id_draft_jurnal_hidden);
    $operator_text = new Text("mutasi_antar_kas_bank_operator", "mutasi_antar_kas_bank_operator", $operator);
    $operator_text->setAtribute("disabled='disabled'");
    $form->addElement("Petugas Entri", $operator_text);
    $tanggal_input_text = new Text("mutasi_antar_kas_bank_tanggal_input", "mutasi_antar_kas_bank_tanggal_input", $tanggal_input);
    $tanggal_input_text->setAtribute("disabled='disabled'");
    $form->addElement("Tanggal Entri", $tanggal_input_text);
    $tanggal_text = new Text("mutasi_antar_kas_bank_tanggal", "mutasi_antar_kas_bank_tanggal", $tanggal);
    if ($readonly)
        $tanggal_text->setAtribute("data-date-format='dd-mm-yyyy hh:ii' disabled='disabled'");
    else
        $tanggal_text->setAtribute("data-date-format='dd-mm-yyyy hh:ii'");

    $tanggal_text->setClass("mydatetime");
    $form->addElement("Tanggal Jurnal", $tanggal_text);
    $nomor_text = new Text("mutasi_antar_kas_bank_nomor", "mutasi_antar_kas_bank_nomor", $nomor);
    $nomor_text->setAtribute("disabled='disabled'");
    $form->addElement("Nomor Jurnal", $nomor_text);
    $keterangan_textarea = new TextArea("mutasi_antar_kas_bank_keterangan", "mutasi_antar_kas_bank_keterangan", $keterangan);
    $keterangan_textarea->setLine(3);
    if ($readonly)
        $keterangan_textarea->setAtribute("disabled='disabled'");
    $form->addElement("Keterangan", $keterangan_textarea);
    if ($readonly) {
        $asal_akun_text = new Text("mutasi_antar_kas_bank_asal_akun", "mutasi_antar_kas_bank_asal_akun", $f_asal_akun);
        $asal_akun_text->setAtribute("disabled='disabled'");
        $form->addElement("Dari Akun", $asal_akun_text);
        $tujuan_akun_text = new Text("mutasi_antar_kas_bank_tujuan_akun", "mutasi_antar_kas_bank_tujuan_akun", $f_tujuan_akun);
        $tujuan_akun_text->setAtribute("disabled='disabled'");
        $form->addElement("Akun Tujuan", $tujuan_akun_text);
    } else {
        $akun_rows = $db->get_result("
            SELECT 
                *
            FROM
                smis_ac_account
            WHERE
                prop = '' 
                    AND id_parent <> 0
                    AND have_child = 0
                    AND nama_tipe LIKE 'Kas & Setara Kas'
            ORDER BY
                nomor ASC
        ");
        $akun_option = new OptionBuilder();
        if ($id == "") {
            $akun_option->add("", "", "1");
        } else {
            $akun_option->add("");
        }
        if ($akun_rows != null) {
            foreach ($akun_rows as $akun_row) {
                if ($id != "" && $asal_nomor_akun != "" && $asal_nomor_akun == $akun_row->nomor) {
                    $akun_option->add($akun_row->nomor . " - " . $akun_row->nama, $akun_row->nomor . " - " . $akun_row->nama, "1");
                } else {
                    $akun_option->add($akun_row->nomor . " - " . $akun_row->nama);
                }
            }
        }
        $asal_akun_select = new Select("mutasi_antar_kas_bank_asal_akun", "mutasi_antar_kas_bank_asal_akun", $akun_option->getContent());
        $form->addElement("Dari Akun", $asal_akun_select);
        $akun_option = new OptionBuilder();
        if ($id == "") {
            $akun_option->add("", "", "1");
        } else {
            $akun_option->add("");
        }
        if ($akun_rows != null) {
            foreach ($akun_rows as $akun_row) {
                if ($id != "" && $tujuan_nomor_akun != "" && $tujuan_nomor_akun == $akun_row->nomor) {
                    $akun_option->add($akun_row->nomor . " - " . $akun_row->nama, $akun_row->nomor . " - " . $akun_row->nama, "1");
                } else {
                    $akun_option->add($akun_row->nomor . " - " . $akun_row->nama);
                }
            }
        }
        $tujuan_akun_select = new Select("mutasi_antar_kas_bank_tujuan_akun", "mutasi_antar_kas_bank_tujuan_akun", $akun_option->getContent());
        $form->addElement("Akun Tujuan", $tujuan_akun_select);
    }
    $kredit_text = new Text("mutasi_antar_kas_bank_kredit", "mutasi_antar_kas_bank_kredit", $kredit);
    if ($readonly) {
        $kredit_text->setTypical("money");
        $kredit_text->setAtribute("data-thousands='.' data-decimal=',' data-precision='2' disabled='disabled'");
    } else {
        $kredit_text->setTypical("money");
        $kredit_text->setAtribute("data-thousands='.' data-decimal=',' data-precision='2'");
    }
    $form->addElement("Kredit", $kredit_text);

    $back_button = new Button("", "", "Kembali ke Daftar");
    $back_button->setClass("btn btn-inverse");
    $back_button->setAction("mutasi_antar_kas_bank.back()");

    $save_button = new Button("", "", "Simpan Jurnal");
    $save_button->setClass("btn btn-success");
    $save_button->setAction("mutasi_antar_kas_bank.save()");

    echo $form->getHtml();
    echo "<div class='clear'>";
    echo "<div class='container-fluid'>";
    echo "<div class='row-fluid'>";
    echo "<div class='span6' align='left'>" . $back_button->getHtml() . "</div>";
    if (!$readonly)
        echo "<div class='span6' align='right'>" . $save_button->getHtml() . "</div>";
    echo "</div>";
    echo "</div>";
    echo addJS("framework/smis/js/table_action.js");
    echo addJS("framework/bootstrap/js/bootstrap-select.js");
    echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");
    echo addCSS("framework/bootstrap/css/bootstrap-select.css");
    echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
?>
<script type="text/javascript">
    var mutasi_antar_kas_bank;
    var row_num;
    $(document).ready(function() {
        row_num = 0;
        $(".mydatetime").datetimepicker({
            minuteStep: 1
        });
        mutasi_antar_kas_bank = new TableAction(
            "mutasi_antar_kas_bank",
            "finance",
            "kb_mutasi_antar_kas_bank_form",
            new Array("kredit")
        );
        mutasi_antar_kas_bank.back = function() {
            var data = this.getRegulerData();
            data['action'] = "kb_mutasi_antar_kas_bank";
            data['super_command'] = "";
            LoadSmisPage(data);
        };
        mutasi_antar_kas_bank.validate = function() {
            var valid = true;
            var tanggal = $("#mutasi_antar_kas_bank_tanggal").val();
            // var nomor = $("#mutasi_antar_kas_bank_nomor").val();
            var keterangan = $("#mutasi_antar_kas_bank_keterangan").val();
            var asal_akun = $("#mutasi_antar_kas_bank_asal_akun").val();
            var tujuan_akun = $("#mutasi_antar_kas_bank_tujuan_akun").val();
            var kredit = parseFloat($("#mutasi_antar_kas_bank_kredit").val().replace(/[^0-9-,]/g, '').replace(",", "."));;
            var invalid_msg = "";
            if (tanggal == "") {
                valid = false;
                invalid_msg += "<li>Tanggal Jurnal tidak diperkenankan kosong.</li>";
            }
            // if (nomor == "") {
            //     valid = false;
            //     invalid_msg += "<li>Nomor Jurnal tidak diperkenankan kosong.</li>";
            // }
            if (keterangan == "") {
                valid = false;
                invalid_msg += "<li>Keterangan tidak diperkenankan kosong.</li>";
            }
            if (asal_akun == "") {
                valid = false;
                invalid_msg += "<li>Dari Akun tidak diperkenankan kosong.</li>"
            }
            if (tujuan_akun == "") {
                valid = false;
                invalid_msg += "<li>Akun Tujuan tidak diperkenankan kosong.</li>"
            }
            if (asal_akun != "" && tujuan_akun != "" && asal_akun == tujuan_akun) {
                valid = false;
                invalid_msg += "<li>Akun Tujuan dan Dari Akun tidak diperkenankan sama.</li>"
            }
            if (kredit == "") {
                valid = false;
                invalid_msg += "<li>Kredit tidak diperkenankan kosong.</li>";
            } else if (kredit == 0) {
                valid = false;
                invalid_msg += "<li>Kredit tidak diperkenankan bernilai nol.</li>";
            }
            if (valid == false) {
                bootbox.alert({
                    title: "Kesalahan",
                    message: "<ul>" + invalid_msg + "</ul>"
                });
            }
            return valid;
        };
        mutasi_antar_kas_bank.getSaveData = function() {
            var data = this.getRegulerData();
            data['command'] = "save";
            data['id'] = $("#mutasi_antar_kas_bank_id").val();
            data['id_draft_jurnal'] = $("#mutasi_antar_kas_bank_id_draft_jurnal").val();
            data['id_detail'] = $("#mutasi_antar_kas_bank_id_detail").val();
            data['operator'] = $("#mutasi_antar_kas_bank_operator").val();
            data['tanggal_input'] = $("#mutasi_antar_kas_bank_tanggal_input").val();
            data['tanggal'] = $("#mutasi_antar_kas_bank_tanggal").val();
            data['nomor'] = $("#mutasi_antar_kas_bank_nomor").val();
            data['keterangan'] = $("#mutasi_antar_kas_bank_keterangan").val();
            data['asal_akun'] = $("#mutasi_antar_kas_bank_asal_akun").val();
            data['tujuan_akun'] = $("#mutasi_antar_kas_bank_tujuan_akun").val();
            var kredit = $("#mutasi_antar_kas_bank_kredit").val();
            data['kredit'] = parseFloat(kredit.replace(/[^0-9-,]/g, '').replace(",", "."));
            return data;
        };
        mutasi_antar_kas_bank.save = function() {
            if (!this.validate())
                return;
            var self = this;
            var data = this.getSaveData();
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    dismissLoading();
                    data['command'] = "print_jurnal";
                    data['id'] = json.id;
                    showLoading();
                    $.post(
                        "",
                        data,
                        function(response) {
                            var json = JSON.parse(response);
                            if (json == null) {
                                dismissLoading();
                                return;
                            }
                            var getUrl = window.location['pathname'] + json;
                            window.open(getUrl, 'pdf');
                            dismissLoading();
                            self.back();
                        }
                    );
                }
            );
        };

        <?php
        if (isset($_POST['data'])) {
        ?>
            $("#mutasi_antar_kas_bank_asal_akun").val("<?php echo $_POST['data']['asal_nomor_akun'] . " - " . $_POST['data']['asal_nama_akun']; ?>");
            $("#mutasi_antar_kas_bank_tujuan_akun").val("<?php echo $_POST['data']['tujuan_nomor_akun'] . " - " . $_POST['data']['tujuan_nama_akun']; ?>");
        <?php } ?>

        <?php
        if (!$readonly) {
        ?>
            $("#mutasi_antar_kas_bank_asal_akun").select2();
            $("#mutasi_antar_kas_bank_tujuan_akun").select2();
        <?php } ?>
    });
</script>
<style type="text/css">
    textarea.detail_textarea {
        width: 100% !important;
    }

    textarea#mutasi_antar_kas_bank_keterangan {
        resize: none;
    }
</style>