<?php
    require_once("finance/class/table/MutasiAntarKasBankTable.php");
    global $db;

    $table = new MutasiAntarKasBankTable(
        array("No.", "No. Jurnal", "Tgl. Jurnal", "Uraian", "Dari", "Tujuan Mutasi", "Nilai"),
        "",
        null,
        true
    );
    $table->setName("kb_mutasi_antar_kas_bank");
    $table->setReloadButtonEnable(false);
    $table->setPrintButtonEnable(false);
    $table->setAddButtonEnable(false);
    $add_button = new Button("", "", "Jurnal");
    $add_button->setClass("btn btn-primary");
    $add_button->setAction("kb_mutasi_antar_kas_bank.show_add_form()");
    $add_button->setIcon("fa fa-plus");
    $add_button->setIsButton(Button::$ICONIC_TEXT);
    $table->addHeaderButton($add_button);
    $table->setFooterVisible(false);

    if (isset($_POST['command'])) {
        $adapter = new SummaryAdapter(true, "No.");
        $adapter->addFixValue("Uraian", "<div align='right'><b>Total</b></div>");
        $adapter->addSummary("Nilai", "nilai", "money");
        $adapter->add("id", "id");
        $adapter->add("lock_draft", "lock_draft");
        $adapter->add("lock_acc", "lock_acc");
        $adapter->add("id_jurnal", "id_jurnal");
        $adapter->add("No. Jurnal", "nomor");
        $adapter->add("Tgl. Jurnal", "tanggal", "date d-m-Y");
        $adapter->add("No. - Nama Akun", "akun");
        $adapter->add("Uraian", "uraian");
        $adapter->add("Dari", "asal");
        $adapter->add("Tujuan Mutasi", "tujuan");
        $adapter->add("Nilai", "nilai", "money");
        $dbtable = new DBTable($db, "smis_ac_draft_jurnal");

        if ($_POST['command'] == "list") {
            $tanggal_dari = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_dari'])->format("Y-m-d");
            $tanggal_sampai = DateTime::createFromFormat("d-m-Y", $_POST['tanggal_sampai'])->format("Y-m-d");
            $kode_akun = $_POST['kode_akun'];
            $nama_akun = $_POST['nama_akun'];
            $filter_akun = "";
            if ($kode_akun != "") {
                $filter_akun = "AND c.nomor = '" . $kode_akun . "' AND c.nama = '" . $nama_akun . "'";
            }

            $query_value = "
                SELECT
                    a.id, a.asal_nama_akun asal, a.tujuan_nama_akun tujuan, b.lock_acc, b.lock_draft, b.id_jurnal, b.nomor, b.tanggal, b.keterangan uraian, b.nilai
                FROM
                    smis_fnc_mutasi_antar_kas_bank a
                        LEFT JOIN smis_ac_draft_jurnal b ON a.id_draft_jurnal = b.id
                        LEFT JOIN smis_ac_detail_draft_jurnal c ON c.id_draft_jurnal = b.id
                        LEFT JOIN smis_ac_account d ON c.nomor_account = d.nomor
                WHERE
                    a.prop = ''
                        AND b.prop = ''
                        AND c.prop = ''
                        AND DATE(b.tanggal) >= '" . $tanggal_dari . "'
                        AND DATE(b.tanggal) <= '" . $tanggal_sampai . "'
                        AND d.nama_tipe LIKE 'Kas & Setara Kas'
                        AND c.debet > c.kredit
                        AND c.debet > 0
                        AND b.j_jurnal LIKE 'Mutasi Kas Bank'
                        " . $filter_akun . "
                ORDER BY
                    b.tanggal ASC, a.id ASC
            ";
            $query_count = "
                SELECT
                    COUNT(*)
                FROM 
                    (" . $query_value . ") v
            ";
            $dbtable->setPreferredQuery(true, $query_value, $query_count);
            $dbtable->setShowAll(true);
        }
        require_once("finance/class/responder/KBMutasiAntarKasBankDBResponder.php");
        $dbresponder = new KBMutasiAntarKasBankDBResponder(
            $dbtable,
            $table,
            $adapter
        );
        $data = $dbresponder->command($_POST['command']);
        echo json_encode($data);
        return;
    }

    $form = new Form("", "", "Mutasi Antar Kas Bank");
    $tanggal_dari_text = new Text("kb_pt_tanggal_dari", "kb_pt_tanggal_dari", "01" . date("-m-Y"));
    $tanggal_dari_text->setAtribute("data-date-format='dd-mm-yyyy'");
    $tanggal_dari_text->setClass("mydate");
    $form->addElement("Dari Tgl.", $tanggal_dari_text);
    $tanggal_sampai_text = new Text("kb_pt_tanggal_sampai", "kb_pt_tanggal_sampai", date("d-m-Y"));
    $tanggal_sampai_text->setAtribute("data-date-format='dd-mm-yyyy'");
    $tanggal_sampai_text->setClass("mydate");
    $form->addElement("Sampai Tgl.", $tanggal_sampai_text);
    $proses_button = new Button("", "", "Proses");
    $proses_button->setClass("btn btn-primary");
    $proses_button->setAction("kb_mutasi_antar_kas_bank.view()");
    $proses_button->setIcon("icon-white icon-repeat");
    $proses_button->setIsButton(Button::$ICONIC);
    $download_excel_button = new Button("", "", "Download XLS");
    $download_excel_button->setClass("btn btn-success");
    $download_excel_button->setAction("kb_mutasi_antar_kas_bank.export_xls()");
    $download_excel_button->setIcon("fa fa-file-excel-o");
    $download_excel_button->setIsButton(Button::$ICONIC);
    $download_pdf_button = new Button("", "", "Download PDF");
    $download_pdf_button->setClass("btn btn-danger");
    $download_pdf_button->setAction("kb_mutasi_antar_kas_bank.export_pdf()");
    $download_pdf_button->setIcon("fa fa-file-pdf-o");
    $download_pdf_button->setIsButton(Button::$ICONIC);
    $button_group = new ButtonGroup();
    $button_group->addButton($proses_button);
    $button_group->addButton($download_excel_button);
    $button_group->addButton($download_pdf_button);
    $form->addElement("", $button_group);

    echo $form->getHtml();
    echo $table->getHtml();
    echo addJS("framework/smis/js/table_action.js");
    echo addJS("framework/bootstrap/js/bootstrap-datepicker.js");
    echo addJS("framework/bootstrap/js/bootstrap-select.js");
    echo addCSS("framework/bootstrap/css/datepicker.css");
    echo addCSS("framework/bootstrap/css/bootstrap-select.css");
?>
<script type="text/javascript">
    var kb_mutasi_antar_kas_bank;
    $(document).ready(function() {
        $(".mydate").datepicker();
        kb_mutasi_antar_kas_bank = new TableAction(
            "kb_mutasi_antar_kas_bank",
            "finance",
            "kb_mutasi_antar_kas_bank",
            new Array()
        );
        kb_mutasi_antar_kas_bank.addRegulerData = function(data) {
            data['tanggal_dari'] = $("#kb_pt_tanggal_dari").val();
            data['tanggal_sampai'] = $("#kb_pt_tanggal_sampai").val();
            return data;
        };
        kb_mutasi_antar_kas_bank.export_xls = function() {
            showLoading();
            var data = this.getRegulerData();
            data['command'] = "export_xls";
            postForm(data);
            dismissLoading();
        };
        kb_mutasi_antar_kas_bank.export_pdf = function() {
            showLoading();
            var data = this.getRegulerData();
            data['command'] = "export_pdf";
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    var getUrl = window.location['pathname'] + json;
                    window.open(getUrl, 'pdf');
                    dismissLoading();
                }
            );
        };
        kb_mutasi_antar_kas_bank.printelement = function(id) {
            var data = this.getRegulerData();
            data['command'] = "print_jurnal";
            data['id'] = id;
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    var getUrl = window.location['pathname'] + json;
                    window.open(getUrl, 'pdf');
                    dismissLoading();
                }
            );
        };
        kb_mutasi_antar_kas_bank.show_add_form = function() {
            var data = this.getRegulerData();
            data['action'] = "kb_mutasi_antar_kas_bank_form";
            data['super_command'] = "";
            LoadSmisPage(data);
        };
        kb_mutasi_antar_kas_bank.edit = function(id) {
            var self = this;
            var data = this.getRegulerData();
            data['command'] = "edit";
            data['id'] = id;
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = getContent(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    dismissLoading();
                    data = self.getRegulerData();
                    data['action'] = "kb_mutasi_antar_kas_bank_form";
                    data['super_command'] = "";
                    data['readonly'] = 0;
                    data['id'] = json.id;
                    data['id_draft_jurnal'] = json.id_draft_jurnal;
                    data['operator'] = json.operator;
                    data['tanggal_input'] = json.tanggal_entri;
                    data['tanggal'] = json.tanggal;
                    data['nomor'] = json.nomor;
                    data['asal_nomor_akun'] = json.asal_nomor_akun;
                    data['asal_nama_akun'] = json.asal_nama_akun;
                    data['tujuan_nomor_akun'] = json.tujuan_nomor_akun;
                    data['tujuan_nama_akun'] = json.tujuan_nama_akun;
                    data['keterangan'] = json.keterangan;
                    data['nilai'] = json.nilai;
                    LoadSmisPage(data);
                }
            );
        };
        kb_mutasi_antar_kas_bank.lock_draft = function(id) {
            var self = this;
            bootbox.confirm({
                title: "Konfirmasi",
                message: "Yakin mengunci data ini?",
                buttons: {
                    confirm: {
                        label: 'Ya',
                        className: 'btn-success'
                    },
                    cancel: {
                        label: 'Tidak',
                        className: 'btn-danger'
                    }
                },
                callback: function(result) {
                    if (result) {
                        var data = self.getRegulerData();
                        data['command'] = "lock_draft";
                        data['id'] = id;
                        showLoading();
                        $.post(
                            "",
                            data,
                            function(response) {
                                var json = JSON.parse(response);
                                if (json == null) {
                                    dismissLoading();
                                    return;
                                }
                                self.view();
                                dismissLoading();
                            }
                        );
                    }
                }
            });
        };
        kb_mutasi_antar_kas_bank.post = function(id) {
            var self = this;
            bootbox.confirm({
                title: "Konfirmasi",
                message: "Yakin menyimpan draft data ini sebagai jurnal?",
                buttons: {
                    confirm: {
                        label: 'Ya',
                        className: 'btn-success'
                    },
                    cancel: {
                        label: 'Tidak',
                        className: 'btn-danger'
                    }
                },
                callback: function(result) {
                    if (result) {
                        var data = self.getRegulerData();
                        data['command'] = "post_journal";
                        data['id'] = id;
                        showLoading();
                        $.post(
                            "",
                            data,
                            function(response) {
                                var json = JSON.parse(response);
                                if (json == null) {
                                    dismissLoading();
                                    return;
                                }
                                self.view();
                                dismissLoading();
                            }
                        );
                    }
                }
            });
        };
        kb_mutasi_antar_kas_bank.view();
    });
</script>