<?php
    global $db;

    if (isset($_POST['command'])) {
        if ($_POST['command'] == "list") {
            $tanggal_dari = DateTime::createFromFormat("d-m-Y H:i", $_POST['tanggal_dari'])->format("Y-m-d H:i");
            $tanggal_sampai = DateTime::createFromFormat("d-m-Y H:i", $_POST['tanggal_sampai'])->format("Y-m-d H:i");
            $kode_akun = $_POST['kode_akun'];
            $nama_akun = $_POST['nama_akun'];
            $html = "";
            $total_debit = 0;
            $total_kredit = 0;
            $saldo_akhir = 0;

            $akun_arr = array();
            if ($kode_akun == "") {
                $akun_rows = $db->get_result("
                    SELECT
                        *
                    FROM 
                        smis_ac_account
                    WHERE
                        prop = '' 
                            AND nama_tipe LIKE 'Kas & Setara Kas'
                            AND id_parent <> 0
                            AND have_child = 0
                    ORDER BY
                        nomor ASC
                ");
                if ($akun_rows != null) {
                    foreach ($akun_rows as $akun_row) {
                        $akun_arr[] = array(
                            'kode_akun'             => $akun_row->nomor,
                            'nama_akun'             => $akun_row->nama,
                            'nilai_saldo_awal'      => $akun_row->nilai_saldo_awal,
                            'tanggal_saldo_awal'    => $akun_row->tgl_saldo_awal
                        );
                    }
                }
            } else {
                $akun_row = $db->get_row("
                    SELECT
                        *
                    FROM 
                        smis_ac_account
                    WHERE
                        prop = '' 
                            AND nama_tipe LIKE 'Kas & Setara Kas' 
                            AND nomor LIKE '" . $kode_akun . "' 
                            AND nama LIKE '" . $nama_akun . "'
                    ORDER BY
                        nomor ASC
                ");
                if ($akun_row != null) {
                    $akun_arr[] = array(
                        'kode_akun'             => $akun_row->nomor,
                        'nama_akun'             => $akun_row->nama,
                        'nilai_saldo_awal'      => $akun_row->nilai_saldo_awal,
                        'tanggal_saldo_awal'    => $akun_row->tgl_saldo_awal
                    );
                }
            }

            if (count($akun_arr) > 0) {
                // Kalkulasi Saldo Akhir Sehari Sebelum Tanggal Awal Pilihan Buku Kas Bank (Saldo Awal Buku Kas Bank) :
                $saldo_awal = 0;
                foreach ($akun_arr as $akun) {
                    $saldo_awal += $akun['nilai_saldo_awal'];
                    $accumulated_transaction_row = $db->get_row("
                        SELECT
                            SUM(a.debet) - SUM(a.kredit) AS value
                        FROM
                            smis_ac_transaksi_detail a
                                INNER JOIN smis_ac_transaksi b ON a.id_transaksi = b.id
                        WHERE
                            a.prop = ''
                                AND b.prop = ''
                                AND a.nomor_account LIKE '" . $akun['kode_akun'] . "'
                                AND a.nama_account LIKE '" . $akun['nama_akun'] . "'
                                AND a.tanggal >= '" . $akun['tanggal_saldo_awal'] . "'
                                AND a.tanggal < '" . $tanggal_dari . "'
                    ");
                    if ($accumulated_transaction_row != null)
                        $saldo_awal += $accumulated_transaction_row->value;
                }
                $f_saldo_awal = $saldo_awal == 0 ? "0,00" : ArrayAdapter::format("only-money", $saldo_awal);
                $uraian = $kode_akun == "" ? "Saldo Awal Kas & Setara Kas per Tgl. " . ArrayAdapter::format("date d-m-Y", $tanggal_dari) : "Saldo Awal " . $kode_akun . " - " . $nama_akun . " per Tgl. " . ArrayAdapter::format("date d-m-Y", $tanggal_dari);
                $nomor = 1;
                $html .=    "<tr>";
                $html .=        "<td id='nomor'>" . $nomor++ . "</td>";
                $html .=        "<td id='tanggal'>" . ArrayAdapter::format("date d-m-Y", $tanggal_dari) . "</td>";
                $html .=        "<td id='akun'></td>";
                $html .=        "<td id='uraian'>" . $uraian . "</td>";
                $html .=        "<td id='debit' style='display: none;'></td>";
                $html .=        "<td id='f_debit'></td>";
                $html .=        "<td id='kredit' style='display: none;'></td>";
                $html .=        "<td id='f_kredit'></td>";
                $html .=        "<td id='saldo' style='display: none;'>" . $saldo_awal . "</td>";
                $html .=        "<td id='f_saldo'><div align='right'><strong>" . $f_saldo_awal . "</strong></div></td>";
                $html .=    "</td>";

                $saldo_akhir = $saldo_awal;

                // Penyajian Transaksi Kas Bank Rentang Tanggal Pilihan :
                $transaction_arr = array();
                foreach ($akun_arr as $akun) {
                    $transaction_rows = $db->get_result("
                        SELECT
                            a.*
                        FROM
                            smis_ac_transaksi_detail a 
                                INNER JOIN smis_ac_transaksi b ON a.id_transaksi = b.id
                        WHERE
                            a.prop = ''
                                AND b.prop = ''
                                AND a.nomor_account LIKE '" . $akun['kode_akun'] . "'
                                AND a.nama_account LIKE '" . $akun['nama_akun'] . "'
                                AND a.tanggal >= '" . $tanggal_dari . "'
                                AND a.tanggal <= '" . $tanggal_sampai . "'
                        ORDER BY
                            tanggal ASC
                    ");
                    if ($transaction_rows != null) {
                        foreach ($transaction_rows as $transaction_row) {
                            $transaction_arr[] = array(
                                'tanggal'   => $transaction_row->tanggal,
                                'kode_akun' => $transaction_row->nomor_account,
                                'nama_akun' => $transaction_row->nama_account,
                                'uraian'    => $transaction_row->keterangan,
                                'debit'     => $transaction_row->debet,
                                'kredit'    => $transaction_row->kredit
                            );
                        }
                    }
                }
                if (count($transaction_arr) > 0) {
                    foreach ($transaction_arr as $transaction) {
                        $debit = $transaction['debit'] == 0 ? "" : $transaction['debit'];
                        $total_debit += $debit;
                        $f_debit = $transaction['debit'] == 0 ? "" : ArrayAdapter::format("only-money", $transaction['debit']);
                        $kredit = $transaction['kredit'] == 0 ? "" : $transaction['kredit'];
                        $total_kredit += $kredit;
                        $f_kredit = $transaction['kredit'] == 0 ? "" : ArrayAdapter::format("only-money", $transaction['kredit']);
                        $saldo_akhir = $saldo_akhir + $transaction['debit'] - $transaction['kredit'];
                        $f_saldo_akhir = $saldo_akhir == 0 ? "0,00" : ArrayAdapter::format("only-money", $saldo_akhir);
                        $html .=    "<tr>";
                        $html .=        "<td id='nomor'>" . $nomor++ . "</td>";
                        $html .=        "<td id='tanggal'>" . ArrayAdapter::format("date d-m-Y", $transaction['tanggal']) . "</td>";
                        $html .=        "<td id='akun'>" . $transaction['kode_akun'] . " - " . $transaction['nama_akun'] . "</td>";
                        $html .=        "<td id='uraian'>" . $transaction['uraian'] . "</td>";
                        $html .=        "<td id='debit' style='display: none;'>" . $debit . "</td>";
                        $html .=        "<td id='f_debit'><div align='right'>" . $f_debit . "</div></td>";
                        $html .=        "<td id='kredit' style='display: none;'>" . $kredit . "</td>";
                        $html .=        "<td id='f_kredit'><div align='right'>" . $f_kredit . "</div></td>";
                        $html .=        "<td id='saldo' style='display: none;'>" . $saldo_akhir . "</td>";
                        if ($nomor - 2 == count($transaction_arr)) {
                            $html .=        "<td id='f_saldo'><div align='right'><strong>" . $f_saldo_akhir . "</strong></div></td>";
                        } else {
                            $html .=        "<td id='f_saldo'><div align='right'>" . $f_saldo_akhir . "</div></td>";
                        }
                        $html .=    "</tr>";
                    }
                }
            }

            $saldo_akhir = $saldo_akhir == 0 ? "0,00" : ArrayAdapter::format("only-money", $saldo_akhir);
            $html = $html == "" ? "<tr><td colspan='7'><center>Data tidak ditemukan.</center></td></tr>" : $html;
            $f_total_debit = "0,00";
            if ($total_debit > 0) {
                $f_total_debit = ArrayAdapter::format("only-money", $total_debit);
            }
            $f_total_kredit = "0,00";
            if ($total_kredit > 0) {
                $f_total_kredit = ArrayAdapter::format("only-money", $total_kredit);
            }

            $html .=    "<tr>";
            $html .=        "<td colspan='4'></td>";
            $html .=        "<td id='total_debit' style='display: none;'>" . $total_debit . "</td>";
            $html .=        "<td id='f_total_debit'><div align='right'><strong>" . $f_total_debit . "</strong></div></td>";
            $html .=        "<td id='total_kredit' style='display: none;'>" . $total_kredit . "</td>";
            $html .=        "<td id='f_total_kredit'><div align='right'><strong>" . $f_total_kredit . "</div></td>";
            $html .=        "<td></td>";
            $html .=    "</tr>";

            $data = array(
                "html"          => $html,
                "saldo_akhir"   => $saldo_akhir
            );
            echo json_encode($data);
        } else if ($_POST['command'] == "export_xls") {
            $tanggal_dari = $_POST['tanggal_dari'];
            $tanggal_sampai = $_POST['tanggal_sampai'];
            $akun = $_POST['akun'];
            require_once("smis-libs-out/php-excel/PHPExcel.php");

            $file = new PHPExcel();
            $file->getProperties()->setCreator("PT. Inovasi Ide Utama");
            $file->getProperties()->setTitle("Buku Kas Bank");
            $file->getProperties()->setSubject("Buku Kas Bank");
            $file->getProperties()->setDescription("Buku Kas Bank - SIMRS");
            $file->getProperties()->setKeywords("Buku Kas Bank");
            $file->getProperties()->setCategory("Buku Kas Bank");

            $sheet = $file->getActiveSheet();
            $sheet->setTitle("Buku Kas Bank");
            $i = 1;

            $sheet->mergeCells("A" . $i . ":G" . $i)->setCellValue("A" . $i, "BUKU KAS BANK");
            $sheet->getStyle("A" . $i . ":G" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle("A" . $i)->getFont()->setBold(true);
            $i = $i + 1;
            $sheet->setCellValue("A" . $i, "Dari Tgl");
            $sheet->setCellValue("B" . $i, ": " . $tanggal_dari);
            $i = $i + 1;
            $sheet->setCellValue("A" . $i, "Sampai Tgl");
            $sheet->setCellValue("B" . $i, ": " . $tanggal_sampai);
            $i = $i + 1;
            $sheet->setCellValue("A" . $i, "Akun Kas Bank");
            $sheet->setCellValue("B" . $i, ": " . $akun);
            $i = $i + 1;
            $sheet->setCellValue("A" . $i, "Saldo Akhir");
            $i = $i + 2;

            $border_start = $i;
            $col = "A";
            $head = array('No.', 'Tanggal', 'No. - Nama Akun', 'Uraian', 'Debit', 'Kredit', 'Saldo');
            foreach ($head as $h)
                $sheet->setCellValue($col++ . $i, $h);
            $sheet->getStyle("A" . $i . ":G" . $i)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
            $sheet->getStyle("A" . $i . ":G" . $i)->getFont()->setBold(true);
            $i = $i + 1;

            $data = json_decode($_POST['d_data']);
            $saldo_akhir = 0;
            $total_debit = 0;
            $total_kredit = 0;
            if (count($data) > 0) {
                foreach ($data as $d) {
                    $sheet->setCellValue("A" . $i, $d->nomor);
                    $sheet->setCellValue("B" . $i, $d->tanggal);
                    $sheet->setCellValue("C" . $i, $d->akun);
                    $sheet->setCellValue("D" . $i, $d->uraian);
                    $sheet->setCellValue("E" . $i, $d->debit);
                    $sheet->setCellValue("F" . $i, $d->kredit);
                    $sheet->setCellValue("G" . $i, $d->saldo);
                    if ($d->debit > 0) {
                        $total_debit += $d->debit;
                    }
                    if ($d->kredit > 0) {
                        $total_kredit += $d->kredit;
                    }
                    $sheet->getStyle("E" . $i)->getNumberFormat()->setFormatCode("#,##0.00");
                    $sheet->getStyle("F" . $i)->getNumberFormat()->setFormatCode("#,##0.00");
                    $sheet->getStyle("G" . $i)->getNumberFormat()->setFormatCode("#,##0.00");
                    $i = $i + 1;
                    $saldo_akhir = $d->saldo;
                }
                $sheet->mergeCells("A" . $i . ":D" . $i)->setCellValue("A" . $i, "");
                $sheet->setCellValue("E" . $i, $total_debit);
                $sheet->setCellValue("F" . $i, $total_kredit);
                $sheet->setCellValue("G" . $i, "");
                $sheet->getStyle("E" . $i)->getNumberFormat()->setFormatCode("#,##0.00");
                $sheet->getStyle("F" . $i)->getNumberFormat()->setFormatCode("#,##0.00");
                $sheet->getStyle("G" . $i)->getNumberFormat()->setFormatCode("#,##0.00");
            }
            $sheet->setCellValue("B5", ": " . number_format($saldo_akhir, 2, ",", "."));

            $thin = array();
            $thin['borders'] = array();
            $thin['borders']['allborders'] = array();
            $thin['borders']['allborders']['style'] = PHPExcel_Style_Border::BORDER_THIN;
            $sheet->getStyle("A" . $border_start . ":G" . $i)->applyFromArray($thin);

            foreach (range('A', 'G') as $columnID)
                $sheet->getColumnDimension($columnID)->setAutoSize(true);

            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="Buku Kas Bank.xls"');
            header('Cache-Control: max-age=0');
            $writer = PHPExcel_IOFactory::createWriter($file, 'Excel5');
            $writer->save('php://output');
        } else if ($_POST['command'] == "export_pdf") {
            $tanggal_dari = $_POST['tanggal_dari'];
            $tanggal_sampai = $_POST['tanggal_sampai'];
            $akun = $_POST['akun'];
            require_once("finance/class/template/pdf.php");
			$fpdf = new PDF("L", "mm", "A4");
			$fpdf->SetMargins(5, 5);
		
            $fpdf->AddPage();
            $fpdf->SetFont("Arial", "B", 12);
            $fpdf->Cell(285, 5, "BUKU KAS BANK", 0, 1, "C");
            $fpdf->SetFont("Arial", "", 10);
            $fpdf->Cell(25, 5, "Dari Tgl.", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, $tanggal_dari, 0, 1);
            $fpdf->Cell(25, 5, "Sampai Tgl.", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, $tanggal_sampai, 0, 1);
            $fpdf->Cell(25, 5, "Akun", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $fpdf->Cell(250, 5, $akun, 0, 1);
            $fpdf->Cell(25, 5, "Saldo Akhir", 0, 0);
            $fpdf->Cell(10, 5, ":", 0, 0, "C");
            $saldo_akhir_x = $fpdf->GetX();
            $saldo_akhir_y = $fpdf->GetY();
            $fpdf->Cell(250, 5, "", 0, 1);
            $fpdf->Cell(285, 5, "", 0, 1, "C");
            $fpdf->SetFont("Arial", "B", 10);
            $fpdf->Cell(15, 5, "No.", 1, 0, "C");
            $fpdf->Cell(25, 5, "Tanggal", 1, 0, "C");
            $fpdf->Cell(70, 5, "No. - Nama Akun", 1, 0, "C");
            $fpdf->Cell(85, 5, "Uraian", 1, 0, "C");
            $fpdf->Cell(30, 5, "Debit", 1, 0, "C");
            $fpdf->Cell(30, 5, "Kredit", 1, 0, "C");
            $fpdf->Cell(30, 5, "Saldo", 1, 1, "C");
            $data = json_decode($_POST['d_data']);
            $saldo_akhir = 0;
            $total_debit = 0;
            $total_kredit = 0;
            if (count($data) > 0) {
                $fpdf->SetFont("Arial", "", 9);
                foreach ($data as $d) {
                    if ($d->nomor > 0) {
                        $fpdf->Cell(15, 5, $d->nomor, 1, 0);
                        $fpdf->Cell(25, 5, $d->tanggal, 1, 0);
                        $lastX = $fpdf->GetX();
                        $lastY = $fpdf->GetY();
                        $fpdf->MultiCell(70, 5, $d->akun, 1, "J", false, 1);
                        $fpdf->SetX($lastX);
                        $fpdf->SetY($lastY);
                        $fpdf->Cell(110, 5, "", 0, 0, "");
                        $lastX = $fpdf->GetX();
                        $lastY = $fpdf->GetY();
                        $fpdf->MultiCell(85, 5, $d->uraian, 1, "J", false, 1);
                        $fpdf->SetX($lastX);
                        $fpdf->SetY($lastY);
                        $fpdf->Cell(195, 5, "", 0, 0, "");
                        $fpdf->Cell(30, 5, ArrayAdapter::format("only-money", $d->debit), 1, 0, "R");
                        $fpdf->Cell(30, 5, ArrayAdapter::format("only-money", $d->kredit), 1, 0, "R");
                        $fpdf->Cell(30, 5, ArrayAdapter::format("only-money", $d->saldo), 1, 1, "R");
                        $saldo_akhir = $d->saldo;
                        if ($d->debit > 0) {
                            $total_debit += $d->debit;
                        }
                        if ($d->kredit > 0) {
                            $total_kredit += $d->kredit;
                        }
                    }
                }
                $fpdf->Cell(195, 5, "", 1, 0, "");
                $fpdf->Cell(30, 5, ArrayAdapter::format("only-money", $total_debit), 1, 0, "R");
                $fpdf->Cell(30, 5, ArrayAdapter::format("only-money", $total_kredit), 1, 0, "R");
                $fpdf->Cell(30, 5, "", 1, 1, "");
            }
            $fpdf->SetX($saldo_akhir_x);
            $fpdf->SetY($saldo_akhir_y);
            $fpdf->Cell(35, 5, "", 0, 0, "C");
            $fpdf->Cell(250, 5, ArrayAdapter::format("only-money", $saldo_akhir), 0, 1);

			global $user;
		    $md5 = md5($id . "_" . date("Ymd_His") . "_" . $user->getNameOnly());
			$filename = "buku_kas_bank.pdf";
			$pathfile = "smis-temp/" . $md5 . $filename;
			$fpdf->Output($pathfile, "F");
			echo json_encode($pathfile);
        }
        return;
    }

    $table = new Table(
        array("No.", "Tanggal", "No. - Nama Akun", "Uraian", "Debit", "Kredit", "Saldo"),
        "",
        null,
        true
    );
    $table->setName("kb_buku_kas_bank");
    $table->setAction(false);
    $table->setFooterVisible(false);

    $form = new Form("", "", "Buku Kas Bank");
    $tanggal_dari_text = new Text("kb_bkb_tanggal_dari", "kb_bkb_tanggal_dari", date("d-m-Y") . " 00:00");
    $tanggal_dari_text->setAtribute("data-date-format='dd-mm-yyyy hh:ii'");
    $tanggal_dari_text->setClass("mydatetime");
    $form->addElement("Dari Tgl.", $tanggal_dari_text);
    $tanggal_sampai_text = new Text("kb_bkb_tanggal_sampai", "kb_bkb_tanggal_sampai", date("d-m-Y H:i"));
    $tanggal_sampai_text->setAtribute("data-date-format='dd-mm-yyyy hh:ii'");
    $tanggal_sampai_text->setClass("mydatetime");
    $form->addElement("Sampai Tgl.", $tanggal_sampai_text);
    $akun_rows = $db->get_result("
        SELECT 
            *
        FROM
            smis_ac_account
        WHERE
            prop = '' 
                AND id_parent <> 0
                AND have_child = 0
                AND nama_tipe LIKE 'Kas & Setara Kas'
        ORDER BY
            nomor ASC
    ");
    $akun_option = new OptionBuilder();
    $akun_option->add("", "", "1");
    if ($akun_rows != null)
        foreach ($akun_rows as $akun_row)
            $akun_option->add($akun_row->nomor . " - " . $akun_row->nama);
    $akun_select = new Select("kb_bkb_akun", "kb_bkb_akun", $akun_option->getContent());
    $form->addElement("Akun Kas Bank", $akun_select);
    $kode_akun_hidden = new Hidden("kb_bkb_kode_akun", "kb_bkb_kode_akun", "");
    $form->addElement("", $kode_akun_hidden);
    $nama_akun_hidden = new Hidden("kb_bkb_nama_akun", "kb_bkb_nama_akun", "");
    $form->addElement("", $nama_akun_hidden);
    $saldo_akhir_text = new Text("kb_bkb_saldo_akhir", "kb_bkb_saldo_akhir", "0,00");
    $saldo_akhir_text->setAtribute("disabled='disabled'");
    $form->addElement("Saldo Akhir", $saldo_akhir_text);
    $proses_button = new Button("", "", "Proses");
    $proses_button->setClass("btn btn-primary");
    $proses_button->setAction("kb_buku_kas_bank.view()");
    $proses_button->setIcon("icon-white icon-repeat");
    $proses_button->setIsButton(Button::$ICONIC);
    $download_excel_button = new Button("", "", "Download XLS");
    $download_excel_button->setClass("btn btn-success");
    $download_excel_button->setAction("kb_buku_kas_bank.export_xls()");
    $download_excel_button->setIcon("fa fa-file-excel-o");
    $download_excel_button->setIsButton(Button::$ICONIC);
    $download_pdf_button = new Button("", "", "Download PDF");
    $download_pdf_button->setClass("btn btn-danger");
    $download_pdf_button->setAction("kb_buku_kas_bank.export_pdf()");
    $download_pdf_button->setIcon("fa fa-file-pdf-o");
    $download_pdf_button->setIsButton(Button::$ICONIC);
    $button_group = new ButtonGroup();
    $button_group->addButton($proses_button);
    $button_group->addButton($download_excel_button);
    $button_group->addButton($download_pdf_button);
    $form->addElement("", $button_group);

    echo $form->getHtml();
    echo $table->getHtml();
    echo addJS("framework/smis/js/table_action.js");
    echo addJS("framework/bootstrap/js/bootstrap-datetimepicker.js");
    echo addJS("framework/bootstrap/js/bootstrap-select.js");
    echo addCSS("framework/bootstrap/css/bootstrap-datetimepicker.css");
    echo addCSS("framework/bootstrap/css/bootstrap-select.css");
?>
<script type="text/javascript">
    var kb_buku_kas_bank;
    $(document).ready(function() {
        $("#kb_buku_kas_bank_list").html("<tr><td colspan='7'><center>Data belum diproses.</center></td></tr>");
        $(".mydatetime").datetimepicker({
            dateFormat: 'dd:mm:yyyy hh:ii',
            minuteStep: 1
        });
        kb_buku_kas_bank = new TableAction(
            "kb_buku_kas_bank",
            "finance",
            "kb_buku_kas_bank",
            new Array()
        );
        kb_buku_kas_bank.addRegulerData = function(data) {
            data['tanggal_dari'] = $("#kb_bkb_tanggal_dari").val();
            data['tanggal_sampai'] = $("#kb_bkb_tanggal_sampai").val();
            data['akun'] = $("#kb_bkb_akun").val();
            data['kode_akun'] = $("#kb_bkb_kode_akun").val();
            data['nama_akun'] = $("#kb_bkb_nama_akun").val();
            return data;
        };
        kb_buku_kas_bank.view = function() {
            var data = this.getRegulerData();
            data['command'] = "list";
            showLoading();
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    $("#kb_buku_kas_bank_list").html(json.html);
                    $("#kb_bkb_saldo_akhir").val(json.saldo_akhir);
                    dismissLoading();
                }
            );
        };
        kb_buku_kas_bank.getDetailData = function() {
            var num_rows = $("#kb_buku_kas_bank_list tr").length - 1;
            var data = {};
            for (var i = 0; i < num_rows; i++) {
                var nomor = $("tbody#kb_buku_kas_bank_list tr:eq(" + i + ") td#nomor").text();
                var tanggal = $("tbody#kb_buku_kas_bank_list tr:eq(" + i + ") td#tanggal").text();
                var akun = $("tbody#kb_buku_kas_bank_list tr:eq(" + i + ") td#akun").text();
                var uraian = $("tbody#kb_buku_kas_bank_list tr:eq(" + i + ") td#uraian").text();
                var debit = $("tbody#kb_buku_kas_bank_list tr:eq(" + i + ") td#debit").text();
                var kredit = $("tbody#kb_buku_kas_bank_list tr:eq(" + i + ") td#kredit").text();
                var saldo = $("tbody#kb_buku_kas_bank_list tr:eq(" + i + ") td#saldo").text();
                data[i] = {
                    "nomor"     : nomor,
                    "tanggal"   : tanggal,
                    "akun"      : akun,
                    "uraian"    : uraian,
                    "debit"     : debit,
                    "kredit"    : kredit,
                    "saldo"     : saldo
                };
            }
            return data;
        };
        kb_buku_kas_bank.export_xls = function() {
            showLoading();
            var data = this.getRegulerData();
            data['command'] = "export_xls";
            data['d_data'] = JSON.stringify(this.getDetailData());
            postForm(data);
            dismissLoading();
        };
        kb_buku_kas_bank.export_pdf = function() {
            showLoading();
            var data = this.getRegulerData();
            data['command'] = "export_pdf";
            data['d_data'] = JSON.stringify(this.getDetailData());
            $.post(
                "",
                data,
                function(response) {
                    var json = JSON.parse(response);
                    if (json == null) {
                        dismissLoading();
                        return;
                    }
                    var getUrl = window.location['pathname'] + json;
                    window.open(getUrl, 'pdf');
                    dismissLoading();
                }
            );
        };
        $("#kb_bkb_akun").select2().on("select2-close", function() {
            var value = $(this).select2('data').text;
            var nama_idx = value.indexOf(" - ") + 3;
            var kode_akun = value.split(" - ")[0].trim();
            var nama_akun = value.substr(nama_idx);
            $("#kb_bkb_nama_akun").val(nama_akun);
            $("#kb_bkb_kode_akun").val(kode_akun);
        });
    });
</script>