<?php
global $db;
require_once 'smis-libs-hrd/EmployeeResponder.php';
require_once 'smis-base/smis-include-service-consumer.php';
require_once 'smis-libs-class/MasterTemplate.php';
require_once 'smis-libs-class/MasterServiceTemplate.php';
require_once 'smis-libs-class/MasterSlaveServiceTemplate.php';
require_once 'smis-libs-class/ServiceProviderList.php';
require_once 'finance/class/MapRuangan.php';
require_once "finance/class/responder/LapTindDokterResponder.php";

$ruangan=MapRuangan::getRuangan();
$ruangan[]=array("name"=>"  ","value"=>"","default"=>"1");

$service = new ServiceConsumer ( $db, "get_carabayar" );
$service->execute ();
$dataasuransi= $service->getContent ();
$adapter=new SelectAdapter("nama", "slug");
$jenis_pembayaran=$adapter->getContent($dataasuransi);
$jenis_pembayaran[]=array("name"=>"","value"=>"","default"=>"1");


$service = new ServiceConsumer ( $db, "get_all_perusahaan" );
$service->execute ();
$perusahaan= $service->getContent ();
$adapter=new SelectAdapter("nama", "nama");
$prsh=$adapter->getContent($perusahaan);
$prsh[]=array("name"=>"","value"=>"","default"=>"1");

$service = new ServiceConsumer ( $db, "get_all_asuransi" );
$service->execute ();
$asuransi= $service->getContent ();
$adapter=new SelectAdapter("nama", "id");
$asr=$adapter->getContent($asuransi);
$asr[]=array("name"=>"","value"=>"","default"=>"1");

$uri = new OptionBuilder();
$uri->add("","","1");
$uri->add("Rawat Jalan","0");
$uri->add("Rawat Inap","1");

$status = new OptionBuilder();
$status->add("Semua","","1");
$status->add("Aktif","0");
$status->add("Selesai","1");

$dkadapter = new SimpleAdapter ();
$dkadapter->add ( "Jabatan", "nama_jabatan" );
$dkadapter->add ( "Nama", "nama" );
$dkadapter->add ( "NIP", "nip" );
$header=array ('Nama','Jabatan',"NIP" );
$dktable = new Table ( $header);
$dktable->setName ( "dokter_tindakan_dokter" );
$dktable->setModel ( Table::$SELECT );
$dokter = new EmployeeResponder ( $db, $dktable, $dkadapter, "dokter" );


$tindakan_dokter = new MasterSlaveServiceTemplate($db, "pendapatan_tindakan_dokter", "finance", "lap_tind_dokter");
$tindakan_dokter ->setDateEnable(true);
$responder = new LapTindDokterResponder($db,$tindakan_dokter->getUItable(),$tindakan_dokter->getAdapter(),"pendapatan_tindakan_dokter");
$tindakan_dokter -> setDBresponder($responder);
$tindakan_dokter ->getServiceResponder()->setMode(ServiceConsumer::$JOIN_ENTITY);

if(isset($_POST['command']) && $_POST['command']=="excel" ){
    $responder->setTitle("Pendapatan Tindakan Dokter");
    $responder->setFileName("Pendapatan Jasa Dokter");
    $responder->addResetMoney("K","Total","total");
    $responder->addResetMoney("L","Jasa Dokter","operator_nilai");
    $responder->setSummary("J",array("K","L"));
	
    $responder->addColumn("A","No.");
    $responder->addColumn("B","No. RM");
    $responder->addColumn("C","No. Reg");
    $responder->addColumn("D","Nama Pasien");
	$responder->addColumn("E","Tanggal Tindakan");
    $responder->addColumn("F","Jenis Layanan");
    $responder->addColumn("G","Cara Bayar");
    $responder->addColumn("H","Ruangan");
    $responder->addColumn("I","Nama Dokter");
	$responder->addColumn("J","Nama Tindakan");
    $responder->addColumn("K","Total");
    $responder->addColumn("L","Jasa Dokter");

	
}

$header = array ("No.","No. RM","No. Reg",'Nama Pasien',"Tanggal Tindakan","Jenis Layanan",'Cara Bayar','Ruangan',"Nama Dokter","Nama Tindakan","Total","Jasa Dokter");
$btn=$tindakan_dokter->addFlag("dari", "Pilih Tanggal Mulainya", "Silakan Pilih Tanggal Mulainya Dahulu")
			  ->addFlag("sampai", "Pilih Tanggal Sampainya", "Silakan Pilih Tanggal Sampainya Dahulu")
			  ->addNoClear("dari")
			  ->addNoClear("sampai")
			  ->getUItable()
			  ->setAddButtonEnable(false)
			  ->getHeaderButton();

$opt = new OptionBuilder();
$opt->add("Tanggal Masuk","Tanggal Masuk");
$opt->add("Tanggal Keluar","Tanggal Keluar");

$tindakan_dokter->getUItable()
		 ->setAction(false)
         ->addModal("keluar_masuk", "select", "Masuk Keluar", $opt->getContent())
		 
         ->addModal("dari", "date", "Dari", "")
		 ->addModal("sampai", "date", "Sampai", "")

         ->addModal("carabayar", "select", "Carabayar", $jenis_pembayaran)
		 ->addModal("asuransi", "select", "Asuransi", $asr)
		 ->addModal("perusahaan", "select", "Perusahaan", $prsh)
         ->addModal("uri", "select", "Jenis", $uri->getContent())
         ->addModal("ruangan", "select", "Ruangan", $ruangan)
         ->addModal("status", "select", "Status", $status->getContent())

         ->addModal("dokter", "chooser-lap_tind_dokter-dokter_tindakan_dokter-Pilih Dokter", "Dokter", "")
		 ->addModal("id_dokter", "hidden", "", "")
		 ->addModal("nama_pasien", "text", "Nama Pasien", "")
         ->addModal("nrm_pasien", "text", "No. RM", "");

$view = new Button("","","Tampilkan");
$view ->setClass("btn-primary");
$view ->setIcon(" fa fa-reload");
$view ->setIsButton(Button::$ICONIC_TEXT);
$view ->setAction("lap_tind_dokter.view()");

$excel = new Button("","","Download");
$excel ->setClass("btn-primary");
$excel ->setIcon(" fa fa-file-excel");
$excel ->setIsButton(Button::$ICONIC_TEXT);
$excel ->setAction("lap_tind_dokter.excel()");

$tindakan_dokter 	->getForm(true,"")
					->addElement("", $view)
					->addElement("", $excel);

$tindakan_dokter ->getUItable()
				 ->setHeader($header)
				 ->setFooterVisible(false);
         
require_once "finance/class/adapter/TindakanPerRuangAdapter.php";
$summary = new TindakanPerRuangAdapter();
$summary ->addSummary("Total", "total","money Rp.");
$summary ->addSummary("Jasa Dokter", "operator_nilai","money Rp.");
$summary ->addFixValue("Nama Tindakan","Total");

$tindakan_dokter ->getSuperCommand()->addResponder("dokter_tindakan_dokter", $dokter);
$tindakan_dokter ->addSuperCommand("dokter_tindakan_dokter", array());
$tindakan_dokter ->addSuperCommandArray("dokter_tindakan_dokter", "dokter", "nama");
$tindakan_dokter ->addSuperCommandArray("dokter_tindakan_dokter", "id_dokter", "id");
$tindakan_dokter ->setAdapter($summary)
				 ->getAdapter()
				 ->setUseNumber(true, "No.","back .")
				 ->add("No. RM", "nrm_pasien")
				 ->add("No. Reg", "noreg_pasien")
				 ->add("Nama Pasien", "nama_pasien")
				 ->add("Jenis Layanan", "uri","trivial_0_Rawat Jalan_Rawat Inap")
				 ->add("Nama Dokter", "nama_dokter")
				 ->add("Nama Tindakan", "nama_tindakan")
				 ->add("Cara Bayar", "carabayar","unslug")
				 ->add("Ruangan", "smis_entity")
				 ->add("Total", "total","money Rp.")
				 ->add("Tanggal Tindakan", "waktu","date d M Y H:i")
				 ->add("Jasa Dokter", "operator_nilai","money Rp.");

$tindakan_dokter ->addViewData("keluar_masuk", "keluar_masuk")
				 ->addViewData("dari", "dari")
				 ->addViewData("sampai", "sampai")

				 ->addViewData("carabayar", "carabayar")
				 ->addViewData("asuransi", "asuransi")
				 ->addViewData("perusahaan", "perusahaan")
				 ->addViewData("uri", "uri")
				 ->addViewData("ruangan", "ruangan")
				 ->addViewData("status", "status")

				 ->addViewData("dokter", "dokter")
				 ->addViewData("id_dokter", "id_dokter")
				 ->addViewData("ruangan", "ruangan")
				 ->addViewData("nama_pasien", "nama_pasien")
				 ->addViewData("nrm_pasien", "nrm_pasien");
$tindakan_dokter ->addResouce("js","finance/resource/js/lap_tind_dokter.js");
$tindakan_dokter ->initialize();