<?php
    class KBPenerimaanTable extends Table {
        public function getBodyContent() {
            $content = "";
            if ($this->content!=NULL) {
                foreach ($this->content as $d) {
                    $content .= "<tr>";
                    foreach ($this->header as $h) {
                        if (isset($d[$h]))
                            $content .= "<td>" . $d[$h] . "</td>";
                        else
                            $content .= "<td></td>";
                    }
                    if ($this->is_action) {
                        if (isset($d['id'])) {
                            $content .= "<td>" . $this->getFilteredContentButton($d['id'], $d['lock_draft'], $d['lock_acc'], $d['id_jurnal'])->getHtml() . "</td>";
                        } else {
                            $content .= "<td></td>";
                        }
                    }
                    $content .= "</tr>";
                }
            }
            return $content;
        }
        public function getFilteredContentButton($id, $lock_draft, $lock_acc, $id_jurnal) {
            $btn_group = new ButtonGroup("noprint");
            $btn_group->setMax(5, "Aksi");
            if ($lock_draft == 0 && $lock_acc == 0) {
                $btn = new Button("", "", "Finalisasi");
                $btn->setAction($this->action . ".lock_draft('" . $id . "')");
                $btn->setClass("btn-success");
                $btn->setAtribute("data-content='Finalisasi' data-toggle='popover' title='Finalisasi'");
                $btn->setIcon("fa fa-lock");
                $btn->setIsButton(Button::$ICONIC);
                $btn_group->addElement($btn);
                $btn = new Button("", "", "Ubah");
                $btn->setAction($this->action . ".edit('" . $id . "')");
                $btn->setClass("btn-warning");
                $btn->setAtribute("data-content='Ubah' data-toggle='popover' title='Ubah'");
                $btn->setIcon("fa fa-pencil");
                $btn->setIsButton(Button::$ICONIC);
                $btn_group->addElement($btn);
                $btn = new Button("", "", "Hapus");
                $btn->setAction($this->action . ".del('" . $id . "')");
                $btn->setClass("btn-danger");
                $btn->setAtribute("data-content='Hapus' data-toggle='popover' title='Hapus'");
                $btn->setIcon("fa fa-trash");
                $btn->setIsButton(Button::$ICONIC);
                $btn_group->addElement($btn);
            } else if ($lock_draft == 1 && $lock_acc == 1) {
                $btn = new Button("", "", "Cetak");
                $btn->setAction($this->action . ".printelement('" . $id . "')");
                $btn->setClass("btn-inverse");
                $btn->setAtribute("data-content='Cetak' data-toggle='popover' title='Cetak'");
                $btn->setIcon("fa fa-print");
                $btn->setIsButton(Button::$ICONIC);
                $btn_group->addElement($btn);
                if ($id_jurnal == 0) {
                    $btn = new Button("", "", "Kirim Jurnal");
                    $btn->setAction($this->action . ".post('" . $id . "')");
                    $btn->setClass("btn-info");
                    $btn->setAtribute("data-content='Kirim Jurnal' data-toggle='popover' title='Kirim Jurnal'");
                    $btn->setIcon("fa fa-paper-plane");
                    $btn->setIsButton(Button::$ICONIC);
                    $btn_group->addElement($btn);
                }
            }
            return $btn_group;
        }
    }
?>